/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.mci.util;

import br.gov.rs.tce.mci.excecao.MCIException;
import java.util.ArrayList;
import java.util.List;

public class CodigoBarrasWrapper {
    private Integer periodoInformacoes;
    private Integer anoExercicio;
    private Integer tipoRelatorio;
    private Integer grupoEntrega;
    private String crc;
    public static List TIPO_PERIODOS_CODIGO_BARRA = new ArrayList(4);
    public static List TIPO_RELATORIO_CODIGO_BARRA;
    public static List TIPO_GRUPOENTREGA_CODIGO_BARRA;
    private static final String UC026_01 = "\u00c9 preciso informar um c\u00f3digo de barras v\u00e1lido";
    private static final String UC026_03 = "\u00c9 preciso informar um per\u00edodo de informa\u00e7\u00f5es v\u00e1lido";
    private static final String UC026_04 = "\u00c9 preciso informar um ano de exerc\u00edcio v\u00e1lido";
    private static final String UC026_05 = "\u00c9 preciso informar um tipo de relat\u00f3rio v\u00e1lido";
    private static final String UC026_06 = "\u00c9 preciso informar um grupo de entrega v\u00e1lido";
    private static final String UC026_07 = "\u00c9 preciso informar d\u00edgitos de controle v\u00e1lido";

    public CodigoBarrasWrapper() {
    }

    public CodigoBarrasWrapper(String codigoBarras) throws MCIException {
        try {
            if (codigoBarras == null) {
                throw new MCIException(UC026_01);
            }
            if (codigoBarras.length() < 1) {
                throw new MCIException(UC026_03);
            }
            this.periodoInformacoes = Integer.parseInt(codigoBarras.substring(1, 1));
            if (codigoBarras.length() < 3) {
                throw new MCIException(UC026_04);
            }
            this.anoExercicio = Integer.parseInt(codigoBarras.substring(2, 4));
            if (codigoBarras.length() < 4) {
                throw new MCIException(UC026_05);
            }
            this.tipoRelatorio = Integer.parseInt(codigoBarras.substring(4, 5));
            if (codigoBarras.length() < 5) {
                throw new MCIException(UC026_06);
            }
            this.grupoEntrega = Integer.parseInt(codigoBarras.substring(5, 6));
            if (codigoBarras.length() < 6) {
                throw new MCIException(UC026_07);
            }
            this.crc = codigoBarras.substring(6);
        }
        catch (NumberFormatException e) {
            throw new MCIException(UC026_01);
        }
    }

    public void setValidaPeriodoInformacoes(String codigoBarras) throws MCIException {
        if (codigoBarras == null) {
            throw new MCIException(UC026_01);
        }
        if (codigoBarras.length() < 1) {
            throw new MCIException(UC026_03);
        }
        Integer valor = null;
        try {
            valor = Integer.parseInt(codigoBarras.substring(0, 1));
        }
        catch (NumberFormatException e) {
            throw new MCIException(UC026_01);
        }
        if (!TIPO_PERIODOS_CODIGO_BARRA.contains(valor)) {
            throw new MCIException(UC026_03);
        }
        this.setPeriodoInformacoes(valor);
    }

    public void setValidaTipoRelatorio(String codigoBarras) throws MCIException {
        if (codigoBarras == null) {
            throw new MCIException(UC026_01);
        }
        if (codigoBarras.length() < 1) {
            throw new MCIException(UC026_03);
        }
        Integer valor = null;
        try {
            valor = Integer.parseInt(codigoBarras.substring(3, 4));
        }
        catch (NumberFormatException e) {
            throw new MCIException(UC026_01);
        }
        if (!TIPO_RELATORIO_CODIGO_BARRA.contains(valor)) {
            throw new MCIException(UC026_05);
        }
        this.setTipoRelatorio(valor);
    }

    public void setValidaGrupoEntrega(String codigoBarras) throws MCIException {
        if (codigoBarras == null) {
            throw new MCIException(UC026_01);
        }
        if (codigoBarras.length() < 1) {
            throw new MCIException(UC026_03);
        }
        Integer valor = null;
        try {
            valor = Integer.parseInt(codigoBarras.substring(4, 5));
        }
        catch (NumberFormatException e) {
            throw new MCIException(UC026_01);
        }
        if (!TIPO_GRUPOENTREGA_CODIGO_BARRA.contains(valor)) {
            throw new MCIException(UC026_06);
        }
        this.setGrupoEntrega(valor);
    }

    public void setValidaDigitosControle(String codigoBarras) throws MCIException {
        if (codigoBarras == null) {
            throw new MCIException(UC026_01);
        }
        if (codigoBarras.length() < 1) {
            throw new MCIException(UC026_03);
        }
        String valor = null;
        try {
            valor = codigoBarras.substring(5, 15);
        }
        catch (NumberFormatException e) {
            throw new MCIException(UC026_01);
        }
        this.setCrc(valor);
    }

    public void setPeriodoInformacoes(Integer periodoInformacoes) {
        this.periodoInformacoes = periodoInformacoes;
    }

    public Integer getPeriodoInformacoes() {
        return this.periodoInformacoes;
    }

    public void setValidaAnoExercicio(String codigoBarras) throws MCIException {
        if (codigoBarras == null) {
            throw new MCIException(UC026_01);
        }
        if (codigoBarras.length() < 3) {
            throw new MCIException(UC026_04);
        }
        Integer valor = null;
        try {
            valor = Integer.parseInt(codigoBarras.substring(1, 3));
        }
        catch (NumberFormatException e) {
            throw new MCIException(UC026_01);
        }
        if (valor < 5 || valor > 10) {
            throw new MCIException(UC026_04);
        }
        this.setAnoExercicio(valor);
    }

    public void setAnoExercicio(Integer anoExercicio) {
        this.anoExercicio = anoExercicio;
    }

    public Integer getAnoExercicio() {
        return this.anoExercicio;
    }

    public void setTipoRelatorio(Integer tipoRelatorio) {
        this.tipoRelatorio = tipoRelatorio;
    }

    public Integer getTipoRelatorio() {
        return this.tipoRelatorio;
    }

    public void setGrupoEntrega(Integer grupoEntrega) {
        this.grupoEntrega = grupoEntrega;
    }

    public Integer getGrupoEntrega() {
        return this.grupoEntrega;
    }

    public void setCrc(String crc) {
        this.crc = crc;
    }

    public String getCrc() {
        return this.crc;
    }

    public String formataPeriodo(Integer valor) {
        return valor + "\u00ba Bimestre";
    }

    public String formataAnoExercicio(Integer valor) {
        if (valor < 10) {
            return "200" + valor;
        }
        return "20" + valor;
    }

    public String formataTipoRel(Integer valor) {
        if (valor == 1) {
            return "RVE";
        }
        if (valor == 2) {
            return "Modelo 9";
        }
        if (valor == 3) {
            return "Modelo 14";
        }
        if (valor == 4) {
            return "MCI 9";
        }
        if (valor == 5) {
            return "MCI 14";
        }
        return null;
    }

    public String formataGrupoEnt(Integer valor) {
        if (valor == 0) {
            return "RVE + Modelo 9 + Modelo 14 + MCI Executivo + MCI Legislativo";
        }
        if (valor == 1) {
            return "RVE + Modelo 9 + MCI Executivo";
        }
        if (valor == 2) {
            return "RVE + Modelo 14 + MCI Legislativo";
        }
        if (valor == 3) {
            return "RVE";
        }
        if (valor == 4) {
            return "RVE + Modelo 9 + Modelo 14 - Consolida\u00e7\u00e3o + MCI Executivo + MCI Legislativo";
        }
        if (valor == 5) {
            return "RVE + Modelo 9 - Consolida\u00e7\u00e3o + MCI Executivo";
        }
        return null;
    }

    public String formataDigitosControle(String valor) {
        return valor;
    }

    static {
        TIPO_PERIODOS_CODIGO_BARRA.add(new Integer(2));
        TIPO_PERIODOS_CODIGO_BARRA.add(new Integer(3));
        TIPO_PERIODOS_CODIGO_BARRA.add(new Integer(4));
        TIPO_PERIODOS_CODIGO_BARRA.add(new Integer(6));
        TIPO_RELATORIO_CODIGO_BARRA = new ArrayList(5);
        TIPO_RELATORIO_CODIGO_BARRA.add(new Integer(1));
        TIPO_RELATORIO_CODIGO_BARRA.add(new Integer(2));
        TIPO_RELATORIO_CODIGO_BARRA.add(new Integer(3));
        TIPO_RELATORIO_CODIGO_BARRA.add(new Integer(4));
        TIPO_RELATORIO_CODIGO_BARRA.add(new Integer(5));
        TIPO_GRUPOENTREGA_CODIGO_BARRA = new ArrayList(6);
        TIPO_GRUPOENTREGA_CODIGO_BARRA.add(new Integer(0));
        TIPO_GRUPOENTREGA_CODIGO_BARRA.add(new Integer(1));
        TIPO_GRUPOENTREGA_CODIGO_BARRA.add(new Integer(2));
        TIPO_GRUPOENTREGA_CODIGO_BARRA.add(new Integer(3));
        TIPO_GRUPOENTREGA_CODIGO_BARRA.add(new Integer(4));
        TIPO_GRUPOENTREGA_CODIGO_BARRA.add(new Integer(5));
    }
}

