/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.mci.modelo.servico;

import br.gov.rs.tce.adf.servico.TCEApplicationModeluImpl;
import br.gov.rs.tce.mci.beans.remessa.Remessa;
import br.gov.rs.tce.mci.beans.remessa.RemessaInfo;
import br.gov.rs.tce.mci.excecao.ConfiguracaoException;
import br.gov.rs.tce.mci.excecao.MCIRuntimeException;
import br.gov.rs.tce.mci.excecao.PersistenciaException;
import br.gov.rs.tce.mci.modelo.servico.acessodados.CadcontinternoViewImpl;
import br.gov.rs.tce.mci.modelo.servico.acessodados.EntidadesConsultaCNPJImpl;
import br.gov.rs.tce.mci.modelo.servico.acessodados.EntidadesViewImpl;
import br.gov.rs.tce.mci.modelo.servico.acessodados.FormacaoViewImpl;
import br.gov.rs.tce.mci.modelo.servico.acessodados.FormregulacaoViewImpl;
import br.gov.rs.tce.mci.modelo.servico.acessodados.NroHabitantesViewImpl;
import br.gov.rs.tce.mci.modelo.servico.acessodados.ObservacoesViewImpl;
import br.gov.rs.tce.mci.modelo.servico.acessodados.PerguntasViewImpl;
import br.gov.rs.tce.mci.modelo.servico.acessodados.PeriodoViewImpl;
import br.gov.rs.tce.mci.modelo.servico.acessodados.RemessasMCIViewImpl;
import br.gov.rs.tce.mci.modelo.servico.acessodados.RespostasRemessasViewImpl;
import br.gov.rs.tce.mci.modelo.servico.common.ServicoMCI;
import java.math.BigDecimal;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;
import oracle.jbo.Key;
import oracle.jbo.Row;
import oracle.jbo.ViewObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ServicoMCIImpl
extends TCEApplicationModeluImpl
implements ServicoMCI {
    private static Log log = LogFactory.getLog(ServicoMCIImpl.class);

    public static void main(String[] args) {
        ServicoMCIImpl.launchTester((String)"br.gov.rs.tce.mci.modelo.servico", (String)"ServicoMCIDerby");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Remessa getRemessaPrincipal() {
        ViewObject remessasView = null;
        Remessa remessa = null;
        try {
            Integer cdPeriodo;
            Integer anoExercicio;
            remessasView = this.createViewObjectFromQueryStmt("RemessaPrincipal", "SELECT * FROM MCI.MCI_REMESSASMCI");
            if (remessasView == null) {
                throw new ConfiguracaoException("N\u00e3o foi poss\u00edvel recuperar o ViewObject de Remessas: RemesssasMCIView");
            }
            remessasView.executeQuery();
            Row remessaRow = remessasView.first();
            if (remessaRow == null) {
                throw new ConfiguracaoException("N\u00e3o foi poss\u00edvel recuperar a Remessas Principal");
            }
            remessa = new Remessa();
            Integer cdEntidade = new Integer(((BigDecimal)remessaRow.getAttribute("CD_ENTIDADE")).intValue());
            if (cdEntidade != null) {
                remessa.setCdEntidade(cdEntidade);
            }
            if ((anoExercicio = new Integer(((BigDecimal)remessaRow.getAttribute("ANO_EXERCICIO")).intValue())) != null) {
                remessa.setAnoExercicio(anoExercicio);
            }
            if ((cdPeriodo = new Integer(((BigDecimal)remessaRow.getAttribute("CD_PERIODO")).intValue())) != null) {
                remessa.setPeriodoInformacoes(cdPeriodo);
            }
            String tpSetor = (String)remessaRow.getAttribute("PODER");
            remessa.setTipoSetor(tpSetor);
            String tpEntrega = (String)remessaRow.getAttribute("TPENTREGA");
            remessa.setTipoEntrega(tpEntrega);
            String ehEncMand = (String)remessaRow.getAttribute("EHENCMANDATO");
            remessa.setEhEncMandato(ehEncMand);
            String perc = this.getRespPergunta("UC022_t1p01", false, true);
            if (perc.length() != 0) {
                remessa.setPercentual(perc);
            }
        }
        finally {
            if (remessasView != null) {
                remessasView.remove();
            }
        }
        return remessa;
    }

    @Override
    public String getCodBarrasMCIOriginal() {
        String retorno = null;
        return retorno;
    }

    public CadcontinternoViewImpl getCadcontinternoView() {
        return (CadcontinternoViewImpl)this.findViewObject("CadcontinternoView");
    }

    @Override
    public EntidadesViewImpl getEntidadesView() {
        return (EntidadesViewImpl)this.findViewObject("EntidadesView");
    }

    public FormregulacaoViewImpl getFormregulacaoView() {
        return (FormregulacaoViewImpl)this.findViewObject("FormregulacaoView");
    }

    public ObservacoesViewImpl getObservacoesView() {
        return (ObservacoesViewImpl)this.findViewObject("ObservacoesView");
    }

    public PerguntasViewImpl getPerguntasView() {
        return (PerguntasViewImpl)this.findViewObject("PerguntasView");
    }

    public PeriodoViewImpl getPeriodoView() {
        return (PeriodoViewImpl)this.findViewObject("PeriodoView");
    }

    public RespostasRemessasViewImpl getRespostasRemessasView() {
        return (RespostasRemessasViewImpl)this.findViewObject("RespostasRemessasView");
    }

    public RemessasMCIViewImpl getRemessasMCIView() {
        return (RemessasMCIViewImpl)this.findViewObject("RemessasMCIView");
    }

    public EntidadesConsultaCNPJImpl getEntidadesConsultaCNPJ() {
        return (EntidadesConsultaCNPJImpl)this.findViewObject("EntidadesConsultaCNPJ");
    }

    public FormacaoViewImpl getFormacaoView() {
        return (FormacaoViewImpl)this.findViewObject("FormacaoView");
    }

    @Override
    public void atualizaCdEntidade(Integer cdEnt) {
        try {
            if (cdEnt != null) {
                ViewObject vo = this.findViewObject("CadcontinternoView");
                vo.executeQuery();
                vo.first();
                vo.previous();
                while (vo.hasNext()) {
                    Row linha = vo.next();
                    if (linha == null) continue;
                    linha.setAttribute(cdEnt.intValue(), (Object)"CdEntidade");
                }
                this.getTransaction().commit();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.getTransaction().rollback();
            throw new PersistenciaException("10029", new Object[]{"Erro ao inserir o CodEntidade no CadConsInterno"}, e);
        }
    }

    @Override
    public int getNroResponsaveis() {
        int retorno;
        try {
            ViewObject vo = this.findViewObject("CadcontinternoView");
            vo.setWhereClause("Ehresp = 'S'");
            vo.executeQuery();
            retorno = vo.getRowCount();
            vo.setWhereClause(null);
            vo.setWhereClauseParams(null);
            vo.executeQuery();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PersistenciaException("10029", new Object[]{"Erro ao inserir o CodEntidade no CadConsInterno"}, e);
        }
        return retorno;
    }

    @Override
    public int getCPFCadastrado(String cpf) {
        int retorno = 0;
        ViewObject voCpfContInterno = this.createViewObject("CpfContInterno", this.getCadcontinternoView().getDefFullName());
        try {
            voCpfContInterno.setWhereClause("CPF = ?");
            voCpfContInterno.setWhereClauseParam(0, (Object)cpf);
            voCpfContInterno.executeQuery();
            retorno = voCpfContInterno.getRowCount();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PersistenciaException("10029", new Object[]{"Erro ao inserir o CodEntidade no CadConsInterno"}, e);
        }
        finally {
            if (voCpfContInterno != null) {
                voCpfContInterno.remove();
            }
        }
        return retorno;
    }

    @Override
    public String getRespPergunta(String codPergunta, boolean resposta, boolean respExt) {
        try {
            if (codPergunta != null) {
                ViewObject vo = this.findViewObject("RespostasRemessasView");
                vo.setWhereClause("CD_PERGUNTA = '" + codPergunta + "'");
                vo.executeQuery();
                Row respostaRow = vo.first();
                if (respostaRow != null) {
                    if (resposta) {
                        return (String)respostaRow.getAttribute("Resposta");
                    }
                    if (respExt) {
                        return (String)respostaRow.getAttribute("RespostaExt");
                    }
                    return "";
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    @Override
    public String buscaCodBarras(String poder) {
        try {
            ViewObject remessasView = this.findViewObject("RemessasMCIView");
            remessasView.executeQuery();
            Row remessaRow = remessasView.first();
            if (remessaRow != null) {
                if (poder.equalsIgnoreCase("P")) {
                    return (String)remessaRow.getAttribute("CodBarrasmod9");
                }
                return (String)remessaRow.getAttribute("CodBarrasmod14");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    @Override
    public String buscaCodBarrasMCI() {
        try {
            ViewObject remessasView = this.findViewObject("RemessasMCIView");
            remessasView.executeQuery();
            Row remessaRow = remessasView.first();
            if (remessaRow != null) {
                return (String)remessaRow.getAttribute("CodBarras");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    @Override
    public String buscaRPPS() {
        try {
            ViewObject remessasView = this.findViewObject("RemessasMCIView");
            remessasView.executeQuery();
            Row remessaRow = remessasView.first();
            if (remessaRow != null) {
                return (String)remessaRow.getAttribute("Possuirpps");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    @Override
    public String buscaNomeEntidade() {
        try {
            ViewObject remessasView = this.findViewObject("RemessasMCIView");
            remessasView.executeQuery();
            Row remessaRow = remessasView.first();
            if (remessaRow != null) {
                return (String)remessaRow.getAttribute("NomeEntidade");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    @Override
    public Integer buscaCdEntidade() {
        try {
            ViewObject remessasView = this.findViewObject("RemessasMCIView");
            remessasView.executeQuery();
            Row remessaRow = remessasView.first();
            if (remessaRow != null) {
                return (Integer)remessaRow.getAttribute("CdEntidade");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new Integer(0);
    }

    @Override
    public int buscaPeriodo() {
        try {
            ViewObject remessasView = this.findViewObject("RemessasMCIView");
            remessasView.executeQuery();
            Row remessaRow = remessasView.first();
            if (remessaRow != null) {
                return (Integer)remessaRow.getAttribute("CdPeriodo");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 0;
    }

    @Override
    public int buscaAnoExercicio() {
        try {
            ViewObject remessasView = this.findViewObject("RemessasMCIView");
            remessasView.executeQuery();
            Row remessaRow = remessasView.first();
            if (remessaRow != null) {
                return (Integer)remessaRow.getAttribute("AnoExercicio");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 0;
    }

    @Override
    public boolean insereResposta(Remessa remessa, String pergunta, String respExt, String resposta) {
        block11: {
            if (resposta == null || resposta.length() != 1) {
                throw new PersistenciaException("10029", new Object[]{"Erro ao inserir na tabela Respostas: valor de resposta inv\u00e1lido [pergunta = " + pergunta + "]"});
            }
            if (respExt == null) {
                respExt = "";
            }
            try {
                ViewObject remessasView = this.findViewObject("RespostasRemessasView");
                remessasView.setWhereClause("CD_PERGUNTA = '" + pergunta + "'");
                remessasView.executeQuery();
                Row remessaRow = remessasView.first();
                if (remessaRow != null) {
                    remessaRow.setAttribute("CdPergunta", (Object)pergunta);
                    if (respExt == null || respExt.length() == 0) {
                        remessaRow.setAttribute("RespostaExt", (Object)"");
                    } else if (respExt.equalsIgnoreCase("X")) {
                        remessaRow.setAttribute("RespostaExt", (Object)"X");
                    } else {
                        remessaRow.setAttribute("RespostaExt", (Object)respExt);
                    }
                    remessaRow.setAttribute("CdEntidade", (Object)remessa.getCdEntidade());
                    remessaRow.setAttribute("Resposta", (Object)resposta);
                    remessasView.insertRow(remessaRow);
                    this.getTransaction().commit();
                    break block11;
                }
                try {
                    this.executeCommand("INSERT INTO MCI.MCI_RESPOSTAS_REMESSAS (CD_PERGUNTA, CD_ENTIDADE, RESPOSTA, RESPOSTA_EXT) VALUES ('" + pergunta + "'," + remessa.getCdEntidade() + ",'" + resposta + "', '" + respExt + "')");
                    this.getTransaction().commit();
                }
                catch (Exception e) {
                    this.getTransaction().rollback();
                    throw new PersistenciaException("10029", new Object[]{"Erro ao inserir pergunta " + pergunta + " na tabela MCI.MCI_RESPOSTAS_REMESSAS"}, e);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean insereObservacoes(String tpObs, Remessa remessa, String textoObs) {
        try {
            this.executeCommand("INSERT INTO MCI.MCI_OBSERVACOES (CD_OBSERVACOES, CD_ENTIDADE, OBSERVACOES) VALUES ('" + tpObs + "', " + remessa.getCdEntidade() + ", '" + textoObs + "')");
            this.getTransaction().commit();
        }
        catch (Exception e) {
            this.getTransaction().rollback();
            throw new PersistenciaException("10029", new Object[]{"Erro ao inserir na tabela MCI.MCI_OBSERVACOES [cd_observacoes = " + tpObs + "]"});
        }
        return true;
    }

    @Override
    public boolean insereCodBarras(String codBarras, String poder) {
        try {
            ViewObject remessasView = this.findViewObject("RemessasMCIView");
            remessasView.executeQuery();
            Row remessaRow = remessasView.first();
            if (poder.equalsIgnoreCase("P")) {
                remessaRow.setAttribute("CodBarrasmod9", (Object)codBarras);
                remessaRow.setAttribute("CodBarrasmod14", (Object)" ");
            } else {
                remessaRow.setAttribute("CodBarrasmod9", (Object)" ");
                remessaRow.setAttribute("CodBarrasmod14", (Object)codBarras);
            }
            this.getTransaction().commit();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.getTransaction().rollback();
            throw new PersistenciaException("10029", new Object[]{"Erro ao inserir o C\u00f3digo de Barras"}, e);
        }
        return true;
    }

    @Override
    public void atualizaDataGravacao(String nomeCampo, String valor) {
        try {
            ViewObject vo;
            Row r;
            if (nomeCampo != null && (r = (vo = this.findViewObject("RemessasMCIView")).getCurrentRow()) != null) {
                Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("America/Sao_Paulo"), new Locale("pt", "BR"));
                java.util.Date dataAtual = cal.getTime();
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
                df.setLenient(true);
                String dataDerby = df.format(dataAtual);
                r.setAttribute(nomeCampo, (Object)Date.valueOf(dataDerby));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void atualizaCampoRemessa(String nomeCampo, String valor) {
        try {
            ViewObject vo;
            Row r;
            if (nomeCampo != null && (r = (vo = this.findViewObject("RemessasMCIView")).getCurrentRow()) != null) {
                r.setAttribute(nomeCampo, (Object)valor);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void atualizaCampoRemessa(String nomeCampo, java.util.Date data) {
        try {
            ViewObject vo;
            Row r;
            if (nomeCampo != null && (r = (vo = this.findViewObject("RemessasMCIView")).getCurrentRow()) != null) {
                r.setAttribute(nomeCampo, (Object)data);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getNomeEntidade(Remessa remessa) {
        try {
            ViewObject vo = this.findViewObject("EntidadesView");
            vo.setWhereClause("CD_ENTIDADE = " + remessa.getCdEntidade());
            vo.executeQuery();
            Row r = vo.getCurrentRow();
            if (r != null) {
                return (String)r.getAttribute("Nome");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    @Override
    public int getNroHabitantes() {
        try {
            ViewObject vo = this.findViewObject("NroHabitantesView");
            Row r = vo.first();
            if (r != null) {
                return ((BigDecimal)r.getAttribute("NRO_HABITANTES")).intValue();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 0;
    }

    @Override
    public void limpaTabelas(int cdEntidade) {
        try {
            this.executeCommand("DELETE FROM MCI.MCI_RESPOSTAS_REMESSAS");
            this.executeCommand("DELETE FROM MCI.MCI_OBSERVACOES");
            this.executeCommand("DELETE FROM MCI.MCI_FORMREGULACAO");
            this.executeCommand("DELETE FROM MCI.MCI_CADCONTINTERNO");
        }
        catch (Exception e) {
            e.printStackTrace();
            this.getTransaction().rollback();
            throw new PersistenciaException("10029", new Object[]{"Erro na limpeza tabela Respostas"}, e);
        }
    }

    @Override
    public void limpaTabelasContInterno() {
        try {
            this.executeCommand("DELETE FROM MCI.MCI_CADCONTINTERNO");
            this.executeCommand("DELETE FROM MCI.MCI_FORMREGULACAO");
        }
        catch (Exception e) {
            System.out.println("Erro na dele\u00e7\u00e3o");
            this.getTransaction().rollback();
            throw new PersistenciaException("10029", new Object[]{"Erro na limpeza tabela Respostas"});
        }
    }

    @Override
    public void limpaCodBarras() {
        try {
            this.executeCommand("UPDATE MCI.MCI_REMESSASMCI SET COD_BARRASMOD9=''");
            this.executeCommand("UPDATE MCI.MCI_REMESSASMCI SET COD_BARRASMOD14=''");
            this.getTransaction().commit();
        }
        catch (Exception e) {
            System.out.println("Erro na dele\u00e7\u00e3o");
            this.getTransaction().rollback();
            throw new PersistenciaException("10029", new Object[]{"Erro na limpeza tabela Respostas"});
        }
    }

    @Override
    public void atualizaCadContInterno() {
        try {
            ViewObject vo = this.findViewObject("RemessasMCIView");
            Row r = vo.getCurrentRow();
            this.executeCommand("UPDATE MCI.MCI_CADCONTINTERNO SET CD_ENTIDADE=" + r.getAttribute("CdEntidade"));
            this.getTransaction().commit();
        }
        catch (Exception e) {
            System.out.println("Erro na dele\u00e7\u00e3o");
            this.getTransaction().rollback();
        }
    }

    public NroHabitantesViewImpl getNroHabitantesView() {
        return (NroHabitantesViewImpl)this.findViewObject("NroHabitantesView");
    }

    @Override
    public void limpaRemessa() {
        try {
            this.getTransaction().rollback();
            this.limpaTabelas(0);
            this.limpaTabelasContInterno();
            this.executeCommand("delete from mci.mci_remessasmci");
            this.getTransaction().commit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void insereRemessa(RemessaInfo remessaInfo) throws Exception {
        Key k = new Key(new Object[]{new BigDecimal("" + remessaInfo.getCodigoEntidade())});
        ViewObject viewRemessa = this.findViewObject("RemessasMCIView");
        Row testrow = viewRemessa.getRow(k);
        if (testrow != null) {
            throw new MCIRuntimeException("Impossivel inserir remessa j\u00e1 existente");
        }
        viewRemessa.executeQuery();
        Row remessaRow = viewRemessa.createRow();
        remessaRow.setAttribute("CdEntidade", (Object)remessaInfo.getCodigoEntidade());
        remessaRow.setAttribute("AnoExercicio", (Object)remessaInfo.getAnoExercicio());
        remessaRow.setAttribute("DtGravacao", (Object)(remessaInfo.getDataGeracao() == null ? null : new Date(remessaInfo.getDataGeracao().getTime())));
        remessaRow.setAttribute("CodBarras", (Object)remessaInfo.getCodBarrasMCI());
        remessaRow.setAttribute("Tpentrega", (Object)remessaInfo.getTipoEntrega());
        remessaRow.setAttribute("VersaoMci", (Object)remessaInfo.getVersao());
        remessaRow.setAttribute("SituacaoCarga", (Object)0);
        remessaRow.setAttribute("CdPeriodo", (Object)remessaInfo.getCodPeriodo());
        remessaRow.setAttribute("Poder", (Object)remessaInfo.getTipoOrgao());
        ViewObject viewEntidades = this.findViewObject("EntidadesView");
        viewEntidades.setWhereClause("cd_entidade = " + remessaInfo.getCodigoEntidade());
        viewEntidades.executeQuery();
        Row rowEntidade = viewEntidades.first();
        System.out.println("ServicoMCIImpl.insereRemessa row:" + rowEntidade + "/" + rowEntidade.getAttribute("Nome") + " / data: " + remessaInfo.getDataGeracao());
        remessaRow.setAttribute("NomeEntidade", rowEntidade.getAttribute("Nome"));
        this.setEscolhidoPre(remessaRow, remessaInfo);
        viewRemessa.insertRow(remessaRow);
        System.out.println("ServicoMCIImpl.insereRemessa: getCodigoEntidade():" + remessaInfo.getCodigoEntidade() + "; getAnoExercicio():" + remessaInfo.getAnoExercicio() + "; getDataGeracao():" + remessaInfo.getDataGeracao() + " barras:" + remessaInfo.getCodBarrasMCI() + "; remessaInfo.getTipoEntrega():" + remessaInfo.getTipoEntrega() + "; remessaInfo.getVersao():" + remessaInfo.getVersao() + "; remessaInfo.getCodPeriodo():" + remessaInfo.getCodPeriodo() + "; poder:" + remessaInfo.getTipoOrgao());
        this.getTransaction().commit();
        viewRemessa.executeQuery();
        testrow = viewRemessa.first();
    }

    private void setEscolhidoPre(Row remessaRow, RemessaInfo remessaInfo) throws Exception {
        remessaRow.setAttribute("EscolhidoPre", (Object)"S");
    }

    @Override
    public void atualizaCNPJEntidade(String cdEntidade, String cnpjNovo) throws PersistenciaException {
        try {
            StringBuffer sql = new StringBuffer();
            sql.append("UPDATE MCI.MCI_ENTIDADES SET CNPJ = '" + cnpjNovo + "' WHERE CD_ENTIDADE = " + cdEntidade);
            this.executeCommand(sql.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PersistenciaException("10029", new Object[]{"Erro ao atualizar Entidade"}, e);
        }
    }
}

