/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.mci.modelo.seguranca.test;

import br.gov.rs.tce.mci.modelo.seguranca.AssinaturaDigitalControle;
import br.gov.rs.tce.mci.util.Base64Utils;
import java.io.File;
import junit.framework.TestCase;

public class AssinaturaDigitalControleTest
extends TestCase {
    public AssinaturaDigitalControleTest(String sTestName) {
        super(sTestName);
    }

    public void testCreateDigitalSign() {
        File file = new File("./test/arquivos.xml");
        File ksFile = new File("./test/saop_cert.pfx");
        AssinaturaDigitalControle.CertificationChainAndSignature cc = AssinaturaDigitalControle.assinaDigitalmenteArquivo(file, ksFile, "GPHE6-ENKJ6-YOUE7");
        AssinaturaDigitalControleTest.assertNotNull((Object)cc);
        System.out.println("\n" + cc.getSignature());
        System.out.println(cc.getCertificationChain());
    }

    public void testCreateDigitalSignStep() {
        File file = new File("./test/arquivos.xml");
        File ksFile = new File("./test/saop_cert.pfx");
        AssinaturaDigitalControle.CertificationChainAndSignature cc = AssinaturaDigitalControle.assinaDigitalmenteArquivo(file, ksFile, "GPHE6-ENKJ6-YOUE7");
        AssinaturaDigitalControleTest.assertNotNull((Object)cc);
        byte[] signature = Base64Utils.base64Decode(cc.getSignature());
        boolean ok = AssinaturaDigitalControle.validaAssinaturaDigital(file, cc.getCertificationChain(), signature);
        AssinaturaDigitalControleTest.assertTrue((String)"Assinatura deve conferir !!!", (boolean)ok);
        signature = Base64Utils.base64Decode(cc.getSignature());
        signature[1] = 2;
        ok = AssinaturaDigitalControle.validaAssinaturaDigital(file, cc.getCertificationChain(), signature);
        AssinaturaDigitalControleTest.assertFalse((String)"Assinatura deve n\u00e3o conferir !!!", (boolean)ok);
    }

    public void testCreateDigest() {
        File file = new File("./test/arquivos.xml");
        byte[] digest = AssinaturaDigitalControle.calculaDigest(file);
        AssinaturaDigitalControleTest.assertNotNull((Object)digest);
        AssinaturaDigitalControleTest.assertEquals((String)"tgwVDZKCYcXAFV76giJm+gf6tbc=", (String)Base64Utils.base64Encode(digest));
    }

    public void testManualSignatureCriptAssimetric() {
    }
}

