/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.mci.modelo.importacao.processadores;

import br.gov.rs.tce.mci.beans.remessa.Remessa;
import br.gov.rs.tce.mci.excecao.MCIRuntimeException;
import br.gov.rs.tce.mci.excecao.PersistenciaException;
import oracle.jbo.ApplicationModule;
import oracle.jbo.JboException;
import oracle.jbo.ViewObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;

public class ProcessaCarga {
    protected ApplicationModule app;
    private String voName;
    private String voImplementation;
    private int niveis = -1;
    private static Log log = LogFactory.getLog(ProcessaCarga.class);

    public ProcessaCarga(ApplicationModule app, String voName, String voImplementation) {
        this.app = app;
        this.voName = voName;
        this.voImplementation = voImplementation;
    }

    public void processaNodo(Element nodo, Remessa remessa) {
        log.debug((Object)"Processamento default do nodo.");
        try {
            ViewObject viewObject = this.criaViewObject(nodo);
        }
        catch (JboException e) {
            e.printStackTrace();
            throw new MCIRuntimeException(e);
        }
        finally {
            ViewObject vo = this.app.findViewObject(this.voName);
            if (vo != null) {
                vo.remove();
            }
        }
    }

    protected ViewObject criaViewObject(Element nodo) {
        ViewObject vo = null;
        try {
            System.setProperty("javax.xml.parsers.DocumentBuilderFactory", "oracle.xml.jaxp.JXDocumentBuilderFactory");
            vo = this.app.findViewObject(this.voName);
            if (vo != null) {
                vo.remove();
            }
            vo = this.app.createViewObject(this.voName, this.voImplementation);
            vo.setWhereClause(null);
            vo.setWhereClauseParams(null);
            vo.executeQuery();
            int conta = vo.getRowCount();
            log.debug((Object)(this.voName + "\n ANTES READ = " + vo.getRowCount()));
            log.debug((Object)("nome do nodo = " + nodo.getNodeName() + " \n valor = " + nodo.getNodeValue()));
            vo.readXML(nodo, this.niveis);
            log.debug((Object)("DEPOIS 1 READ = " + vo.getRowCount()));
            if (conta == vo.getRowCount()) {
                vo.readRowXML(nodo, this.niveis);
                log.debug((Object)("DEPOIS 2 READ = " + vo.getRowCount()));
            }
        }
        catch (JboException e) {
            log.error((Object)e);
            e.printStackTrace();
            throw new PersistenciaException(e);
        }
        catch (Exception e) {
            log.error((Object)e);
            e.printStackTrace();
            throw new PersistenciaException(e);
        }
        return vo;
    }

    protected ViewObject criaViewObject(Element nodo, int niveis) {
        this.niveis = niveis;
        return this.criaViewObject(nodo);
    }
}

