/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.mci.modelo.exportacao;

import br.gov.rs.tce.mci.beans.ConsultaExtracao;
import br.gov.rs.tce.mci.beans.ConsultaSQL;
import br.gov.rs.tce.mci.beans.ConsultasExtracaoList;
import br.gov.rs.tce.mci.beans.TipoBancoDados;
import br.gov.rs.tce.mci.beans.remessa.Remessa;
import br.gov.rs.tce.mci.excecao.ImportacaoException;
import br.gov.rs.tce.mci.excecao.PersistenciaException;
import br.gov.rs.tce.mci.modelo.profiler.CodigosProfile;
import br.gov.rs.tce.mci.util.IndicadorProgresso;
import com.sun.java.util.collections.HashMap;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import oracle.jbo.ApplicationModule;
import oracle.jbo.JboException;
import oracle.jbo.ViewObject;
import oracle.jdeveloper.profiler.ProfilerAPI;
import oracle.xml.parser.v2.XMLNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class ExportacaoDados
implements IndicadorProgresso {
    private ApplicationModule _applicationModule;
    private static HashMap mapDefs = new HashMap(0);
    private DocumentBuilderFactory factory;
    private DocumentBuilder builder;
    private static final Log log = LogFactory.getLog(ExportacaoDados.class);
    private int _eventHandler;
    private ChangeListener _changeListener;
    private String _situacao;
    private int _progresso;

    public ExportacaoDados(ApplicationModule appModule, ChangeListener listener) {
        this(appModule);
        this._changeListener = listener;
    }

    public ExportacaoDados(ApplicationModule appModule) {
        try {
            this._applicationModule = appModule;
            System.setProperty("javax.xml.parsers.DocumentBuilderFactory", "oracle.xml.jaxp.JXDocumentBuilderFactory");
            this.factory = DocumentBuilderFactory.newInstance();
            this.builder = this.factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
    }

    public void montaXMLsaida(ConsultasExtracaoList consultas, File arquivo, Remessa remessa, TipoBancoDados tpBanco) {
        this.montaXMLsaida(consultas, arquivo, remessa, tpBanco, false);
    }

    public void montaXMLsaida(ConsultasExtracaoList consultas, File arquivo, Remessa remessa, TipoBancoDados tpBanco, boolean isUTF8) {
        String formatEncoding = "";
        formatEncoding = isUTF8 || "remessa.xml".equals(arquivo.getName().toLowerCase()) ? "UTF-8" : "ISO-8859-1";
        if (consultas == null) {
            throw new IllegalArgumentException("ConsultasExtracaoList n\u00e3o pode ser nulo");
        }
        if (arquivo == null) {
            throw new IllegalArgumentException("O arquivo de destino n\u00e3o pode ser nulo");
        }
        if (tpBanco == null) {
            throw new IllegalArgumentException("O tipo de banco de dados n\u00e3o pode ser nulo");
        }
        BufferedWriter bw = null;
        try {
            this.setSituacao("Preparando para extra\u00e7\u00e3o de informa\u00e7\u00f5es do banco de dados...");
            if (!arquivo.getParentFile().exists()) {
                arquivo.getParentFile().mkdir();
            }
            Document documentoXML = this.builder.newDocument();
            String nomeElementoPai = consultas.getElementoPai();
            Element root = documentoXML.createElement(consultas.getElementoPai());
            List listaConsultas = consultas.getConsultasExtracao();
            this.setProgresso(0);
            int qtdElementos = 0;
            for (int i = 0; i < listaConsultas.size(); ++i) {
                ConsultaExtracao consExtracao = (ConsultaExtracao)listaConsultas.get(i);
                qtdElementos += this.contaElementosAninhados(consExtracao, 0);
                System.gc();
            }
            System.gc();
            int idxAtual = 0;
            for (int i = 0; i < listaConsultas.size(); ++i) {
                ConsultaExtracao consExtracao = (ConsultaExtracao)listaConsultas.get(i);
                idxAtual += this.montaElementos(consExtracao, documentoXML, root, remessa, tpBanco, idxAtual, qtdElementos);
            }
            System.gc();
            bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(arquivo), formatEncoding));
            bw.write("<?xml version=\"1.0\" encoding=\"" + formatEncoding + "\"?>\n");
            this.setSituacao("Salvando informa\u00e7\u00f5es extra\u00eddas...");
            ((XMLNode)root).print((Writer)bw);
        }
        catch (IOException ioe) {
            throw new PersistenciaException("10033", new Object[]{ioe.getMessage()}, ioe);
        }
        finally {
            if (bw != null) {
                try {
                    bw.close();
                }
                catch (IOException e) {
                    log.error((Object)e);
                }
            }
        }
        System.gc();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int montaElementos(ConsultaExtracao consulta, Document documento, Element elementoPai, Remessa remessa, TipoBancoDados tpBanco, int idxAtual, int qtdElementos) {
        if (consulta == null) {
            throw new IllegalArgumentException("Consulta n\u00e3o pode ser nulo");
        }
        int eventHandler = -1;
        try {
            List aninhadas = consulta.getConsultas();
            int qtdAninhadas = aninhadas.size();
            ConsultaSQL consultaSQL = null;
            String nomeElemento = consulta.getElemento();
            if (nomeElemento == null || nomeElemento.length() == 0) {
                throw new IllegalArgumentException("O nome de um elemento n\u00e3o pode ser vazio.");
            }
            if (CodigosProfile.MONTA_ELEMENTO_EXPORTACAO_ON) {
                eventHandler = ProfilerAPI.startEvent((int)505, (String)("Elemento: " + nomeElemento));
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Gerando elemento: " + nomeElemento));
            }
            try {
                consultaSQL = consulta.recuperaConsultaSQL(remessa, tpBanco);
            }
            catch (IllegalArgumentException e) {
                if (qtdAninhadas == 0) {
                    throw e;
                }
            }
            catch (Exception x) {
                log.debug((Object)("Erro: " + x.getMessage()));
            }
            if (consultaSQL != null) {
                Node nodoDados = this.extraiDadosViaSQL(nomeElemento, consultaSQL);
                if (nodoDados != null) {
                    int eventHandlerXML = -1;
                    if (CodigosProfile.XML_MONTA_ELEMENTO_EXPORTACAO_ON) {
                        eventHandlerXML = ProfilerAPI.startEvent((int)507, (String)("\nImporta\u00e7\u00e3o elemento: " + nomeElemento + " para documento final."));
                    }
                    Node nodoImportado = documento.importNode(nodoDados, true);
                    elementoPai.appendChild(nodoImportado);
                    if (eventHandlerXML != -1 && CodigosProfile.XML_MONTA_ELEMENTO_EXPORTACAO_ON) {
                        ProfilerAPI.endEvent((int)eventHandlerXML);
                    }
                }
            } else {
                Element elemento = documento.createElement(nomeElemento);
                elementoPai.appendChild(elemento);
                elementoPai = elemento;
            }
            for (int i = 0; i < qtdAninhadas; ++i) {
                ConsultaExtracao inner = (ConsultaExtracao)aninhadas.get(i);
                idxAtual += this.montaElementos(inner, documento, elementoPai, remessa, tpBanco, idxAtual, qtdElementos);
            }
        }
        finally {
            if (eventHandler != -1 && CodigosProfile.MONTA_ELEMENTO_EXPORTACAO_ON) {
                ProfilerAPI.endEvent((int)eventHandler);
            }
        }
        if (consulta.hasSqlQuery()) {
            idxAtual = 1;
            double d = (double)idxAtual * 1.0 / (double)qtdElementos * 100.0;
            this.setProgresso((int)Math.round(d));
        }
        return idxAtual;
    }

    protected Node extraiDadosViaSQL(String nomeElemento, ConsultaSQL consultaSql) {
        ViewObject vo = null;
        Node dados = null;
        int eventHandlerSQL = -1;
        int eventHandlerXML = -1;
        try {
            vo = this._applicationModule.createViewObjectFromQueryStmt(nomeElemento, consultaSql.getSql());
            Object[] parametros = consultaSql.getValoresParametros();
            for (int i = 0; i < parametros.length; ++i) {
                vo.setWhereClauseParam(i, parametros[i]);
            }
            vo.executeQuery();
            if (CodigosProfile.XML_MONTA_ELEMENTO_EXPORTACAO_ON) {
                eventHandlerXML = ProfilerAPI.startEvent((int)507, (String)("\nGera\u00e7\u00e3o do XML do Elemento: " + nomeElemento));
            }
            dados = vo.writeXML(0L, mapDefs);
            vo.closeRowSet();
        }
        catch (JboException jboe) {
            log.debug((Object)("Elemento: " + nomeElemento + " - " + jboe.getMessage()));
            throw new ImportacaoException("10033", new Object[]{nomeElemento}, (Exception)((Object)jboe));
        }
        finally {
            if (vo != null) {
                vo.remove();
            }
            if (eventHandlerXML != -1 && CodigosProfile.XML_MONTA_ELEMENTO_EXPORTACAO_ON) {
                ProfilerAPI.endEvent((int)eventHandlerXML);
            }
        }
        return dados;
    }

    private void setSituacao(String situacao) {
        this._situacao = situacao;
        this.fireChangeStateEvent();
    }

    @Override
    public String getSituacao() {
        return this._situacao;
    }

    public void fireChangeStateEvent() {
        if (this._changeListener != null) {
            ChangeEvent change = new ChangeEvent(this);
            this._changeListener.stateChanged(change);
        }
    }

    private void setProgresso(int progresso) {
        this._progresso = progresso;
        this.fireChangeStateEvent();
    }

    @Override
    public int getProgresso() {
        return this._progresso;
    }

    public int contaElementosAninhados(ConsultaExtracao consulta, int count) {
        List aninhadas = consulta.getConsultas();
        if (aninhadas != null) {
            for (int i = 0; i < aninhadas.size(); ++i) {
                ConsultaExtracao inner = (ConsultaExtracao)aninhadas.get(i);
                if (inner.hasSqlQuery()) {
                    ++count;
                    continue;
                }
                count = count + this.contaElementosAninhados(inner, count++);
            }
        }
        return count;
    }
}

