/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.mci.modelo.decisao;

import br.gov.rs.tce.mci.beans.Tela;
import br.gov.rs.tce.mci.excecao.MCIActionException;
import br.gov.rs.tce.mci.modelo.action.MciModeloAction;
import br.gov.rs.tce.mci.modelo.decisao.DecisaoNavegacaoTelas;
import br.gov.rs.tce.mci.modelo.decisao.Navegacao;
import oracle.adf.model.BindingContext;
import oracle.adf.model.generic.DCGenericDataControl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class NavegacaoTelasControle
extends DCGenericDataControl {
    public static final String NAVEGACAO_DATA_CONTROL = "$NavegacaoDataControl";
    private Navegacao _navegacao;
    private BindingContext _binding;
    private Log log = LogFactory.getLog(NavegacaoTelasControle.class);

    public NavegacaoTelasControle() {
        super(NAVEGACAO_DATA_CONTROL, Navegacao.class.getName(), (Object)new Navegacao(), true);
        this._navegacao = (Navegacao)this.getDataProvider();
        this._navegacao.avancarTela(DecisaoNavegacaoTelas.getInstancia().getTelaInicial());
    }

    public Tela avancarTela(String codigoTelaAtual, BindingContext binding) {
        this._binding = binding;
        DecisaoNavegacaoTelas decicaoTelas = DecisaoNavegacaoTelas.getInstancia();
        Tela atual = decicaoTelas.getTelaPorCodigo(codigoTelaAtual);
        Tela tela = decicaoTelas.escolheProximaTela(codigoTelaAtual, binding);
        this.limpaModelo(atual, binding);
        this.preparaModelo(tela, binding);
        this._navegacao.avancarTela(tela);
        this.log.info((Object)("Avancando para tela: " + tela.getCodigo()));
        return tela;
    }

    public Tela voltarTela() {
        Tela telaAtual = this._navegacao.getTelaAtual();
        this.limpaModelo(telaAtual, this._binding);
        Tela tela = this._navegacao.voltarTela();
        this.preparaModelo(tela, this._binding);
        return tela;
    }

    public Tela getConfigTelaAtual() {
        return this._navegacao.getTelaAtual();
    }

    private void preparaModelo(Tela proxTela, BindingContext binding) {
        String nomeActionModelo = proxTela.getActionModelo();
        if (nomeActionModelo != null && nomeActionModelo.length() > 5) {
            MciModeloAction action = this.getAction(proxTela.getCodigo(), nomeActionModelo);
            action.preparaModelo(proxTela, binding);
        }
    }

    private void limpaModelo(Tela tela, BindingContext binding) {
        String classe = tela.getActionModelo();
        if (classe != null && !classe.equals("")) {
            MciModeloAction action = this.getAction(tela.getCodigo(), classe);
            action.limpaModelo(tela, binding);
        }
    }

    private MciModeloAction getAction(String codigoTela, String nomeClasse) throws MCIActionException {
        MciModeloAction action = null;
        try {
            action = (MciModeloAction)Class.forName(nomeClasse).newInstance();
        }
        catch (Exception e) {
            throw new MCIActionException(codigoTela, nomeClasse, e);
        }
        return action;
    }
}

