/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.mci.modelo;

import br.gov.rs.tce.mci.beans.TipoBancoDados;
import br.gov.rs.tce.mci.beans.remessa.Remessa;
import br.gov.rs.tce.mci.beans.remessa.RemessaInfo;
import br.gov.rs.tce.mci.excecao.ConfiguracaoException;
import br.gov.rs.tce.mci.excecao.SegurancaException;
import br.gov.rs.tce.mci.excecao.SenhaInvalidaException;
import br.gov.rs.tce.mci.modelo.ConfiguracaoControle;
import br.gov.rs.tce.mci.modelo.GeraArquivoRemessa;
import br.gov.rs.tce.mci.modelo.relatorio.RelatorioControle;
import br.gov.rs.tce.mci.modelo.seguranca.AssinaturaDigitalControle;
import br.gov.rs.tce.mci.modelo.seguranca.CriptografiaControle;
import br.gov.rs.tce.mci.modelo.servico.common.ServicoMCI;
import br.gov.rs.tce.mci.util.CodigoBarrasHelper;
import br.gov.rs.tce.mci.util.CompactacaoHelper;
import br.gov.rs.tce.mci.util.DatabaseHelper;
import br.gov.rs.tce.mci.util.DatacontrolHelper;
import br.gov.rs.tce.mci.util.VersaoUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.adf.model.BindingContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.ValidationException;

public class RemessaControle {
    static Log log = LogFactory.getLog(RemessaControle.class);
    public static final String SENHA_CERTIFICADO = "YABX5-EMUE7-ECDD7";
    private Remessa remessa = null;
    private File diretorioDestino = null;
    private List _changeListeners;
    private String _situacao;
    private int _progresso;
    private ServicoMCI servicoMCI;

    public RemessaControle(Remessa rem, File diretorioDestino) {
        this.remessa = rem;
        this.diretorioDestino = diretorioDestino;
    }

    public RemessaControle(Remessa rem, File diretorioDestino, ChangeListener listener) {
        this.remessa = rem;
        this.diretorioDestino = diretorioDestino;
        this._changeListeners = new ArrayList();
        this._changeListeners.add(listener);
    }

    public void geraZipRemessa() {
        this.compactaArquivosXml();
    }

    public void geraZipAssinado(File arquivoSaida) {
        int QTD_ARQUIVOS = 3;
        File[] f = new File[]{new File(this.getPath() + "remessa.crp"), new File(this.getPath() + "remessa_info.xml"), new File(this.getPath() + "relat.crp")};
        CompactacaoHelper zip = new CompactacaoHelper();
        zip.compacta(f, arquivoSaida);
    }

    public void geraXml(Object rem, FileWriter writer) {
        try {
            Marshaller mar = new Marshaller((Writer)writer);
            mar.setEncoding("ISO-8859-1");
            mar.marshal(rem);
        }
        catch (IOException e) {
            throw new ConfiguracaoException("Erro ao gerar arquivo com informa\u00e7\u00f5es sobre a remessa e assinatura", e);
        }
        catch (MarshalException e) {
            throw new ConfiguracaoException("Erro ao gerar arquivo com informa\u00e7\u00f5es sobre a remessa e assinatura", (Exception)((Object)e));
        }
        catch (ValidationException e) {
            throw new ConfiguracaoException("Erro ao gerar arquivo com informa\u00e7\u00f5es sobre a remessa e assinatura", (Exception)((Object)e));
        }
    }

    private void criptografaZipRemessa() {
        try {
            CriptografiaControle.criptografa(new File(this.getPath() + "remessa.zip"), new File(this.getPath() + "remessa.crp"), "P@D.WEB?D&SKTOP;");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public void compactaArquivosXml() {
        File[] f = this.buscaArquivosXml();
        CompactacaoHelper zip = new CompactacaoHelper();
        zip.compacta(f, new File(this.getPath() + "remessa.zip"));
    }

    private File[] buscaArquivosXml() {
        ArrayList<File> fileL = new ArrayList<File>();
        fileL.add(new File(this.getPath() + File.separator + "relmci.xml"));
        fileL.add(new File(this.getPath() + File.separator + "remessa.xml"));
        return this.converteArrayFile(fileL);
    }

    public void geraRemessa(ServicoMCI module, char[] senha, File certificado) {
        RemessaInfo reme;
        block8: {
            this.servicoMCI = module;
            this.setSituacao("Recuperando informa\u00e7\u00f5es da remessa atual");
            reme = new RemessaInfo();
            reme.setCodigoEntidade(this.remessa.getCdEntidade());
            reme.setAnoExercicio(this.remessa.getAnoExercicio());
            reme.setCodPeriodo(this.remessa.getPeriodoInformacoes());
            Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("America/Sao_Paulo"), new Locale("pt", "BR"));
            reme.setDataGeracao(cal.getTime());
            reme.setVersao("3.0.1.9");
            reme.setTipoOrgao(this.remessa.getTipoSetor());
            reme.setTipoEntrega(this.remessa.getTipoEntrega());
            if (this.remessa.getTipoSetor().equalsIgnoreCase("P")) {
                reme.setCodBarrasModelo9(this.servicoMCI.buscaCodBarras("P"));
                reme.setCodBarrasModelo14("");
                reme.setGrupoEntrega(String.valueOf(RemessaControle.getGrupoRelatorio(reme.getCodBarrasModelo9())));
            } else {
                reme.setCodBarrasModelo9("");
                reme.setCodBarrasModelo14(this.servicoMCI.buscaCodBarras("C"));
                reme.setGrupoEntrega(String.valueOf(RemessaControle.getGrupoRelatorio(reme.getCodBarrasModelo14())));
            }
            TipoBancoDados tp = DatabaseHelper.recuperaTipoBancoDados(module);
            GeraArquivoRemessa gera = new GeraArquivoRemessa(module, new File(this.getPath() + "remessa.xml"), this.remessa, tp);
            this.setSituacao("Gerando Arquivo da remessa");
            gera.geraArquivo();
            this.setSituacao("Compactando arquivo de remessa");
            this.compactaArquivosXml();
            this.setSituacao("Criptografando dados da remessa");
            this.criptografaZipRemessa();
            try {
                String strSenha = null;
                strSenha = senha != null ? new String(senha) : SENHA_CERTIFICADO;
                AssinaturaDigitalControle.CertificationChainAndSignature cc = null;
                this.setSituacao("Assinando digitalmente arquivos da remessa");
                cc = AssinaturaDigitalControle.assinaDigitalmenteArquivo(new File(this.getPath() + "remessa.crp"), certificado, strSenha);
                reme.setAssinaturaXml(cc.getSignature());
                reme.setCadeiaCertificado(cc.getCertificationChain());
            }
            catch (Exception e) {
                if (e.getMessage().indexOf("failed to decrypt safe contents entry") < 0) break block8;
                throw new SenhaInvalidaException("Senha informada n\u00e3o confere com senha do arquivo de certificado");
            }
        }
        reme.calculaDigestRemessa();
        if (reme.getTipoOrgao().equalsIgnoreCase("C")) {
            reme.setCodBarrasMCI(CodigoBarrasHelper.constroiCodigoBarra(reme, 5));
        } else {
            reme.setCodBarrasMCI(CodigoBarrasHelper.constroiCodigoBarra(reme, 4));
        }
        System.out.println(">>>> codigo-barras-mci: " + reme.getCodBarrasMCI());
        this.setSituacao("Gerando arquivo com informa\u00e7\u00f5es sobre a remessa atual");
        try {
            this.geraXml(reme, new FileWriter(this.getPath() + "remessa_info.xml"));
        }
        catch (IOException e) {
            throw new ConfiguracaoException("Erro ao gerar xml da RemessaInfo");
        }
        module.atualizaCampoRemessa("CodBarras", reme.getCodBarrasMCI());
        this.setSituacao("Gerando arquivo compactado com remessa e arquivos de informa\u00e7\u00e3o");
        this.setSituacao("Arquivo de remessa gerado");
    }

    public static synchronized int getGrupoRelatorio(String codBarras) {
        int retorno = -1;
        if (codBarras != null && !"".equals(codBarras)) {
            if (codBarras.length() == 15) {
                retorno = Integer.parseInt(codBarras.substring(4, 5));
            } else if (codBarras.length() == 17) {
                retorno = Integer.parseInt(codBarras.substring(5, 7));
            }
        }
        return retorno;
    }

    public RemessaInfo recuperaArquivosRemessa(File fRemessa, ChangeListener listener) {
        CompactacaoHelper comp = new CompactacaoHelper();
        boolean retorno = true;
        retorno = comp.copiaArquivoCompactado(new File(fRemessa.getPath()), new File(this.getPath()), listener);
        if (!retorno) {
            return null;
        }
        comp.descompacta(new File(this.getPath() + File.separator + "remessa.dat"), new File(this.getPath()));
        System.gc();
        File remessaInfo = new File(this.getPath() + File.separator + "remessa_info.xml");
        RemessaInfo rem = (RemessaInfo)ConfiguracaoControle.carregaDadosArquivoXML("remessa-info", remessaInfo, true);
        return rem;
    }

    public void geraRelatorios(BindingContext binding) {
        RelatorioControle relatorios = new RelatorioControle();
        relatorios.geraRelatorios(DatacontrolHelper.getRemessaDataControl(binding), DatacontrolHelper.getServicoMCIAppModule(binding), this.diretorioDestino);
    }

    public void geraRemessa(ServicoMCI module, char[] senha, File certificado, boolean compactaTXT) {
        this.geraRemessa(module, senha, certificado);
    }

    private void fireChangedEvent() {
        ChangeEvent evento = new ChangeEvent(this);
        Iterator it = this._changeListeners.iterator();
        while (it.hasNext()) {
            ((ChangeListener)it.next()).stateChanged(evento);
        }
    }

    public int getProgressoEnvio() {
        return this._progresso;
    }

    public String getSituacao() {
        return this._situacao;
    }

    private void setSituacao(String situacao) {
        this._situacao = situacao;
        this.fireChangedEvent();
    }

    public String getPath() {
        return this.diretorioDestino.getAbsolutePath() + File.separator;
    }

    private File[] converteArrayFile(List files) {
        int cont = 0;
        File[] file = new File[files.size()];
        Iterator i = files.iterator();
        while (i.hasNext()) {
            file[cont] = (File)i.next();
            ++cont;
        }
        return file;
    }

    public void removeArquivosRemessa() {
        this.excluiArquivo("consolida_remessa.dat");
        this.excluiArquivo("remessa.crp");
        this.excluiArquivo("relmci.xsl");
        this.excluiArquivo("remessa.zip");
        this.excluiArquivo("remessa.crp");
        this.excluiArquivo("relat.zip");
        if (!VersaoUtils.isDebugModeEnabled()) {
            this.excluiArquivo("relmci.xml");
            this.excluiArquivo("remessa.xml");
        }
    }

    private void excluiArquivo(String file) {
        File f = new File(this.getPath() + File.separator + file);
        try {
            System.out.println(f.getCanonicalFile());
            if (f.exists()) {
                f.delete();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void geraArquivoCrpPDFs() {
        File relmci = new File(this.getPath() + File.separator + "relmci.pdf");
        ArrayList<File> files = new ArrayList<File>();
        if (relmci.exists()) {
            files.add(relmci);
        }
        try {
            CompactacaoHelper zip = new CompactacaoHelper();
            File relatZip = new File(this.getPath() + "relat.zip");
            File relatCrp = new File(this.getPath() + "relat.crp");
            zip.compacta(this.converteArrayFile(files), relatZip);
            CriptografiaControle.criptografa(relatZip, relatCrp, "P@D.WEB?D&SKTOP;");
        }
        catch (SegurancaException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }
}

