/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.mci.modelo;

import br.gov.rs.tce.mci.beans.Configuracao;
import br.gov.rs.tce.mci.excecao.ConfiguracaoException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.castor.mapping.Mapping;
import org.exolab.castor.xml.Unmarshaller;
import org.xml.sax.InputSource;

public class ConfiguracaoControle {
    private Configuracao configuracaoAmbiente;
    public static final String MENSAGENS_MAPPING_CONF = "mensagens";
    public static final String TELAS_MAPPING_CONF = "telas";
    public static final String EXTRACAO_MAPPING_CONF = "extracao";
    public static final String REMESSA_INFO = "remessa-info";
    public static final String BACKUP_MAPPING_CONF = "backup";
    public static final String CONFIGURACAO_MAPPING_CONF = "configuracao-versao";
    protected static final Log log = LogFactory.getLog(ConfiguracaoControle.class);
    protected static Map cacheDefinicoes = new HashMap();
    private static String[][] definicoesXML = new String[][]{{"mensagens", "mensagens.xml", "mapping-mensagens.xml"}, {"telas", "config-telas.xml", "mapping-config-telas.xml"}, {"extracao", "consultas-extracao.xml", "mapping-extracao.xml"}, {"remessa-info", "remessa-info.xml", "mapping-remessa-info.xml"}, {"backup", "consultas-backup.xml", "mapping-backup.xml"}, {"configuracao-versao", "configuracao-versao.xml", "mapping-configuracao-versao.xml"}};

    private ConfiguracaoControle() {
    }

    public static void inicializaDadosConfiguracao() {
        File arquivo = new File("arquivos.xml");
    }

    public static Object carregaDadosArquivoXML(String configArquivo, boolean reload) {
        return ConfiguracaoControle.carregaDadosArquivoXML(configArquivo, null, reload);
    }

    public static Object carregaDadosArquivoXML(String configArquivo) {
        return ConfiguracaoControle.carregaDadosArquivoXML(configArquivo, null);
    }

    public static Object carregaDadosArquivoXML(String configArquivo, File arquivoXML) {
        return ConfiguracaoControle.carregaDadosArquivoXML(configArquivo, arquivoXML, false);
    }

    public static synchronized Object carregaDadosArquivoXML(String configArquivo, File arquivoXML, boolean reload) {
        Mapping mapping = new Mapping();
        Object conteudo = null;
        String mappingConf = null;
        String arquivoDadosXML = null;
        long iniTime = System.currentTimeMillis();
        conteudo = cacheDefinicoes.get(configArquivo);
        System.out.println("1 - " + configArquivo);
        if (reload || conteudo == null) {
            for (int i = 0; i < definicoesXML.length; ++i) {
                String[] config = definicoesXML[i];
                if (config[0] != configArquivo) continue;
                arquivoDadosXML = config[1];
                mappingConf = config[2];
            }
            if (arquivoXML == null) {
                System.out.println("2 era null - " + arquivoDadosXML);
                arquivoXML = new File(arquivoDadosXML);
            }
            if (mappingConf == null || arquivoDadosXML == null) {
                throw new ConfiguracaoException("N\u00e3o foi possivel carregar defini\u00e7\u00f5es para o tipo de arquivo - " + configArquivo);
            }
            try {
                mapping.loadMapping(new InputSource(ConfiguracaoControle.class.getClassLoader().getResourceAsStream(mappingConf)));
                mapping.setLogWriter(new PrintWriter(System.out));
                Unmarshaller unmar = new Unmarshaller(mapping);
                BufferedReader is = null;
                if (!arquivoXML.exists()) {
                    System.out.println("3 usando classloader - " + arquivoDadosXML);
                    is = new BufferedReader(new InputStreamReader(ConfiguracaoControle.class.getClassLoader().getResourceAsStream(arquivoXML.getName()), "UTF-8"));
                } else {
                    System.out.println("3 usando is - " + arquivoDadosXML);
                    is = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(arquivoXML), "UTF-8"));
                }
                conteudo = unmar.unmarshal((Reader)is);
                System.out.println("4 after unmarshall - " + arquivoDadosXML);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Carga " + configArquivo + " efetuada em " + (System.currentTimeMillis() - iniTime) + " ms."));
                }
            }
            catch (Exception e) {
                System.out.println("5 excpetion - " + e);
                throw new ConfiguracaoException("Carga do arquivo: " + arquivoXML, e);
            }
            cacheDefinicoes.put(configArquivo, conteudo);
        }
        System.out.println("6 exit - " + conteudo);
        return conteudo;
    }
}

