/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.mci.beans.remessa;

import br.gov.rs.tce.mci.modelo.seguranca.AssinaturaDigitalControle;
import br.gov.rs.tce.mci.util.Base64Utils;
import java.io.Serializable;
import java.util.Date;

public class RemessaInfo
implements Serializable {
    private Integer _codigoEntidade;
    private String _codBarrasMCI;
    private String _codBarrasModelo9;
    private String _codBarrasModelo14;
    private String _assinaturaXml;
    private String _cadeiaCertificado;
    byte[] _digestRemessa;
    private Integer _anoExercicio;
    private String _tipoOrgao;
    private Date _dataGeracao;
    private String _tipoEntrega;
    String _versao;
    private int _codPeriodo;
    private String _tipoCertificado;
    private String _grupoEntrega;
    private String _poder;

    public String getCodBarrasMCI() {
        return this._codBarrasMCI;
    }

    public void setCodBarrasMCI(String codBarrasMCI) {
        this._codBarrasMCI = codBarrasMCI;
    }

    public String getCodBarrasModelo9() {
        return this._codBarrasModelo9;
    }

    public void setCodBarrasModelo9(String codBarrasModelo9) {
        this._codBarrasModelo9 = codBarrasModelo9;
    }

    public String getCodBarrasModelo14() {
        return this._codBarrasModelo14;
    }

    public void setCodBarrasModelo14(String codBarrasModelo14) {
        this._codBarrasModelo14 = codBarrasModelo14;
    }

    public String getAssinaturaXml() {
        return this._assinaturaXml;
    }

    public void setAssinaturaXml(String assinaturaXml) {
        this._assinaturaXml = assinaturaXml;
    }

    public String getCadeiaCertificado() {
        return this._cadeiaCertificado;
    }

    public void setCadeiaCertificado(String cadeiaCertificado) {
        this._cadeiaCertificado = cadeiaCertificado;
    }

    public byte[] getDigestRemessaArray() {
        return this._digestRemessa;
    }

    public void calculaDigestRemessa() {
        this.validaAtributoDigest(this._codigoEntidade, "_codigoEntidade");
        this.validaAtributoDigest(this._assinaturaXml, "_assinaturaXml");
        this.validaAtributoDigest(this._cadeiaCertificado, "_cadeiaCertificado");
        this.validaAtributoDigest(this._anoExercicio, "_anoExercicio");
        this._digestRemessa = this.geraDigestRemessa();
    }

    private void validaAtributoDigest(Object valor, String nomeAtributo) {
        if (valor == null) {
            throw new IllegalStateException("N\u00e3o \u00e9 possivel calcular o Digest da remessa, o atributo: " + nomeAtributo + " deve ser diferente de null.");
        }
    }

    private byte[] geraDigestRemessa() {
        StringBuffer buf = new StringBuffer(2048);
        buf.append(this.getAnoExercicio());
        buf.append(this.getCodigoEntidade());
        buf.append(this.getAssinaturaXml());
        buf.append(this.getCadeiaCertificado());
        return AssinaturaDigitalControle.calculaDigest(buf.toString().getBytes());
    }

    public boolean digestRemessaValido() {
        boolean ok = true;
        byte[] calculado = this.geraDigestRemessa();
        boolean bl = ok = calculado != null && this._digestRemessa != null && calculado.length == this._digestRemessa.length;
        if (ok) {
            for (int i = 0; i < calculado.length; ++i) {
                boolean bl2 = ok = calculado[i] == this._digestRemessa[i];
                if (!ok) break;
            }
        }
        return ok;
    }

    public void setDigestRemessa(String digestRemessa) {
        this._digestRemessa = Base64Utils.base64Decode(digestRemessa);
    }

    public String getDigestRemessa() {
        return Base64Utils.base64Encode(this._digestRemessa);
    }

    public void setCodigoEntidade(Integer codigoEntidade) {
        this._codigoEntidade = codigoEntidade;
    }

    public Integer getCodigoEntidade() {
        return this._codigoEntidade;
    }

    public void setAnoExercicio(int anoExercicio) {
        this._anoExercicio = new Integer(anoExercicio);
    }

    public Integer getAnoExercicio() {
        return this._anoExercicio;
    }

    public String getTipoOrgao() {
        return this._tipoOrgao;
    }

    public void setTipoOrgao(String _tipoEntidade) {
        this._tipoOrgao = _tipoEntidade;
    }

    public Date getDataGeracao() {
        return this._dataGeracao;
    }

    public void setDataGeracao(Date dataGeracao) {
        this._dataGeracao = dataGeracao;
    }

    public String getTipoEntrega() {
        return this._tipoEntrega;
    }

    public void setTipoEntrega(String _tipoEntrega) {
        this._tipoEntrega = _tipoEntrega;
    }

    public String getVersao() {
        return this._versao;
    }

    public void setVersao(String _versao) {
        this._versao = _versao;
    }

    public int getCodPeriodo() {
        return this._codPeriodo;
    }

    public void setCodPeriodo(int _codPeriodo) {
        this._codPeriodo = _codPeriodo;
    }

    public String getTipoCertificado() {
        return this._tipoCertificado;
    }

    public void setTipoCertificado(String _tipoCertificado) {
        this._tipoCertificado = _tipoCertificado;
    }

    public String getGrupoEntrega() {
        return this._grupoEntrega;
    }

    public void setGrupoEntrega(String _grupoEntrega) {
        this._grupoEntrega = _grupoEntrega;
    }
}

