/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.mci.beans.remessa;

import br.gov.rs.tce.mci.beans.remessa.Remessa;
import br.gov.rs.tce.mci.excecao.ConfiguracaoException;
import oracle.adf.model.BindingContext;
import oracle.adf.model.generic.DCGenericDataControl;
import oracle.jbo.ApplicationModule;
import oracle.jbo.Row;
import oracle.jbo.ViewObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RemessaDataControlControle
extends DCGenericDataControl {
    static Log log = LogFactory.getLog(RemessaDataControlControle.class);
    public static final String REMESSA_DATA_CONTROL = "$RemessaDataControl";
    private Remessa _remessa;
    public static final String REMESSAS_VIEWOBJECT_NAME = "RemessasMCIView";
    public static final String ENTIDADES_VIEWOBJECT_NAME = "EntidadesView";
    public static final String JUSTIFICATIVAS_VIEWOBJECT_NAME = "ObservacoesView";

    public RemessaDataControlControle() {
        super(REMESSA_DATA_CONTROL, Remessa.class.getName(), (Object)new Remessa(), true);
    }

    public void inicializaControle() {
        BindingContext ctx = this.getBindingContext();
        ApplicationModule mciModule = (ApplicationModule)ctx.findDataControl("ServicoMCIDataControl").getDataProvider();
        if (mciModule == null) {
            throw new ConfiguracaoException("N\u00e3o foi poss\u00edvel obter a instancia do ApplicationModule - ServicoMCIDataControl");
        }
        this._remessa = this.inicializaRemessa((Remessa)this.getDataProvider(), mciModule);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Remessa Criada: " + this.getDataProvider().toString()));
        }
    }

    private Remessa inicializaRemessa(Remessa remessa, ApplicationModule mciModule) {
        Integer cdEntidade;
        Integer anoExercicio;
        ViewObject remessasView = mciModule.findViewObject(REMESSAS_VIEWOBJECT_NAME);
        ViewObject entidadeView = mciModule.findViewObject(ENTIDADES_VIEWOBJECT_NAME);
        if (remessasView == null) {
            throw new ConfiguracaoException("N\u00e3o foi poss\u00edvel recuperar o ViewObject de Remessas: RemessasMCIView");
        }
        remessasView.executeQuery();
        Row remessaRow = remessasView.first();
        if (remessaRow == null) {
            remessaRow = remessasView.createRow();
            remessaRow.setAttribute("CdEntidade", (Object)new Integer(0));
            remessaRow.setAttribute("AnoExercicio", (Object)new Integer(2008));
            remessaRow.setAttribute("CdPeriodo", (Object)new Integer(0));
            remessaRow.setAttribute("NomeRepresentante", (Object)" ");
            remessaRow.setAttribute("SituacaoCarga", (Object)new Integer(0));
            remessaRow.setAttribute("VersaoMci", (Object)"3.0.1.9");
            remessasView.insertRow(remessaRow);
        }
        if ((anoExercicio = (Integer)remessaRow.getAttribute("AnoExercicio")) != null) {
            remessa.setAnoExercicio(anoExercicio);
        }
        if ((cdEntidade = (Integer)remessaRow.getAttribute("CdEntidade")) != null) {
            remessa.setCdEntidade(cdEntidade);
        }
        String tipoSetor = (String)remessaRow.getAttribute("Poder");
        remessa.setTipoSetor(tipoSetor);
        Integer peridodo = (Integer)remessaRow.getAttribute("CdPeriodo");
        remessa.setPeriodoInformacoes(peridodo);
        remessa.setTipoOperacao(1);
        return remessa;
    }

    public Remessa getRemessa() {
        return this._remessa;
    }
}

