/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.mci.beans;

import br.gov.rs.tce.mci.beans.Mensagem;
import br.gov.rs.tce.mci.excecao.MensagemInvalidaException;
import java.io.Serializable;
import java.text.Collator;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public final class Mensagens
implements Serializable {
    private Map _mapaMensagens = new TreeMap(new MensagemComparator());

    public void addMensagem(Mensagem vMensagem) throws IndexOutOfBoundsException {
        this._mapaMensagens.put(vMensagem.getCodigo(), vMensagem);
    }

    public void clearMensagem() {
        this._mapaMensagens.clear();
    }

    public Mensagem getMensagemPorCodigo(String codigoMensagem) {
        Mensagem msg = (Mensagem)this._mapaMensagens.get(codigoMensagem);
        if (msg == null) {
            throw new MensagemInvalidaException(codigoMensagem);
        }
        return msg;
    }

    public boolean removeMensagem(Mensagem vMensagem) {
        return this._mapaMensagens.remove(vMensagem) != null;
    }

    public int getMensagemCount() {
        return this._mapaMensagens.size();
    }

    public Mensagem[] getMensagem() {
        int size = this._mapaMensagens.size();
        Mensagem[] mArray = new Mensagem[size];
        int index = 0;
        Iterator it = this._mapaMensagens.values().iterator();
        while (it.hasNext()) {
            mArray[index] = (Mensagem)it.next();
            ++index;
        }
        return mArray;
    }

    private static final class MensagemComparator
    implements Comparator,
    Serializable {
        transient Collator col = Collator.getInstance();

        private MensagemComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (!(o1 instanceof String) && !(o2 instanceof String)) {
                throw new IllegalArgumentException("Este comparador s\u00f3 pode ser usado com objetos String");
            }
            return this.col.compare((String)o1, (String)o2);
        }
    }
}

