/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.adf.util;

import java.math.BigDecimal;
import org.apache.commons.lang.StringUtils;

public class ValidacaoCampoHelper {
    private ValidacaoCampoHelper() {
    }

    public static boolean validateEmail(Object emailObj) {
        if (emailObj == null) {
            return false;
        }
        if (!(emailObj instanceof String)) {
            return false;
        }
        String email = (String)emailObj;
        if (!ValidacaoCampoHelper.validateMinimoSequenciasCaracter(email)) {
            return false;
        }
        return email.indexOf("@") != -1 && email.indexOf("@") == email.lastIndexOf("@");
    }

    public static boolean validateCargo(Object cargoObj) {
        if (cargoObj == null) {
            return false;
        }
        if (!(cargoObj instanceof String)) {
            return false;
        }
        String cargo = (String)cargoObj;
        if (!ValidacaoCampoHelper.validateMinimoSequenciasCaracter(cargo)) {
            return false;
        }
        return cargo.length() > 3;
    }

    public static boolean validateEndereco(Object endObj) {
        if (endObj == null) {
            return false;
        }
        if (!(endObj instanceof String)) {
            return false;
        }
        String end = (String)endObj;
        if (!ValidacaoCampoHelper.validateMinimoSequenciasCaracter(end)) {
            return false;
        }
        return end.length() > 3;
    }

    public static boolean validatePortariaNom(Object portObj) {
        if (portObj == null) {
            return false;
        }
        if (!(portObj instanceof String)) {
            return false;
        }
        String port = (String)portObj;
        if (!ValidacaoCampoHelper.validateMinimoSequenciasCaracter(port)) {
            return false;
        }
        return port.length() > 3;
    }

    public static boolean validateTelefone(Object foneObj) {
        if (foneObj == null) {
            return false;
        }
        if (!(foneObj instanceof String)) {
            return false;
        }
        String fone = (String)foneObj;
        if (!ValidacaoCampoHelper.validateMinimoSequenciasCaracter(fone)) {
            return false;
        }
        return fone.length() > 6;
    }

    public static boolean validateNr(Object nrObj) {
        if (nrObj == null) {
            return false;
        }
        return nrObj instanceof BigDecimal;
    }

    public static boolean validateNome(Object nomeObj) {
        if (nomeObj == null) {
            return false;
        }
        if (!(nomeObj instanceof String)) {
            return false;
        }
        String nome = (String)nomeObj;
        if (!ValidacaoCampoHelper.validateMinimoSequenciasCaracter(nome)) {
            return false;
        }
        if (!ValidacaoCampoHelper.validateExisteEspacoEmBranco(nome)) {
            return false;
        }
        String strA = nome.substring(0, nome.indexOf(" ")).trim();
        String strB = nome.substring(nome.indexOf(" ") + 1, nome.length()).trim();
        if (strA.length() <= 1) {
            return false;
        }
        return strB.length() > 1;
    }

    public static boolean validateMinimoSequenciasCaracter(String nome) {
        return !StringUtils.isEmpty((String)nome) && nome.length() != 0;
    }

    public static boolean validateExisteEspacoEmBranco(String nome) {
        return nome.indexOf(" ") != -1;
    }

    public static boolean validateTipo(Object tipoObj) {
        if (tipoObj == null) {
            return false;
        }
        if (!(tipoObj instanceof Integer)) {
            return false;
        }
        Integer tipo = (Integer)tipoObj;
        return tipo != -1;
    }

    public static boolean validateResp(Object respObj) {
        if (respObj == null) {
            return false;
        }
        if (!(respObj instanceof String)) {
            return false;
        }
        String resp = (String)respObj;
        return ValidacaoCampoHelper.validateMinimoSequenciasCaracter(resp);
    }

    public static boolean validateFormacao(Object formacaoObj) {
        if (formacaoObj == null) {
            return false;
        }
        if (!(formacaoObj instanceof Integer)) {
            return false;
        }
        Integer formacao = (Integer)formacaoObj;
        return formacao != -1;
    }
}

