/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.adf.controle;

import br.gov.rs.tce.adf.excecao.ExceptionHelper;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import oracle.adf.controller.lifecycle.Evaluator;
import oracle.adf.controller.lifecycle.LifecycleContext;
import oracle.adf.controller.lifecycle.PageLifecycle;
import oracle.adf.controller.struts.actions.DataActionContext;
import oracle.adf.controller.struts.actions.DataForwardAction;
import oracle.adf.model.bc4j.DCJboDataControl;
import oracle.adf.model.binding.DCBindingContainer;
import oracle.adf.model.binding.DCControlBinding;
import oracle.adf.model.binding.DCControlBindingDef;
import oracle.adf.model.binding.DCDataControl;
import oracle.adf.model.binding.DCIteratorBinding;
import oracle.jbo.ApplicationModule;
import oracle.jbo.AttrValException;
import oracle.jbo.JboException;
import oracle.jbo.ValidationException;
import oracle.jbo.uicli.binding.JUCtrlActionDef;
import org.apache.struts.action.ActionError;
import org.apache.struts.action.ActionErrors;

public class TCEDataForwardAction
extends DataForwardAction {
    private static final String ERRMSG = "error.validation";

    protected void prepareModel(DataActionContext ctx) throws Exception {
        if (!this.handlingEvents(ctx)) {
            this.initializeModelForPage(ctx);
        }
        super.prepareModel(ctx);
        if (!this.handlingEvents(ctx)) {
            this.initializeBindingsForPage(ctx);
        }
    }

    protected void initializeModelForPage(DataActionContext ctx) {
    }

    protected void initializeBindingsForPage(DataActionContext ctx) {
    }

    protected ApplicationModule getApplicationModule(String dataControlName, DataActionContext ctx) {
        DCDataControl dc = ctx.getBindingContext().findDataControl(dataControlName);
        if (dc != null && dc instanceof DCJboDataControl) {
            return (ApplicationModule)dc.getDataProvider();
        }
        return null;
    }

    protected void releaseDataControlStateless(String dcName, DataActionContext ctx) {
        DCDataControl dc = ctx.getBindingContext().findDataControl(dcName);
        if (dc != null) {
            dc.resetState();
        }
    }

    protected void releaseAllDataControlsStateless(DataActionContext ctx) {
        DCBindingContainer bc = ctx.getBindingContainer();
        if (bc != null) {
            ArrayList<String> dcNames = new ArrayList<String>();
            ArrayList controlBindings = bc.getCtrlBindingList();
            for (DCControlBinding curBinding : controlBindings) {
                JUCtrlActionDef actionDef;
                String dataControlName;
                DCControlBindingDef curBindingDef = curBinding.getDef();
                if (!(curBindingDef instanceof JUCtrlActionDef) || (dataControlName = (actionDef = (JUCtrlActionDef)curBindingDef).getDataControlName()) == null || dcNames.contains(dataControlName)) continue;
                dcNames.add(dataControlName);
            }
            ArrayList iteratorBindings = ctx.getBindingContainer().getIterBindingList();
            for (DCIteratorBinding curBinding : iteratorBindings) {
                String dataControlName = curBinding.getDataControl().getName();
                if (dataControlName == null || dcNames.contains(dataControlName)) continue;
                dcNames.add(dataControlName);
            }
            int dataControlCount = dcNames.size();
            int count = dcNames.size();
            for (int z = 0; z < count; ++z) {
                this.releaseDataControlStateless((String)dcNames.get(z), ctx);
            }
        }
    }

    protected void handleLifecycle(DataActionContext ctx) throws Exception {
        super.handleLifecycle(ctx);
        if (this.releaseStateless()) {
            this.releaseAllDataControlsStateless(ctx);
        }
    }

    protected boolean releaseStateless() {
        return false;
    }

    private boolean handlingEvents(DataActionContext ctx) {
        List events = ctx.getEvents();
        return events != null && events.size() > 0;
    }

    protected void reportErrors(DataActionContext ctx) {
        ArrayList exceptions;
        DCBindingContainer bc = ctx.getBindingContainer();
        if (bc != null && (exceptions = bc.getExceptionsList()) != null) {
            ActionErrors errors = ctx.getActionErrors();
            Locale userLocale = ctx.getBindingContext().getLocaleContext().getLocale();
            for (Exception currentException : exceptions) {
                this.translateExceptionToStrutsErrors(currentException, errors, userLocale);
            }
            this.saveErrors(ctx);
        }
    }

    protected void translateExceptionToStrutsErrors(Exception ex, ActionErrors errors, Locale locale) {
        ArrayList globalErrors = new ArrayList();
        HashMap attributeErrors = new HashMap();
        this.processException(ex, globalErrors, attributeErrors, null, locale);
        int numGlob = globalErrors.size();
        int numAttr = attributeErrors.size();
        if (numGlob > 0) {
            for (int z = 0; z < numGlob; ++z) {
                String msg = (String)globalErrors.get(z);
                if (msg == null) continue;
                errors.add("org.apache.struts.action.GLOBAL_ERROR", new ActionError(ERRMSG, (Object)msg));
            }
        }
        if (numAttr > 0) {
            for (String attrNameKey : attributeErrors.keySet()) {
                String msg = (String)attributeErrors.get(attrNameKey);
                errors.add(attrNameKey, new ActionError(ERRMSG, (Object)msg));
            }
        }
    }

    private void processException(Exception ex, List globalErrs, Map attrErrs, String attrName, Locale locale) {
        JboException jboex;
        Object[] details;
        if (!(ex instanceof JboException)) {
            String msg = ex.getLocalizedMessage();
            if (msg == null) {
                msg = this.firstLineOfStackTrace(ex, true);
            }
            globalErrs.add(msg);
            this.reportUnexpectedException(ex);
            return;
        }
        if (ex instanceof AttrValException) {
            AttrValException ave = (AttrValException)ex;
            attrName = ave.getAttrName();
            Object obj = attrErrs.get(attrName);
            Object[] details2 = ave.getDetails();
            if (obj != null) {
                return;
            }
            if (details2 == null || details2.length == 0) {
                attrErrs.put(attrName, ExceptionHelper.message((Exception)ave, locale));
            }
        }
        if ((details = (jboex = (JboException)((Object)ex)).getDetails()) != null && details.length > 0) {
            int count = details.length;
            for (int j = 0; j < count; ++j) {
                this.processException((Exception)details[j], globalErrs, attrErrs, attrName, locale);
            }
        } else {
            if (attrName == null) {
                String errorCode = jboex.getErrorCode();
                globalErrs.add(ExceptionHelper.message((Exception)((Object)jboex), locale));
            } else {
                attrErrs.put(attrName, ExceptionHelper.message((Exception)((Object)jboex), locale));
            }
            if (!(jboex instanceof ValidationException)) {
                this.reportUnexpectedException((Exception)((Object)jboex));
            }
        }
    }

    private String firstLineOfStackTrace(Exception ex, boolean logToError) {
        if (logToError) {
            ex.printStackTrace(System.err);
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        ex.printStackTrace(pw);
        LineNumberReader lnr = new LineNumberReader(new StringReader(sw.toString()));
        try {
            String lineOne = lnr.readLine();
            String lineTwo = lnr.readLine();
            return lineOne + " " + lineTwo;
        }
        catch (IOException e) {
            return null;
        }
    }

    protected void reportUnexpectedException(Exception ex) {
        ex.printStackTrace();
    }

    protected boolean isNullOrEmpty(String s) {
        return s == null || s.equals("");
    }

    protected Object evalEL(String expression, DataActionContext ctx) {
        Evaluator eval = Evaluator.getEvaluator((LifecycleContext)ctx);
        return eval.getValue(expression);
    }

    protected void invokeEventAction(DataActionContext ctx) {
        if (ctx.getEventActionBinding() != null) {
            PageLifecycle p = (PageLifecycle)this.getPageLifecycle(ctx);
            p.invokeActionBinding((LifecycleContext)ctx, ctx.getEventActionBinding().getName());
        }
    }
}

