
@echo off

set "TCERS_EXEC=-jar mciDesktop.jar"
set "TCERS_OPTS=-Xms64m -Dderby.storage.pageCacheSize=250 -Dlog4j.configuration=conf/log4j.properties -Djbo.debugoutput=silent"

:checkJavaHome
if exist "%JAVA_HOME%\bin\java.exe" goto javaHomeOk
if exist "%JAVA_HOME%\java.exe" goto javaHomeBinOk

:checkJavaExe
where /q java.exe
::echo ERRORLEVEL-where==%ERRORLEVEL%
if ERRORLEVEL 9009 goto javaTryAnyway
if ERRORLEVEL 1 goto findJava
goto javaOk

:javaOk
echo JAVA_OK

:javaTryAnyway
java %TCERS_OPTS% %TCERS_EXEC%
::echo ERRORLEVEL-java==%ERRORLEVEL%
if ERRORLEVEL 9009 goto findJava
goto end

:findJava
if exist "%ProgramFiles%\Java\jre8\bin\java.exe" goto javaJre8Ok
if exist "%ProgramFiles%\Java\jre7\bin\java.exe" goto javaJre7Ok
if exist "%ProgramFiles%\Java\jre6\bin\java.exe" goto javaJre6Ok
if exist "%ProgramFiles(x86)%\Java\jre8\bin\java.exe" goto javaJre8x86Ok
if exist "%ProgramFiles(x86)%\Java\jre7\bin\java.exe" goto javaJre7x86Ok
if exist "%ProgramFiles(x86)%\Java\jre6\bin\java.exe" goto javaJre6x86Ok
goto erro

:javaHomeBinOk
echo JAVA_HOME_BIN_OK
"%JAVA_HOME%\java.exe" %TCERS_OPTS% %TCERS_EXEC%
goto end

:javaHomeOk
echo JAVA_HOME_OK
"%JAVA_HOME%\bin\java.exe" %TCERS_OPTS% %TCERS_EXEC%
goto end

:javaJre8Ok
echo JRE8_OK
"%ProgramFiles%\Java\jre8\bin\java.exe" %TCERS_OPTS% %TCERS_EXEC%
goto end

:javaJre7Ok
echo JRE7_OK
"%ProgramFiles%\Java\jre7\bin\java.exe" %TCERS_OPTS% %TCERS_EXEC%
goto end

:javaJre6Ok
echo JRE6_OK
"%ProgramFiles%\Java\jre6\bin\java.exe" %TCERS_OPTS% %TCERS_EXEC%
goto end

:javaJre8x86Ok
echo JRE8x86_OK
"%ProgramFiles(x86)%\Java\jre8\bin\java.exe" %TCERS_OPTS% %TCERS_EXEC%
goto end

:javaJre7x86Ok
echo JRE7x86_OK
"%ProgramFiles(x86)%\Java\jre7\bin\java.exe" %TCERS_OPTS% %TCERS_EXEC%
goto end

:javaJre6x86Ok
echo JRE6x86_OK
"%ProgramFiles(x86)%\Java\jre6\bin\java.exe" %TCERS_OPTS% %TCERS_EXEC%
goto end

:erro
echo ATENCAO: maquina virtual java (jvm/jre) nao encontrada
pause

:end
