<?xml version='1.0' encoding='ISO-8859-1'?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:barcode="org.krysalis.barcode4j.xalan.BarcodeExt" 
  xmlns:java="http://xml.apache.org/xslt/java" exclude-result-prefixes="java" extension-element-prefixes="barcode" 
  xmlns:cal="xalan://java.util.GregorianCalendar"> 


<xsl:output method="xml" encoding="ISO-8859-1" indent="yes"/>

<xsl:decimal-format decimal-separator="," grouping-separator="."/>

  <!--xsl:include href = "relmci-definicoes.xsl" /-->

  <!-- Variveis de ambiente de execuo -->
  <xsl:param name="TIPO_RELATORIO" select="'DESKTOP'"/> <!-- (PCDI|DESKTOP) -->

  <xsl:param name="PATH_IMAGENS" select="'imagens/'"/> <!-- produo: desktop e pcdi -->
  <!--xsl:param name="PATH_IMAGENS" select="'remessa/imagens/'"/--> <!-- teste local -->

  <xsl:param name="PATH_REMESSA" select="'remessa/'"/> <!-- desktop -->
  <!--xsl:param name="PATH_REMESSA" select="'///u00/app/oracle/product/as1013/j2ee/OC4J_PCDI/applications/pcdi/pcdi/relatorios/'"/--> <!-- pcdi -->
  
  <xsl:param name="PATH_REMESSA_INFO" select="concat($PATH_REMESSA,'\remessa_info.xml')"/>

  <xsl:attribute-set name="bordas"> 
	  <xsl:attribute name="border-after-width">1pt</xsl:attribute> 
	  <xsl:attribute name="border-after-style">solid</xsl:attribute> 
	  <xsl:attribute name="border-before-width">1pt</xsl:attribute> 
	  <xsl:attribute name="border-before-style">solid</xsl:attribute> 
	  <xsl:attribute name="border-left-width">1pt</xsl:attribute> 
	  <xsl:attribute name="border-left-style">solid</xsl:attribute> 
  	  <xsl:attribute name="border-right-width">1pt</xsl:attribute> 
  	  <xsl:attribute name="border-right-style">solid</xsl:attribute> 
  </xsl:attribute-set>
    
  <xsl:attribute-set name="cabecalhoLeftCourier">
	<xsl:attribute name="font-size">8.0pt</xsl:attribute>
	<xsl:attribute name="font-family">Courier, monospace</xsl:attribute>
    <xsl:attribute name="font-weight">normal</xsl:attribute>
	<xsl:attribute name="background-color">white</xsl:attribute>
	<xsl:attribute name="text-align">left</xsl:attribute>
	<xsl:attribute name="space-after">1mm</xsl:attribute>	
	<xsl:attribute name="padding-top">2pt</xsl:attribute>
  </xsl:attribute-set>

  <xsl:attribute-set name="cabecalhoRightCourier">
	<xsl:attribute name="font-size">8.0pt</xsl:attribute>
	<xsl:attribute name="font-family">Courier, monospace</xsl:attribute>
    <xsl:attribute name="font-weight">normal</xsl:attribute>
	<xsl:attribute name="background-color">white</xsl:attribute>
	<xsl:attribute name="text-align">right</xsl:attribute>
	<xsl:attribute name="space-after">1mm</xsl:attribute>	
	<xsl:attribute name="padding-top">2pt</xsl:attribute>
  </xsl:attribute-set>

  <xsl:attribute-set name="cabecalhoLeft">
	<xsl:attribute name="font-size">9.0pt</xsl:attribute>
	<xsl:attribute name="font-family">serif, monospace</xsl:attribute>
    <xsl:attribute name="font-weight">normal</xsl:attribute>
	<xsl:attribute name="background-color">white</xsl:attribute>
	<xsl:attribute name="text-align">left</xsl:attribute>
	<xsl:attribute name="space-after">1mm</xsl:attribute>	
	<xsl:attribute name="padding-top">2pt</xsl:attribute>
  </xsl:attribute-set>

  <xsl:attribute-set name="cabecalhoRight">
	<xsl:attribute name="font-size">9.0pt</xsl:attribute>
	<xsl:attribute name="font-family">serif, monospace</xsl:attribute>
    <xsl:attribute name="font-weight">normal</xsl:attribute>
	<xsl:attribute name="background-color">white</xsl:attribute>
	<xsl:attribute name="text-align">right</xsl:attribute>
	<xsl:attribute name="space-after">1mm</xsl:attribute>	
	<xsl:attribute name="padding-top">2pt</xsl:attribute>
  </xsl:attribute-set>

  <xsl:attribute-set name="titFCinza">
    <xsl:attribute name="font-size">8.0pt</xsl:attribute>
	<xsl:attribute name="font-family">serif</xsl:attribute>
    <xsl:attribute name="font-weight">bold</xsl:attribute>
	<xsl:attribute name="border-bottom-style">solid</xsl:attribute>
	<xsl:attribute name="border-bottom-width">1.0pt</xsl:attribute>
	<xsl:attribute name="background-color">#EEEEEE</xsl:attribute>
	<xsl:attribute name="space-after">1mm</xsl:attribute>	
	<xsl:attribute name="padding-top">2pt</xsl:attribute>
  </xsl:attribute-set>

  <xsl:attribute-set name="titFCinzaEscuro">
    <xsl:attribute name="font-size">8.0pt</xsl:attribute>
	<xsl:attribute name="font-family">serif</xsl:attribute>
    <xsl:attribute name="font-weight">bold</xsl:attribute>
	<xsl:attribute name="border-bottom-style">solid</xsl:attribute>
	<xsl:attribute name="border-bottom-width">1.0pt</xsl:attribute>
	<xsl:attribute name="background-color">silver</xsl:attribute>
	<xsl:attribute name="space-after">1mm</xsl:attribute>	
	<xsl:attribute name="padding-top">2pt</xsl:attribute>
  </xsl:attribute-set>

  <xsl:attribute-set name="titNegrito">
	<xsl:attribute name="font-size">8.0pt</xsl:attribute>
	<xsl:attribute name="font-family">serif</xsl:attribute>
    <xsl:attribute name="font-weight">bold</xsl:attribute>
	<xsl:attribute name="text-align">center</xsl:attribute>
	<xsl:attribute name="space-after">1mm</xsl:attribute>	
	<xsl:attribute name="padding-top">2pt</xsl:attribute>
  </xsl:attribute-set>

  <xsl:attribute-set name="titNegritoLeft">
	<xsl:attribute name="font-size">8.0pt</xsl:attribute>
	<xsl:attribute name="font-family">serif</xsl:attribute>
    <xsl:attribute name="font-weight">bold</xsl:attribute>
	<xsl:attribute name="text-align">left</xsl:attribute>
	<xsl:attribute name="space-after">1mm</xsl:attribute>	
	<xsl:attribute name="padding-top">2pt</xsl:attribute>
  </xsl:attribute-set>

  <xsl:attribute-set name="titNegritoBig">
	<xsl:attribute name="font-size">12.0pt</xsl:attribute>
	<xsl:attribute name="font-family">serif</xsl:attribute>
    <xsl:attribute name="font-weight">bold</xsl:attribute>
	<xsl:attribute name="text-align">center</xsl:attribute>
	<xsl:attribute name="space-after">1mm</xsl:attribute>	
	<xsl:attribute name="padding-top">2pt</xsl:attribute>
  </xsl:attribute-set>

  <xsl:attribute-set name="titNegritoMed">
	<xsl:attribute name="font-size">10.0pt</xsl:attribute>
	<xsl:attribute name="font-family">serif</xsl:attribute>
    <xsl:attribute name="font-weight">bold</xsl:attribute>
	<xsl:attribute name="text-align">left</xsl:attribute>
	<xsl:attribute name="space-after">1mm</xsl:attribute>	
	<xsl:attribute name="padding-top">2pt</xsl:attribute>
  </xsl:attribute-set>

  <xsl:attribute-set name="titMed">
	<xsl:attribute name="font-size">10.0pt</xsl:attribute>
	<xsl:attribute name="font-family">serif</xsl:attribute>
    <xsl:attribute name="font-weight">normal</xsl:attribute>
	<xsl:attribute name="text-align">left</xsl:attribute>
	<xsl:attribute name="space-after">1mm</xsl:attribute>	
	<xsl:attribute name="padding-top">2pt</xsl:attribute>
  </xsl:attribute-set>

  <xsl:attribute-set name="titNegritoItalico">
    <xsl:attribute name="font-size">8.0pt</xsl:attribute>
	<xsl:attribute name="font-family">serif</xsl:attribute>
	<xsl:attribute name="font-weight">bold</xsl:attribute>
	<xsl:attribute name="border-bottom-style">solid</xsl:attribute>
	<xsl:attribute name="border-bottom-width">1.0pt</xsl:attribute>
	<xsl:attribute name="background-color">silver</xsl:attribute>
	<xsl:attribute name="space-after">1mm</xsl:attribute>
	<xsl:attribute name="padding-top">2pt</xsl:attribute>
  </xsl:attribute-set>

  <xsl:attribute-set name="total">
	<xsl:attribute name="font-size">8.0pt</xsl:attribute>
	<xsl:attribute name="font-family">serif</xsl:attribute>
    <xsl:attribute name="font-weight">normal</xsl:attribute>
	<xsl:attribute name="background-color">white</xsl:attribute>
	<xsl:attribute name="text-align">right</xsl:attribute>
	<xsl:attribute name="space-after">1mm</xsl:attribute>	
	<xsl:attribute name="padding-top">2pt</xsl:attribute>
  </xsl:attribute-set>

  <xsl:attribute-set name="totalLeft">
    <xsl:attribute name="font-size">8.0pt</xsl:attribute>
	<xsl:attribute name="font-family">serif</xsl:attribute>
    <xsl:attribute name="font-weight">normal</xsl:attribute>
	<xsl:attribute name="background-color">white</xsl:attribute>
	<xsl:attribute name="text-align">left</xsl:attribute>
	<xsl:attribute name="space-after">1mm</xsl:attribute>	
	<xsl:attribute name="padding-top">2pt</xsl:attribute>
  </xsl:attribute-set>

  <xsl:attribute-set name="cabecalho">
	<xsl:attribute name="font-size">8.0pt</xsl:attribute>
	<xsl:attribute name="font-family">serif</xsl:attribute>
    <xsl:attribute name="font-weight">normal</xsl:attribute>
	<xsl:attribute name="background-color">white</xsl:attribute>
	<xsl:attribute name="text-align">right</xsl:attribute>
	<xsl:attribute name="space-after">1mm</xsl:attribute>
	<xsl:attribute name="padding-top">2pt</xsl:attribute>
  </xsl:attribute-set>

  <xsl:attribute-set name="cabecalhoCenter">
	<xsl:attribute name="font-size">8.0pt</xsl:attribute>
	<xsl:attribute name="font-family">serif</xsl:attribute>
    <xsl:attribute name="font-weight">normal</xsl:attribute>
	<xsl:attribute name="background-color">white</xsl:attribute>
	<xsl:attribute name="text-align">center</xsl:attribute>
	<xsl:attribute name="space-after">1mm</xsl:attribute>
	<xsl:attribute name="padding-top">2pt</xsl:attribute>
  </xsl:attribute-set>

  <xsl:attribute-set name="txtJustifyMed">
	<xsl:attribute name="font-size">10.0pt</xsl:attribute>
	<xsl:attribute name="font-family">serif</xsl:attribute>
    <xsl:attribute name="font-weight">normal</xsl:attribute>
	<xsl:attribute name="text-align">justify</xsl:attribute>
	<xsl:attribute name="hyphenate">true</xsl:attribute>
	<xsl:attribute name="space-after">1mm</xsl:attribute>	
	<xsl:attribute name="padding-top">2pt</xsl:attribute>
	<xsl:attribute name="language">pt</xsl:attribute>
  </xsl:attribute-set>

  <xsl:attribute-set name="txtJustify">
    <xsl:attribute name="font-size">8.0pt</xsl:attribute>
	<xsl:attribute name="font-family">serif</xsl:attribute>
    <xsl:attribute name="font-weight">normal</xsl:attribute>
	<xsl:attribute name="text-align">justify</xsl:attribute>
	<xsl:attribute name="hyphenate">true</xsl:attribute>
	<xsl:attribute name="space-after">1mm</xsl:attribute>
	<xsl:attribute name="padding-top">2pt</xsl:attribute>
	<xsl:attribute name="language">pt</xsl:attribute>
  </xsl:attribute-set>

  <xsl:attribute-set name="txtLeft">
    <xsl:attribute name="font-size">8.0pt</xsl:attribute>
	<xsl:attribute name="font-family">serif</xsl:attribute>
    <xsl:attribute name="font-weight">normal</xsl:attribute>
	<xsl:attribute name="text-align">left</xsl:attribute>
	<xsl:attribute name="space-after">1mm</xsl:attribute>
	<xsl:attribute name="padding-top">2pt</xsl:attribute>
  </xsl:attribute-set>
  
  <xsl:attribute-set name="txtLeftShort">
    <xsl:attribute name="font-size">7.4pt</xsl:attribute>
	<xsl:attribute name="font-family">serif</xsl:attribute>
    <xsl:attribute name="font-weight">normal</xsl:attribute>
	<xsl:attribute name="text-align">left</xsl:attribute>
	<xsl:attribute name="space-after">1mm</xsl:attribute>
	<xsl:attribute name="padding-top">2pt</xsl:attribute>
  </xsl:attribute-set>  
  
  <xsl:attribute-set name="txtLeftBig">
    <xsl:attribute name="font-size">12.0pt</xsl:attribute>
	<xsl:attribute name="font-family">serif</xsl:attribute>
    <xsl:attribute name="font-weight">normal</xsl:attribute>
	<xsl:attribute name="text-align">left</xsl:attribute>
	<xsl:attribute name="space-after">1mm</xsl:attribute>
	<xsl:attribute name="padding-top">2pt</xsl:attribute>
  </xsl:attribute-set>
  
  <xsl:attribute-set name="txtLeftBigCur">
    <xsl:attribute name="font-size">12.0pt</xsl:attribute>
	<xsl:attribute name="font-family">Courier, monospace</xsl:attribute>
    <xsl:attribute name="font-weight">normal</xsl:attribute>
	<xsl:attribute name="text-align">left</xsl:attribute>
	<xsl:attribute name="space-after">1mm</xsl:attribute>
	<xsl:attribute name="padding-top">2pt</xsl:attribute>
  </xsl:attribute-set>

  <xsl:attribute-set name="txtCenter">
    <xsl:attribute name="font-size">8.0pt</xsl:attribute>
	<xsl:attribute name="font-family">serif</xsl:attribute>
    <xsl:attribute name="font-weight">normal</xsl:attribute>
	<xsl:attribute name="text-align">center</xsl:attribute>
	<xsl:attribute name="space-after">1mm</xsl:attribute>
	<xsl:attribute name="padding-top">2pt</xsl:attribute>
  </xsl:attribute-set>

  <xsl:attribute-set name="txtCenterBig">
    <xsl:attribute name="font-size">12.0pt</xsl:attribute>
	<xsl:attribute name="font-family">serif</xsl:attribute>
    <xsl:attribute name="font-weight">normal</xsl:attribute>
	<xsl:attribute name="text-align">center</xsl:attribute>
	<xsl:attribute name="space-after">1mm</xsl:attribute>
	<xsl:attribute name="padding-top">2pt</xsl:attribute>
  </xsl:attribute-set>

  <xsl:attribute-set name="txtRight">
    <xsl:attribute name="font-size">8.0pt</xsl:attribute>
	<xsl:attribute name="font-family">serif</xsl:attribute>
    <xsl:attribute name="font-weight">normal</xsl:attribute>
	<xsl:attribute name="text-align">right</xsl:attribute>
	<xsl:attribute name="space-after">1mm</xsl:attribute>
	<xsl:attribute name="padding-top">2pt</xsl:attribute>
  </xsl:attribute-set>
  
  <xsl:attribute-set name="txtRightShort">
    <xsl:attribute name="font-size">7.4pt</xsl:attribute>
	<xsl:attribute name="font-family">serif</xsl:attribute>
    <xsl:attribute name="font-weight">normal</xsl:attribute>
	<xsl:attribute name="text-align">right</xsl:attribute>
	<xsl:attribute name="space-after">1mm</xsl:attribute>
	<xsl:attribute name="padding-top">2pt</xsl:attribute>
  </xsl:attribute-set>   

  <xsl:attribute-set name="txtRightBig">
    <xsl:attribute name="font-size">12.0pt</xsl:attribute>
	<xsl:attribute name="font-family">serif</xsl:attribute>
    <xsl:attribute name="font-weight">normal</xsl:attribute>
	<xsl:attribute name="text-align">right</xsl:attribute>
	<xsl:attribute name="space-after">1mm</xsl:attribute>
	<xsl:attribute name="padding-top">2pt</xsl:attribute>
  </xsl:attribute-set>

  <xsl:attribute-set name="linhaTotal">
	<xsl:attribute name="font-size">8.0pt</xsl:attribute>
	<xsl:attribute name="font-family">serif</xsl:attribute>
    <xsl:attribute name="font-weight">normal</xsl:attribute>
	<xsl:attribute name="background-color">white</xsl:attribute>
	<xsl:attribute name="text-align">right</xsl:attribute>
	<xsl:attribute name="border-bottom-style">solid</xsl:attribute>
	<xsl:attribute name="border-bottom-width">1.0pt</xsl:attribute>
	<xsl:attribute name="border-top-style">solid</xsl:attribute>
	<xsl:attribute name="border-top-width">1.0pt</xsl:attribute>
	<xsl:attribute name="space-after">1mm</xsl:attribute>
	<xsl:attribute name="padding-top">2pt</xsl:attribute>
  </xsl:attribute-set>

  <xsl:template match="/">

  <fo:root>
    <fo:layout-master-set>
      <!-- Define a body (or default) page. -->
      <fo:simple-page-master master-name="default-master" page-height="29.6cm" page-width="21cm" margin-top="15pt" 	 margin-left="20pt" margin-right="20pt" margin-bottom="15pt">

        <!-- Central part of page -->
        <fo:region-body column-count="1" margin-top="1.55in" margin-bottom="0.2in"/>

        <!-- Header -->
        <fo:region-before border-after-style="solid" extent="1.55in"/>

        <!-- Footer -->
        <fo:region-after border-before-style="solid" extent="0.2in"/>
      </fo:simple-page-master>
    </fo:layout-master-set>

    <!-- Body page -->
    <fo:page-sequence master-reference="default-master">

      <!-- Define the contents of the header. -->
      <fo:static-content flow-name="xsl-region-before">
		<xsl:apply-templates select="RelMCI/Header"/>
      </fo:static-content>

      <!-- Define the contents of the footer. -->
      <fo:static-content flow-name="xsl-region-after">
		<xsl:if test="$TIPO_RELATORIO = 'PCDI'">

		<fo:table text-align="center" width="556pt" table-layout="fixed">
		<fo:table-column column-width="115pt"/>
		<fo:table-column column-width="126pt"/>
		<fo:table-column column-width="115pt"/>
		<fo:table-body>
			<fo:table-row>
				<fo:table-cell number-columns-spanned="3" border-bottom-style="solid" border-bottom-width="1pt">
			  		<fo:block>
			  		</fo:block>
				</fo:table-cell>
		  	</fo:table-row>
		   	<fo:table-row>
				<fo:table-cell number-columns-spanned="3" >
			  		<fo:block xsl:use-attribute-sets="txtCenter">
              			Dados e/ou informaes de responsabilidade da Entidade e no auditados pelo TCE-RS
			  		</fo:block>
				</fo:table-cell>
		  	</fo:table-row>
		</fo:table-body>
		</fo:table>

		</xsl:if>
      </fo:static-content>


      <!-- The main contents of the body page, that is, the catalog entries 
	   ########## CORPO DO TEXTO DOS RELAT&#211;RIOS #########
	    -->
      <fo:flow flow-name="xsl-region-body">
        <fo:block font-size="8.0pt" font-family="serif">
		 <fo:block><fo:leader leader-pattern="space" /></fo:block>
		 
		 <!--********** Variaveis **********-->
		 <xsl:variable name="entidade">
	 	  <xsl:if test="RelMCI/Header/Informacoes/InformacoesRow/PODER='P'">Poder Executivo</xsl:if>
		  <xsl:if test="RelMCI/Header/Informacoes/InformacoesRow/PODER='C'">Poder Legislativo</xsl:if>
		 </xsl:variable>
		 <xsl:variable name="ehencmand">
	 	  <xsl:if test="RelMCI/Header/Informacoes/InformacoesRow/EHENCMANDATO = 'S'"> Encerramento de Mandato? Sim</xsl:if>
	 	  <xsl:if test="RelMCI/Header/Informacoes/InformacoesRow/EHENCMANDATO = 'N'"> Encerramento de Mandato? No</xsl:if> 	  
		 </xsl:variable>
		 <xsl:variable name="possuirpps">
	 	  <xsl:if test="RelMCI/Header/Informacoes/InformacoesRow/POSSUIRPPS = 'S'">Possui RPPS? Sim</xsl:if>
	 	  <xsl:if test="RelMCI/Header/Informacoes/InformacoesRow/POSSUIRPPS = 'N'">Possui RPPS? No</xsl:if> 	  
		 </xsl:variable>
		 <xsl:variable name="formaorg">
	 	  <xsl:if test="RelMCI/Header/Informacoes/InformacoesRow/FORMAORG = 'F'">Forma de Organizao? Fundo</xsl:if>
	 	  <xsl:if test="RelMCI/Header/Informacoes/InformacoesRow/FORMAORG = 'A'">Forma de Organizao? Autarquia/Fundao</xsl:if> 	  
		 </xsl:variable>

		<!--********** Variaveis **********-->
		
		<!-- CABECALHO INICIAL -->
		 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
		  <fo:table-column column-number="1" column-width="556pt"/>

		  <fo:table-body>  
		   <fo:table-row>
		    <fo:table-cell border-width="0.5pt">
		     <fo:block xsl:use-attribute-sets="titNegritoLeft">Nome da Entidade: <xsl:value-of select="RelMCI/Header/Informacoes/InformacoesRow/NOME"/></fo:block>
		    </fo:table-cell>
		   </fo:table-row>
		   <!--fo:table-row>
		    <fo:table-cell border-width="0.5pt">
		     <fo:block xsl:use-attribute-sets="titNegritoLeft">Cdigo do rgo: <xsl:value-of select="RelMCI/Header/Informacoes/InformacoesRow/CD_ENTIDADE"/></fo:block>
		    </fo:table-cell>
		   </fo:table-row-->
		   <fo:table-row>
		    <fo:table-cell border-width="0.5pt">
		     <fo:block xsl:use-attribute-sets="titNegritoLeft">CNPJ: <xsl:value-of select="RelMCI/Header/Informacoes/InformacoesRow/CNPJ"/></fo:block>
		    </fo:table-cell>
		   </fo:table-row>
		   <fo:table-row>
		    <fo:table-cell border-width="0.5pt">
		     <fo:block xsl:use-attribute-sets="titNegritoLeft">ORGO N: <xsl:value-of select="document( $PATH_REMESSA_INFO )//codigo-entidade"/></fo:block>
		    </fo:table-cell>
		   </fo:table-row>
		   <fo:table-row>
		    <fo:table-cell border-width="0.5pt">	     
             <xsl:if test="RelMCI/Header/Informacoes/InformacoesRow/PODER='P'">
               <fo:block xsl:use-attribute-sets="titNegritoLeft">Cdigo de Barras do RGF que originou o Relatrio: <xsl:value-of select="document( concat($PATH_REMESSA,'/remessa_info.xml') )//cod-barras-modelo9"/> (Modelo 9)</fo:block>
             </xsl:if>
             <xsl:if test="RelMCI/Header/Informacoes/InformacoesRow/PODER='C'">
               <fo:block xsl:use-attribute-sets="titNegritoLeft">Cdigo de Barras do RGF que originou o Relatrio: <xsl:value-of select="document( concat($PATH_REMESSA,'/remessa_info.xml') )//cod-barras-modelo14"/> (Modelo 14)</fo:block>
             </xsl:if>        
		    </fo:table-cell>
		   </fo:table-row>
		   <fo:table-row>
		    <fo:table-cell border-width="0.5pt">
              <xsl:if test="RelMCI/Header/Informacoes/InformacoesRow/EHENCMANDATO != 'X'">
 			   <fo:block xsl:use-attribute-sets="titNegritoLeft"><xsl:value-of select="$ehencmand"/></fo:block>
              </xsl:if>        		     
		    </fo:table-cell>
		   </fo:table-row>
		   <fo:table-row>
		    <fo:table-cell border-width="0.5pt">
              <xsl:if test="RelMCI/Header/Informacoes/InformacoesRow/POSSUIRPPS != 'X'">
 			   <fo:block xsl:use-attribute-sets="titNegritoLeft"><xsl:value-of select="$possuirpps"/></fo:block>
              </xsl:if>        		     
		    </fo:table-cell>
		   </fo:table-row>
		   <fo:table-row>
		    <fo:table-cell border-width="0.5pt">
              <xsl:if test="RelMCI/Header/Informacoes/InformacoesRow/FORMAORG != 'X'">
 			   <fo:block xsl:use-attribute-sets="titNegritoLeft"><xsl:value-of select="$formaorg"/></fo:block>
              </xsl:if>        		     
		    </fo:table-cell>
		   </fo:table-row>
		   <!--Insero dos Responsveis pelo pelo Fundo - Forma de Organizao-->
		   <fo:table-row>
		    <fo:table-cell border-width="0.5pt">
              <xsl:if test="RelMCI/Header/Informacoes/InformacoesRow/FORMAORG = 'F'">
			    <fo:block xsl:use-attribute-sets="titNegritoLeft">Responsvel pelo Fundo: <xsl:value-of select="/RelMCI/Header/Informacoes/InformacoesRow/NOME_RESPONSAVEL"/></fo:block>
			    <fo:block xsl:use-attribute-sets="titNegritoLeft">Telefone: <xsl:value-of select="/RelMCI/Header/Informacoes/InformacoesRow/TELEFONE_RESPONSAVEL"/></fo:block>
			    <fo:block xsl:use-attribute-sets="titNegritoLeft">e-mail: <xsl:value-of select="/RelMCI/Header/Informacoes/InformacoesRow/EMAIL_RESPONSAVEL"/></fo:block>
              </xsl:if>        		     
		    </fo:table-cell>
		   </fo:table-row>
		   <!-- -->
		   <xsl:variable name="lei_data" select="RelMCI/FormReg/FormRegulacao/FormRegulacaoRow/DATALEI"/> 
		   <xsl:variable name="lei_dia" select="substring($lei_data, 9, 2)"/>
		   <xsl:variable name="lei_mes" select="substring($lei_data, 6, 2)"/>
		   <xsl:variable name="lei_ano" select="substring($lei_data, 1, 4)"/>
		   
		   <fo:table-row>
			<fo:table-cell>
			  <fo:block xsl:use-attribute-sets="titNegritoLeft">Lei de Instituio do Controle Interno: <xsl:value-of select="/RelMCI/FormReg/FormRegulacao/FormRegulacaoRow/LEI"/></fo:block>	
			  <fo:block xsl:use-attribute-sets="titNegritoLeft">Data da Lei de Instituio do Controle Interno: <xsl:value-of select="$lei_dia"/>/<xsl:value-of select="$lei_mes"/>/<xsl:value-of select="$lei_ano"/></fo:block>

			  <xsl:choose>
				  <xsl:when test="RelMCI/FormReg/FormRegulacao/FormRegulacaoRow/HOUVEALTERACAOLEI = 'S'">
					  <xsl:variable name="leialt_data" select="RelMCI/FormReg/FormRegulacao/FormRegulacaoRow/DATALEIALTERACAO"/> 
					  <xsl:variable name="leialt_dia" select="substring($leialt_data, 9, 2)"/>
					  <xsl:variable name="leialt_mes" select="substring($leialt_data, 6, 2)"/>
					  <xsl:variable name="leialt_ano" select="substring($leialt_data, 1, 4)"/>

					  <fo:block xsl:use-attribute-sets="titNegritoLeft">Lei em vigor que dispe sobre o Controle Interno: <xsl:value-of select="/RelMCI/FormReg/FormRegulacao/FormRegulacaoRow/LEIALTERACAO"/></fo:block>
					  <fo:block xsl:use-attribute-sets="titNegritoLeft">Data da Lei em vigor que dispe sobre o Controle Interno: <xsl:value-of select="$leialt_dia"/>/<xsl:value-of select="$leialt_mes"/>/<xsl:value-of select="$leialt_ano"/></fo:block>
				  </xsl:when>
				  <xsl:otherwise>
					  <fo:block xsl:use-attribute-sets="titNegritoLeft">(No houve alterao da Lei de Instituio do Controle Interno)</fo:block>
				  </xsl:otherwise>
			  </xsl:choose>

        <xsl:choose>
          <xsl:when test="RelMCI/FormReg/FormRegulacao/FormRegulacaoRow/POSSUIRI = 'S'">
            <fo:block xsl:use-attribute-sets="titNegritoLeft">
              Norma que aprovou o Regimento Interno do Controle Interno:
              <xsl:value-of select="/RelMCI/FormReg/FormRegulacao/FormRegulacaoRow/NORMA"/>
            </fo:block>
          </xsl:when>
          <xsl:otherwise>
            <fo:block xsl:use-attribute-sets="titNegritoLeft">(No possui Regimento Interno)</fo:block>
          </xsl:otherwise>
        </xsl:choose>

        <xsl:choose>
          <xsl:when test="RelMCI/FormReg/FormRegulacao/FormRegulacaoRow/POSSUI_DECRETO_REG = 'S'">
            <fo:block xsl:use-attribute-sets="titNegritoLeft">
              Decreto que regulamentou a Lei em vigor que dispe sobre o Controle Interno:
              <xsl:value-of select="/RelMCI/FormReg/FormRegulacao/FormRegulacaoRow/DECRETO_REG"/>
            </fo:block>
          </xsl:when>
          <xsl:otherwise>
            <fo:block xsl:use-attribute-sets="titNegritoLeft">(No possui Decreto que regulamenta a Lei em vigor que dispe sobre o Controle Interno)</fo:block>
          </xsl:otherwise>
        </xsl:choose>

        <fo:block xsl:use-attribute-sets="titNegritoLeft">
          Forma de Estruturao do Controle Interno:
        </fo:block>
        <xsl:choose>
          <xsl:when test="RelMCI/FormReg/FormRegulacao/FormRegulacaoRow/FORMREG = 'S'">
            <fo:block xsl:use-attribute-sets="titNegritoLeft">
              O SCI funciona sob a forma de Comisso, composta por servidores das principais reas do Municpio,
              abrangendo o Poder Executivo e o Poder Legislativo
            </fo:block>
          </xsl:when>
          <xsl:when test="RelMCI/FormReg/FormRegulacao/FormRegulacaoRow/FORMDED = 'S'">
            <fo:block xsl:use-attribute-sets="titNegritoLeft">
              O SCI  composto por servidores com dedicao exclusiva, com objetivo de executar as atividades de
              controle municipal, no mbito do Poder Executivo
            </fo:block>
            <fo:block xsl:use-attribute-sets="titNegritoLeft">
              O municpio 
              <xsl:choose>
                <xsl:when test="RelMCI/FormReg/FormRegulacao/FormRegulacaoRow/FORMDEDCONC = 'S'">
                  realizou
                </xsl:when>
                <xsl:otherwise>
                  no realizou
                </xsl:otherwise>
              </xsl:choose>
              concurso para a admisso de servidores para comporem a unidade de controle interno.
            </fo:block>
          </xsl:when>
          <xsl:otherwise>
            <fo:block xsl:use-attribute-sets="titNegritoLeft">
              Outro: <xsl:value-of select="/RelMCI/FormReg/FormRegulacao/FormRegulacaoRow/FORMOUTROSESPEC"/>
            </fo:block>
          </xsl:otherwise>
        </xsl:choose>
        
			</fo:table-cell>
		   </fo:table-row>
		  </fo:table-body>
		 </fo:table>
		 <!-- FIM CABECALHO INICIAL -->

		 <fo:block><fo:leader leader-pattern="space"/></fo:block>
		 <fo:block><fo:leader leader-pattern="space"/></fo:block>

         <!--Responsveis pelo Controle Interno-->
		 <xsl:apply-templates select="RelMCI/ContInternoResp"/>
         
		 <!--Demais Integrantes do Controle Interno-->
		 <xsl:if test="RelMCI/ContInterno/RespContInterno!=''">
 		  <xsl:apply-templates select="RelMCI/ContInterno"/>
		 </xsl:if>

		 <!--Observaes do Cadastro do Sistema de Controle Interno-->
		 <xsl:if test="RelMCI/ObsContInterno/ObservacoesControleInterno!=''">
 		  <xsl:apply-templates select="RelMCI/ObsContInterno"/>
		 </xsl:if>

		 <!--Poder Executivo-->
		 <xsl:if test="RelMCI/Header/Informacoes/InformacoesRow/PODER='P'">

		   <!--UC005 - Audincia Pblica-->
		   <xsl:if test="RelMCI/Respostas/UC005!=''">
		    <fo:block><fo:leader leader-pattern="space" /></fo:block>
 		    <xsl:apply-templates select="RelMCI/Respostas/UC005"/>
		   </xsl:if>
           
		   <!--Verifica se  1 quadrimestre ou 1 semestre-->
		   <xsl:if test="((RelMCI/Header/Informacoes/InformacoesRow/DS_PERIODO='1 Quadrimestre') or (RelMCI/Header/Informacoes/InformacoesRow/DS_PERIODO='1 Semestre'))"> 

             <!--UC007 - Lei de Diretrizes Oramentrias-->
   		     <xsl:if test="RelMCI/Respostas/UC007!=''">
		       <fo:block><fo:leader leader-pattern="space" /></fo:block>
 		       <xsl:apply-templates select="RelMCI/Respostas/UC007"/>
		     </xsl:if>

             <!--UC008 - Anexo de Metas Fiscais-->
   		     <xsl:if test="RelMCI/Respostas/UC008!=''">
		       <fo:block><fo:leader leader-pattern="space" /></fo:block>
 		       <xsl:apply-templates select="RelMCI/Respostas/UC008"/>
		     </xsl:if>

             <!--UC009 - Anexo de Riscos Fiscais-->
   		     <xsl:if test="RelMCI/Respostas/UC009!=''">
		       <fo:block><fo:leader leader-pattern="space" /></fo:block>
 		       <xsl:apply-templates select="RelMCI/Respostas/UC009"/>
		     </xsl:if>

             <!--UC010 - Cronograma Mensal de Desembolsos-->
   		     <xsl:if test="RelMCI/Respostas/UC010!=''">
		       <fo:block><fo:leader leader-pattern="space" /></fo:block>
 		       <xsl:apply-templates select="RelMCI/Respostas/UC010"/>
		     </xsl:if>

             <!--UC011 - Metas Bimestrais de Arrecadao-->
   		     <xsl:if test="RelMCI/Respostas/UC011!=''">
		       <fo:block><fo:leader leader-pattern="space" /></fo:block>
 		       <xsl:apply-templates select="RelMCI/Respostas/UC011"/>
		     </xsl:if>

             <!--UC012 - Limitao de Empenho e Mov. Financeira-->
   		     <xsl:if test="RelMCI/Respostas/UC012!=''">
		       <fo:block><fo:leader leader-pattern="space" /></fo:block>
 		       <xsl:apply-templates select="RelMCI/Respostas/UC012"/>
		     </xsl:if>

             <!--UC013 - Operaes de Crdito-->
   		     <xsl:if test="RelMCI/Respostas/UC013!=''">
		       <fo:block><fo:leader leader-pattern="space" /></fo:block>
 		       <xsl:apply-templates select="RelMCI/Respostas/UC013"/>
		     </xsl:if>

             <!--UC014 - Dvida Consolidada Lquida-->
   		     <xsl:if test="RelMCI/Respostas/UC014!=''">
		       <fo:block><fo:leader leader-pattern="space" /></fo:block>
 		       <xsl:apply-templates select="RelMCI/Respostas/UC014"/>
		     </xsl:if>

             <!--UC015 - Aplicao da Receita de Alienao de Bens-->
   		     <xsl:if test="RelMCI/Respostas/UC015!=''">
		       <fo:block><fo:leader leader-pattern="space" /></fo:block>
 		       <xsl:apply-templates select="RelMCI/Respostas/UC015"/>
		     </xsl:if>

		     <!--Verifica se  1 quadrimestre ou 1 semestre-->
		     <xsl:if test="((RelMCI/Header/Informacoes/InformacoesRow/DS_PERIODO='1 Quadrimestre') or (RelMCI/Header/Informacoes/InformacoesRow/DS_PERIODO='1 Semestre'))"> 

               <!--UC016 - Consolidao das Contas-->
   		       <xsl:if test="RelMCI/Respostas/UC016!=''">
		         <fo:block><fo:leader leader-pattern="space" /></fo:block>
 		         <xsl:apply-templates select="RelMCI/Respostas/UC016"/>
		       </xsl:if>

             </xsl:if>

             <!--UC017 - Correta Utilizao dos Recursos Vinculados-->
   		     <xsl:if test="RelMCI/Respostas/UC017!=''">
		       <fo:block><fo:leader leader-pattern="space" /></fo:block>
 		       <xsl:apply-templates select="RelMCI/Respostas/UC017"/>
		     </xsl:if>

             <!--UC018 - Identificao de Pagamento Sentenas Judiciais-->
   		     <xsl:if test="RelMCI/Respostas/UC018!=''">
		       <fo:block><fo:leader leader-pattern="space" /></fo:block>
 		       <xsl:apply-templates select="RelMCI/Respostas/UC018"/>
		     </xsl:if>

             <!--UC019 - Renncia de Receita-->
   		     <xsl:if test="RelMCI/Respostas/UC019!=''">
		       <fo:block><fo:leader leader-pattern="space" /></fo:block>
 		       <xsl:apply-templates select="RelMCI/Respostas/UC019"/>
		     </xsl:if>

             <!--UC020 - Publicao do Rel. Res. Execuo Oramentria-->
   		     <xsl:if test="RelMCI/Respostas/UC020!=''">
		       <fo:block><fo:leader leader-pattern="space" /></fo:block>
 		       <xsl:apply-templates select="RelMCI/Respostas/UC020"/>
		     </xsl:if>

             <!--UC021 - Publicao do relatrio de Gesto Fiscal-->
   		     <xsl:if test="RelMCI/Respostas/UC021!=''">
		       <fo:block><fo:leader leader-pattern="space" /></fo:block>
 		       <xsl:apply-templates select="RelMCI/Respostas/UC021"/>
		     </xsl:if>

             <!--UC022 - Despesa com Pessoal-->
   		     <xsl:if test="RelMCI/Respostas/UC022!=''">
		       <fo:block><fo:leader leader-pattern="space" /></fo:block>
 		       <xsl:apply-templates select="RelMCI/Respostas/UC022"/>
		     </xsl:if>

		     <!--Verifica se  3 quadrimestre ou 2 semestre-->
		     <xsl:if test="((RelMCI/Header/Informacoes/InformacoesRow/DS_PERIODO='2 Semestre') or (RelMCI/Header/Informacoes/InformacoesRow/DS_PERIODO='3 Quadrimestre'))"> 

               <!--UC023 - Inst. Prev. Efetiva Arrecadao de Impostos-->
   		       <xsl:if test="RelMCI/Respostas/UC023!=''">
		         <fo:block><fo:leader leader-pattern="space" /></fo:block>
 		         <xsl:apply-templates select="RelMCI/Respostas/UC023"/>
		       </xsl:if>

		       <!--Verifica se  encerramento de mandato-->
		       <xsl:if test="RelMCI/Header/Informacoes/InformacoesRow/EHENCMANDATO='S'"> 

                 <!--UC024 - Restos a Pagar-->
   		         <xsl:if test="RelMCI/Respostas/UC024!=''">
		           <fo:block><fo:leader leader-pattern="space" /></fo:block>
 		           <xsl:apply-templates select="RelMCI/Respostas/UC024"/>
		         </xsl:if>           

               </xsl:if> <!--Encerramento de Mandato-->

		       <!--UC025 - Equilbrio Financeiro-->
   		       <xsl:if test="RelMCI/Respostas/UC025!=''">
		         <fo:block><fo:leader leader-pattern="space" /></fo:block>
 		         <xsl:apply-templates select="RelMCI/Respostas/UC025"/>
		       </xsl:if>

             </xsl:if> <!--Verifica se  2 quadrimestre, 3 quadrimestre ou 2 semestre-->


           </xsl:if> <!--Verifica se  1 quadrimestre ou 1 semestre-->

		   <!--Verifica se  2 quadrimestre, 3 quadrimestre ou 2 semestre-->
		   <xsl:if test="((RelMCI/Header/Informacoes/InformacoesRow/DS_PERIODO='2 Quadrimestre') or (RelMCI/Header/Informacoes/InformacoesRow/DS_PERIODO='2 Semestre') or (RelMCI/Header/Informacoes/InformacoesRow/DS_PERIODO='3 Quadrimestre'))"> 


			   <!--Verifica se  3 quadrimestre ou 2 semestre-->
			   <xsl:if test="((RelMCI/Header/Informacoes/InformacoesRow/DS_PERIODO='2 Semestre') or (RelMCI/Header/Informacoes/InformacoesRow/DS_PERIODO='3 Quadrimestre'))"> 

		           <!--UC006 - Disp. Estudos e Estimativas de Receita-->
		   		   <xsl:if test="RelMCI/Respostas/UC006!=''">
				     <fo:block><fo:leader leader-pattern="space" /></fo:block>
		 		     <xsl:apply-templates select="RelMCI/Respostas/UC006"/>
				   </xsl:if>

				</xsl:if> <!--Verifica se  3 quadrimestre ou 2 semestre-->
			 
			 <!--UC012 - Limitao de Empenho e Mov. Financeira-->
   		     <xsl:if test="RelMCI/Respostas/UC012!=''">
		       <fo:block><fo:leader leader-pattern="space" /></fo:block>
 		       <xsl:apply-templates select="RelMCI/Respostas/UC012"/>
		     </xsl:if>

             <!--UC013 - Operaes de Crdito-->
   		     <xsl:if test="RelMCI/Respostas/UC013!=''">
		       <fo:block><fo:leader leader-pattern="space" /></fo:block>
 		       <xsl:apply-templates select="RelMCI/Respostas/UC013"/>
		     </xsl:if>

             <!--UC014 - Dvida Consolidada Lquida-->
   		     <xsl:if test="RelMCI/Respostas/UC014!=''">
		       <fo:block><fo:leader leader-pattern="space" /></fo:block>
 		       <xsl:apply-templates select="RelMCI/Respostas/UC014"/>
		     </xsl:if>

             <!--UC015 - Aplicao da Receita de Alienao de Bens-->
   		     <xsl:if test="RelMCI/Respostas/UC015!=''">
		       <fo:block><fo:leader leader-pattern="space" /></fo:block>
 		       <xsl:apply-templates select="RelMCI/Respostas/UC015"/>
		     </xsl:if>

		     <!--Verifica se  1 quadrimestre ou 1 semestre-->
		     <xsl:if test="((RelMCI/Header/Informacoes/InformacoesRow/DS_PERIODO='1 Quadrimestre') or (RelMCI/Header/Informacoes/InformacoesRow/DS_PERIODO='1 Semestre'))"> 

               <!--UC016 - Consolidao das Contas-->
   		       <xsl:if test="RelMCI/Respostas/UC016!=''">
		         <fo:block><fo:leader leader-pattern="space" /></fo:block>
 		         <xsl:apply-templates select="RelMCI/Respostas/UC016"/>
		       </xsl:if>

             </xsl:if>
		     <!--Verifica se  2 quadrimestre, 3 quadrimestre ou 2 semestre-->
		     <xsl:if test="((RelMCI/Header/Informacoes/InformacoesRow/DS_PERIODO='2 Quadrimestre') or (RelMCI/Header/Informacoes/InformacoesRow/DS_PERIODO='2 Semestre') or (RelMCI/Header/Informacoes/InformacoesRow/DS_PERIODO='3 Quadrimestre'))"> 

               <!--UC017 - Correta Utilizao dos Recursos Vinculados-->
   		       <xsl:if test="RelMCI/Respostas/UC017!=''">
		         <fo:block><fo:leader leader-pattern="space" /></fo:block>
 		         <xsl:apply-templates select="RelMCI/Respostas/UC017"/>
		       </xsl:if>

               <!--UC018 - Identificao de Pagamento Sentenas Judiciais-->
   		       <xsl:if test="RelMCI/Respostas/UC018!=''">
		         <fo:block><fo:leader leader-pattern="space" /></fo:block>
 		         <xsl:apply-templates select="RelMCI/Respostas/UC018"/>
		       </xsl:if>

               <!--UC019 - Renncia de Receita-->
   		       <xsl:if test="RelMCI/Respostas/UC019!=''">
		         <fo:block><fo:leader leader-pattern="space" /></fo:block>
 		         <xsl:apply-templates select="RelMCI/Respostas/UC019"/>
		       </xsl:if>

               <!--UC020 - Publicao do Rel. Res. Execuo Oramentria-->
   		       <xsl:if test="RelMCI/Respostas/UC020!=''">
		         <fo:block><fo:leader leader-pattern="space" /></fo:block>
 		         <xsl:apply-templates select="RelMCI/Respostas/UC020"/>
		       </xsl:if>

               <!--UC021 - Publicao do relatrio de Gesto Fiscal-->
   		       <xsl:if test="RelMCI/Respostas/UC021!=''">
		         <fo:block><fo:leader leader-pattern="space" /></fo:block>
 		         <xsl:apply-templates select="RelMCI/Respostas/UC021"/>
		       </xsl:if>

               <!--UC022 - Despesa com Pessoal-->
   		       <xsl:if test="RelMCI/Respostas/UC022!=''">
		         <fo:block><fo:leader leader-pattern="space" /></fo:block>
 		         <xsl:apply-templates select="RelMCI/Respostas/UC022"/>
		       </xsl:if>

		       <!--Verifica se  3 quadrimestre ou 2 semestre-->
		       <xsl:if test="((RelMCI/Header/Informacoes/InformacoesRow/DS_PERIODO='2 Semestre') or (RelMCI/Header/Informacoes/InformacoesRow/DS_PERIODO='3 Quadrimestre'))"> 

                 <!--UC023 - Inst. Prev. Efetiva Arrecadao de Impostos-->
   		         <xsl:if test="RelMCI/Respostas/UC023!=''">
		           <fo:block><fo:leader leader-pattern="space" /></fo:block>
 		           <xsl:apply-templates select="RelMCI/Respostas/UC023"/>
		         </xsl:if>

		         <!--Verifica se  encerramento de mandato-->
		         <xsl:if test="RelMCI/Header/Informacoes/InformacoesRow/EHENCMANDATO='S'"> 

                   <!--UC024 - Restos a Pagar-->
   		           <xsl:if test="RelMCI/Respostas/UC024!=''">
		             <fo:block><fo:leader leader-pattern="space" /></fo:block>
 		             <xsl:apply-templates select="RelMCI/Respostas/UC024"/>
		           </xsl:if>

                 </xsl:if>                 

               </xsl:if> <!--Se  3 quadrimestre ou 2 semestre-->

               <!--UC025 - Equilbrio Financeiro-->
		       <xsl:if test="RelMCI/Respostas/UC025!=''">
		         <fo:block><fo:leader leader-pattern="space" /></fo:block>
 		         <xsl:apply-templates select="RelMCI/Respostas/UC025"/>
		       </xsl:if>

		       <!--UC040 - Informaes sobre Inativos e Pensionistas-->
   		       <xsl:if test="RelMCI/Respostas/UC040!=''">
		         <fo:block><fo:leader leader-pattern="space" /></fo:block>
 		         <xsl:apply-templates select="RelMCI/Respostas/UC040"/>
		       </xsl:if>

             </xsl:if> <!--Verifica se  2 quadrimestre, 3 quadrimestre ou 2 semestre-->

           </xsl:if>

			   <!--Verifica se  2 semestre ou 3 quadrimestre -->
			   <xsl:if test="((RelMCI/Header/Informacoes/InformacoesRow/DS_PERIODO='2 Semestre') or (RelMCI/Header/Informacoes/InformacoesRow/DS_PERIODO='3 Quadrimestre'))"> 

		           <!--UC041 - Disp. Estudos e Estimativas de Receita-->
		   		   <xsl:if test="RelMCI/Respostas/UC041!=''">
				     <fo:block><fo:leader leader-pattern="space" /></fo:block>
		 		     <xsl:apply-templates select="RelMCI/Respostas/UC041"/>
				   </xsl:if>

				</xsl:if> <!-- fim Verifica -->

			   <!--UC042 - LC131/2010 - transparencia da gestao fiscal -->
			   <xsl:if test="RelMCI/Respostas/UC042!=''">
				 <fo:block><fo:leader leader-pattern="space" /></fo:block>
				 <xsl:apply-templates select="RelMCI/Respostas/UC042"/>
			   </xsl:if>

			   <!--UC045 - Sistema de controle de custos -->
			   <xsl:if test="RelMCI/Respostas/UC045!=''">
				 <fo:block><fo:leader leader-pattern="space" /></fo:block>
				 <xsl:apply-templates select="RelMCI/Respostas/UC045"/>
			   </xsl:if>

        <!-- UC046 - Sistema de controle interno -->
        <xsl:if test="RelMCI/Respostas/UC046!=''">
          <fo:block><fo:leader leader-pattern="space" /></fo:block>
          <xsl:apply-templates select="RelMCI/Respostas/UC046"/>
        </xsl:if>

		 </xsl:if>
		 <!--Poder Legislativo-->
		 <xsl:if test="RelMCI/Header/Informacoes/InformacoesRow/PODER='C'">

		   <!--UC018 - Ident. Beneficirios Pagamentos Sentenas Judiciais-->
		   <xsl:if test="RelMCI/Respostas/UC018!=''">
		    <fo:block><fo:leader leader-pattern="space" /></fo:block>
 		    <xsl:apply-templates select="RelMCI/Respostas/UC018"/>
		   </xsl:if>

		   <!--UC021 - Publicao do Relatrio de Gesto Fiscal-->
		   <xsl:if test="RelMCI/Respostas/UC021!=''">
		    <fo:block><fo:leader leader-pattern="space" /></fo:block>
 		    <xsl:apply-templates select="RelMCI/Respostas/UC021"/>
		   </xsl:if>

		   <!--UC022 - Despesa com Pessoal-->
		   <xsl:if test="RelMCI/Respostas/UC022!=''">
		    <fo:block><fo:leader leader-pattern="space" /></fo:block>
 		    <xsl:apply-templates select="RelMCI/Respostas/UC022"/>
		   </xsl:if>

		   <!--Verifica se  3 quadrimestre ou 2 semestre-->
		   <xsl:if test="((RelMCI/Header/Informacoes/InformacoesRow/DS_PERIODO='3 Quadrimestre') or (RelMCI/Header/Informacoes/InformacoesRow/DS_PERIODO='2 Semestre'))"> 

 		     <!--UC032 - Gastos Totais-->
		     <xsl:if test="RelMCI/Respostas/UC032!=''">
		      <fo:block><fo:leader leader-pattern="space" /></fo:block>
 		      <xsl:apply-templates select="RelMCI/Respostas/UC032"/>
		     </xsl:if>

		     <!--Verifica se  encerramento de mandato-->
		     <xsl:if test="RelMCI/Header/Informacoes/InformacoesRow/EHENCMANDATO='S'"> 

 		       <!--UC024 - Restos a Pagar-->
		       <xsl:if test="RelMCI/Respostas/UC024!=''">
		        <fo:block><fo:leader leader-pattern="space" /></fo:block>
 		        <xsl:apply-templates select="RelMCI/Respostas/UC024"/>
		       </xsl:if>

             </xsl:if> <!--Verifica se  encerramento de mandato-->

 		     <!--UC025 - Equilbrio Financeiro-->
		     <xsl:if test="RelMCI/Respostas/UC025!=''">
		      <fo:block><fo:leader leader-pattern="space" /></fo:block>
 		      <xsl:apply-templates select="RelMCI/Respostas/UC025"/>
		     </xsl:if>

           </xsl:if>

		   <!--Verifica se  1 quadrimestre, 2 quadrimestre ou 1 semestre-->
		   <xsl:if test="((RelMCI/Header/Informacoes/InformacoesRow/DS_PERIODO='1 Quadrimestre') or (RelMCI/Header/Informacoes/InformacoesRow/DS_PERIODO='2 Quadrimestre') or (RelMCI/Header/Informacoes/InformacoesRow/DS_PERIODO='1 Semestre'))"> 

		     <!--Verifica se  1 quadrimestre ou 1 semestre-->
		     <xsl:if test="((RelMCI/Header/Informacoes/InformacoesRow/DS_PERIODO='1 Quadrimestre') or (RelMCI/Header/Informacoes/InformacoesRow/DS_PERIODO='1 Semestre'))"> 

 		       <!--UC033 - Reestimativa de Receita Oramentria - DEPRECATED -->
		       <!--xsl:if test="RelMCI/Respostas/UC033!=''">
		        <fo:block><fo:leader leader-pattern="space" /></fo:block>
 		        <xsl:apply-templates select="RelMCI/Respostas/UC033"/>
		       </xsl:if-->

             </xsl:if> <!--Verifica se  1 quadrimestre ou 1 semestre-->

           </xsl:if>

		 </xsl:if>

		 <xsl:if test="RelMCI/Header/Informacoes!=''">
		  <fo:block><fo:leader leader-pattern="space" /></fo:block>
 		  <xsl:apply-templates select="RelMCI/Header/Informacoes"/>
		 </xsl:if>
   		 
		 <!-- pagina final -->
		 <fo:block id="last-page"/>
		 <!-- pagina final -->
        </fo:block>
      </fo:flow>
    </fo:page-sequence>
  </fo:root>
</xsl:template>

<!--
###############################################
# Cadastro de Responsveis do Controle Interno#
###############################################
-->
<xsl:template match="ContInternoResp">
 
 <!-- INICIO 1 - Audincia Pblica -->
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 
 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" />
  <fo:table-body>
   <fo:table-row>
    <fo:table-cell>
     <fo:block xsl:use-attribute-sets="titFCinza">
      <xsl:text>Cadastro dos Integrantes do Controle Interno</xsl:text>
     </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-body>
 </fo:table>
 
 <fo:block><fo:leader leader-pattern="space"/></fo:block>

 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" />
  <fo:table-body>
   <fo:table-row>
    <fo:table-cell>
     <fo:block xsl:use-attribute-sets="titFCinza">
      <xsl:text>- Responsvel pelo Controle Interno</xsl:text>
     </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-body>
 </fo:table>
 
 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
		<fo:table-column column-width="56pt"/>
		<fo:table-column column-width="180pt"/>
		<fo:table-column column-width="70pt"/>
		<fo:table-column column-width="150pt"/>
		<fo:table-column column-width="50pt"/>

  <fo:table-body >	   
	<fo:table-row>
		<fo:table-cell>
			<fo:block xsl:use-attribute-sets="txtLeft">CPF</fo:block>	
		</fo:table-cell>
		<fo:table-cell>
			<fo:block xsl:use-attribute-sets="txtLeft">NOME</fo:block>
		</fo:table-cell>
		<fo:table-cell>
			<fo:block xsl:use-attribute-sets="txtLeft">CARGO</fo:block>
		</fo:table-cell>
		<fo:table-cell>
			<fo:block xsl:use-attribute-sets="txtLeft">EMAIL</fo:block>
		</fo:table-cell>
		<fo:table-cell>
			<fo:block xsl:use-attribute-sets="txtLeft">TELEFONE</fo:block>
		</fo:table-cell>
	</fo:table-row>
   	<xsl:for-each select="/RelMCI/ContInternoResp/RespContInternoResp/RespContInternoRespRow">
    <fo:table-row>								
		<fo:table-cell>
			<fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="CPF"/></fo:block>	
		</fo:table-cell>
		<fo:table-cell>
			<fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="NOME"/></fo:block>
		</fo:table-cell>
		<fo:table-cell>
			<fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="CARGO"/></fo:block>
		</fo:table-cell>
		<fo:table-cell>
			<fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="EMAIL"/></fo:block>
		</fo:table-cell>
		<fo:table-cell>
			<fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="TELEFONE"/></fo:block>
		</fo:table-cell>
    </fo:table-row>   	
	</xsl:for-each>
  </fo:table-body>
 </fo:table> 
 

 <!-- FIM    CADASTRO DO CONTROLE INTERNO  --> 
</xsl:template>

<!--
###############################################
# Cadastro de Demais Int. do Controle Interno #
###############################################
-->
<xsl:template match="ContInterno">
 
 <!-- INICIO - Demais Integrantes do Controle Interno -->
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 
 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" />
  <fo:table-body>
   <fo:table-row>
    <fo:table-cell>
     <fo:block xsl:use-attribute-sets="titFCinza">
      <xsl:text>- Demais Integrantes do Controle Interno</xsl:text>
     </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-body>
 </fo:table>
 
 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
		<fo:table-column column-width="150pt"/>
		<fo:table-column column-width="406pt"/>

  <fo:table-body >	   
	<fo:table-row>
		<fo:table-cell>
			<fo:block xsl:use-attribute-sets="txtLeft">CPF</fo:block>	
		</fo:table-cell>
		<fo:table-cell>
			<fo:block xsl:use-attribute-sets="txtLeft">NOME</fo:block>
		</fo:table-cell>
	</fo:table-row>
   	<xsl:for-each select="/RelMCI/ContInterno/RespContInterno/RespContInternoRow">
    <fo:table-row>								
		<fo:table-cell>
			<fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="CPF"/></fo:block>	
		</fo:table-cell>
		<fo:table-cell>
			<fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="NOME"/></fo:block>
		</fo:table-cell>
    </fo:table-row>   	
	</xsl:for-each>
  </fo:table-body>
 </fo:table> 
 <!-- FIM    CADASTRO DOS DEMAIS INTEGRANTES DO CONTROLE INTERNO  --> 
</xsl:template>


<!--
###############################################
# Observaes do Sistema de Controle Interno  #
###############################################
-->
<xsl:template match="ObsContInterno">

 <!-- INICIO - Demais Integrantes do Controle Interno -->
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 
 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" />
  <fo:table-body>
   <fo:table-row>
    <fo:table-cell>
     <fo:block xsl:use-attribute-sets="titFCinza">
      <xsl:text>- Observaes do Cadastro do Sistema de Controle Interno</xsl:text>
     </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-body>
 </fo:table>

 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="556pt"/>

 <fo:block><fo:leader leader-pattern="space"/></fo:block>

  <fo:table-body >	   
    <fo:table-row>								
     <fo:table-cell>
	  <fo:block xsl:use-attribute-sets="txtJustifyMed" text-align="justify" margin-left="15pt" hyphenate="true" >
       <xsl:if test="../ObsContInterno/ObservacoesControleInterno/ObservacoesControleInternoRow/OBSERVACOES!=''">
        <fo:inline font-weight="bold">Observaes: </fo:inline><xsl:value-of select="../ObsContInterno/ObservacoesControleInterno/ObservacoesControleInternoRow/OBSERVACOES"></xsl:value-of>
       </xsl:if>
       <xsl:if test="../ObsContInterno/ObservacoesControleInterno/ObservacoesControleInternoRow/OBSERVACOES=''">
        <fo:inline font-style="italic">No foram inseridas observaes para este item.</fo:inline>
       </xsl:if>
      </fo:block>
     </fo:table-cell>
    </fo:table-row>   	
  </fo:table-body>
 </fo:table> 
 <!-- FIM    OBSERVAES DO SISTEMA DE CONTROLE INTERNO  --> 
</xsl:template>


<!--
###############################################
######      1 - Audincia Pblica        ######
###############################################
-->
<xsl:template match="UC005">

 <!--Varivel de exibio do Modelo - 1 -->
 <xsl:variable name="periodo">
  <xsl:if test="../../Header/Informacoes/InformacoesRow/DS_PERIODO='1 Quadrimestre'"> 3 Quadrimestre do exerccio anterior</xsl:if>
  <xsl:if test="../../Header/Informacoes/InformacoesRow/DS_PERIODO='1 Semestre'"> 3 Quadrimestre do exerccio anterior</xsl:if>
  <xsl:if test="../../Header/Informacoes/InformacoesRow/DS_PERIODO='2 Quadrimestre'"> 2 Quadrimestre do exerccio atual</xsl:if>
  <xsl:if test="../../Header/Informacoes/InformacoesRow/DS_PERIODO='3 Quadrimestre'"> 2 Quadrimestre do exerccio atual</xsl:if>
  <xsl:if test="../../Header/Informacoes/InformacoesRow/DS_PERIODO='2 Semestre'"> 2 Quadrimestre do exerccio atual</xsl:if>
 </xsl:variable>
 <xsl:variable name="perg1a">
  <xsl:if test="UC005Row[CD_PERGUNTA='UC005_t1p1a']/RESPOSTA='S'">
   <xsl:value-of select="' dentro '"></xsl:value-of>
  </xsl:if>
  <xsl:if test="UC005Row[CD_PERGUNTA='UC005_t1p1a']/RESPOSTA='N'">
   <xsl:value-of select="' fora '"></xsl:value-of>
  </xsl:if>
 </xsl:variable>
 <xsl:variable name="perg2a">
  <xsl:if test="UC005Row[CD_PERGUNTA='UC005_t1p2a']/RESPOSTA='S'">
   <xsl:value-of select="' dentro '"></xsl:value-of>
  </xsl:if>
  <xsl:if test="UC005Row[CD_PERGUNTA='UC005_t1p2a']/RESPOSTA='N'">
   <xsl:value-of select="' fora '"></xsl:value-of>
  </xsl:if>
 </xsl:variable>
 
 <!-- INICIO 1 - Audincia Pblica -->
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 
 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" />
  <fo:table-body>
   <fo:table-row>
    <fo:table-cell>
     <fo:block xsl:use-attribute-sets="titFCinza">
      <xsl:text>1 - Audincia Pblica</xsl:text>
     </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-body>
 </fo:table>
 
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 
 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="556pt"/>

  <fo:table-body >	   
    <fo:table-row>								
     <fo:table-cell>
	  <fo:block xsl:use-attribute-sets="txtJustifyMed" text-align="justify" margin-left="15pt" hyphenate="true" >
       <!-- Primeira Resposta do Relatrio-->
	   <xsl:if test="UC005Row[CD_PERGUNTA='UC005_t1p01']/RESPOSTA='N'">
		 O Poder Executivo no demonstrou e avaliou o cumprimento das metas fiscais do <xsl:value-of select="$periodo"/>, em audincia pblica.
       </xsl:if>        
       <xsl:if test="UC005Row[CD_PERGUNTA='UC005_t1p01']/RESPOSTA='S'">
		 O Poder Executivo demonstrou e avaliou o cumprimento das metas fiscais do <xsl:value-of select="$periodo"/>, em audincia pblica, realizada <xsl:value-of select="UC005Row[CD_PERGUNTA='UC005_t1p02']/RESPOSTA_EXT"/> <xsl:value-of select="$perg1a"/> do prazo estabelecido no art. 9,  4 da LRF.
       </xsl:if>        
       <!-- Segunda Resposta do Relatrio-->
       <xsl:if test="((../../Header/Informacoes/InformacoesRow/DS_PERIODO='1 Quadrimestre') or (../../Header/Informacoes/InformacoesRow/DS_PERIODO='1 Semestre'))">	 
        
		<!-- Se for o perodo correto, exibe a segunda resposta-->        
        
		<fo:block><fo:leader leader-pattern="space"/></fo:block>			
		<xsl:if test="UC005Row[CD_PERGUNTA='UC005_t1p03']/RESPOSTA='N'">
 	 	  O cumprimento das metas fiscais do 1 quadrimestre  do exerccio atual, no foi demonstrado e avaliado em audincia pblica.
        </xsl:if>        
        <xsl:if test="UC005Row[CD_PERGUNTA='UC005_t1p03']/RESPOSTA='S'">
 	 	  O cumprimento das metas fiscais do 1 quadrimestre  do exerccio atual, foi demonstrado e avaliado em audincia pblica, realizada <xsl:value-of select="UC005Row[CD_PERGUNTA='UC005_t1p04']/RESPOSTA_EXT"/> <xsl:value-of select="$perg2a"/> do prazo estabelecido no art. 9,  4 da LRF.
        </xsl:if>        

       </xsl:if>        

      </fo:block>
     </fo:table-cell>
    </fo:table-row>   	
  </fo:table-body>
 </fo:table> 
  
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 
 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="556pt"/>

  <fo:table-body >	   
    <fo:table-row>								
     <fo:table-cell>
	  <fo:block xsl:use-attribute-sets="txtJustifyMed" text-align="justify" margin-left="15pt" hyphenate="true" >
       <xsl:if test="../../Observacoes/ObservacoesRemessas/ObservacoesRemessasRow[CD_OBSERVACOES='UC005']/OBSERVACOES!=''">
        <fo:inline font-weight="bold">Observaes: </fo:inline><xsl:value-of select="../../Observacoes/ObservacoesRemessas/ObservacoesRemessasRow[CD_OBSERVACOES='UC005']/OBSERVACOES"></xsl:value-of>
       </xsl:if>
       <xsl:if test="../../Observacoes/ObservacoesRemessas/ObservacoesRemessasRow[CD_OBSERVACOES='UC005']/OBSERVACOES=''">
        <fo:inline font-style="italic">No foram inseridas observaes para este item.</fo:inline>
       </xsl:if>
      </fo:block>
     </fo:table-cell>
    </fo:table-row>   	
  </fo:table-body>
 </fo:table> 
 <!-- FIM    UC005  --> 
</xsl:template>

<!--
###############################################
# 5 - Disponibilizao de Est. e Est. Receitas#
###############################################
-->
<xsl:template match="UC006">

 <xsl:variable name="perg1">
  <xsl:if test="UC006Row[CD_PERGUNTA='UC006_t1p01']/RESPOSTA='S'">
   <xsl:value-of select="' colocou '"></xsl:value-of>
  </xsl:if>
  <xsl:if test="UC006Row[CD_PERGUNTA='UC006_t1p01']/RESPOSTA='N'">
   <xsl:value-of select="' no colocou '"></xsl:value-of>
  </xsl:if>
 </xsl:variable>
 <xsl:variable name="perg3">
  <xsl:if test="UC006Row[CD_PERGUNTA='UC006_t1p03']/RESPOSTA='S'">
   <xsl:value-of select="' observando '"></xsl:value-of>
  </xsl:if>
  <xsl:if test="UC006Row[CD_PERGUNTA='UC006_t1p03']/RESPOSTA='N'">
   <xsl:value-of select="' no observando '"></xsl:value-of>
  </xsl:if>
 </xsl:variable>

 <!-- INICIO 5 - Disponibilizao dos Estudos e Estimativas da Receita -->
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 
 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" />
  <fo:table-body>
   <fo:table-row>
    <fo:table-cell>
     <fo:block xsl:use-attribute-sets="titFCinza">
      <xsl:text>5 - Disponibilizao dos Estudos e Estimativas das Receitas</xsl:text>
     </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-body>
 </fo:table>
 
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 
 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="556pt"/>

  <fo:table-body >	   
    <fo:table-row>								
     <fo:table-cell>
	  <fo:block xsl:use-attribute-sets="txtJustifyMed" text-align="justify" margin-left="15pt" hyphenate="true" >
       <!-- Primeira, Segunda e Terceira Resposta do Relatrio-->        
        <xsl:if test="UC006Row[CD_PERGUNTA='UC006_t1p01']/RESPOSTA='S'">
  		 O Poder Executivo <xsl:value-of select="$perg1"/>  disposio do Poder Legislativo Municipal em <xsl:value-of select="UC006Row[CD_PERGUNTA='UC006_t1p02']/RESPOSTA_EXT"/>, os estudos e as estimativas das receitas para o exerccio subseqente, inclusive da Receita Corrente Lquida, bem como as respectivas memrias de clculo, <xsl:value-of select="$perg3"/> o prazo mnimo de trinta dias antes do prazo final de encaminhamento da proposta oramentria, conforme definido no  3 do artigo 12 da Lei de Responsabilidade Fiscal.
        </xsl:if>
        <xsl:if test="UC006Row[CD_PERGUNTA='UC006_t1p01']/RESPOSTA='N'">
  		 O Poder Executivo <xsl:value-of select="$perg1"/>  disposio do Poder Legislativo Municipal, os estudos e as estimativas das receitas para o exerccio subseqente, inclusive da Receita Corrente Lquida, bem como as respectivas memrias de clculo, conforme definido no  3 do artigo 12 da Lei de Responsabilidade Fiscal.
        </xsl:if>
      </fo:block>
     </fo:table-cell>
    </fo:table-row>   	
  </fo:table-body>
 </fo:table> 
  
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 
 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="556pt"/>

  <fo:table-body >	   
    <fo:table-row>								
     <fo:table-cell>
	  <fo:block xsl:use-attribute-sets="txtJustifyMed" text-align="justify" margin-left="15pt" hyphenate="true" >
       <xsl:if test="../../Observacoes/ObservacoesRemessas/ObservacoesRemessasRow[CD_OBSERVACOES='UC006']/OBSERVACOES!=''">
        <fo:inline font-weight="bold">Observaes: </fo:inline><xsl:value-of select="../../Observacoes/ObservacoesRemessas/ObservacoesRemessasRow[CD_OBSERVACOES='UC006']/OBSERVACOES"></xsl:value-of>
       </xsl:if>
       <xsl:if test="../../Observacoes/ObservacoesRemessas/ObservacoesRemessasRow[CD_OBSERVACOES='UC006']/OBSERVACOES=''">
        <fo:inline font-style="italic">No foram inseridas observaes para este item.</fo:inline>
       </xsl:if>
      </fo:block>
     </fo:table-cell>
    </fo:table-row>   	
  </fo:table-body>
 </fo:table> 
 <!-- FIM    UC006  --> 
</xsl:template>

<!--
###############################################
##  2 - Lei de Diretrizes Oramentrias    ####
###############################################
-->
<xsl:template match="UC007">

 <!-- INICIO 2 - Lei de Diretrizes Oramentrias -->
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 
 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" />
  <fo:table-body>
   <fo:table-row>
    <fo:table-cell>
     <fo:block xsl:use-attribute-sets="titFCinza">
      <xsl:text>2 - Lei de Diretrizes Oramentrias - LDO</xsl:text>
     </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-body>
 </fo:table>
 
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 
 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="556pt"/>

  <fo:table-body >	   
    <fo:table-row>								
     <fo:table-cell>
	  <fo:block xsl:use-attribute-sets="txtJustifyMed" text-align="justify" margin-left="15pt" hyphenate="true" >
       <!-- Primeira Resposta do Relatrio-->
		A LDO n <xsl:value-of select="UC007Row[CD_PERGUNTA='UC007_t1p01']/RESPOSTA_EXT"/>, publicada em <xsl:value-of select="UC007Row[CD_PERGUNTA='UC007_t1p02']/RESPOSTA_EXT"/>:
       <fo:block><fo:leader leader-pattern="space"/></fo:block>
       <!-- Segunda Resposta do Relatrio-->
       <xsl:if test="UC007Row[CD_PERGUNTA='UC007_t1p03']/RESPOSTA='S'">
		 a) Contm matria acerca do equilbrio entre receitas e despesas;
       </xsl:if>        
       <xsl:if test="UC007Row[CD_PERGUNTA='UC007_t1p03']/RESPOSTA='N'">
		 a) No contm matria acerca do equilbrio entre receitas e despesas;
       </xsl:if>        
       <fo:block><fo:leader leader-pattern="space"/></fo:block>
       <!-- Terceira Resposta do Relatrio-->
       <xsl:if test="UC007Row[CD_PERGUNTA='UC007_t1p04']/RESPOSTA='S'">
		 b) Fixou critrios e forma de limitao de empenho;
       </xsl:if>        
       <xsl:if test="UC007Row[CD_PERGUNTA='UC007_t1p04']/RESPOSTA='N'">
		 b) No fixou critrios e forma de limitao de empenho;
       </xsl:if>        
       <fo:block><fo:leader leader-pattern="space"/></fo:block>
       <!-- Quarta Resposta do Relatrio-->
       <xsl:if test="UC007Row[CD_PERGUNTA='UC007_t1p05']/RESPOSTA='S'">
		 c) Estabeleceu normas relativas ao controle de custos e  avaliao dos resultados dos programas financiados com recursos dos oramentos;
       </xsl:if>        
       <xsl:if test="UC007Row[CD_PERGUNTA='UC007_t1p05']/RESPOSTA='N'">
		 c) No estabeleceu normas relativas ao controle de custos e  avaliao dos resultados dos programas financiados com recursos dos oramentos;
       </xsl:if>        
       <fo:block><fo:leader leader-pattern="space"/></fo:block>
       <!-- Quinta Resposta do Relatrio-->
       <xsl:if test="UC007Row[CD_PERGUNTA='UC007_t1p06']/RESPOSTA='S'">
		 d) Definiu demais condies e exigncias para transferncias de recursos a entidades pblicas e privadas;
       </xsl:if>        
       <xsl:if test="UC007Row[CD_PERGUNTA='UC007_t1p06']/RESPOSTA='N'">
		 d) No definiu demais condies e exigncias para transferncias de recursos a entidades pblicas e privadas;
       </xsl:if>        

      </fo:block>
     </fo:table-cell>
    </fo:table-row>   	
  </fo:table-body>
 </fo:table> 
  
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 
 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="556pt"/>

  <fo:table-body >	   
    <fo:table-row>								
     <fo:table-cell>
	  <fo:block xsl:use-attribute-sets="txtJustifyMed" text-align="justify" margin-left="15pt" hyphenate="true" >
       <xsl:if test="../../Observacoes/ObservacoesRemessas/ObservacoesRemessasRow[CD_OBSERVACOES='UC007']/OBSERVACOES!=''">
        <fo:inline font-weight="bold">Observaes: </fo:inline><xsl:value-of select="../../Observacoes/ObservacoesRemessas/ObservacoesRemessasRow[CD_OBSERVACOES='UC007']/OBSERVACOES"></xsl:value-of>
       </xsl:if>
       <xsl:if test="../../Observacoes/ObservacoesRemessas/ObservacoesRemessasRow[CD_OBSERVACOES='UC007']/OBSERVACOES=''">
        <fo:inline font-style="italic">No foram inseridas observaes para este item.</fo:inline>
       </xsl:if>
      </fo:block>
     </fo:table-cell>
    </fo:table-row>   	
  </fo:table-body>
 </fo:table> 
 <!-- FIM    UC007  --> 
</xsl:template>

<!--
###############################################
##       4 - Anexo de Riscos Fiscais       ####
###############################################
-->
<xsl:template match="UC009">

 <xsl:variable name="perg1">
  <xsl:if test="UC009Row[CD_PERGUNTA='UC009_t1p01']/RESPOSTA='S'">
   <xsl:value-of select="' contm '"></xsl:value-of>
  </xsl:if>
  <xsl:if test="UC009Row[CD_PERGUNTA='UC009_t1p01']/RESPOSTA='N'">
   <xsl:value-of select="' no contm '"></xsl:value-of>
  </xsl:if>
 </xsl:variable>
 <xsl:variable name="perg2">
  <xsl:if test="UC009Row[CD_PERGUNTA='UC009_t1p02']/RESPOSTA='S'">
   <xsl:value-of select="' foram '"></xsl:value-of>
  </xsl:if>
  <xsl:if test="UC009Row[CD_PERGUNTA='UC009_t1p02']/RESPOSTA='N'">
   <xsl:value-of select="' no foram '"></xsl:value-of>
  </xsl:if>
 </xsl:variable>
 <xsl:variable name="perg3">
  <xsl:if test="UC009Row[CD_PERGUNTA='UC009_t1p03']/RESPOSTA='S'">
   <xsl:value-of select="' foram '"></xsl:value-of>
  </xsl:if>
  <xsl:if test="UC009Row[CD_PERGUNTA='UC009_t1p03']/RESPOSTA='N'">
   <xsl:value-of select="' no foram '"></xsl:value-of>
  </xsl:if>
 </xsl:variable>

 <!-- INICIO 4 - Anexo de Riscos Fiscais -->
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 
 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" />
  <fo:table-body>
   <fo:table-row>
    <fo:table-cell>
     <fo:block xsl:use-attribute-sets="titFCinza">
      <xsl:text>4 - Anexo de Riscos Fiscais</xsl:text>
     </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-body>
 </fo:table>
 
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 
 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="556pt"/>

  <fo:table-body >	   
    <fo:table-row>								
     <fo:table-cell>
	  <fo:block xsl:use-attribute-sets="txtJustifyMed" text-align="justify" margin-left="15pt" hyphenate="true" >
       <!-- Primeira, Segunda e Terceira Resposta do Relatrio-->
        <xsl:if test="(UC009Row[CD_PERGUNTA='UC009_t1p01']/RESPOSTA='S') and (UC009Row[CD_PERGUNTA='UC009_t1p02']/RESPOSTA='S')">
         A LDO <xsl:value-of select="$perg1"/> o Anexo de Riscos Fiscais, onde <xsl:value-of select="$perg2"/> avaliados os passivos contingentes e outros riscos capazes de afetar as contas pblicas e <xsl:value-of select="$perg3"/> informadas as providncias a serem tomadas, caso se concretizem.
        </xsl:if>		
        <xsl:if test="(UC009Row[CD_PERGUNTA='UC009_t1p01']/RESPOSTA='S') and (UC009Row[CD_PERGUNTA='UC009_t1p02']/RESPOSTA='N')">
         A LDO <xsl:value-of select="$perg1"/> o Anexo de Riscos Fiscais, onde <xsl:value-of select="$perg2"/> avaliados os passivos contingentes e outros riscos capazes de afetar as contas pblicas.
        </xsl:if>		
        <xsl:if test="UC009Row[CD_PERGUNTA='UC009_t1p01']/RESPOSTA='N'">
         A LDO <xsl:value-of select="$perg1"/> o Anexo de Riscos Fiscais.
        </xsl:if>			
      </fo:block>
     </fo:table-cell>
    </fo:table-row>   	
  </fo:table-body>
 </fo:table> 
  
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 
 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="556pt"/>

  <fo:table-body >	   
    <fo:table-row>								
     <fo:table-cell>
	  <fo:block xsl:use-attribute-sets="txtJustifyMed" text-align="justify" margin-left="15pt" hyphenate="true" >
       <xsl:if test="../../Observacoes/ObservacoesRemessas/ObservacoesRemessasRow[CD_OBSERVACOES='UC009']/OBSERVACOES!=''">
        <fo:inline font-weight="bold">Observaes: </fo:inline><xsl:value-of select="../../Observacoes/ObservacoesRemessas/ObservacoesRemessasRow[CD_OBSERVACOES='UC009']/OBSERVACOES"></xsl:value-of>
       </xsl:if>
       <xsl:if test="../../Observacoes/ObservacoesRemessas/ObservacoesRemessasRow[CD_OBSERVACOES='UC009']/OBSERVACOES=''">
        <fo:inline font-style="italic">No foram inseridas observaes para este item.</fo:inline>
       </xsl:if>
      </fo:block>
     </fo:table-cell>
    </fo:table-row>   	
  </fo:table-body>
 </fo:table> 
 <!-- FIM    UC009  --> 
</xsl:template>

<!--
###############################################
###    6 - Cronograma Mensal de Desembolso  ###
###############################################
-->
<xsl:template match="UC010">

 <xsl:variable name="perg1">
  <xsl:if test="UC010Row[CD_PERGUNTA='UC010_t1p01']/RESPOSTA='S'">
   <xsl:value-of select="' estabeleceu '"></xsl:value-of>
  </xsl:if>
  <xsl:if test="UC010Row[CD_PERGUNTA='UC010_t1p01']/RESPOSTA='N'">
   <xsl:value-of select="' no estabeleceu '"></xsl:value-of>
  </xsl:if>
 </xsl:variable>
 <xsl:variable name="perg2">
  <xsl:if test="UC010Row[CD_PERGUNTA='UC010_t1p01']/RESPOSTA='N'">
   <xsl:value-of select="' em at '"></xsl:value-of>
  </xsl:if>  
  <xsl:if test="UC010Row[CD_PERGUNTA='UC010_t1p02']/RESPOSTA='S'">
   <xsl:value-of select="' em at '"></xsl:value-of>
  </xsl:if>
  <xsl:if test="UC010Row[CD_PERGUNTA='UC010_t1p02']/RESPOSTA='N'">
   <xsl:value-of select="', contudo no observou o prazo de '"></xsl:value-of>
  </xsl:if>
 </xsl:variable>

 <!-- INICIO 6 - Cronograma Mensal de Desembolso -->
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 
 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" />
  <fo:table-body>
   <fo:table-row>
    <fo:table-cell>
     <fo:block xsl:use-attribute-sets="titFCinza">
      <xsl:text>6 - Cronograma de Execuo Mensal de Desembolso</xsl:text>
     </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-body>
 </fo:table>
 
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 
 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="556pt"/>

  <fo:table-body >	   
    <fo:table-row>								
     <fo:table-cell>
	  <fo:block xsl:use-attribute-sets="txtJustifyMed" text-align="justify" margin-left="15pt" hyphenate="true" >
       <!-- Primeira Resposta do Relatrio-->        
 		O Poder Executivo <xsl:value-of select="$perg1"/> a programao financeira e o cronograma de execuo mensal de desembolso <xsl:value-of select="$perg2"/> trinta dias aps a publicao dos oramentos.
      </fo:block>
     </fo:table-cell>
    </fo:table-row>   	
  </fo:table-body>
 </fo:table> 
  
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 
 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="556pt"/>

  <fo:table-body >	   
    <fo:table-row>								
     <fo:table-cell>
	  <fo:block xsl:use-attribute-sets="txtJustifyMed" text-align="justify" margin-left="15pt" hyphenate="true" >
       <xsl:if test="../../Observacoes/ObservacoesRemessas/ObservacoesRemessasRow[CD_OBSERVACOES='UC010']/OBSERVACOES!=''">
        <fo:inline font-weight="bold">Observaes: </fo:inline><xsl:value-of select="../../Observacoes/ObservacoesRemessas/ObservacoesRemessasRow[CD_OBSERVACOES='UC010']/OBSERVACOES"></xsl:value-of>
       </xsl:if>
       <xsl:if test="../../Observacoes/ObservacoesRemessas/ObservacoesRemessasRow[CD_OBSERVACOES='UC010']/OBSERVACOES=''">
        <fo:inline font-style="italic">No foram inseridas observaes para este item.</fo:inline>
       </xsl:if>
      </fo:block>
     </fo:table-cell>
    </fo:table-row>   	
  </fo:table-body>
 </fo:table> 
 <!-- FIM    UC010  --> 
</xsl:template>

<!--
###############################################
###    7 - Metas Bimestrais de Arrecadao  ###
###############################################
-->
<xsl:template match="UC011">

 <xsl:variable name="perg1">
  <xsl:if test="UC011Row[CD_PERGUNTA='UC011_t1p01']/RESPOSTA='S'">
   <xsl:value-of select="' foram '"></xsl:value-of>
  </xsl:if>
  <xsl:if test="UC011Row[CD_PERGUNTA='UC011_t1p01']/RESPOSTA='N'">
   <xsl:value-of select="' no foram '"></xsl:value-of>
  </xsl:if>
 </xsl:variable>
 <xsl:variable name="perg2">
  <xsl:if test="UC011Row[CD_PERGUNTA='UC011_t1p02']/RESPOSTA='S'">
   <xsl:value-of select="' Foi '"></xsl:value-of>
  </xsl:if>
  <xsl:if test="UC011Row[CD_PERGUNTA='UC011_t1p02']/RESPOSTA='N'">
   <xsl:value-of select="' No foi '"></xsl:value-of>
  </xsl:if>
 </xsl:variable>
 <xsl:variable name="perg3">
  <xsl:if test="UC011Row[CD_PERGUNTA='UC011_t1p03']/RESPOSTA='S'">
   <xsl:value-of select="' Foram '"></xsl:value-of>
  </xsl:if>
  <xsl:if test="UC011Row[CD_PERGUNTA='UC011_t1p03']/RESPOSTA='N'">
   <xsl:value-of select="' No foram '"></xsl:value-of>
  </xsl:if>
 </xsl:variable>
 <xsl:variable name="perg4">
  <xsl:if test="UC011Row[CD_PERGUNTA='UC011_t1p04']/RESPOSTA='S'">
   <xsl:value-of select="' Foi '"></xsl:value-of>
  </xsl:if>
  <xsl:if test="UC011Row[CD_PERGUNTA='UC011_t1p04']/RESPOSTA='N'">
   <xsl:value-of select="' No foi '"></xsl:value-of>
  </xsl:if>
 </xsl:variable>
 <xsl:variable name="perg5">
  <xsl:if test="UC011Row[CD_PERGUNTA='UC011_t1p01']/RESPOSTA='N'">
   <xsl:value-of select="' no prazo '"></xsl:value-of>
  </xsl:if>
  <xsl:if test="UC011Row[CD_PERGUNTA='UC011_t1p05']/RESPOSTA='S'">
   <xsl:value-of select="' no prazo '"></xsl:value-of>
  </xsl:if>
  <xsl:if test="UC011Row[CD_PERGUNTA='UC011_t1p05']/RESPOSTA='N'">
   <xsl:value-of select="' fora do prazo '"></xsl:value-of>
  </xsl:if>
 </xsl:variable>


 <!-- INICIO 7 - Metas Bimestrais de Arrecadao -->
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 
 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" />
  <fo:table-body>
   <fo:table-row>
    <fo:table-cell>
     <fo:block xsl:use-attribute-sets="titFCinza">
      <xsl:text>7 - Metas Bimestrais de Arrecadao</xsl:text>
     </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-body>
 </fo:table>
 
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 
 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="556pt"/>

  <fo:table-body >	   
    <fo:table-row>								
     <fo:table-cell>
	  <fo:block xsl:use-attribute-sets="txtJustifyMed" text-align="justify" margin-left="15pt" hyphenate="true" >
       <!-- Primeira Resposta do Relatrio-->        
        <xsl:if test="UC011Row[CD_PERGUNTA='UC011_t1p01']/RESPOSTA='S'">
		 As receitas previstas <xsl:value-of select="$perg1"/> desdobradas, pelo Poder Executivo, <xsl:value-of select="$perg5"/> previsto no art. 8 da LRF (30 dias aps a publicao dos oramentos), em metas bimestrais de arrecadao, e:
         <fo:block><fo:leader leader-pattern="space"/></fo:block>
		 - <xsl:value-of select="$perg3"/> especificadas em separado as medidas de combate  evaso e  sonegao;
         <fo:block><fo:leader leader-pattern="space"/></fo:block>
		 - <xsl:value-of select="$perg4"/> especificada em separado a quantidade e valores de aes ajuizadas para cobrana de dvida ativa;
         <fo:block><fo:leader leader-pattern="space"/></fo:block>
		 - <xsl:value-of select="$perg2"/> especificada em separado a evoluo do montante dos crditos tributrios passveis de cobrana administrativa.
        </xsl:if>
        <xsl:if test="UC011Row[CD_PERGUNTA='UC011_t1p01']/RESPOSTA='N'">
		 As receitas previstas <xsl:value-of select="$perg1"/> desdobradas, pelo Poder Executivo, no prazo previsto no art. 8 da LRF (30 dias aps a publicao dos oramentos), em metas bimestrais de arrecadao.
        </xsl:if> 		
      </fo:block>
     </fo:table-cell>
    </fo:table-row>   	
  </fo:table-body>
 </fo:table> 
  
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 
 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="556pt"/>

  <fo:table-body >	   
    <fo:table-row>								
     <fo:table-cell>
	  <fo:block xsl:use-attribute-sets="txtJustifyMed" text-align="justify" margin-left="15pt" hyphenate="true" >
       <xsl:if test="../../Observacoes/ObservacoesRemessas/ObservacoesRemessasRow[CD_OBSERVACOES='UC011']/OBSERVACOES!=''">
        <fo:inline font-weight="bold">Observaes: </fo:inline><xsl:value-of select="../../Observacoes/ObservacoesRemessas/ObservacoesRemessasRow[CD_OBSERVACOES='UC011']/OBSERVACOES"></xsl:value-of>
       </xsl:if>
       <xsl:if test="../../Observacoes/ObservacoesRemessas/ObservacoesRemessasRow[CD_OBSERVACOES='UC011']/OBSERVACOES=''">
        <fo:inline font-style="italic">No foram inseridas observaes para este item.</fo:inline>
       </xsl:if>
      </fo:block>
     </fo:table-cell>
    </fo:table-row>   	
  </fo:table-body>
 </fo:table> 
 <!-- FIM    UC011  --> 
</xsl:template>

<!--
###############################################
# 8 - Limitao de Empenho e Mov. Financeira  #
###############################################
-->
<xsl:template match="UC012">

 <xsl:variable name="perg1">
  <xsl:if test="UC012Row[CD_PERGUNTA='UC012_t2p06']/RESPOSTA='S'">
   <xsl:value-of select="' ocorreu '"></xsl:value-of>
  </xsl:if>
  <xsl:if test="UC012Row[CD_PERGUNTA='UC012_t2p06']/RESPOSTA='N'">
   <xsl:value-of select="' no ocorreu '"></xsl:value-of>
  </xsl:if>
 </xsl:variable>
 <xsl:variable name="perg2">
  <xsl:if test="UC012Row[CD_PERGUNTA='UC012_t2p04']/RESPOSTA='T'">
   <xsl:value-of select="' total '"></xsl:value-of>
  </xsl:if>
  <xsl:if test="UC012Row[CD_PERGUNTA='UC012_t2p04']/RESPOSTA='P'">
   <xsl:value-of select="' parcial '"></xsl:value-of>
  </xsl:if>
 </xsl:variable>
 <xsl:variable name="perg3">
  <xsl:if test="UC012Row[CD_PERGUNTA='UC012_t2p05']/RESPOSTA='S'">
    <xsl:if test="UC012Row[CD_PERGUNTA='UC012_t2p06']/RESPOSTA='S'">
      <xsl:value-of select="' ocorreu '"></xsl:value-of>   
    </xsl:if> 
    <xsl:if test="UC012Row[CD_PERGUNTA='UC012_t2p06']/RESPOSTA='N'">
      <xsl:value-of select="' no ocorreu '"></xsl:value-of>   
    </xsl:if> 
  </xsl:if>
  <xsl:if test="UC012Row[CD_PERGUNTA='UC012_t2p05']/RESPOSTA='N'">
   <xsl:value-of select="' no ocorreu '"></xsl:value-of>
  </xsl:if>
 </xsl:variable>
 <xsl:variable name="perg4">
  <xsl:if test="UC012Row[CD_PERGUNTA='UC012_t1p01']/RESPOSTA_EXT='00001'"><xsl:value-of select="' 5 '"></xsl:value-of></xsl:if>
  <xsl:if test="UC012Row[CD_PERGUNTA='UC012_t1p01']/RESPOSTA_EXT='00010'"><xsl:value-of select="' 4 '"></xsl:value-of></xsl:if>
  <xsl:if test="UC012Row[CD_PERGUNTA='UC012_t1p01']/RESPOSTA_EXT='00011'"><xsl:value-of select="' 4 e 5 '"></xsl:value-of></xsl:if>
  <xsl:if test="UC012Row[CD_PERGUNTA='UC012_t1p01']/RESPOSTA_EXT='00100'"><xsl:value-of select="' 3 '"></xsl:value-of></xsl:if>
  <xsl:if test="UC012Row[CD_PERGUNTA='UC012_t1p01']/RESPOSTA_EXT='00101'"><xsl:value-of select="' 3 e 5 '"></xsl:value-of></xsl:if>
  <xsl:if test="UC012Row[CD_PERGUNTA='UC012_t1p01']/RESPOSTA_EXT='00110'"><xsl:value-of select="' 3 e 4 '"></xsl:value-of></xsl:if>
  <xsl:if test="UC012Row[CD_PERGUNTA='UC012_t1p01']/RESPOSTA_EXT='00111'"><xsl:value-of select="' 3, 4 e 5 '"></xsl:value-of></xsl:if>
  <xsl:if test="UC012Row[CD_PERGUNTA='UC012_t1p01']/RESPOSTA_EXT='01000'"><xsl:value-of select="' 2 '"></xsl:value-of></xsl:if>
  <xsl:if test="UC012Row[CD_PERGUNTA='UC012_t1p01']/RESPOSTA_EXT='01001'"><xsl:value-of select="' 2 e 5 '"></xsl:value-of></xsl:if>
  <xsl:if test="UC012Row[CD_PERGUNTA='UC012_t1p01']/RESPOSTA_EXT='01010'"><xsl:value-of select="' 2 e 4 '"></xsl:value-of></xsl:if>
  <xsl:if test="UC012Row[CD_PERGUNTA='UC012_t1p01']/RESPOSTA_EXT='01011'"><xsl:value-of select="' 2, 4 e 5 '"></xsl:value-of></xsl:if>
  <xsl:if test="UC012Row[CD_PERGUNTA='UC012_t1p01']/RESPOSTA_EXT='01100'"><xsl:value-of select="' 2 e 3 '"></xsl:value-of></xsl:if>
  <xsl:if test="UC012Row[CD_PERGUNTA='UC012_t1p01']/RESPOSTA_EXT='01101'"><xsl:value-of select="' 2, 3 e 5 '"></xsl:value-of></xsl:if>
  <xsl:if test="UC012Row[CD_PERGUNTA='UC012_t1p01']/RESPOSTA_EXT='01110'"><xsl:value-of select="' 2, 3 e 4 '"></xsl:value-of></xsl:if>
  <xsl:if test="UC012Row[CD_PERGUNTA='UC012_t1p01']/RESPOSTA_EXT='01111'"><xsl:value-of select="' 2, 3, 4 e 5 '"></xsl:value-of></xsl:if>
  <xsl:if test="UC012Row[CD_PERGUNTA='UC012_t1p01']/RESPOSTA_EXT='10000'"><xsl:value-of select="' 1 '"></xsl:value-of></xsl:if>
  <xsl:if test="UC012Row[CD_PERGUNTA='UC012_t1p01']/RESPOSTA_EXT='10001'"><xsl:value-of select="' 1 e 5 '"></xsl:value-of></xsl:if>
  <xsl:if test="UC012Row[CD_PERGUNTA='UC012_t1p01']/RESPOSTA_EXT='10010'"><xsl:value-of select="' 1 e 4 '"></xsl:value-of></xsl:if>
  <xsl:if test="UC012Row[CD_PERGUNTA='UC012_t1p01']/RESPOSTA_EXT='10011'"><xsl:value-of select="' 1, 4 e 5 '"></xsl:value-of></xsl:if>
  <xsl:if test="UC012Row[CD_PERGUNTA='UC012_t1p01']/RESPOSTA_EXT='10100'"><xsl:value-of select="' 1 e 3 '"></xsl:value-of></xsl:if>
  <xsl:if test="UC012Row[CD_PERGUNTA='UC012_t1p01']/RESPOSTA_EXT='10101'"><xsl:value-of select="' 1, 3 e 5 '"></xsl:value-of></xsl:if>
  <xsl:if test="UC012Row[CD_PERGUNTA='UC012_t1p01']/RESPOSTA_EXT='10110'"><xsl:value-of select="' 1, 3 e 4 '"></xsl:value-of></xsl:if>
  <xsl:if test="UC012Row[CD_PERGUNTA='UC012_t1p01']/RESPOSTA_EXT='10111'"><xsl:value-of select="' 1, 3, 4 e 5 '"></xsl:value-of></xsl:if>
  <xsl:if test="UC012Row[CD_PERGUNTA='UC012_t1p01']/RESPOSTA_EXT='11000'"><xsl:value-of select="' 1 e 2'"></xsl:value-of></xsl:if>
  <xsl:if test="UC012Row[CD_PERGUNTA='UC012_t1p01']/RESPOSTA_EXT='11001'"><xsl:value-of select="' 1, 2 e 5 '"></xsl:value-of></xsl:if>
  <xsl:if test="UC012Row[CD_PERGUNTA='UC012_t1p01']/RESPOSTA_EXT='11010'"><xsl:value-of select="' 1, 2 e 4 '"></xsl:value-of></xsl:if>
  <xsl:if test="UC012Row[CD_PERGUNTA='UC012_t1p01']/RESPOSTA_EXT='11011'"><xsl:value-of select="' 1, 2, 4 e 5 '"></xsl:value-of></xsl:if>
  <xsl:if test="UC012Row[CD_PERGUNTA='UC012_t1p01']/RESPOSTA_EXT='11100'"><xsl:value-of select="' 1, 2 e 3 '"></xsl:value-of></xsl:if>
  <xsl:if test="UC012Row[CD_PERGUNTA='UC012_t1p01']/RESPOSTA_EXT='11101'"><xsl:value-of select="' 1, 2, 3 e 5 '"></xsl:value-of></xsl:if>
  <xsl:if test="UC012Row[CD_PERGUNTA='UC012_t1p01']/RESPOSTA_EXT='11110'"><xsl:value-of select="' 1, 2, 3 e 4 '"></xsl:value-of></xsl:if>
  <xsl:if test="UC012Row[CD_PERGUNTA='UC012_t1p01']/RESPOSTA_EXT='11111'"><xsl:value-of select="' 1, 2, 3, 4 e 5 '"></xsl:value-of></xsl:if>
 </xsl:variable>
 <xsl:variable name="perg5">
  <xsl:if test="UC012Row[CD_PERGUNTA='UC012_t1p02']/RESPOSTA='S'">
   <xsl:value-of select="' promoveu '"></xsl:value-of>
  </xsl:if>
  <xsl:if test="UC012Row[CD_PERGUNTA='UC012_t1p02']/RESPOSTA='N'">
   <xsl:value-of select="' no promoveu '"></xsl:value-of>
  </xsl:if>
 </xsl:variable>
 <xsl:variable name="perg6">
  <xsl:if test="UC012Row[CD_PERGUNTA='UC012_t2p01']/RESPOSTA='S'">
   <xsl:value-of select="' '"></xsl:value-of>
  </xsl:if>
  <xsl:if test="UC012Row[CD_PERGUNTA='UC012_t2p01']/RESPOSTA='N'">
   <xsl:value-of select="' porm no '"></xsl:value-of>
  </xsl:if>
 </xsl:variable>
 <xsl:variable name="perg7">
  <xsl:if test="UC012Row[CD_PERGUNTA='UC012_t2p02']/RESPOSTA='S'">
   <xsl:value-of select="' observando '"></xsl:value-of>
  </xsl:if>
  <xsl:if test="UC012Row[CD_PERGUNTA='UC012_t2p02']/RESPOSTA='N'">
   <xsl:value-of select="' no observando '"></xsl:value-of>
  </xsl:if>
 </xsl:variable>
 <xsl:variable name="perg8">
  <xsl:if test="UC012Row[CD_PERGUNTA='UC012_t2p03']/RESPOSTA='S'">
   <xsl:value-of select="' segundo '"></xsl:value-of>
  </xsl:if>
  <xsl:if test="UC012Row[CD_PERGUNTA='UC012_t2p03']/RESPOSTA='N'">
   <xsl:value-of select="' em desacordo com '"></xsl:value-of>
  </xsl:if>
 </xsl:variable>
 <xsl:variable name="perg9">
  <xsl:if test="UC012Row[CD_PERGUNTA='UC012_t2p05']/RESPOSTA='S'">
   <xsl:value-of select="' entretanto '"></xsl:value-of>
  </xsl:if>
  <xsl:if test="UC012Row[CD_PERGUNTA='UC012_t2p05']/RESPOSTA='N'">
   <xsl:value-of select="' e no '"></xsl:value-of>
  </xsl:if>
 </xsl:variable>



 <!-- INICIO 8 - Limitao de Empenho e Movimentao Financeira -->
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 
 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" />
  <fo:table-body>
   <fo:table-row>
    <fo:table-cell>
     <fo:block xsl:use-attribute-sets="titFCinza">
      <xsl:text>8 - Limitao de Empenho e Movimentao Financeira</xsl:text>
     </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-body>
 </fo:table>
 
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 
 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="556pt"/>

  <fo:table-body >	   
    <fo:table-row>								
     <fo:table-cell>
	  <fo:block xsl:use-attribute-sets="txtJustifyMed" text-align="justify" margin-left="15pt" hyphenate="true" >
       <!-- Primeira Resposta do Relatrio-->        
       
	   <xsl:if test="UC012Row[CD_PERGUNTA='UC012_t1p01']/RESPOSTA_EXT='00000'">
        O Poder Executivo Municipal no promoveu a limitao de empenho, pois foi constatado que a realizao da receita dever comportar o cumprimento das metas de resultado nominal ou primrio.
       </xsl:if>       
	   <xsl:if test="UC012Row[CD_PERGUNTA='UC012_t1p01']/RESPOSTA_EXT!='00000'">
         <!--Primeiro Pargrafo-->
		 <xsl:if test="UC012Row[CD_PERGUNTA='UC012_t1p02']/RESPOSTA='N'">
          O Poder Executivo Municipal, ao constatar ao final do <xsl:value-of select="$perg4"/> bimestre que a realizao da receita poder no comportar o cumprimento das metas de resultado primrio ou nominal, estabelecidas no Anexo de Metas Fiscais, <xsl:value-of select="$perg5"/> a limitao de empenho e movimentao financeira.
		 </xsl:if>
		 <xsl:if test="UC012Row[CD_PERGUNTA='UC012_t1p02']/RESPOSTA='S'">
          O Poder Executivo Municipal, ao constatar ao final do <xsl:value-of select="$perg4"/> bimestre que a realizao da receita poder no comportar o cumprimento das metas de resultado primrio ou nominal, estabelecidas no Anexo de Metas Fiscais, <xsl:value-of select="$perg5"/> a limitao de empenho e movimentao financeira, <xsl:value-of select="$perg6"/> no montante necessrio, <xsl:value-of select="$perg7"/> o prazo legal (trinta dias subseqentes ao encerramento do bimestre), <xsl:value-of select="$perg8"/> os critrios fixados na LDO.
		 </xsl:if>

	     <!--Segundo pargrafo-->
		 <xsl:if test="UC012Row[CD_PERGUNTA='UC012_t2p04']/RESPOSTA!='N'">
          <fo:block><fo:leader leader-pattern="space"/></fo:block>
          <!--Verifica se exibe at o texto no ocorreu, dependendo da resposta da pergunta 6 - tela 2 -->
		  <xsl:if test="UC012Row[CD_PERGUNTA='UC012_t1p02']/RESPOSTA='N'">
            Houve restabelecimento <xsl:value-of select="$perg2"/> da receita prevista.
		  </xsl:if>
		  <xsl:if test="UC012Row[CD_PERGUNTA='UC012_t1p02']/RESPOSTA='S'">
 		    <xsl:if test="UC012Row[CD_PERGUNTA='UC012_t2p05']/RESPOSTA='N'">
		     Houve restabelecimento <xsl:value-of select="$perg2"/> da receita prevista e a recomposio das dotaes cujos empenhos foram limitados <xsl:value-of select="$perg3"/>.
		    </xsl:if>
		    <xsl:if test="UC012Row[CD_PERGUNTA='UC012_t2p05']/RESPOSTA='S'">
		     Houve restabelecimento <xsl:value-of select="$perg2"/> da receita prevista e a recomposio das dotaes cujos empenhos foram limitados <xsl:value-of select="$perg3"/> de forma proporcional s redues efetivadas.
		    </xsl:if>		  
		  </xsl:if>

         </xsl:if>       		

	     <!--Terceiro pargrafo-->
		 <xsl:if test="UC012Row[CD_PERGUNTA='UC012_t2p04']/RESPOSTA='N'">
           <fo:block><fo:leader leader-pattern="space"/></fo:block>
           <xsl:if test="UC012Row[CD_PERGUNTA='UC012_t1p02']/RESPOSTA='N'">
		     No houve restabelecimento da receita prevista.
		   </xsl:if>
           <xsl:if test="UC012Row[CD_PERGUNTA='UC012_t1p02']/RESPOSTA='S'">
		     <xsl:if test="UC012Row[CD_PERGUNTA='UC012_t2p05']/RESPOSTA='N'">
               No houve restabelecimento da receita prevista, <xsl:value-of select="$perg9"/> foi efetuada a recomposio das dotaes cujos empenhos foram limitados.		  
		     </xsl:if>
             <xsl:if test="UC012Row[CD_PERGUNTA='UC012_t2p05']/RESPOSTA='S'">
               No houve restabelecimento da receita prevista, <xsl:value-of select="$perg9"/> foi efetuada a recomposio das dotaes cujos empenhos foram limitados, que <xsl:value-of select="$perg1"/> de forma proporcional s redues efetivadas.		  		  
		     </xsl:if>  		  		   
		   </xsl:if>

         </xsl:if>       		

       </xsl:if>       

      </fo:block>
     </fo:table-cell>
    </fo:table-row>   	
  </fo:table-body>
 </fo:table> 
  
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 
 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="556pt"/>

  <fo:table-body >	   
    <fo:table-row>								
     <fo:table-cell>
	  <fo:block xsl:use-attribute-sets="txtJustifyMed" text-align="justify" margin-left="15pt" hyphenate="true" >
       <xsl:if test="../../Observacoes/ObservacoesRemessas/ObservacoesRemessasRow[CD_OBSERVACOES='UC012']/OBSERVACOES!=''">
        <fo:inline font-weight="bold">Observaes: </fo:inline><xsl:value-of select="../../Observacoes/ObservacoesRemessas/ObservacoesRemessasRow[CD_OBSERVACOES='UC012']/OBSERVACOES"></xsl:value-of>
       </xsl:if>
       <xsl:if test="../../Observacoes/ObservacoesRemessas/ObservacoesRemessasRow[CD_OBSERVACOES='UC012']/OBSERVACOES=''">
        <fo:inline font-style="italic">No foram inseridas observaes para este item.</fo:inline>
       </xsl:if>
      </fo:block>
     </fo:table-cell>
    </fo:table-row>   	
  </fo:table-body>
 </fo:table> 
 <!-- FIM    UC012  --> 
</xsl:template>

<!--
###############################################
###        9 - Operaes de Crdito         ###
###############################################
-->
<xsl:template match="UC013">

 <xsl:variable name="perg1">
  <xsl:if test="((UC013Row[CD_PERGUNTA='UC013_t1p01']/RESPOSTA='S') and (UC013Row[CD_PERGUNTA='UC013_t1p02']/RESPOSTA='S') and (UC013Row[CD_PERGUNTA='UC013_t1p03']/RESPOSTA='S'))">
   <xsl:value-of select="'As operaes de crdito, as inscries em Restos a Pagar e as demais formas de financiamento ou assuno de compromissos junto a terceiros'"></xsl:value-of>
  </xsl:if>
  <xsl:if test="((UC013Row[CD_PERGUNTA='UC013_t1p01']/RESPOSTA='S') and (UC013Row[CD_PERGUNTA='UC013_t1p02']/RESPOSTA='S') and ((UC013Row[CD_PERGUNTA='UC013_t1p03']/RESPOSTA='N') or (UC013Row[CD_PERGUNTA='UC013_t1p03']/RESPOSTA='H')))">
   <xsl:value-of select="'As operaes de crdito e as inscries em Restos a Pagar'"></xsl:value-of>
  </xsl:if>
  <xsl:if test="((UC013Row[CD_PERGUNTA='UC013_t1p01']/RESPOSTA='S') and ((UC013Row[CD_PERGUNTA='UC013_t1p02']/RESPOSTA='N') or (UC013Row[CD_PERGUNTA='UC013_t1p02']/RESPOSTA='H')) and ((UC013Row[CD_PERGUNTA='UC013_t1p03']/RESPOSTA='N') or (UC013Row[CD_PERGUNTA='UC013_t1p03']/RESPOSTA='H')))">
   <xsl:value-of select="'As operaes de crdito'"></xsl:value-of>
  </xsl:if>
  <xsl:if test="(((UC013Row[CD_PERGUNTA='UC013_t1p01']/RESPOSTA='N') or (UC013Row[CD_PERGUNTA='UC013_t1p01']/RESPOSTA='H')) and (UC013Row[CD_PERGUNTA='UC013_t1p02']/RESPOSTA='S') and (UC013Row[CD_PERGUNTA='UC013_t1p03']/RESPOSTA='S'))">
   <xsl:value-of select="'As inscries em Restos a Pagar e as demais formas de financiamento ou assuno de compromissos junto a terceiros'"></xsl:value-of>
  </xsl:if>
  <xsl:if test="((UC013Row[CD_PERGUNTA='UC013_t1p01']/RESPOSTA='S') and ((UC013Row[CD_PERGUNTA='UC013_t1p02']/RESPOSTA='N') or (UC013Row[CD_PERGUNTA='UC013_t1p02']/RESPOSTA='H')) and (UC013Row[CD_PERGUNTA='UC013_t1p03']/RESPOSTA='S'))">
   <xsl:value-of select="'As operaes de crdito e as demais formas de financiamento ou assuno de compromissos junto a terceiros'"></xsl:value-of>
  </xsl:if>
  <xsl:if test="(((UC013Row[CD_PERGUNTA='UC013_t1p01']/RESPOSTA='N') or (UC013Row[CD_PERGUNTA='UC013_t1p01']/RESPOSTA='H')) and (UC013Row[CD_PERGUNTA='UC013_t1p02']/RESPOSTA='S') and ((UC013Row[CD_PERGUNTA='UC013_t1p03']/RESPOSTA='N') or (UC013Row[CD_PERGUNTA='UC013_t1p03']/RESPOSTA='H')))">
   <xsl:value-of select="'As inscries em Restos a Pagar'"></xsl:value-of>
  </xsl:if>
  <xsl:if test="(((UC013Row[CD_PERGUNTA='UC013_t1p01']/RESPOSTA='N') or (UC013Row[CD_PERGUNTA='UC013_t1p01']/RESPOSTA='H')) and ((UC013Row[CD_PERGUNTA='UC013_t1p02']/RESPOSTA='N') or (UC013Row[CD_PERGUNTA='UC013_t1p02']/RESPOSTA='H')) and (UC013Row[CD_PERGUNTA='UC013_t1p03']/RESPOSTA='S'))">
   <xsl:value-of select="'As demais formas de financiamento ou assuno de compromissos junto a terceiros'"></xsl:value-of>
  </xsl:if>
 </xsl:variable>
 <xsl:variable name="perg5">
  <xsl:if test="(((UC013Row[CD_PERGUNTA='UC013_t1p01']/RESPOSTA='N') or (UC013Row[CD_PERGUNTA='UC013_t1p01']/RESPOSTA='H')) and ((UC013Row[CD_PERGUNTA='UC013_t1p02']/RESPOSTA='N') or (UC013Row[CD_PERGUNTA='UC013_t1p02']/RESPOSTA='H')) and (UC013Row[CD_PERGUNTA='UC013_t1p03']/RESPOSTA='S'))">
   <xsl:value-of select="'as demais formas de financiamento ou assuno de compromissos junto a terceiros'"></xsl:value-of>
  </xsl:if>
  <xsl:if test="(((UC013Row[CD_PERGUNTA='UC013_t1p01']/RESPOSTA='N') or (UC013Row[CD_PERGUNTA='UC013_t1p01']/RESPOSTA='H')) and (UC013Row[CD_PERGUNTA='UC013_t1p02']/RESPOSTA='S') and (UC013Row[CD_PERGUNTA='UC013_t1p03']/RESPOSTA='S'))">
   <xsl:value-of select="'as inscries em Restos a Pagar e as demais formas de financiamento ou assuno de compromissos junto a terceiros'"></xsl:value-of>
  </xsl:if>
  <xsl:if test="((UC013Row[CD_PERGUNTA='UC013_t1p01']/RESPOSTA='S') and ((UC013Row[CD_PERGUNTA='UC013_t1p02']/RESPOSTA='N') or (UC013Row[CD_PERGUNTA='UC013_t1p02']/RESPOSTA='H')) and ((UC013Row[CD_PERGUNTA='UC013_t1p03']/RESPOSTA='N') or (UC013Row[CD_PERGUNTA='UC013_t1p03']/RESPOSTA='H')))">
   <xsl:value-of select="'as operaes de crdito'"></xsl:value-of>
  </xsl:if>
  <xsl:if test="(((UC013Row[CD_PERGUNTA='UC013_t1p01']/RESPOSTA='N') or (UC013Row[CD_PERGUNTA='UC013_t1p03']/RESPOSTA='H')) and (UC013Row[CD_PERGUNTA='UC013_t1p02']/RESPOSTA='S') and ((UC013Row[CD_PERGUNTA='UC013_t1p03']/RESPOSTA='N') or (UC013Row[CD_PERGUNTA='UC013_t1p03']/RESPOSTA='H')))">
   <xsl:value-of select="'as inscries em Restos a Pagar'"></xsl:value-of>
  </xsl:if>
  <xsl:if test="((UC013Row[CD_PERGUNTA='UC013_t1p01']/RESPOSTA='S') and ((UC013Row[CD_PERGUNTA='UC013_t1p02']/RESPOSTA='N') or (UC013Row[CD_PERGUNTA='UC013_t1p02']/RESPOSTA='H')) and (UC013Row[CD_PERGUNTA='UC013_t1p03']/RESPOSTA='S'))">
   <xsl:value-of select="'as operaes de crdito e as demais formas de financiamento ou assuno de compromissos junto a terceiros'"></xsl:value-of>
  </xsl:if>
  <xsl:if test="((UC013Row[CD_PERGUNTA='UC013_t1p01']/RESPOSTA='S') and (UC013Row[CD_PERGUNTA='UC013_t1p02']/RESPOSTA='S') and ((UC013Row[CD_PERGUNTA='UC013_t1p03']/RESPOSTA='N') or (UC013Row[CD_PERGUNTA='UC013_t1p03']/RESPOSTA='H')))">
   <xsl:value-of select="'as operaes de crdito e as inscries em Restos a Pagar'"></xsl:value-of>
  </xsl:if>
 </xsl:variable>
 <xsl:variable name="perg2">
  <xsl:if test="UC013Row[CD_PERGUNTA='UC013_t1p04']/RESPOSTA='S'">
   <xsl:value-of select="'Houve '"></xsl:value-of>
  </xsl:if>
  <xsl:if test="UC013Row[CD_PERGUNTA='UC013_t1p04']/RESPOSTA='N'">
   <xsl:value-of select="'No houve '"></xsl:value-of>
  </xsl:if>
 </xsl:variable>
 <xsl:variable name="perg3">
  <xsl:if test="UC013Row[CD_PERGUNTA='UC013_t1p05']/RESPOSTA='S'">
   <xsl:value-of select="' foi '"></xsl:value-of>
  </xsl:if>
  <xsl:if test="UC013Row[CD_PERGUNTA='UC013_t1p05']/RESPOSTA='N'">
   <xsl:value-of select="' no foi '"></xsl:value-of>
  </xsl:if>
 </xsl:variable>
 <xsl:variable name="perg4">
  <xsl:if test="UC013Row[CD_PERGUNTA='UC013_t1p06']/RESPOSTA='S'">
   <xsl:value-of select="' foi '"></xsl:value-of>
  </xsl:if>
  <xsl:if test="UC013Row[CD_PERGUNTA='UC013_t1p06']/RESPOSTA='N'">
   <xsl:value-of select="' no foi '"></xsl:value-of>
  </xsl:if>
 </xsl:variable>
 <xsl:variable name="perg6">
  <xsl:if test="(((UC013Row[CD_PERGUNTA='UC013_t1p01']/RESPOSTA='S') or (UC013Row[CD_PERGUNTA='UC013_t1p01']/RESPOSTA='H')) and ((UC013Row[CD_PERGUNTA='UC013_t1p02']/RESPOSTA='S') or (UC013Row[CD_PERGUNTA='UC013_t1p02']/RESPOSTA='H')) and (UC013Row[CD_PERGUNTA='UC013_t1p03']/RESPOSTA='N'))">
   <xsl:value-of select="'As demais formas de financiamento ou assuno de compromissos junto a terceiros'"></xsl:value-of>
  </xsl:if>
  <xsl:if test="(((UC013Row[CD_PERGUNTA='UC013_t1p01']/RESPOSTA='S') or (UC013Row[CD_PERGUNTA='UC013_t1p01']/RESPOSTA='H')) and (UC013Row[CD_PERGUNTA='UC013_t1p02']/RESPOSTA='N') and (UC013Row[CD_PERGUNTA='UC013_t1p03']/RESPOSTA='N'))">
   <xsl:value-of select="'As inscries em Restos a Pagar e as demais formas de financiamento ou assuno de compromissos junto a terceiros'"></xsl:value-of>
  </xsl:if>
  <xsl:if test="((UC013Row[CD_PERGUNTA='UC013_t1p01']/RESPOSTA='N') and ((UC013Row[CD_PERGUNTA='UC013_t1p02']/RESPOSTA='S') or (UC013Row[CD_PERGUNTA='UC013_t1p02']/RESPOSTA='H')) and ((UC013Row[CD_PERGUNTA='UC013_t1p03']/RESPOSTA='S') or (UC013Row[CD_PERGUNTA='UC013_t1p03']/RESPOSTA='H')))">
   <xsl:value-of select="'As operaes de crdito'"></xsl:value-of>
  </xsl:if>
  <xsl:if test="(((UC013Row[CD_PERGUNTA='UC013_t1p01']/RESPOSTA='S') or (UC013Row[CD_PERGUNTA='UC013_t1p03']/RESPOSTA='H')) and (UC013Row[CD_PERGUNTA='UC013_t1p02']/RESPOSTA='N') and ((UC013Row[CD_PERGUNTA='UC013_t1p03']/RESPOSTA='S') or (UC013Row[CD_PERGUNTA='UC013_t1p03']/RESPOSTA='H')))">
   <xsl:value-of select="'As inscries em Restos a Pagar'"></xsl:value-of>
  </xsl:if>
  <xsl:if test="((UC013Row[CD_PERGUNTA='UC013_t1p01']/RESPOSTA='N') and ((UC013Row[CD_PERGUNTA='UC013_t1p02']/RESPOSTA='S') or (UC013Row[CD_PERGUNTA='UC013_t1p02']/RESPOSTA='H')) and (UC013Row[CD_PERGUNTA='UC013_t1p03']/RESPOSTA='N'))">
   <xsl:value-of select="'As operaes de crdito e as demais formas de financiamento ou assuno de compromissos junto a terceiros'"></xsl:value-of>
  </xsl:if>
  <xsl:if test="((UC013Row[CD_PERGUNTA='UC013_t1p01']/RESPOSTA='N') and (UC013Row[CD_PERGUNTA='UC013_t1p02']/RESPOSTA='N') and ((UC013Row[CD_PERGUNTA='UC013_t1p03']/RESPOSTA='S') or (UC013Row[CD_PERGUNTA='UC013_t1p03']/RESPOSTA='H')))">
   <xsl:value-of select="'As operaes de crdito e as inscries em Restos a Pagar'"></xsl:value-of>
  </xsl:if>
 </xsl:variable>

 <xsl:variable name="perg7">
  <!--0: No e 1: Sim ou No Houve-->  
  <!--001-->
  <xsl:if test="( (UC013Row[CD_PERGUNTA='UC013_t1p01']/RESPOSTA='N') and (UC013Row[CD_PERGUNTA='UC013_t1p02']/RESPOSTA='N') and ((UC013Row[CD_PERGUNTA='UC013_t1p03']/RESPOSTA='S') or (UC013Row[CD_PERGUNTA='UC013_t1p03']/RESPOSTA='H')) )">
   <xsl:value-of select="'as operaes de crdito e as inscries em Restos a Pagar'"></xsl:value-of>
  </xsl:if>
  <!--010-->
  <xsl:if test="( (UC013Row[CD_PERGUNTA='UC013_t1p01']/RESPOSTA='N') and ((UC013Row[CD_PERGUNTA='UC013_t1p02']/RESPOSTA='S') or (UC013Row[CD_PERGUNTA='UC013_t1p02']/RESPOSTA='H')) and (UC013Row[CD_PERGUNTA='UC013_t1p03']/RESPOSTA='N') )">
   <xsl:value-of select="'as operaes de crdito e as demais formas de financiamento ou assuno de compromissos junto a terceiros'"></xsl:value-of>
  </xsl:if>
  <!--011-->
  <xsl:if test="( (UC013Row[CD_PERGUNTA='UC013_t1p01']/RESPOSTA='N') and ((UC013Row[CD_PERGUNTA='UC013_t1p02']/RESPOSTA='S') or (UC013Row[CD_PERGUNTA='UC013_t1p02']/RESPOSTA='H')) and ((UC013Row[CD_PERGUNTA='UC013_t1p03']/RESPOSTA='S') or (UC013Row[CD_PERGUNTA='UC013_t1p03']/RESPOSTA='H')) )">
   <xsl:value-of select="'as operaes de crdito'"></xsl:value-of>
  </xsl:if>
  <!--100-->
  <xsl:if test="( ((UC013Row[CD_PERGUNTA='UC013_t1p01']/RESPOSTA='S') or (UC013Row[CD_PERGUNTA='UC013_t1p01']/RESPOSTA='H')) and (UC013Row[CD_PERGUNTA='UC013_t1p02']/RESPOSTA='N') and (UC013Row[CD_PERGUNTA='UC013_t1p03']/RESPOSTA='N') )">
   <xsl:value-of select="'as inscries em Restos a Pagar e as demais formas de financiamento ou assuno de compromissos junto a terceiros'"></xsl:value-of>
  </xsl:if>
  <!--101-->
  <xsl:if test="( ((UC013Row[CD_PERGUNTA='UC013_t1p01']/RESPOSTA='S') or (UC013Row[CD_PERGUNTA='UC013_t1p01']/RESPOSTA='H')) and (UC013Row[CD_PERGUNTA='UC013_t1p02']/RESPOSTA='N') and ((UC013Row[CD_PERGUNTA='UC013_t1p03']/RESPOSTA='S') or (UC013Row[CD_PERGUNTA='UC013_t1p03']/RESPOSTA='H')) )">
   <xsl:value-of select="'as inscries em Restos a Pagar'"></xsl:value-of>
  </xsl:if>
  <!--110-->
  <xsl:if test="( ((UC013Row[CD_PERGUNTA='UC013_t1p01']/RESPOSTA='S') or (UC013Row[CD_PERGUNTA='UC013_t1p01']/RESPOSTA='H')) and ((UC013Row[CD_PERGUNTA='UC013_t1p02']/RESPOSTA='S') or (UC013Row[CD_PERGUNTA='UC013_t1p02']/RESPOSTA='H')) and (UC013Row[CD_PERGUNTA='UC013_t1p03']/RESPOSTA='N') )">
   <xsl:value-of select="'as demais formas de financiamento ou assuno de compromissos junto a terceiros'"></xsl:value-of>
  </xsl:if>
 </xsl:variable>

 <xsl:variable name="perg71">
  <!--0: No e 1: Sim ou No Houve-->  
  <!--001-->
  <xsl:if test="( (UC013Row[CD_PERGUNTA='UC013_t1p01']/RESPOSTA='N') and (UC013Row[CD_PERGUNTA='UC013_t1p02']/RESPOSTA='N') and ((UC013Row[CD_PERGUNTA='UC013_t1p03']/RESPOSTA='S') or (UC013Row[CD_PERGUNTA='UC013_t1p03']/RESPOSTA='H')) )">
   <xsl:value-of select="'As operaes de crdito e as inscries em Restos a Pagar'"></xsl:value-of>
  </xsl:if>
  <!--010-->
  <xsl:if test="( (UC013Row[CD_PERGUNTA='UC013_t1p01']/RESPOSTA='N') and ((UC013Row[CD_PERGUNTA='UC013_t1p02']/RESPOSTA='S') or (UC013Row[CD_PERGUNTA='UC013_t1p02']/RESPOSTA='H')) and (UC013Row[CD_PERGUNTA='UC013_t1p03']/RESPOSTA='N') )">
   <xsl:value-of select="'As operaes de crdito e as demais formas de financiamento ou assuno de compromissos junto a terceiros'"></xsl:value-of>
  </xsl:if>
  <!--011-->
  <xsl:if test="( (UC013Row[CD_PERGUNTA='UC013_t1p01']/RESPOSTA='N') and ((UC013Row[CD_PERGUNTA='UC013_t1p02']/RESPOSTA='S') or (UC013Row[CD_PERGUNTA='UC013_t1p02']/RESPOSTA='H')) and ((UC013Row[CD_PERGUNTA='UC013_t1p03']/RESPOSTA='S') or (UC013Row[CD_PERGUNTA='UC013_t1p03']/RESPOSTA='H')) )">
   <xsl:value-of select="'As operaes de crdito'"></xsl:value-of>
  </xsl:if>
  <!--100-->
  <xsl:if test="( ((UC013Row[CD_PERGUNTA='UC013_t1p01']/RESPOSTA='S') or (UC013Row[CD_PERGUNTA='UC013_t1p01']/RESPOSTA='H')) and (UC013Row[CD_PERGUNTA='UC013_t1p02']/RESPOSTA='N') and (UC013Row[CD_PERGUNTA='UC013_t1p03']/RESPOSTA='N') )">
   <xsl:value-of select="'As inscries em Restos a Pagar e as demais formas de financiamento ou assuno de compromissos junto a terceiros'"></xsl:value-of>
  </xsl:if>
  <!--101-->
  <xsl:if test="( ((UC013Row[CD_PERGUNTA='UC013_t1p01']/RESPOSTA='S') or (UC013Row[CD_PERGUNTA='UC013_t1p01']/RESPOSTA='H')) and (UC013Row[CD_PERGUNTA='UC013_t1p02']/RESPOSTA='N') and ((UC013Row[CD_PERGUNTA='UC013_t1p03']/RESPOSTA='S') or (UC013Row[CD_PERGUNTA='UC013_t1p03']/RESPOSTA='H')) )">
   <xsl:value-of select="'As inscries em Restos a Pagar'"></xsl:value-of>
  </xsl:if>
  <!--110-->
  <xsl:if test="( ((UC013Row[CD_PERGUNTA='UC013_t1p01']/RESPOSTA='S') or (UC013Row[CD_PERGUNTA='UC013_t1p01']/RESPOSTA='H')) and ((UC013Row[CD_PERGUNTA='UC013_t1p02']/RESPOSTA='S') or (UC013Row[CD_PERGUNTA='UC013_t1p02']/RESPOSTA='H')) and (UC013Row[CD_PERGUNTA='UC013_t1p03']/RESPOSTA='N') )">
   <xsl:value-of select="'As demais formas de financiamento ou assuno de compromissos junto a terceiros'"></xsl:value-of>
  </xsl:if>
 </xsl:variable>


 <!-- INICIO 9 - Operaes de Crdito -->
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 
 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" />
  <fo:table-body>
   <fo:table-row>
    <fo:table-cell>
     <fo:block xsl:use-attribute-sets="titFCinza">
      <xsl:text>9 - Operaes de Crdito</xsl:text>
     </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-body>
 </fo:table>
 
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 
 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="556pt"/>

  <fo:table-body >	   
    <fo:table-row>								
     <fo:table-cell>
	  <fo:block xsl:use-attribute-sets="txtJustifyMed" text-align="justify" margin-left="15pt" hyphenate="true" >
       <!-- Primeira Resposta do Relatrio-->        

       <xsl:if test="((UC013Row[CD_PERGUNTA='UC013_t1p01']/RESPOSTA='S') or (UC013Row[CD_PERGUNTA='UC013_t1p02']/RESPOSTA='S') or (UC013Row[CD_PERGUNTA='UC013_t1p03']/RESPOSTA='S'))">
		 <xsl:value-of select="$perg1"/> foram escrituradas de modo a evidenciar o montante e a variao da dvida pblica no <xsl:value-of select="../../Header/Informacoes/InformacoesRow/DS_PERIODO"/> de <xsl:value-of select="../../Header/Informacoes/InformacoesRow/ANO_EXERCICIO"/>, detalhando, pelo menos, a natureza e o tipo do credor.
       </xsl:if>

       <xsl:if test="((UC013Row[CD_PERGUNTA='UC013_t1p01']/RESPOSTA='N') or (UC013Row[CD_PERGUNTA='UC013_t1p02']/RESPOSTA='N') or (UC013Row[CD_PERGUNTA='UC013_t1p03']/RESPOSTA='N'))">
         <fo:block><fo:leader leader-pattern="space"/></fo:block>		 
		 <xsl:if test="((UC013Row[CD_PERGUNTA='UC013_t1p01']/RESPOSTA='N') and (UC013Row[CD_PERGUNTA='UC013_t1p02']/RESPOSTA='N') and (UC013Row[CD_PERGUNTA='UC013_t1p03']/RESPOSTA='N'))"> 
		  As operaes de crdito, as inscries de Restos a Pagar e as demais formas de financiamento ou assuno de compromissos junto a terceiros no foram escrituradas de modo a evidenciar o montante e a variao da dvida pblica no <xsl:value-of select="../../Header/Informacoes/InformacoesRow/DS_PERIODO"/> de <xsl:value-of select="../../Header/Informacoes/InformacoesRow/ANO_EXERCICIO"/>, detalhando, pelo menos, a natureza e o tipo do credor.
         </xsl:if>
		 <xsl:if test="((UC013Row[CD_PERGUNTA='UC013_t1p01']/RESPOSTA='S') or (UC013Row[CD_PERGUNTA='UC013_t1p02']/RESPOSTA='S') or (UC013Row[CD_PERGUNTA='UC013_t1p03']/RESPOSTA='S'))"> 
		  Contudo, <xsl:value-of select="$perg7"/> no foram escrituradas de modo a evidenciar o montante e a variao da dvida pblica no <xsl:value-of select="../../Header/Informacoes/InformacoesRow/DS_PERIODO"/> de <xsl:value-of select="../../Header/Informacoes/InformacoesRow/ANO_EXERCICIO"/>, detalhando, pelo menos, a natureza e o tipo do credor.
         </xsl:if>

		 <xsl:if test="((UC013Row[CD_PERGUNTA='UC013_t1p01']/RESPOSTA!='S') and (UC013Row[CD_PERGUNTA='UC013_t1p02']/RESPOSTA!='S') and (UC013Row[CD_PERGUNTA='UC013_t1p03']/RESPOSTA!='S'))"> 
		  <xsl:if test="((UC013Row[CD_PERGUNTA='UC013_t1p01']/RESPOSTA='H') or (UC013Row[CD_PERGUNTA='UC013_t1p02']/RESPOSTA='H') or (UC013Row[CD_PERGUNTA='UC013_t1p03']/RESPOSTA='H'))"> 
		   <xsl:value-of select="$perg71"/> no foram escrituradas de modo a evidenciar o montante e a variao da dvida pblica no <xsl:value-of select="../../Header/Informacoes/InformacoesRow/DS_PERIODO"/> de <xsl:value-of select="../../Header/Informacoes/InformacoesRow/ANO_EXERCICIO"/>, detalhando, pelo menos, a natureza e o tipo do credor.
          </xsl:if>
         </xsl:if>
       </xsl:if>
       <xsl:if test="((UC013Row[CD_PERGUNTA='UC013_t1p01']/RESPOSTA='H') and (UC013Row[CD_PERGUNTA='UC013_t1p02']/RESPOSTA='H') and (UC013Row[CD_PERGUNTA='UC013_t1p03']/RESPOSTA='H'))">
         <fo:block><fo:leader leader-pattern="space"/></fo:block>		 
          No foram contradas operaes de crdito, no houve incries em Restos a Pagar, tampouco financiamento ou assuno de compromissos junto a terceiros no exerccio.
       </xsl:if>

       
	   <fo:block><fo:leader leader-pattern="space"/></fo:block>
	   <xsl:value-of select="$perg2"/> realizao de operao de crdito por antecipao de receita (ARO) no exerccio.
        
       <xsl:if test="UC013Row[CD_PERGUNTA='UC013_t1p04']/RESPOSTA='S'">
         <fo:block><fo:leader leader-pattern="space"/></fo:block>
	     a) A ARO <xsl:value-of select="$perg3"/> realizada somente a partir do dcimo dia do incio do exerccio.
         <fo:block><fo:leader leader-pattern="space"/></fo:block>
	   	 b) A ARO <xsl:value-of select="$perg4"/> liquidada, com juros e outros encargos incidentes, at o dia dez de dezembro do exerccio.
       </xsl:if>

      </fo:block>
     </fo:table-cell>
    </fo:table-row>   	
  </fo:table-body>
 </fo:table> 
  
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 
 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="556pt"/>

  <fo:table-body >	   
    <fo:table-row>								
     <fo:table-cell>
	  <fo:block xsl:use-attribute-sets="txtJustifyMed" text-align="justify" margin-left="15pt" hyphenate="true" >
       <xsl:if test="../../Observacoes/ObservacoesRemessas/ObservacoesRemessasRow[CD_OBSERVACOES='UC013']/OBSERVACOES!=''">
        <fo:inline font-weight="bold">Observaes: </fo:inline><xsl:value-of select="../../Observacoes/ObservacoesRemessas/ObservacoesRemessasRow[CD_OBSERVACOES='UC013']/OBSERVACOES"></xsl:value-of>
       </xsl:if>
       <xsl:if test="../../Observacoes/ObservacoesRemessas/ObservacoesRemessasRow[CD_OBSERVACOES='UC013']/OBSERVACOES=''">
        <fo:inline font-style="italic">No foram inseridas observaes para este item.</fo:inline>
       </xsl:if>
      </fo:block>
     </fo:table-cell>
    </fo:table-row>   	
  </fo:table-body>
 </fo:table> 
 <!-- FIM    UC013  --> 
</xsl:template>

<!--
###############################################
###    10 - Dvida Consolidada Lquida      ###
###############################################
-->
<xsl:template match="UC014">

 <xsl:variable name="perg1">
  <xsl:if test="UC014Row[CD_PERGUNTA='UC014_t1p01']/RESPOSTA='S'">
   <xsl:value-of select="' de acordo '"></xsl:value-of>
  </xsl:if>
  <xsl:if test="UC014Row[CD_PERGUNTA='UC014_t1p01']/RESPOSTA='N'">
   <xsl:value-of select="' em desacordo '"></xsl:value-of>
  </xsl:if>
 </xsl:variable>
 <xsl:variable name="perg2">
  <xsl:if test="UC014Row[CD_PERGUNTA='UC014_t1p02']/RESPOSTA='S'">
   <xsl:value-of select="'Foram '"></xsl:value-of>
  </xsl:if>
  <xsl:if test="UC014Row[CD_PERGUNTA='UC014_t1p02']/RESPOSTA='N'">
   <xsl:value-of select="'No foram '"></xsl:value-of>
  </xsl:if>
 </xsl:variable>

 <!-- INICIO 10 - Dvida Consolidada Lquida -->
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 
 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" />
  <fo:table-body>
   <fo:table-row>
    <fo:table-cell>
     <fo:block xsl:use-attribute-sets="titFCinza">
      <xsl:text>10 - Dvida Consolidada Lquida</xsl:text>
     </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-body>
 </fo:table>
 
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 
 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="556pt"/>

  <fo:table-body >	   
    <fo:table-row>								
     <fo:table-cell>
	  <fo:block xsl:use-attribute-sets="txtJustifyMed" text-align="justify" margin-left="15pt" hyphenate="true" >
       <!-- Primeira Resposta do Relatrio-->        
		<xsl:if test="UC014Row[CD_PERGUNTA='UC014_t1p02']/RESPOSTA='N'">		
		  <xsl:value-of select="$perg2"/> identificados valores registrados no grupo de contas que compe a Dvida Consolidada ou Fundada.
        </xsl:if>
		<fo:block><fo:leader leader-pattern="space"/></fo:block> 
		<xsl:if test="UC014Row[CD_PERGUNTA='UC014_t1p02']/RESPOSTA='S'">
		  A Dvida Consolidada Lquida foi apurada no <xsl:value-of select="../../Header/Informacoes/InformacoesRow/DS_PERIODO"/> de <xsl:value-of select="../../Header/Informacoes/InformacoesRow/ANO_EXERCICIO"/><xsl:value-of select="$perg1"/> com o estabelecido na Resoluo do Senado Federal n 40/2001, inciso II do art. 3 e nas Resolues e Instrues Normativas do TCE-RS.
        </xsl:if>
      </fo:block>
     </fo:table-cell>
    </fo:table-row>   	
  </fo:table-body>
 </fo:table> 
  
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 
 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="556pt"/>

  <fo:table-body >	   
    <fo:table-row>								
     <fo:table-cell>
	  <fo:block xsl:use-attribute-sets="txtJustifyMed" text-align="justify" margin-left="15pt" hyphenate="true" >
       <xsl:if test="../../Observacoes/ObservacoesRemessas/ObservacoesRemessasRow[CD_OBSERVACOES='UC014']/OBSERVACOES!=''">
        <fo:inline font-weight="bold">Observaes: </fo:inline><xsl:value-of select="../../Observacoes/ObservacoesRemessas/ObservacoesRemessasRow[CD_OBSERVACOES='UC014']/OBSERVACOES"></xsl:value-of>
       </xsl:if>
       <xsl:if test="../../Observacoes/ObservacoesRemessas/ObservacoesRemessasRow[CD_OBSERVACOES='UC014']/OBSERVACOES=''">
        <fo:inline font-style="italic">No foram inseridas observaes para este item.</fo:inline>
       </xsl:if>
      </fo:block>
     </fo:table-cell>
    </fo:table-row>   	
  </fo:table-body>
 </fo:table> 
 <!-- FIM    UC014  --> 
</xsl:template>

<!--
###############################################
# 11 - Aplicao da Rec. de Alienao de Bens #
###############################################
-->
<xsl:template match="UC015">

 <xsl:variable name="perg1">
  <xsl:if test="UC015Row[CD_PERGUNTA='UC015_t1p01']/RESPOSTA='S'">
   <xsl:value-of select="' aplicou '"></xsl:value-of>
  </xsl:if>
  <xsl:if test="UC015Row[CD_PERGUNTA='UC015_t1p01']/RESPOSTA='N'">
   <xsl:value-of select="' no aplicou '"></xsl:value-of>
  </xsl:if>
 </xsl:variable>
 <xsl:variable name="perg2">
  <xsl:if test="UC015Row[CD_PERGUNTA='UC015_t1p02']/RESPOSTA='C'">
   <xsl:value-of select="' corrente'"></xsl:value-of>
  </xsl:if>
  <xsl:if test="UC015Row[CD_PERGUNTA='UC015_t1p02']/RESPOSTA='K'">
   <xsl:value-of select="' de capital'"></xsl:value-of>
  </xsl:if>
  <xsl:if test="UC015Row[CD_PERGUNTA='UC015_t1p02']/RESPOSTA='A'">
   <xsl:value-of select="' corrente e de capital'"></xsl:value-of>
  </xsl:if>
 </xsl:variable>
 <xsl:variable name="perg3">
  <xsl:if test="UC015Row[CD_PERGUNTA='UC015_t1p03']/RESPOSTA='S'">
   <xsl:value-of select="' aplicou'"></xsl:value-of>
  </xsl:if>
  <xsl:if test="UC015Row[CD_PERGUNTA='UC015_t1p03']/RESPOSTA='N'">
   <xsl:value-of select="' no aplicou'"></xsl:value-of>
  </xsl:if>
 </xsl:variable>
 <xsl:variable name="perg4">
  <xsl:if test="UC015Row[CD_PERGUNTA='UC015_t1p04']/RESPOSTA='S'">
   <xsl:value-of select="' com '"></xsl:value-of>
  </xsl:if>
  <xsl:if test="UC015Row[CD_PERGUNTA='UC015_t1p04']/RESPOSTA='N'">
   <xsl:value-of select="' sem '"></xsl:value-of>
  </xsl:if>
 </xsl:variable>
 <xsl:variable name="perg8">
  <xsl:if test="UC015Row[CD_PERGUNTA='UC015_t1p08']/RESPOSTA='S'">
   <xsl:value-of select="' foi '"></xsl:value-of>
  </xsl:if>
  <xsl:if test="UC015Row[CD_PERGUNTA='UC015_t1p08']/RESPOSTA='N'">
   <xsl:value-of select="' no foi '"></xsl:value-of>
  </xsl:if>
 </xsl:variable>


 <!-- INICIO 11 - Aplicao da receita de Alienao de Bens -->
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 
 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" />
  <fo:table-body>
   <fo:table-row>
    <fo:table-cell>
     <fo:block xsl:use-attribute-sets="titFCinza">
      <xsl:text>11 - Aplicao da Receita de Alienao de Bens</xsl:text>
     </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-body>
 </fo:table>
 
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 
 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="556pt"/>

  <fo:table-body >	   
    <fo:table-row>								
     <fo:table-cell>
	  <fo:block xsl:use-attribute-sets="txtJustifyMed" text-align="justify" margin-left="15pt" hyphenate="true">
       <!-- Primeira Resposta do Relatrio-->        
		<xsl:if test="UC015Row[CD_PERGUNTA='UC015_t1p07']/RESPOSTA='N'">
		  No <xsl:value-of select="../../Header/Informacoes/InformacoesRow/DS_PERIODO"/> de <xsl:value-of select="../../Header/Informacoes/InformacoesRow/ANO_EXERCICIO"/>  no houve registro de receita de capital derivada da alienao de bens e direitos que integram o patrimnio pblico.
		</xsl:if>
		<xsl:if test="UC015Row[CD_PERGUNTA='UC015_t1p07']/RESPOSTA='S'">
		  <xsl:if test="UC015Row[CD_PERGUNTA='UC015_t1p01']/RESPOSTA='N'">
		    O Poder Executivo <xsl:value-of select="$perg1"/>, no <xsl:value-of select="../../Header/Informacoes/InformacoesRow/DS_PERIODO"/> de <xsl:value-of select="../../Header/Informacoes/InformacoesRow/ANO_EXERCICIO"/>, a receita de capital derivada da alienao de bens e direitos que integram o patrimnio pblico para o financiamento de despesa.  
		  </xsl:if>
		  <xsl:if test="UC015Row[CD_PERGUNTA='UC015_t1p01']/RESPOSTA='S'">
		    O Poder Executivo <xsl:value-of select="$perg1"/>, no <xsl:value-of select="../../Header/Informacoes/InformacoesRow/DS_PERIODO"/> de <xsl:value-of select="../../Header/Informacoes/InformacoesRow/ANO_EXERCICIO"/>, a receita de capital derivada da alienao de bens e direitos que integram o patrimnio pblico para o financiamento de despesa <xsl:value-of select="$perg2"/>.  		  
		  </xsl:if>
          <fo:block><fo:leader leader-pattern="space"/></fo:block>         

		  <xsl:if test="UC015Row[CD_PERGUNTA='UC015_t1p08']/RESPOSTA='S'">
		    A receita de capital<xsl:value-of select="$perg8"/> vinculada a fonte de recurso especfico, cdigo(s) <xsl:value-of select="UC015Row[CD_PERGUNTA='UC015_t1p09']/RESPOSTA_EXT"/>.
		  </xsl:if>
		  <xsl:if test="UC015Row[CD_PERGUNTA='UC015_t1p08']/RESPOSTA='N'">
		    A receita de capital<xsl:value-of select="$perg8"/> vinculada a fonte de recurso especfico.
		  </xsl:if>
          <fo:block><fo:leader leader-pattern="space"/></fo:block>         				
		  
     	  <xsl:if test="UC015Row[CD_PERGUNTA='UC015_t1p04']/RESPOSTA='S'">
            O Poder Executivo <xsl:value-of select="$perg3"/>, no <xsl:value-of select="../../Header/Informacoes/InformacoesRow/DS_PERIODO"/> de <xsl:value-of select="../../Header/Informacoes/InformacoesRow/ANO_EXERCICIO"/>, a receita de capital derivada da alienao de bens e direitos que integram o patrimnio pblico em pagamento aos regimes de previdncia social, geral e prprio dos servidores pblicos, <xsl:value-of select="$perg4"/> autorizao de Lei Municipal n <xsl:value-of select="UC015Row[CD_PERGUNTA='UC015_t1p05']/RESPOSTA_EXT"/>, de <xsl:value-of select="UC015Row[CD_PERGUNTA='UC015_t1p06']/RESPOSTA_EXT"/>.
          </xsl:if>         
          <xsl:if test="UC015Row[CD_PERGUNTA='UC015_t1p04']/RESPOSTA='N'">
            O Poder Executivo <xsl:value-of select="$perg3"/>, no <xsl:value-of select="../../Header/Informacoes/InformacoesRow/DS_PERIODO"/> de <xsl:value-of select="../../Header/Informacoes/InformacoesRow/ANO_EXERCICIO"/>, a receita de capital derivada da alienao de bens e direitos que integram o patrimnio pblico em pagamento aos regimes de previdncia social, geral e prprio dos servidores pblicos, <xsl:value-of select="$perg4"/> autorizao de Lei Municipal.
          </xsl:if>  
		         
		</xsl:if>
      </fo:block>
     </fo:table-cell>
    </fo:table-row>   	
  </fo:table-body>
 </fo:table> 
  
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 
 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="556pt"/>

  <fo:table-body >	   
    <fo:table-row>								
     <fo:table-cell>
	  <fo:block xsl:use-attribute-sets="txtJustifyMed" text-align="justify" margin-left="15pt" hyphenate="true" >
       <xsl:if test="../../Observacoes/ObservacoesRemessas/ObservacoesRemessasRow[CD_OBSERVACOES='UC015']/OBSERVACOES!=''">
        <fo:inline font-weight="bold">Observaes: </fo:inline><xsl:value-of select="../../Observacoes/ObservacoesRemessas/ObservacoesRemessasRow[CD_OBSERVACOES='UC015']/OBSERVACOES"></xsl:value-of>
       </xsl:if>
       <xsl:if test="../../Observacoes/ObservacoesRemessas/ObservacoesRemessasRow[CD_OBSERVACOES='UC015']/OBSERVACOES=''">
        <fo:inline font-style="italic">No foram inseridas observaes para este item.</fo:inline>
       </xsl:if>
      </fo:block>
     </fo:table-cell>
    </fo:table-row>   	
  </fo:table-body>
 </fo:table> 
 <!-- FIM    UC015  --> 
</xsl:template>

<!--
###############################################
####      12 - Consolidao das Contas    #####
###############################################
-->
<xsl:template match="UC016">

 <xsl:variable name="perg1">
  <xsl:if test="UC016Row[CD_PERGUNTA='UC016_t1p01']/RESPOSTA='S'">
   <xsl:value-of select="' encaminhou '"></xsl:value-of>
  </xsl:if>
  <xsl:if test="UC016Row[CD_PERGUNTA='UC016_t1p01']/RESPOSTA='N'">
   <xsl:value-of select="' no encaminhou '"></xsl:value-of>
  </xsl:if>
 </xsl:variable>
 <xsl:variable name="perg2">
  <xsl:if test="UC016Row[CD_PERGUNTA='UC016_t1p02']/RESPOSTA='S'">
   <xsl:value-of select="' no '"></xsl:value-of>
  </xsl:if>
  <xsl:if test="UC016Row[CD_PERGUNTA='UC016_t1p02']/RESPOSTA='N'">
   <xsl:value-of select="' fora do '"></xsl:value-of>
  </xsl:if>
 </xsl:variable>
 <xsl:variable name="perg3">
  <xsl:if test="UC016Row[CD_PERGUNTA='UC016_t1p03']/RESPOSTA='S'">
   <xsl:value-of select="' enviando '"></xsl:value-of>
  </xsl:if>
  <xsl:if test="UC016Row[CD_PERGUNTA='UC016_t1p03']/RESPOSTA='N'">
   <xsl:value-of select="' no enviando '"></xsl:value-of>
  </xsl:if>
 </xsl:variable>
 <xsl:variable name="perg4">
  <xsl:if test="UC016Row[CD_PERGUNTA='UC016_t1p03']/RESPOSTA='N'">
   <xsl:value-of select="' dentro do mesmo prazo'"></xsl:value-of>
  </xsl:if>
  <xsl:if test="((UC016Row[CD_PERGUNTA='UC016_t1p02']/RESPOSTA='S') and (UC016Row[CD_PERGUNTA='UC016_t1p03']/RESPOSTA='S') and (UC016Row[CD_PERGUNTA='UC016_t1p04']/RESPOSTA='S'))">
   <xsl:value-of select="' dentro do mesmo prazo'"></xsl:value-of>
  </xsl:if>
  <xsl:if test="((UC016Row[CD_PERGUNTA='UC016_t1p02']/RESPOSTA='N') and (UC016Row[CD_PERGUNTA='UC016_t1p03']/RESPOSTA='S') and (UC016Row[CD_PERGUNTA='UC016_t1p04']/RESPOSTA='S'))">
   <xsl:value-of select="' dentro do prazo'"></xsl:value-of>
  </xsl:if>
  <xsl:if test="((UC016Row[CD_PERGUNTA='UC016_t1p02']/RESPOSTA='N') and (UC016Row[CD_PERGUNTA='UC016_t1p03']/RESPOSTA='S') and (UC016Row[CD_PERGUNTA='UC016_t1p04']/RESPOSTA='N'))">
   <xsl:value-of select="' fora do prazo tambm'"></xsl:value-of>
  </xsl:if>
  <xsl:if test="((UC016Row[CD_PERGUNTA='UC016_t1p02']/RESPOSTA='S') and (UC016Row[CD_PERGUNTA='UC016_t1p03']/RESPOSTA='S') and (UC016Row[CD_PERGUNTA='UC016_t1p04']/RESPOSTA='N'))">
   <xsl:value-of select="' fora do prazo'"></xsl:value-of>
  </xsl:if>
 </xsl:variable>

 <!-- INICIO 11 - Aplicao da receita de Alienao de Bens -->
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 
 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" />
  <fo:table-body>
   <fo:table-row>
    <fo:table-cell>
     <fo:block xsl:use-attribute-sets="titFCinza">
      <xsl:text>12 - Consolidao das Contas</xsl:text>
     </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-body>
 </fo:table>
 
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 
 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="556pt"/>

  <fo:table-body >	   
    <fo:table-row>								
     <fo:table-cell>
	  <fo:block xsl:use-attribute-sets="txtJustifyMed" text-align="justify" margin-left="15pt" hyphenate="true" >
       <!-- Primeira Resposta do Relatrio-->        
	   <xsl:if test="UC016Row[CD_PERGUNTA='UC016_t1p01']/RESPOSTA='S'">
          O Poder Executivo <xsl:value-of select="$perg1"/>suas contas ao Poder Executivo da Unio em <xsl:value-of select="UC016Row[CD_PERGUNTA='UC016_t1p05']/RESPOSTA_EXT"/> <xsl:value-of select="$perg2"/>prazo definido no inciso I do  1 do art. 51 da LRF, <xsl:value-of select="$perg3"/>cpia ao Poder Executivo Estadual <xsl:value-of select="$perg4"/>.
       </xsl:if>         
	   <xsl:if test="UC016Row[CD_PERGUNTA='UC016_t1p01']/RESPOSTA='N'">
          O Poder Executivo <xsl:value-of select="$perg1"/>suas contas ao Poder Executivo da Unio.
       </xsl:if>         
      </fo:block>
     </fo:table-cell>
    </fo:table-row>   	
  </fo:table-body>
 </fo:table> 
  
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 
 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="556pt"/>

  <fo:table-body >	   
    <fo:table-row>								
     <fo:table-cell>
	  <fo:block xsl:use-attribute-sets="txtJustifyMed" text-align="justify" margin-left="15pt" hyphenate="true" >
       <xsl:if test="../../Observacoes/ObservacoesRemessas/ObservacoesRemessasRow[CD_OBSERVACOES='UC016']/OBSERVACOES!=''">
        <fo:inline font-weight="bold">Observaes: </fo:inline><xsl:value-of select="../../Observacoes/ObservacoesRemessas/ObservacoesRemessasRow[CD_OBSERVACOES='UC016']/OBSERVACOES"></xsl:value-of>
       </xsl:if>
       <xsl:if test="../../Observacoes/ObservacoesRemessas/ObservacoesRemessasRow[CD_OBSERVACOES='UC016']/OBSERVACOES=''">
        <fo:inline font-style="italic">No foram inseridas observaes para este item.</fo:inline>
       </xsl:if>
      </fo:block>
     </fo:table-cell>
    </fo:table-row>   	
  </fo:table-body>
 </fo:table> 
 <!-- FIM    UC016  --> 
</xsl:template>

<!--
###############################################
# 13 - Correta Util. dos Recursos Vinculados ##
###############################################
-->
<xsl:template match="UC017">

 <xsl:variable name="perg1">
  <xsl:if test="UC017Row[CD_PERGUNTA='UC017_t1p01']/RESPOSTA='S'">
   <xsl:value-of select="' constam '"></xsl:value-of>
  </xsl:if>
  <xsl:if test="UC017Row[CD_PERGUNTA='UC017_t1p01']/RESPOSTA='N'">
   <xsl:value-of select="' no constam '"></xsl:value-of>
  </xsl:if>
 </xsl:variable>
 <xsl:variable name="perg2">
  <xsl:if test="UC017Row[CD_PERGUNTA='UC017_t1p02']/RESPOSTA='S'">
   <xsl:value-of select="' esto '"></xsl:value-of>
  </xsl:if>
  <xsl:if test="UC017Row[CD_PERGUNTA='UC017_t1p02']/RESPOSTA='N'">
   <xsl:value-of select="' no esto '"></xsl:value-of>
  </xsl:if>
 </xsl:variable>
 <xsl:variable name="perg3">
  <xsl:if test="UC017Row[CD_PERGUNTA='UC017_t1p03']/RESPOSTA='S'">
   <xsl:value-of select="' contudo, esto '"></xsl:value-of>
  </xsl:if>
  <xsl:if test="UC017Row[CD_PERGUNTA='UC017_t1p03']/RESPOSTA='N'">
   <xsl:value-of select="' contudo, no esto '"></xsl:value-of>
  </xsl:if>
 </xsl:variable>
 <xsl:variable name="perg31">
  <xsl:if test="(((UC017Row[CD_PERGUNTA='UC017_t1p03']/RESPOSTA='S') and (UC017Row[CD_PERGUNTA='UC017_t1p04']/RESPOSTA='S')) or ((UC017Row[CD_PERGUNTA='UC017_t1p03']/RESPOSTA='N') and (UC017Row[CD_PERGUNTA='UC017_t1p04']/RESPOSTA='N')))">
   <xsl:value-of select="' e,'"></xsl:value-of>
  </xsl:if>
  <xsl:if test="(((UC017Row[CD_PERGUNTA='UC017_t1p03']/RESPOSTA='S') and (UC017Row[CD_PERGUNTA='UC017_t1p04']/RESPOSTA='N')) or ((UC017Row[CD_PERGUNTA='UC017_t1p03']/RESPOSTA='N') and (UC017Row[CD_PERGUNTA='UC017_t1p04']/RESPOSTA='S')))">
   <xsl:value-of select="','"></xsl:value-of>
  </xsl:if>
 </xsl:variable>
 <xsl:variable name="perg4">
  <xsl:if test="UC017Row[CD_PERGUNTA='UC017_t1p04']/RESPOSTA='S'">
   <xsl:value-of select="' foram '"></xsl:value-of>
  </xsl:if>
  <xsl:if test="UC017Row[CD_PERGUNTA='UC017_t1p04']/RESPOSTA='N'">
   <xsl:value-of select="' no foram '"></xsl:value-of>
  </xsl:if>
 </xsl:variable>
 <xsl:variable name="perg5">
  <xsl:if test="UC017Row[CD_PERGUNTA='UC017_t1p05']/RESPOSTA='S'">
   <xsl:value-of select="' esto '"></xsl:value-of>
  </xsl:if>
  <xsl:if test="UC017Row[CD_PERGUNTA='UC017_t1p05']/RESPOSTA='N'">
   <xsl:value-of select="' no esto '"></xsl:value-of>
  </xsl:if>
 </xsl:variable>
 <xsl:variable name="perg15">
  <xsl:if test="(((UC017Row[CD_PERGUNTA='UC017_t1p01']/RESPOSTA='S') and (UC017Row[CD_PERGUNTA='UC017_t1p05']/RESPOSTA='S'))or((UC017Row[CD_PERGUNTA='UC017_t1p01']/RESPOSTA='N') and (UC017Row[CD_PERGUNTA='UC017_t1p05']/RESPOSTA='N')))">
   <xsl:value-of select="' e '"></xsl:value-of>
  </xsl:if>
  <xsl:if test="(((UC017Row[CD_PERGUNTA='UC017_t1p01']/RESPOSTA='S') and (UC017Row[CD_PERGUNTA='UC017_t1p05']/RESPOSTA='N'))or((UC017Row[CD_PERGUNTA='UC017_t1p01']/RESPOSTA='N') and (UC017Row[CD_PERGUNTA='UC017_t1p05']/RESPOSTA='S')))">
   <xsl:value-of select="', todavia '"></xsl:value-of>
  </xsl:if>
 </xsl:variable>


 <!-- INICIO 13 - Utilizao dos Recursos Vinculados -->
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 
 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" />
  <fo:table-body>
   <fo:table-row>
    <fo:table-cell>
     <fo:block xsl:use-attribute-sets="titFCinza">
      <xsl:text>13 - Utilizao das Fontes de Recursos</xsl:text>
     </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-body>
 </fo:table>
 
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 
 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="556pt"/>

  <fo:table-body >	   
    <fo:table-row>								
     <fo:table-cell>
	  <fo:block xsl:use-attribute-sets="txtJustifyMed" text-align="justify" margin-left="15pt" hyphenate="true" >
       <!-- Primeira Resposta do Relatrio-->        
	    As disponibilidades <xsl:value-of select="$perg1"/> de registro prprio<xsl:value-of select="$perg15"/> os recursos vinculados a rgo, fundo ou despesa obrigatria<xsl:value-of select="$perg5"/>identificados e escriturados de forma individualizada.   
        <fo:block><fo:leader leader-pattern="space"/></fo:block>
	   <!-- Verifica se possui RPPS -->
	   <xsl:if test="../../Header/Informacoes/InformacoesRow/POSSUIRPPS='S'">
	     <xsl:if test="(((UC017Row[CD_PERGUNTA='UC017_t1p02']/RESPOSTA='S') and (UC017Row[CD_PERGUNTA='UC017_t1p03']/RESPOSTA='S')) or ((UC017Row[CD_PERGUNTA='UC017_t1p02']/RESPOSTA='N') and (UC017Row[CD_PERGUNTA='UC017_t1p03']/RESPOSTA='N')))">          
		  As disponibilidades do RPPS<xsl:value-of select="$perg2"/> depositadas em conta separada das demais disponibilidades de cada ente e aplicadas nas condies de mercado, com observncia dos limites e condies de proteo e prudncia financeira.
         </xsl:if>
	     <xsl:if test="(((UC017Row[CD_PERGUNTA='UC017_t1p02']/RESPOSTA='S') and (UC017Row[CD_PERGUNTA='UC017_t1p03']/RESPOSTA='N')) or ((UC017Row[CD_PERGUNTA='UC017_t1p02']/RESPOSTA='N') and (UC017Row[CD_PERGUNTA='UC017_t1p03']/RESPOSTA='S')))">          
		  As disponibilidades do RPPS<xsl:value-of select="$perg2"/> depositadas em conta separada das demais disponibilidades de cada ente<xsl:value-of select="$perg31"/> <xsl:value-of select="$perg3"/> aplicadas nas condies de mercado, com observncia dos limites e condies de proteo e prudncia financeira.
         </xsl:if>
         <fo:block><fo:leader leader-pattern="space"/></fo:block>		 
       </xsl:if>         
	   	 Os recursos legalmente vinculados  finalidade especfica <xsl:value-of select="$perg4"/> utilizados exclusivamente para atender ao objeto de sua vinculao.
      </fo:block>
     </fo:table-cell>
    </fo:table-row>   	
  </fo:table-body>
 </fo:table> 
  
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 
 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="556pt"/>

  <fo:table-body >	   
    <fo:table-row>								
     <fo:table-cell>
	  <fo:block xsl:use-attribute-sets="txtJustifyMed" text-align="justify" margin-left="15pt" hyphenate="true" >
       <xsl:if test="../../Observacoes/ObservacoesRemessas/ObservacoesRemessasRow[CD_OBSERVACOES='UC017']/OBSERVACOES!=''">
        <fo:inline font-weight="bold">Observaes: </fo:inline><xsl:value-of select="../../Observacoes/ObservacoesRemessas/ObservacoesRemessasRow[CD_OBSERVACOES='UC017']/OBSERVACOES"></xsl:value-of>
       </xsl:if>
       <xsl:if test="../../Observacoes/ObservacoesRemessas/ObservacoesRemessasRow[CD_OBSERVACOES='UC017']/OBSERVACOES=''">
        <fo:inline font-style="italic">No foram inseridas observaes para este item.</fo:inline>
       </xsl:if>
      </fo:block>
     </fo:table-cell>
    </fo:table-row>   	
  </fo:table-body>
 </fo:table> 
 <!-- FIM    UC017  --> 
</xsl:template>

<!--
###############################################
## 14 - Ident. Beneficiarios Sent. Judiciais ##
###############################################
-->
<xsl:template match="UC018">

 <!--Varivel de exibio do Modelo - 14 -->
 <xsl:variable name="texto_uc018">
  <xsl:if test="UC018Row[CD_PERGUNTA='UC018_t1p01']/RESPOSTA='N'">
    <xsl:if test="../../Header/Informacoes/InformacoesRow/PODER='C'">
      <xsl:value-of select="'No existem beneficirios de pagamento de Sentenas Judiciais no Poder Legislativo.'"></xsl:value-of>     
    </xsl:if>
    <xsl:if test="../../Header/Informacoes/InformacoesRow/PODER='P'">
      <xsl:value-of select="'No existem beneficirios de pagamento de Sentenas Judiciais no Poder Executivo.'"></xsl:value-of>         
	</xsl:if>   
  </xsl:if>
  <xsl:if test="(UC018Row[CD_PERGUNTA='UC018_t1p01']/RESPOSTA='S') and (UC018Row[CD_PERGUNTA='UC018_t1p02']/RESPOSTA='N')">
   <xsl:value-of select="'A contabilidade no identifica os beneficirios de pagamento de sentenas judiciais, no possibilitando a observncia da ordem cronolgica determinada no art. 100 da Constituio.'"></xsl:value-of>
  </xsl:if>
  <xsl:if test="(UC018Row[CD_PERGUNTA='UC018_t1p01']/RESPOSTA='S') and (UC018Row[CD_PERGUNTA='UC018_t1p02']/RESPOSTA='S') and (UC018Row[CD_PERGUNTA='UC018_t1p03']/RESPOSTA='N')">
   <xsl:value-of select="'A contabilidade identifica os beneficirios de pagamento de sentenas judiciais, entretanto, no possibilita a observncia da ordem cronolgica determinada no art. 100 da Constituio.'"></xsl:value-of>
  </xsl:if>
  <xsl:if test="(UC018Row[CD_PERGUNTA='UC018_t1p01']/RESPOSTA='S') and (UC018Row[CD_PERGUNTA='UC018_t1p02']/RESPOSTA='S') and (UC018Row[CD_PERGUNTA='UC018_t1p03']/RESPOSTA='S')">
   <xsl:value-of select="'A contabilidade identifica os beneficirios de pagamento de sentenas judiciais, possibilitando a observncia da ordem cronolgica determinada no art. 100 da Constituio.'"></xsl:value-of>
  </xsl:if>
 </xsl:variable>
 
 <!-- INICIO 14 - Ident. Beneficiarios Sent. Judiciais -->
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 
 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" />
  <fo:table-body>
   <fo:table-row>
    <fo:table-cell>
     <fo:block xsl:use-attribute-sets="titFCinza">
      <xsl:text>14 - Identificao de Beneficirios de Pagamentos de Sentenas Judiciais</xsl:text>
     </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-body>
 </fo:table>
 
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 
 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="556pt"/>

  <fo:table-body >	   
    <fo:table-row>								
     <fo:table-cell>
	  <fo:block xsl:use-attribute-sets="txtJustifyMed" text-align="justify" margin-left="15pt" hyphenate="true" >
        <xsl:value-of select="$texto_uc018"/>
      </fo:block>
     </fo:table-cell>
    </fo:table-row>   	
  </fo:table-body>
 </fo:table> 
  
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 
 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="556pt"/>

  <fo:table-body >	   
    <fo:table-row>								
     <fo:table-cell>
	  <fo:block xsl:use-attribute-sets="txtJustifyMed" text-align="justify" margin-left="15pt" hyphenate="true" >
       <xsl:if test="../../Observacoes/ObservacoesRemessas/ObservacoesRemessasRow[CD_OBSERVACOES='UC018']/OBSERVACOES!=''">
        <fo:inline font-weight="bold">Observaes: </fo:inline><xsl:value-of select="../../Observacoes/ObservacoesRemessas/ObservacoesRemessasRow[CD_OBSERVACOES='UC018']/OBSERVACOES"></xsl:value-of>
       </xsl:if>
       <xsl:if test="../../Observacoes/ObservacoesRemessas/ObservacoesRemessasRow[CD_OBSERVACOES='UC018']/OBSERVACOES=''">
        <fo:inline font-style="italic">No foram inseridas observaes para este item.</fo:inline>
       </xsl:if>
      </fo:block>
     </fo:table-cell>
    </fo:table-row>   	
  </fo:table-body>
 </fo:table> 
 <!-- FIM    UC018  --> 
</xsl:template>

<!--
###############################################
####      15 - Renncia de Receita       ######
###############################################
-->
<xsl:template match="UC019">

 <xsl:variable name="perg1">
  <xsl:if test="UC019Row[CD_PERGUNTA='UC019_t1p01']/RESPOSTA='S'">
   <xsl:value-of select="' houve '"></xsl:value-of>
  </xsl:if>
  <xsl:if test="UC019Row[CD_PERGUNTA='UC019_t1p01']/RESPOSTA='N'">
   <xsl:value-of select="' no houve '"></xsl:value-of>
  </xsl:if>
 </xsl:variable>

 <!-- INICIO 15 - Renncia de Receita -->
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 
 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" />
  <fo:table-body>
   <fo:table-row>
    <fo:table-cell>
     <fo:block xsl:use-attribute-sets="titFCinza">
      <xsl:text>15 - Renncia de Receita</xsl:text>
     </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-body>
 </fo:table>
 
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 
 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="556pt"/>

  <fo:table-body >	   
    <fo:table-row>								
     <fo:table-cell>
	  <fo:block xsl:use-attribute-sets="txtJustifyMed" text-align="justify" margin-left="15pt" hyphenate="true" >
       <!-- Primeira Resposta do Relatrio-->        
	    No <xsl:value-of select="../../Header/Informacoes/InformacoesRow/DS_PERIODO"/> de <xsl:value-of select="../../Header/Informacoes/InformacoesRow/ANO_EXERCICIO"/> <xsl:value-of select="$perg1"/> renncia de receita decorrente da concesso e/ou ampliao de incentivo ou benefcio de natureza tributria.   
      </fo:block>
     </fo:table-cell>
    </fo:table-row>   	
  </fo:table-body>
 </fo:table> 
  
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 
 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="556pt"/>

  <fo:table-body >	   
    <fo:table-row>								
     <fo:table-cell>
	  <fo:block xsl:use-attribute-sets="txtJustifyMed" text-align="justify" margin-left="15pt" hyphenate="true" >
       <xsl:if test="../../Observacoes/ObservacoesRemessas/ObservacoesRemessasRow[CD_OBSERVACOES='UC019']/OBSERVACOES!=''">
        <fo:inline font-weight="bold">Observaes: </fo:inline><xsl:value-of select="../../Observacoes/ObservacoesRemessas/ObservacoesRemessasRow[CD_OBSERVACOES='UC019']/OBSERVACOES"></xsl:value-of>
       </xsl:if>
       <xsl:if test="../../Observacoes/ObservacoesRemessas/ObservacoesRemessasRow[CD_OBSERVACOES='UC019']/OBSERVACOES=''">
        <fo:inline font-style="italic">No foram inseridas observaes para este item.</fo:inline>
       </xsl:if>
      </fo:block>
     </fo:table-cell>
    </fo:table-row>   	
  </fo:table-body>
 </fo:table> 
 <!-- FIM    UC019  --> 
</xsl:template>

<!--
###############################################
# 16 - Pub. do Rel. Res. Ex. Oramentria    ##
###############################################
-->
<xsl:template match="UC020">

 <!-- 1 Bimestre --> 

 <xsl:variable name="perg3bim1">
  <xsl:if test="substring(UC020Row[CD_PERGUNTA='UC020_t1p03']/RESPOSTA_EXT, 1, 1) = '1'">
   <xsl:value-of select="'Sim'"></xsl:value-of>
  </xsl:if>  
  <xsl:if test="substring(UC020Row[CD_PERGUNTA='UC020_t1p03']/RESPOSTA_EXT, 1, 1) = '0'">
   <xsl:value-of select="'No'"></xsl:value-of>
  </xsl:if>  
 </xsl:variable>
 <xsl:variable name="perg4bim1">
  <xsl:if test="substring(UC020Row[CD_PERGUNTA='UC020_t1p04']/RESPOSTA_EXT, 1, 1) = '1'">
   <xsl:value-of select="'Sim'"></xsl:value-of>
  </xsl:if>  
  <xsl:if test="substring(UC020Row[CD_PERGUNTA='UC020_t1p04']/RESPOSTA_EXT, 1, 1) = '0'">
   <xsl:value-of select="'No'"></xsl:value-of>
  </xsl:if>  
 </xsl:variable>
 <xsl:variable name="perg5bim1">
  <xsl:if test="substring(UC020Row[CD_PERGUNTA='UC020_t1p05']/RESPOSTA_EXT, 1, 1) = '1'">
   <xsl:value-of select="'Sim'"></xsl:value-of>
  </xsl:if>  
  <xsl:if test="substring(UC020Row[CD_PERGUNTA='UC020_t1p05']/RESPOSTA_EXT, 1, 1) = '0'">
   <xsl:value-of select="'No'"></xsl:value-of>
  </xsl:if>  
 </xsl:variable>
 <xsl:variable name="perg6bim1">
  <xsl:if test="substring(UC020Row[CD_PERGUNTA='UC020_t2p06']/RESPOSTA_EXT, 1, 1) = '1'">
   <xsl:value-of select="'Sim'"></xsl:value-of>
  </xsl:if>  
  <xsl:if test="substring(UC020Row[CD_PERGUNTA='UC020_t2p06']/RESPOSTA_EXT, 1, 1) = '0'">
   <xsl:value-of select="'No'"></xsl:value-of>
  </xsl:if>  
 </xsl:variable>
 <xsl:variable name="perg7bim1">
  <xsl:if test="substring(UC020Row[CD_PERGUNTA='UC020_t2p07']/RESPOSTA_EXT, 1, 1) = '1'">
   <xsl:value-of select="'Sim'"></xsl:value-of>
  </xsl:if>  
  <xsl:if test="substring(UC020Row[CD_PERGUNTA='UC020_t2p07']/RESPOSTA_EXT, 1, 1) = '0'">
   <xsl:value-of select="'No'"></xsl:value-of>
  </xsl:if>  
 </xsl:variable>
 <xsl:variable name="perg8bim1">
  <xsl:if test="substring(UC020Row[CD_PERGUNTA='UC020_t2p08']/RESPOSTA_EXT, 1, 1) = '1'">
   <xsl:value-of select="'Sim'"></xsl:value-of>
  </xsl:if>  
  <xsl:if test="substring(UC020Row[CD_PERGUNTA='UC020_t2p08']/RESPOSTA_EXT, 1, 1) = '0'">
   <xsl:value-of select="'No'"></xsl:value-of>
  </xsl:if>  
 </xsl:variable>
 <xsl:variable name="perg9bim1">
  <xsl:if test="substring(UC020Row[CD_PERGUNTA='UC020_t2p09']/RESPOSTA_EXT, 1, 1) = '1'">
   <xsl:value-of select="'Sim'"></xsl:value-of>
  </xsl:if>  
  <xsl:if test="substring(UC020Row[CD_PERGUNTA='UC020_t2p09']/RESPOSTA_EXT, 1, 1) = '0'">
   <xsl:value-of select="'No'"></xsl:value-of>
  </xsl:if>  
 </xsl:variable>
 <xsl:variable name="perg10bim1">
  <xsl:if test="substring(UC020Row[CD_PERGUNTA='UC020_t2p10']/RESPOSTA_EXT, 1, 1) = '1'">
   <xsl:value-of select="'Sim'"></xsl:value-of>
  </xsl:if>  
  <xsl:if test="substring(UC020Row[CD_PERGUNTA='UC020_t2p10']/RESPOSTA_EXT, 1, 1) = '0'">
   <xsl:value-of select="'No'"></xsl:value-of>
  </xsl:if>  
 </xsl:variable>
 <xsl:variable name="perg11bim1">
  <xsl:if test="substring(UC020Row[CD_PERGUNTA='UC020_t2p11']/RESPOSTA_EXT, 1, 1) = '1'">
   <xsl:value-of select="'Sim'"></xsl:value-of>
  </xsl:if>  
  <xsl:if test="substring(UC020Row[CD_PERGUNTA='UC020_t2p11']/RESPOSTA_EXT, 1, 1) = '0'">
   <xsl:value-of select="'No'"></xsl:value-of>
  </xsl:if>  
 </xsl:variable>

 <!-- 2 Bimestre --> 

 <xsl:variable name="perg3bim2">
  <xsl:if test="substring(UC020Row[CD_PERGUNTA='UC020_t1p03']/RESPOSTA_EXT, 2, 1) = '1'">
   <xsl:value-of select="'Sim'"></xsl:value-of>
  </xsl:if>  
  <xsl:if test="substring(UC020Row[CD_PERGUNTA='UC020_t1p03']/RESPOSTA_EXT, 2, 1) = '0'">
   <xsl:value-of select="'No'"></xsl:value-of>
  </xsl:if>  
 </xsl:variable>
 <xsl:variable name="perg4bim2">
  <xsl:if test="substring(UC020Row[CD_PERGUNTA='UC020_t1p04']/RESPOSTA_EXT, 2, 1) = '1'">
   <xsl:value-of select="'Sim'"></xsl:value-of>
  </xsl:if>  
  <xsl:if test="substring(UC020Row[CD_PERGUNTA='UC020_t1p04']/RESPOSTA_EXT, 2, 1) = '0'">
   <xsl:value-of select="'No'"></xsl:value-of>
  </xsl:if>  
 </xsl:variable>
 <xsl:variable name="perg5bim2">
  <xsl:if test="substring(UC020Row[CD_PERGUNTA='UC020_t1p05']/RESPOSTA_EXT, 2, 1) = '1'">
   <xsl:value-of select="'Sim'"></xsl:value-of>
  </xsl:if>  
  <xsl:if test="substring(UC020Row[CD_PERGUNTA='UC020_t1p05']/RESPOSTA_EXT, 2, 1) = '0'">
   <xsl:value-of select="'No'"></xsl:value-of>
  </xsl:if>  
 </xsl:variable>
 <xsl:variable name="perg6bim2">
  <xsl:if test="substring(UC020Row[CD_PERGUNTA='UC020_t2p06']/RESPOSTA_EXT, 2, 1) = '1'">
   <xsl:value-of select="'Sim'"></xsl:value-of>
  </xsl:if>  
  <xsl:if test="substring(UC020Row[CD_PERGUNTA='UC020_t2p06']/RESPOSTA_EXT, 2, 1) = '0'">
   <xsl:value-of select="'No'"></xsl:value-of>
  </xsl:if>  
 </xsl:variable>
 <xsl:variable name="perg7bim2">
  <xsl:if test="substring(UC020Row[CD_PERGUNTA='UC020_t2p07']/RESPOSTA_EXT, 2, 1) = '1'">
   <xsl:value-of select="'Sim'"></xsl:value-of>
  </xsl:if>  
  <xsl:if test="substring(UC020Row[CD_PERGUNTA='UC020_t2p07']/RESPOSTA_EXT, 2, 1) = '0'">
   <xsl:value-of select="'No'"></xsl:value-of>
  </xsl:if>  
 </xsl:variable>
 <xsl:variable name="perg8bim2">
  <xsl:if test="substring(UC020Row[CD_PERGUNTA='UC020_t2p08']/RESPOSTA_EXT, 2, 1) = '1'">
   <xsl:value-of select="'Sim'"></xsl:value-of>
  </xsl:if>  
  <xsl:if test="substring(UC020Row[CD_PERGUNTA='UC020_t2p08']/RESPOSTA_EXT, 2, 1) = '0'">
   <xsl:value-of select="'No'"></xsl:value-of>
  </xsl:if>  
 </xsl:variable>
 <xsl:variable name="perg9bim2">
  <xsl:if test="substring(UC020Row[CD_PERGUNTA='UC020_t2p09']/RESPOSTA_EXT, 2, 1) = '1'">
   <xsl:value-of select="'Sim'"></xsl:value-of>
  </xsl:if>  
  <xsl:if test="substring(UC020Row[CD_PERGUNTA='UC020_t2p09']/RESPOSTA_EXT, 2, 1) = '0'">
   <xsl:value-of select="'No'"></xsl:value-of>
  </xsl:if>  
 </xsl:variable>
 <xsl:variable name="perg10bim2">
  <xsl:if test="substring(UC020Row[CD_PERGUNTA='UC020_t2p10']/RESPOSTA_EXT, 2, 1) = '1'">
   <xsl:value-of select="'Sim'"></xsl:value-of>
  </xsl:if>  
  <xsl:if test="substring(UC020Row[CD_PERGUNTA='UC020_t2p10']/RESPOSTA_EXT, 2, 1) = '0'">
   <xsl:value-of select="'No'"></xsl:value-of>
  </xsl:if>  
 </xsl:variable>
 <xsl:variable name="perg11bim2">
  <xsl:if test="substring(UC020Row[CD_PERGUNTA='UC020_t2p11']/RESPOSTA_EXT, 2, 1) = '1'">
   <xsl:value-of select="'Sim'"></xsl:value-of>
  </xsl:if>  
  <xsl:if test="substring(UC020Row[CD_PERGUNTA='UC020_t2p11']/RESPOSTA_EXT, 2, 1) = '0'">
   <xsl:value-of select="'No'"></xsl:value-of>
  </xsl:if>  
 </xsl:variable>

 <!-- 3 Bimestre --> 

 <xsl:variable name="perg3bim3">
  <xsl:if test="substring(UC020Row[CD_PERGUNTA='UC020_t1p03']/RESPOSTA_EXT, 3, 1) = '1'">
   <xsl:value-of select="'Sim'"></xsl:value-of>
  </xsl:if>  
  <xsl:if test="((substring(UC020Row[CD_PERGUNTA='UC020_t1p03']/RESPOSTA_EXT, 3, 1) = '0') and (../../Header/Informacoes/InformacoesRow/DS_PERIODO != '1 Quadrimestre'))">
   <xsl:value-of select="'No'"></xsl:value-of>
  </xsl:if>  
  <xsl:if test="../../Header/Informacoes/InformacoesRow/DS_PERIODO = '1 Quadrimestre'">
   <xsl:value-of select="' - '"></xsl:value-of>
  </xsl:if>  
 </xsl:variable>
 <xsl:variable name="perg4bim3">
  <xsl:if test="substring(UC020Row[CD_PERGUNTA='UC020_t1p04']/RESPOSTA_EXT, 3, 1) = '1'">
   <xsl:value-of select="'Sim'"></xsl:value-of>
  </xsl:if>  
  <xsl:if test="((substring(UC020Row[CD_PERGUNTA='UC020_t1p04']/RESPOSTA_EXT, 3, 1) = '0')  and (../../Header/Informacoes/InformacoesRow/DS_PERIODO != '1 Quadrimestre'))">
   <xsl:value-of select="'No'"></xsl:value-of>
  </xsl:if>  
  <xsl:if test="../../Header/Informacoes/InformacoesRow/DS_PERIODO = '1 Quadrimestre'">
   <xsl:value-of select="' - '"></xsl:value-of>
  </xsl:if>  
 </xsl:variable>
 <xsl:variable name="perg5bim3">
  <xsl:if test="substring(UC020Row[CD_PERGUNTA='UC020_t1p05']/RESPOSTA_EXT, 3, 1) = '1'">
   <xsl:value-of select="'Sim'"></xsl:value-of>
  </xsl:if>  
  <xsl:if test="((substring(UC020Row[CD_PERGUNTA='UC020_t1p05']/RESPOSTA_EXT, 3, 1) = '0')  and (../../Header/Informacoes/InformacoesRow/DS_PERIODO != '1 Quadrimestre'))">
   <xsl:value-of select="'No'"></xsl:value-of>
  </xsl:if>  
  <xsl:if test="../../Header/Informacoes/InformacoesRow/DS_PERIODO = '1 Quadrimestre'">
   <xsl:value-of select="' - '"></xsl:value-of>
  </xsl:if>  
 </xsl:variable>
 <xsl:variable name="perg6bim3">
  <xsl:if test="substring(UC020Row[CD_PERGUNTA='UC020_t2p06']/RESPOSTA_EXT, 3, 1) = '1'">
   <xsl:value-of select="'Sim'"></xsl:value-of>
  </xsl:if>  
  <xsl:if test="((substring(UC020Row[CD_PERGUNTA='UC020_t2p06']/RESPOSTA_EXT, 3, 1) = '0')  and (../../Header/Informacoes/InformacoesRow/DS_PERIODO != '1 Quadrimestre'))">
   <xsl:value-of select="'No'"></xsl:value-of>
  </xsl:if>  
  <xsl:if test="../../Header/Informacoes/InformacoesRow/DS_PERIODO = '1 Quadrimestre'">
   <xsl:value-of select="' - '"></xsl:value-of>
  </xsl:if>  
 </xsl:variable>
 <xsl:variable name="perg7bim3">
  <xsl:if test="substring(UC020Row[CD_PERGUNTA='UC020_t2p07']/RESPOSTA_EXT, 3, 1) = '1'">
   <xsl:value-of select="'Sim'"></xsl:value-of>
  </xsl:if>  
  <xsl:if test="((substring(UC020Row[CD_PERGUNTA='UC020_t2p07']/RESPOSTA_EXT, 3, 1) = '0')  and (../../Header/Informacoes/InformacoesRow/DS_PERIODO != '1 Quadrimestre'))">
   <xsl:value-of select="'No'"></xsl:value-of>
  </xsl:if>  
  <xsl:if test="../../Header/Informacoes/InformacoesRow/DS_PERIODO = '1 Quadrimestre'">
   <xsl:value-of select="' - '"></xsl:value-of>
  </xsl:if>  
 </xsl:variable>
 <xsl:variable name="perg8bim3">
  <xsl:if test="substring(UC020Row[CD_PERGUNTA='UC020_t2p08']/RESPOSTA_EXT, 3, 1) = '1'">
   <xsl:value-of select="'Sim'"></xsl:value-of>
  </xsl:if>  
  <xsl:if test="((substring(UC020Row[CD_PERGUNTA='UC020_t2p08']/RESPOSTA_EXT, 3, 1) = '0')  and (../../Header/Informacoes/InformacoesRow/DS_PERIODO != '1 Quadrimestre'))">
   <xsl:value-of select="'No'"></xsl:value-of>
  </xsl:if>  
  <xsl:if test="../../Header/Informacoes/InformacoesRow/DS_PERIODO = '1 Quadrimestre'">
   <xsl:value-of select="' - '"></xsl:value-of>
  </xsl:if>  
 </xsl:variable>
 <xsl:variable name="perg9bim3">
  <xsl:if test="substring(UC020Row[CD_PERGUNTA='UC020_t2p09']/RESPOSTA_EXT, 3, 1) = '1'">
   <xsl:value-of select="'Sim'"></xsl:value-of>
  </xsl:if>  
  <xsl:if test="((substring(UC020Row[CD_PERGUNTA='UC020_t2p09']/RESPOSTA_EXT, 3, 1) = '0')  and (../../Header/Informacoes/InformacoesRow/DS_PERIODO != '1 Quadrimestre'))">
   <xsl:value-of select="'No'"></xsl:value-of>
  </xsl:if>  
  <xsl:if test="../../Header/Informacoes/InformacoesRow/DS_PERIODO = '1 Quadrimestre'">
   <xsl:value-of select="' - '"></xsl:value-of>
  </xsl:if>  
 </xsl:variable>
 <xsl:variable name="perg10bim3">
  <xsl:if test="substring(UC020Row[CD_PERGUNTA='UC020_t2p10']/RESPOSTA_EXT, 3, 1) = '1'">
   <xsl:value-of select="'Sim'"></xsl:value-of>
  </xsl:if>  
  <xsl:if test="((substring(UC020Row[CD_PERGUNTA='UC020_t2p10']/RESPOSTA_EXT, 3, 1) = '0')  and (../../Header/Informacoes/InformacoesRow/DS_PERIODO != '1 Quadrimestre'))">
   <xsl:value-of select="'No'"></xsl:value-of>
  </xsl:if>  
  <xsl:if test="../../Header/Informacoes/InformacoesRow/DS_PERIODO = '1 Quadrimestre'">
   <xsl:value-of select="' - '"></xsl:value-of>
  </xsl:if>  
 </xsl:variable>
 <xsl:variable name="perg11bim3">
  <xsl:if test="substring(UC020Row[CD_PERGUNTA='UC020_t2p11']/RESPOSTA_EXT, 3, 1) = '1'">
   <xsl:value-of select="'Sim'"></xsl:value-of>
  </xsl:if>  
  <xsl:if test="((substring(UC020Row[CD_PERGUNTA='UC020_t2p11']/RESPOSTA_EXT, 3, 1) = '0')  and (../../Header/Informacoes/InformacoesRow/DS_PERIODO != '1 Quadrimestre'))">
   <xsl:value-of select="'No'"></xsl:value-of>
  </xsl:if>  
  <xsl:if test="../../Header/Informacoes/InformacoesRow/DS_PERIODO = '1 Quadrimestre'">
   <xsl:value-of select="' - '"></xsl:value-of>
  </xsl:if>  
 </xsl:variable>

 <!-- 4 Bimestre --> 

 <xsl:variable name="perg3bim4">
  <xsl:if test="substring(UC020Row[CD_PERGUNTA='UC020_t1p03']/RESPOSTA_EXT, 4, 1) = '1'">
   <xsl:value-of select="'Sim'"></xsl:value-of>
  </xsl:if>  
  <xsl:if test="((substring(UC020Row[CD_PERGUNTA='UC020_t1p03']/RESPOSTA_EXT, 4, 1) = '0') and ((../../Header/Informacoes/InformacoesRow/DS_PERIODO != '1 Quadrimestre') and (../../Header/Informacoes/InformacoesRow/DS_PERIODO != '1 Semestre')))">
   <xsl:value-of select="'No'"></xsl:value-of>
  </xsl:if>  
  <xsl:if test="((../../Header/Informacoes/InformacoesRow/DS_PERIODO = '1 Quadrimestre') or (../../Header/Informacoes/InformacoesRow/DS_PERIODO = '1 Semestre'))">
   <xsl:value-of select="' - '"></xsl:value-of>
  </xsl:if>  
 </xsl:variable>
 <xsl:variable name="perg4bim4">
  <xsl:if test="substring(UC020Row[CD_PERGUNTA='UC020_t1p04']/RESPOSTA_EXT, 4, 1) = '1'">
   <xsl:value-of select="'Sim'"></xsl:value-of>
  </xsl:if>  
  <xsl:if test="((substring(UC020Row[CD_PERGUNTA='UC020_t1p04']/RESPOSTA_EXT, 4, 1) = '0')  and ((../../Header/Informacoes/InformacoesRow/DS_PERIODO != '1 Quadrimestre') and (../../Header/Informacoes/InformacoesRow/DS_PERIODO != '1 Semestre')))">
   <xsl:value-of select="'No'"></xsl:value-of>
  </xsl:if>  
  <xsl:if test="((../../Header/Informacoes/InformacoesRow/DS_PERIODO = '1 Quadrimestre') or (../../Header/Informacoes/InformacoesRow/DS_PERIODO = '1 Semestre'))">
   <xsl:value-of select="' - '"></xsl:value-of>
  </xsl:if>  
 </xsl:variable>
 <xsl:variable name="perg5bim4">
  <xsl:if test="substring(UC020Row[CD_PERGUNTA='UC020_t1p05']/RESPOSTA_EXT, 4, 1) = '1'">
   <xsl:value-of select="'Sim'"></xsl:value-of>
  </xsl:if>  
  <xsl:if test="((substring(UC020Row[CD_PERGUNTA='UC020_t1p05']/RESPOSTA_EXT, 4, 1) = '0')  and ((../../Header/Informacoes/InformacoesRow/DS_PERIODO != '1 Quadrimestre') and (../../Header/Informacoes/InformacoesRow/DS_PERIODO != '1 Semestre')))">
   <xsl:value-of select="'No'"></xsl:value-of>
  </xsl:if>  
  <xsl:if test="((../../Header/Informacoes/InformacoesRow/DS_PERIODO = '1 Quadrimestre') or (../../Header/Informacoes/InformacoesRow/DS_PERIODO = '1 Semestre'))">
   <xsl:value-of select="' - '"></xsl:value-of>
  </xsl:if>  
 </xsl:variable>
 <xsl:variable name="perg6bim4">
  <xsl:if test="substring(UC020Row[CD_PERGUNTA='UC020_t2p06']/RESPOSTA_EXT, 4, 1) = '1'">
   <xsl:value-of select="'Sim'"></xsl:value-of>
  </xsl:if>  
  <xsl:if test="((substring(UC020Row[CD_PERGUNTA='UC020_t2p06']/RESPOSTA_EXT, 4, 1) = '0')   and ((../../Header/Informacoes/InformacoesRow/DS_PERIODO != '1 Quadrimestre') and (../../Header/Informacoes/InformacoesRow/DS_PERIODO != '1 Semestre')))">
   <xsl:value-of select="'No'"></xsl:value-of>
  </xsl:if>  
  <xsl:if test="((../../Header/Informacoes/InformacoesRow/DS_PERIODO = '1 Quadrimestre') or (../../Header/Informacoes/InformacoesRow/DS_PERIODO = '1 Semestre'))">
   <xsl:value-of select="' - '"></xsl:value-of>
  </xsl:if>  
 </xsl:variable>
 <xsl:variable name="perg7bim4">
  <xsl:if test="substring(UC020Row[CD_PERGUNTA='UC020_t2p07']/RESPOSTA_EXT, 4, 1) = '1'">
   <xsl:value-of select="'Sim'"></xsl:value-of>
  </xsl:if>  
  <xsl:if test="((substring(UC020Row[CD_PERGUNTA='UC020_t2p07']/RESPOSTA_EXT, 4, 1) = '0')   and ((../../Header/Informacoes/InformacoesRow/DS_PERIODO != '1 Quadrimestre') and (../../Header/Informacoes/InformacoesRow/DS_PERIODO != '1 Semestre')))">
   <xsl:value-of select="'No'"></xsl:value-of>
  </xsl:if>  
  <xsl:if test="((../../Header/Informacoes/InformacoesRow/DS_PERIODO = '1 Quadrimestre') or (../../Header/Informacoes/InformacoesRow/DS_PERIODO = '1 Semestre'))">
   <xsl:value-of select="' - '"></xsl:value-of>
  </xsl:if>  
 </xsl:variable>
 <xsl:variable name="perg8bim4">
  <xsl:if test="substring(UC020Row[CD_PERGUNTA='UC020_t2p08']/RESPOSTA_EXT, 4, 1) = '1'">
   <xsl:value-of select="'Sim'"></xsl:value-of>
  </xsl:if>  
  <xsl:if test="((substring(UC020Row[CD_PERGUNTA='UC020_t2p08']/RESPOSTA_EXT, 4, 1) = '0')   and ((../../Header/Informacoes/InformacoesRow/DS_PERIODO != '1 Quadrimestre') and (../../Header/Informacoes/InformacoesRow/DS_PERIODO != '1 Semestre')))">
   <xsl:value-of select="'No'"></xsl:value-of>
  </xsl:if>  
  <xsl:if test="((../../Header/Informacoes/InformacoesRow/DS_PERIODO = '1 Quadrimestre') or (../../Header/Informacoes/InformacoesRow/DS_PERIODO = '1 Semestre'))">
   <xsl:value-of select="' - '"></xsl:value-of>
  </xsl:if>  
 </xsl:variable>
 <xsl:variable name="perg9bim4">
  <xsl:if test="substring(UC020Row[CD_PERGUNTA='UC020_t2p09']/RESPOSTA_EXT, 4, 1) = '1'">
   <xsl:value-of select="'Sim'"></xsl:value-of>
  </xsl:if>  
  <xsl:if test="((substring(UC020Row[CD_PERGUNTA='UC020_t2p09']/RESPOSTA_EXT, 4, 1) = '0')   and ((../../Header/Informacoes/InformacoesRow/DS_PERIODO != '1 Quadrimestre') and (../../Header/Informacoes/InformacoesRow/DS_PERIODO != '1 Semestre')))">
   <xsl:value-of select="'No'"></xsl:value-of>
  </xsl:if>  
  <xsl:if test="((../../Header/Informacoes/InformacoesRow/DS_PERIODO = '1 Quadrimestre') or (../../Header/Informacoes/InformacoesRow/DS_PERIODO = '1 Semestre'))">
   <xsl:value-of select="' - '"></xsl:value-of>
  </xsl:if>  
 </xsl:variable>
 <xsl:variable name="perg10bim4">
  <xsl:if test="substring(UC020Row[CD_PERGUNTA='UC020_t2p10']/RESPOSTA_EXT, 4, 1) = '1'">
   <xsl:value-of select="'Sim'"></xsl:value-of>
  </xsl:if>  
  <xsl:if test="((substring(UC020Row[CD_PERGUNTA='UC020_t2p10']/RESPOSTA_EXT, 4, 1) = '0')   and ((../../Header/Informacoes/InformacoesRow/DS_PERIODO != '1 Quadrimestre') and (../../Header/Informacoes/InformacoesRow/DS_PERIODO != '1 Semestre')))">
   <xsl:value-of select="'No'"></xsl:value-of>
  </xsl:if>  
  <xsl:if test="((../../Header/Informacoes/InformacoesRow/DS_PERIODO = '1 Quadrimestre') or (../../Header/Informacoes/InformacoesRow/DS_PERIODO = '1 Semestre'))">
   <xsl:value-of select="' - '"></xsl:value-of>
  </xsl:if>  
 </xsl:variable>
 <xsl:variable name="perg11bim4">
  <xsl:if test="substring(UC020Row[CD_PERGUNTA='UC020_t2p11']/RESPOSTA_EXT, 4, 1) = '1'">
   <xsl:value-of select="'Sim'"></xsl:value-of>
  </xsl:if>  
  <xsl:if test="((substring(UC020Row[CD_PERGUNTA='UC020_t2p11']/RESPOSTA_EXT, 4, 1) = '0')   and ((../../Header/Informacoes/InformacoesRow/DS_PERIODO != '1 Quadrimestre') and (../../Header/Informacoes/InformacoesRow/DS_PERIODO != '1 Semestre')))">
   <xsl:value-of select="'No'"></xsl:value-of>
  </xsl:if>  
  <xsl:if test="((../../Header/Informacoes/InformacoesRow/DS_PERIODO = '1 Quadrimestre') or (../../Header/Informacoes/InformacoesRow/DS_PERIODO = '1 Semestre'))">
   <xsl:value-of select="' - '"></xsl:value-of>
  </xsl:if>  
 </xsl:variable>

 <!-- 5 Bimestre --> 

 <xsl:variable name="perg3bim5">
  <xsl:if test="substring(UC020Row[CD_PERGUNTA='UC020_t1p03']/RESPOSTA_EXT, 5, 1) = '1'">
   <xsl:value-of select="'Sim'"></xsl:value-of>
  </xsl:if>  
  <xsl:if test="((substring(UC020Row[CD_PERGUNTA='UC020_t1p03']/RESPOSTA_EXT, 5, 1) = '0') and ((../../Header/Informacoes/InformacoesRow/DS_PERIODO != '1 Quadrimestre') and (../../Header/Informacoes/InformacoesRow/DS_PERIODO != '1 Semestre') and (../../Header/Informacoes/InformacoesRow/DS_PERIODO != '2 Quadrimestre')))">
   <xsl:value-of select="'No'"></xsl:value-of>
  </xsl:if>  
  <xsl:if test="((../../Header/Informacoes/InformacoesRow/DS_PERIODO = '1 Quadrimestre') or (../../Header/Informacoes/InformacoesRow/DS_PERIODO = '1 Semestre') or (../../Header/Informacoes/InformacoesRow/DS_PERIODO = '2 Quadrimestre'))">
   <xsl:value-of select="' - '"></xsl:value-of>
  </xsl:if>  
 </xsl:variable>
 <xsl:variable name="perg4bim5">
  <xsl:if test="substring(UC020Row[CD_PERGUNTA='UC020_t1p04']/RESPOSTA_EXT, 5, 1) = '1'">
   <xsl:value-of select="'Sim'"></xsl:value-of>
  </xsl:if>  
  <xsl:if test="((substring(UC020Row[CD_PERGUNTA='UC020_t1p04']/RESPOSTA_EXT, 5, 1) = '0')  and ((../../Header/Informacoes/InformacoesRow/DS_PERIODO != '1 Quadrimestre') and (../../Header/Informacoes/InformacoesRow/DS_PERIODO != '1 Semestre') and (../../Header/Informacoes/InformacoesRow/DS_PERIODO != '2 Quadrimestre')))">
   <xsl:value-of select="'No'"></xsl:value-of>
  </xsl:if>  
  <xsl:if test="((../../Header/Informacoes/InformacoesRow/DS_PERIODO = '1 Quadrimestre') or (../../Header/Informacoes/InformacoesRow/DS_PERIODO = '1 Semestre') or (../../Header/Informacoes/InformacoesRow/DS_PERIODO = '2 Quadrimestre'))">
   <xsl:value-of select="' - '"></xsl:value-of>
  </xsl:if>  
 </xsl:variable>
 <xsl:variable name="perg5bim5">
  <xsl:if test="substring(UC020Row[CD_PERGUNTA='UC020_t1p05']/RESPOSTA_EXT, 5, 1) = '1'">
   <xsl:value-of select="'Sim'"></xsl:value-of>
  </xsl:if>  
  <xsl:if test="((substring(UC020Row[CD_PERGUNTA='UC020_t1p05']/RESPOSTA_EXT, 5, 1) = '0')  and ((../../Header/Informacoes/InformacoesRow/DS_PERIODO != '1 Quadrimestre') and (../../Header/Informacoes/InformacoesRow/DS_PERIODO != '1 Semestre') and (../../Header/Informacoes/InformacoesRow/DS_PERIODO != '2 Quadrimestre')))">
   <xsl:value-of select="'No'"></xsl:value-of>
  </xsl:if>  
  <xsl:if test="((../../Header/Informacoes/InformacoesRow/DS_PERIODO = '1 Quadrimestre') or (../../Header/Informacoes/InformacoesRow/DS_PERIODO = '1 Semestre') or (../../Header/Informacoes/InformacoesRow/DS_PERIODO = '2 Quadrimestre'))">
   <xsl:value-of select="' - '"></xsl:value-of>
  </xsl:if>  
 </xsl:variable>
 <xsl:variable name="perg6bim5">
  <xsl:if test="substring(UC020Row[CD_PERGUNTA='UC020_t2p06']/RESPOSTA_EXT, 5, 1) = '1'">
   <xsl:value-of select="'Sim'"></xsl:value-of>
  </xsl:if>  
  <xsl:if test="((substring(UC020Row[CD_PERGUNTA='UC020_t2p06']/RESPOSTA_EXT, 5, 1) = '0')  and ((../../Header/Informacoes/InformacoesRow/DS_PERIODO != '1 Quadrimestre') and (../../Header/Informacoes/InformacoesRow/DS_PERIODO != '1 Semestre') and (../../Header/Informacoes/InformacoesRow/DS_PERIODO != '2 Quadrimestre')))">
   <xsl:value-of select="'No'"></xsl:value-of>
  </xsl:if>  
  <xsl:if test="((../../Header/Informacoes/InformacoesRow/DS_PERIODO = '1 Quadrimestre') or (../../Header/Informacoes/InformacoesRow/DS_PERIODO = '1 Semestre') or (../../Header/Informacoes/InformacoesRow/DS_PERIODO = '2 Quadrimestre'))">
   <xsl:value-of select="' - '"></xsl:value-of>
  </xsl:if>  
 </xsl:variable>
 <xsl:variable name="perg7bim5">
  <xsl:if test="substring(UC020Row[CD_PERGUNTA='UC020_t2p07']/RESPOSTA_EXT, 5, 1) = '1'">
   <xsl:value-of select="'Sim'"></xsl:value-of>
  </xsl:if>  
  <xsl:if test="((substring(UC020Row[CD_PERGUNTA='UC020_t2p07']/RESPOSTA_EXT, 5, 1) = '0')  and ((../../Header/Informacoes/InformacoesRow/DS_PERIODO != '1 Quadrimestre') and (../../Header/Informacoes/InformacoesRow/DS_PERIODO != '1 Semestre') and (../../Header/Informacoes/InformacoesRow/DS_PERIODO != '2 Quadrimestre')))">
   <xsl:value-of select="'No'"></xsl:value-of>
  </xsl:if>  
  <xsl:if test="((../../Header/Informacoes/InformacoesRow/DS_PERIODO = '1 Quadrimestre') or (../../Header/Informacoes/InformacoesRow/DS_PERIODO = '1 Semestre') or (../../Header/Informacoes/InformacoesRow/DS_PERIODO = '2 Quadrimestre'))">
   <xsl:value-of select="' - '"></xsl:value-of>
  </xsl:if>  
 </xsl:variable>
 <xsl:variable name="perg8bim5">
  <xsl:if test="substring(UC020Row[CD_PERGUNTA='UC020_t2p08']/RESPOSTA_EXT, 5, 1) = '1'">
   <xsl:value-of select="'Sim'"></xsl:value-of>
  </xsl:if>  
  <xsl:if test="((substring(UC020Row[CD_PERGUNTA='UC020_t2p08']/RESPOSTA_EXT, 5, 1) = '0')  and ((../../Header/Informacoes/InformacoesRow/DS_PERIODO != '1 Quadrimestre') and (../../Header/Informacoes/InformacoesRow/DS_PERIODO != '1 Semestre') and (../../Header/Informacoes/InformacoesRow/DS_PERIODO != '2 Quadrimestre')))">
   <xsl:value-of select="'No'"></xsl:value-of>
  </xsl:if>  
  <xsl:if test="((../../Header/Informacoes/InformacoesRow/DS_PERIODO = '1 Quadrimestre') or (../../Header/Informacoes/InformacoesRow/DS_PERIODO = '1 Semestre') or (../../Header/Informacoes/InformacoesRow/DS_PERIODO = '2 Quadrimestre'))">
   <xsl:value-of select="' - '"></xsl:value-of>
  </xsl:if>  
 </xsl:variable>
 <xsl:variable name="perg9bim5">
  <xsl:if test="substring(UC020Row[CD_PERGUNTA='UC020_t2p09']/RESPOSTA_EXT, 5, 1) = '1'">
   <xsl:value-of select="'Sim'"></xsl:value-of>
  </xsl:if>  
  <xsl:if test="((substring(UC020Row[CD_PERGUNTA='UC020_t2p09']/RESPOSTA_EXT, 5, 1) = '0')  and ((../../Header/Informacoes/InformacoesRow/DS_PERIODO != '1 Quadrimestre') and (../../Header/Informacoes/InformacoesRow/DS_PERIODO != '1 Semestre') and (../../Header/Informacoes/InformacoesRow/DS_PERIODO != '2 Quadrimestre')))">
   <xsl:value-of select="'No'"></xsl:value-of>
  </xsl:if>  
  <xsl:if test="((../../Header/Informacoes/InformacoesRow/DS_PERIODO = '1 Quadrimestre') or (../../Header/Informacoes/InformacoesRow/DS_PERIODO = '1 Semestre') or (../../Header/Informacoes/InformacoesRow/DS_PERIODO = '2 Quadrimestre'))">
   <xsl:value-of select="' - '"></xsl:value-of>
  </xsl:if>  
 </xsl:variable>
 <xsl:variable name="perg10bim5">
  <xsl:if test="substring(UC020Row[CD_PERGUNTA='UC020_t2p10']/RESPOSTA_EXT, 5, 1) = '1'">
   <xsl:value-of select="'Sim'"></xsl:value-of>
  </xsl:if>  
  <xsl:if test="((substring(UC020Row[CD_PERGUNTA='UC020_t2p10']/RESPOSTA_EXT, 5, 1) = '0')  and ((../../Header/Informacoes/InformacoesRow/DS_PERIODO != '1 Quadrimestre') and (../../Header/Informacoes/InformacoesRow/DS_PERIODO != '1 Semestre') and (../../Header/Informacoes/InformacoesRow/DS_PERIODO != '2 Quadrimestre')))">
   <xsl:value-of select="'No'"></xsl:value-of>
  </xsl:if>  
  <xsl:if test="((../../Header/Informacoes/InformacoesRow/DS_PERIODO = '1 Quadrimestre') or (../../Header/Informacoes/InformacoesRow/DS_PERIODO = '1 Semestre') or (../../Header/Informacoes/InformacoesRow/DS_PERIODO = '2 Quadrimestre'))">
   <xsl:value-of select="' - '"></xsl:value-of>
  </xsl:if>  
 </xsl:variable>
 <xsl:variable name="perg11bim5">
  <xsl:if test="substring(UC020Row[CD_PERGUNTA='UC020_t2p11']/RESPOSTA_EXT, 5, 1) = '1'">
   <xsl:value-of select="'Sim'"></xsl:value-of>
  </xsl:if>  
  <xsl:if test="((substring(UC020Row[CD_PERGUNTA='UC020_t2p11']/RESPOSTA_EXT, 5, 1) = '0')  and ((../../Header/Informacoes/InformacoesRow/DS_PERIODO != '1 Quadrimestre') and (../../Header/Informacoes/InformacoesRow/DS_PERIODO != '1 Semestre') and (../../Header/Informacoes/InformacoesRow/DS_PERIODO != '2 Quadrimestre')))">
   <xsl:value-of select="'No'"></xsl:value-of>
  </xsl:if>  
  <xsl:if test="((../../Header/Informacoes/InformacoesRow/DS_PERIODO = '1 Quadrimestre') or (../../Header/Informacoes/InformacoesRow/DS_PERIODO = '1 Semestre') or (../../Header/Informacoes/InformacoesRow/DS_PERIODO = '2 Quadrimestre'))">
   <xsl:value-of select="' - '"></xsl:value-of>
  </xsl:if>  
 </xsl:variable>

 <!-- 6 Bimestre --> 

 <xsl:variable name="perg3bim6">
  <xsl:if test="substring(UC020Row[CD_PERGUNTA='UC020_t1p03']/RESPOSTA_EXT, 6, 1) = '1'">
   <xsl:value-of select="'Sim'"></xsl:value-of>
  </xsl:if>  
  <xsl:if test="((substring(UC020Row[CD_PERGUNTA='UC020_t1p03']/RESPOSTA_EXT, 6, 1) = '0') and ((../../Header/Informacoes/InformacoesRow/DS_PERIODO != '1 Quadrimestre') and (../../Header/Informacoes/InformacoesRow/DS_PERIODO != '1 Semestre') and (../../Header/Informacoes/InformacoesRow/DS_PERIODO != '2 Quadrimestre')))">
   <xsl:value-of select="'No'"></xsl:value-of>
  </xsl:if>  
  <xsl:if test="((../../Header/Informacoes/InformacoesRow/DS_PERIODO = '1 Quadrimestre') or (../../Header/Informacoes/InformacoesRow/DS_PERIODO = '1 Semestre') or (../../Header/Informacoes/InformacoesRow/DS_PERIODO = '2 Quadrimestre'))">
   <xsl:value-of select="' - '"></xsl:value-of>
  </xsl:if>  
 </xsl:variable>
 <xsl:variable name="perg4bim6">
  <xsl:if test="substring(UC020Row[CD_PERGUNTA='UC020_t1p04']/RESPOSTA_EXT, 6, 1) = '1'">
   <xsl:value-of select="'Sim'"></xsl:value-of>
  </xsl:if>  
  <xsl:if test="((substring(UC020Row[CD_PERGUNTA='UC020_t1p04']/RESPOSTA_EXT, 6, 1) = '0')  and ((../../Header/Informacoes/InformacoesRow/DS_PERIODO != '1 Quadrimestre') and (../../Header/Informacoes/InformacoesRow/DS_PERIODO != '1 Semestre') and (../../Header/Informacoes/InformacoesRow/DS_PERIODO != '2 Quadrimestre')))">
   <xsl:value-of select="'No'"></xsl:value-of>
  </xsl:if>  
  <xsl:if test="((../../Header/Informacoes/InformacoesRow/DS_PERIODO = '1 Quadrimestre') or (../../Header/Informacoes/InformacoesRow/DS_PERIODO = '1 Semestre') or (../../Header/Informacoes/InformacoesRow/DS_PERIODO = '2 Quadrimestre'))">
   <xsl:value-of select="' - '"></xsl:value-of>
  </xsl:if>  
 </xsl:variable>
 <xsl:variable name="perg5bim6">
  <xsl:if test="substring(UC020Row[CD_PERGUNTA='UC020_t1p05']/RESPOSTA_EXT, 6, 1) = '1'">
   <xsl:value-of select="'Sim'"></xsl:value-of>
  </xsl:if>  
  <xsl:if test="((substring(UC020Row[CD_PERGUNTA='UC020_t1p05']/RESPOSTA_EXT, 6, 1) = '0')  and ((../../Header/Informacoes/InformacoesRow/DS_PERIODO != '1 Quadrimestre') and (../../Header/Informacoes/InformacoesRow/DS_PERIODO != '1 Semestre') and (../../Header/Informacoes/InformacoesRow/DS_PERIODO != '2 Quadrimestre')))">
   <xsl:value-of select="'No'"></xsl:value-of>
  </xsl:if>  
  <xsl:if test="((../../Header/Informacoes/InformacoesRow/DS_PERIODO = '1 Quadrimestre') or (../../Header/Informacoes/InformacoesRow/DS_PERIODO = '1 Semestre') or (../../Header/Informacoes/InformacoesRow/DS_PERIODO = '2 Quadrimestre'))">
   <xsl:value-of select="' - '"></xsl:value-of>
  </xsl:if>  
 </xsl:variable>
 <xsl:variable name="perg6bim6">
  <xsl:if test="substring(UC020Row[CD_PERGUNTA='UC020_t2p06']/RESPOSTA_EXT, 6, 1) = '1'">
   <xsl:value-of select="'Sim'"></xsl:value-of>
  </xsl:if>  
  <xsl:if test="((substring(UC020Row[CD_PERGUNTA='UC020_t2p06']/RESPOSTA_EXT, 6, 1) = '0')  and ((../../Header/Informacoes/InformacoesRow/DS_PERIODO != '1 Quadrimestre') and (../../Header/Informacoes/InformacoesRow/DS_PERIODO != '1 Semestre') and (../../Header/Informacoes/InformacoesRow/DS_PERIODO != '2 Quadrimestre')))">
   <xsl:value-of select="'No'"></xsl:value-of>
  </xsl:if>  
  <xsl:if test="((../../Header/Informacoes/InformacoesRow/DS_PERIODO = '1 Quadrimestre') or (../../Header/Informacoes/InformacoesRow/DS_PERIODO = '1 Semestre') or (../../Header/Informacoes/InformacoesRow/DS_PERIODO = '2 Quadrimestre'))">
   <xsl:value-of select="' - '"></xsl:value-of>
  </xsl:if>  
 </xsl:variable>
 <xsl:variable name="perg7bim6">
  <xsl:if test="substring(UC020Row[CD_PERGUNTA='UC020_t2p07']/RESPOSTA_EXT, 6, 1) = '1'">
   <xsl:value-of select="'Sim'"></xsl:value-of>
  </xsl:if>  
  <xsl:if test="((substring(UC020Row[CD_PERGUNTA='UC020_t2p07']/RESPOSTA_EXT, 6, 1) = '0')  and ((../../Header/Informacoes/InformacoesRow/DS_PERIODO != '1 Quadrimestre') and (../../Header/Informacoes/InformacoesRow/DS_PERIODO != '1 Semestre') and (../../Header/Informacoes/InformacoesRow/DS_PERIODO != '2 Quadrimestre')))">
   <xsl:value-of select="'No'"></xsl:value-of>
  </xsl:if>  
  <xsl:if test="((../../Header/Informacoes/InformacoesRow/DS_PERIODO = '1 Quadrimestre') or (../../Header/Informacoes/InformacoesRow/DS_PERIODO = '1 Semestre') or (../../Header/Informacoes/InformacoesRow/DS_PERIODO = '2 Quadrimestre'))">
   <xsl:value-of select="' - '"></xsl:value-of>
  </xsl:if>  
 </xsl:variable>
 <xsl:variable name="perg8bim6">
  <xsl:if test="substring(UC020Row[CD_PERGUNTA='UC020_t2p08']/RESPOSTA_EXT, 6, 1) = '1'">
   <xsl:value-of select="'Sim'"></xsl:value-of>
  </xsl:if>  
  <xsl:if test="((substring(UC020Row[CD_PERGUNTA='UC020_t2p08']/RESPOSTA_EXT, 6, 1) = '0')  and ((../../Header/Informacoes/InformacoesRow/DS_PERIODO != '1 Quadrimestre') and (../../Header/Informacoes/InformacoesRow/DS_PERIODO != '1 Semestre') and (../../Header/Informacoes/InformacoesRow/DS_PERIODO != '2 Quadrimestre')))">
   <xsl:value-of select="'No'"></xsl:value-of>
  </xsl:if>  
  <xsl:if test="((../../Header/Informacoes/InformacoesRow/DS_PERIODO = '1 Quadrimestre') or (../../Header/Informacoes/InformacoesRow/DS_PERIODO = '1 Semestre') or (../../Header/Informacoes/InformacoesRow/DS_PERIODO = '2 Quadrimestre'))">
   <xsl:value-of select="' - '"></xsl:value-of>
  </xsl:if>  
 </xsl:variable>
 <xsl:variable name="perg9bim6">
  <xsl:if test="substring(UC020Row[CD_PERGUNTA='UC020_t2p09']/RESPOSTA_EXT, 6, 1) = '1'">
   <xsl:value-of select="'Sim'"></xsl:value-of>
  </xsl:if>  
  <xsl:if test="((substring(UC020Row[CD_PERGUNTA='UC020_t2p09']/RESPOSTA_EXT, 6, 1) = '0')  and ((../../Header/Informacoes/InformacoesRow/DS_PERIODO != '1 Quadrimestre') and (../../Header/Informacoes/InformacoesRow/DS_PERIODO != '1 Semestre') and (../../Header/Informacoes/InformacoesRow/DS_PERIODO != '2 Quadrimestre')))">
   <xsl:value-of select="'No'"></xsl:value-of>
  </xsl:if>  
  <xsl:if test="((../../Header/Informacoes/InformacoesRow/DS_PERIODO = '1 Quadrimestre') or (../../Header/Informacoes/InformacoesRow/DS_PERIODO = '1 Semestre') or (../../Header/Informacoes/InformacoesRow/DS_PERIODO = '2 Quadrimestre'))">
   <xsl:value-of select="' - '"></xsl:value-of>
  </xsl:if>  
 </xsl:variable>
 <xsl:variable name="perg10bim6">
  <xsl:if test="substring(UC020Row[CD_PERGUNTA='UC020_t2p10']/RESPOSTA_EXT, 6, 1) = '1'">
   <xsl:value-of select="'Sim'"></xsl:value-of>
  </xsl:if>  
  <xsl:if test="((substring(UC020Row[CD_PERGUNTA='UC020_t2p10']/RESPOSTA_EXT, 6, 1) = '0')  and ((../../Header/Informacoes/InformacoesRow/DS_PERIODO != '1 Quadrimestre') and (../../Header/Informacoes/InformacoesRow/DS_PERIODO != '1 Semestre') and (../../Header/Informacoes/InformacoesRow/DS_PERIODO != '2 Quadrimestre')))">
   <xsl:value-of select="'No'"></xsl:value-of>
  </xsl:if>  
  <xsl:if test="((../../Header/Informacoes/InformacoesRow/DS_PERIODO = '1 Quadrimestre') or (../../Header/Informacoes/InformacoesRow/DS_PERIODO = '1 Semestre') or (../../Header/Informacoes/InformacoesRow/DS_PERIODO = '2 Quadrimestre'))">
   <xsl:value-of select="' - '"></xsl:value-of>
  </xsl:if>  
 </xsl:variable>
 <xsl:variable name="perg11bim6">
  <xsl:if test="substring(UC020Row[CD_PERGUNTA='UC020_t2p11']/RESPOSTA_EXT, 6, 1) = '1'">
   <xsl:value-of select="'Sim'"></xsl:value-of>
  </xsl:if>  
  <xsl:if test="((substring(UC020Row[CD_PERGUNTA='UC020_t2p11']/RESPOSTA_EXT, 6, 1) = '0')  and ((../../Header/Informacoes/InformacoesRow/DS_PERIODO != '1 Quadrimestre') and (../../Header/Informacoes/InformacoesRow/DS_PERIODO != '1 Semestre') and (../../Header/Informacoes/InformacoesRow/DS_PERIODO != '2 Quadrimestre')))">
   <xsl:value-of select="'No'"></xsl:value-of>
  </xsl:if>  
  <xsl:if test="((../../Header/Informacoes/InformacoesRow/DS_PERIODO = '1 Quadrimestre') or (../../Header/Informacoes/InformacoesRow/DS_PERIODO = '1 Semestre') or (../../Header/Informacoes/InformacoesRow/DS_PERIODO = '2 Quadrimestre'))">
   <xsl:value-of select="' - '"></xsl:value-of>
  </xsl:if>  
 </xsl:variable>

 <!-- Variveis de Perodos --> 

 <xsl:variable name="pergunta3">
  <xsl:value-of select="111111 + UC020Row[CD_PERGUNTA='UC020_t1p03']/RESPOSTA_EXT"></xsl:value-of>
 </xsl:variable>
 <xsl:variable name="pergunta4">
  <xsl:value-of select="111111 + UC020Row[CD_PERGUNTA='UC020_t1p04']/RESPOSTA_EXT"></xsl:value-of>
 </xsl:variable>
 <xsl:variable name="pergunta5">
  <xsl:value-of select="111111 + UC020Row[CD_PERGUNTA='UC020_t1p05']/RESPOSTA_EXT"></xsl:value-of>
 </xsl:variable>
 <xsl:variable name="pergunta6">
  <xsl:value-of select="111111 + UC020Row[CD_PERGUNTA='UC020_t2p06']/RESPOSTA_EXT"></xsl:value-of>
 </xsl:variable>
 <xsl:variable name="pergunta7">
  <xsl:value-of select="111111 + UC020Row[CD_PERGUNTA='UC020_t2p07']/RESPOSTA_EXT"></xsl:value-of>
 </xsl:variable>
 <xsl:variable name="pergunta8">
  <xsl:value-of select="111111 + UC020Row[CD_PERGUNTA='UC020_t2p08']/RESPOSTA_EXT"></xsl:value-of>
 </xsl:variable>
 <xsl:variable name="pergunta9">
  <xsl:value-of select="111111 + UC020Row[CD_PERGUNTA='UC020_t2p09']/RESPOSTA_EXT"></xsl:value-of>
 </xsl:variable>
 <xsl:variable name="pergunta10">
  <xsl:value-of select="111111 + UC020Row[CD_PERGUNTA='UC020_t2p10']/RESPOSTA_EXT"></xsl:value-of>
 </xsl:variable>
 <xsl:variable name="pergunta11">
  <xsl:value-of select="111111 + UC020Row[CD_PERGUNTA='UC020_t2p11']/RESPOSTA_EXT"></xsl:value-of>
 </xsl:variable>

 <!-- INICIO 16 - Publicao do Relatrio Resumido da Execuo Oramentria - RREO -->
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 
 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" />
  <fo:table-body>
   <fo:table-row>
    <fo:table-cell>
     <fo:block xsl:use-attribute-sets="titFCinza">
      <xsl:text>16 - Publicao do Relatrio Resumido da Execuo Oramentria - RREO</xsl:text>
     </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-body>
 </fo:table>

 <fo:block><fo:leader leader-pattern="space"/></fo:block>

 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="556pt"/>

  <fo:table-body >	   
    <fo:table-row>								
     <fo:table-cell>
	  <fo:block xsl:use-attribute-sets="txtJustifyMed" text-align="justify" margin-left="15pt" hyphenate="true" >
       <!-- Segundo pargrafo do Relatrio -->        
	    <fo:block>O quadro a seguir demonstra os bimestres em que foram efetuadas as publicaes e divulgaes bimestrais dos Relatrios Resumidos de Execuo Oramentria - RREO, bem como o cumprimento do prazo fixado no art. 52 da LRF e a observncia dos modelos da STN.</fo:block>
		<fo:block><fo:leader leader-pattern="space"/></fo:block>
  		<xsl:if test="../../Header/Informacoes/InformacoesRow/NRO_HABITANTES &lt; 50000">
   			<fo:block>Considerando que o municpio possui menos de 50.000 habitantes, o Poder Executivo poder optar pela publicao do RREO no jornal ou pela afixao no Mural, sendo obrigatria a disponibilizao via Internet.</fo:block>
  		</xsl:if>  
      </fo:block>
     </fo:table-cell>
    </fo:table-row>   	
  </fo:table-body>
 </fo:table> 

 
 <fo:block><fo:leader leader-pattern="space"/></fo:block>

 <fo:table table-layout="fixed" width="556pt">
	<fo:table-column column-width="256pt"/>
	<fo:table-column column-width="50pt"/>
	<fo:table-column column-width="50pt"/>
	<fo:table-column column-width="50pt"/>
	<fo:table-column column-width="50pt"/>
	<fo:table-column column-width="50pt"/>
	<fo:table-column column-width="50pt"/>

  <fo:table-body>  
	<fo:table-row>
	  <fo:table-cell padding-left="10pt" xsl:use-attribute-sets="bordas">
		<fo:block xsl:use-attribute-sets="titNegrito" text-align="left">     </fo:block>
	  </fo:table-cell>
	  <fo:table-cell xsl:use-attribute-sets="bordas">
		<fo:block xsl:use-attribute-sets="txtCenter">1 Bimestre</fo:block>
	  </fo:table-cell>
  	  <fo:table-cell xsl:use-attribute-sets="bordas">
		<fo:block xsl:use-attribute-sets="txtCenter">2 Bimestre</fo:block>
	  </fo:table-cell>
  	  <fo:table-cell xsl:use-attribute-sets="bordas">
		<fo:block xsl:use-attribute-sets="txtCenter">3 Bimestre</fo:block>
	  </fo:table-cell>
  	  <fo:table-cell xsl:use-attribute-sets="bordas">
		<fo:block xsl:use-attribute-sets="txtCenter">4 Bimestre</fo:block>
	  </fo:table-cell>
  	  <fo:table-cell xsl:use-attribute-sets="bordas">
		<fo:block xsl:use-attribute-sets="txtCenter">5 Bimestre</fo:block>
	  </fo:table-cell>
  	  <fo:table-cell xsl:use-attribute-sets="bordas">
		<fo:block xsl:use-attribute-sets="txtCenter">6 Bimestre</fo:block>
	  </fo:table-cell>
    </fo:table-row>

    <fo:table-row>
	  <fo:table-cell xsl:use-attribute-sets="bordas" number-columns-spanned="7">
		<fo:block xsl:use-attribute-sets="txtLeft">Quanto a fixao em mural:</fo:block>
	  </fo:table-cell>
    </fo:table-row>

	<fo:table-row>
	  <fo:table-cell xsl:use-attribute-sets="bordas" padding-left="10pt">
		<fo:block xsl:use-attribute-sets="txtLeft" text-align="left">o RREO foi fixado em mural?</fo:block>
	  </fo:table-cell>
	  <fo:table-cell xsl:use-attribute-sets="bordas" padding-left="10pt">
		<fo:block xsl:use-attribute-sets="txtCenter" text-align="center"><xsl:value-of select="$perg3bim1"/></fo:block>
	  </fo:table-cell>
	  <fo:table-cell xsl:use-attribute-sets="bordas" padding-left="10pt">
		<fo:block xsl:use-attribute-sets="txtCenter" text-align="center"><xsl:value-of select="$perg3bim2"/></fo:block>
	  </fo:table-cell>
	  <fo:table-cell xsl:use-attribute-sets="bordas" padding-left="10pt">
		<fo:block xsl:use-attribute-sets="txtCenter" text-align="center"><xsl:value-of select="$perg3bim3"/></fo:block>
	  </fo:table-cell>
	  <fo:table-cell xsl:use-attribute-sets="bordas" padding-left="10pt">
		<fo:block xsl:use-attribute-sets="txtCenter" text-align="center"><xsl:value-of select="$perg3bim4"/></fo:block>
	  </fo:table-cell>
	  <fo:table-cell xsl:use-attribute-sets="bordas" padding-left="10pt">
		<fo:block xsl:use-attribute-sets="txtCenter" text-align="center"><xsl:value-of select="$perg3bim5"/></fo:block>
	  </fo:table-cell>
	  <fo:table-cell xsl:use-attribute-sets="bordas" padding-left="10pt">
		<fo:block xsl:use-attribute-sets="txtCenter" text-align="center"><xsl:value-of select="$perg3bim6"/></fo:block>
	  </fo:table-cell>
	</fo:table-row>

	<fo:table-row>
	  <fo:table-cell xsl:use-attribute-sets="bordas" padding-left="10pt">
		<fo:block xsl:use-attribute-sets="txtLeft" text-align="left">Foi observado o prazo?</fo:block>
	  </fo:table-cell>
	  <fo:table-cell xsl:use-attribute-sets="bordas" padding-left="10pt">
		<fo:block xsl:use-attribute-sets="txtCenter" text-align="center"><xsl:value-of select="$perg4bim1"/></fo:block>
	  </fo:table-cell>
	  <fo:table-cell xsl:use-attribute-sets="bordas" padding-left="10pt">
		<fo:block xsl:use-attribute-sets="txtCenter" text-align="center"><xsl:value-of select="$perg4bim2"/></fo:block>
	  </fo:table-cell>
	  <fo:table-cell xsl:use-attribute-sets="bordas" padding-left="10pt">
		<fo:block xsl:use-attribute-sets="txtCenter" text-align="center"><xsl:value-of select="$perg4bim3"/></fo:block>
	  </fo:table-cell>
	  <fo:table-cell xsl:use-attribute-sets="bordas" padding-left="10pt">
		<fo:block xsl:use-attribute-sets="txtCenter" text-align="center"><xsl:value-of select="$perg4bim4"/></fo:block>
	  </fo:table-cell>
	  <fo:table-cell xsl:use-attribute-sets="bordas" padding-left="10pt">
		<fo:block xsl:use-attribute-sets="txtCenter" text-align="center"><xsl:value-of select="$perg4bim5"/></fo:block>
	  </fo:table-cell>
	  <fo:table-cell xsl:use-attribute-sets="bordas" padding-left="10pt">
		<fo:block xsl:use-attribute-sets="txtCenter" text-align="center"><xsl:value-of select="$perg4bim6"/></fo:block>
	  </fo:table-cell>
	</fo:table-row>

	<fo:table-row>
	  <fo:table-cell xsl:use-attribute-sets="bordas" padding-left="10pt">
		<fo:block xsl:use-attribute-sets="txtLeft" text-align="left">Foram observados os modelos da STN?</fo:block>
	  </fo:table-cell>
	  <fo:table-cell xsl:use-attribute-sets="bordas" padding-left="10pt">
		<fo:block xsl:use-attribute-sets="txtCenter" text-align="center"><xsl:value-of select="$perg5bim1"/></fo:block>
	  </fo:table-cell>
	  <fo:table-cell xsl:use-attribute-sets="bordas" padding-left="10pt">
		<fo:block xsl:use-attribute-sets="txtCenter" text-align="center"><xsl:value-of select="$perg5bim2"/></fo:block>
	  </fo:table-cell>
	  <fo:table-cell xsl:use-attribute-sets="bordas" padding-left="10pt">
		<fo:block xsl:use-attribute-sets="txtCenter" text-align="center"><xsl:value-of select="$perg5bim3"/></fo:block>
	  </fo:table-cell>
	  <fo:table-cell xsl:use-attribute-sets="bordas" padding-left="10pt">
		<fo:block xsl:use-attribute-sets="txtCenter" text-align="center"><xsl:value-of select="$perg5bim4"/></fo:block>
	  </fo:table-cell>
	  <fo:table-cell xsl:use-attribute-sets="bordas" padding-left="10pt">
		<fo:block xsl:use-attribute-sets="txtCenter" text-align="center"><xsl:value-of select="$perg5bim5"/></fo:block>
	  </fo:table-cell>
	  <fo:table-cell xsl:use-attribute-sets="bordas" padding-left="10pt">
		<fo:block xsl:use-attribute-sets="txtCenter" text-align="center"><xsl:value-of select="$perg5bim6"/></fo:block>
	  </fo:table-cell>
	</fo:table-row>

    <fo:table-row>
	  <fo:table-cell xsl:use-attribute-sets="bordas" number-columns-spanned="7">
		<fo:block xsl:use-attribute-sets="txtLeft">Quanto  divulgao, em jornal ou Dirio Oficial do Municpio:</fo:block>
	  </fo:table-cell>
    </fo:table-row>

	<fo:table-row>
	  <fo:table-cell xsl:use-attribute-sets="bordas" padding-left="10pt">
		<fo:block xsl:use-attribute-sets="txtLeft" text-align="left">o RREO foi divulgado em jornal ou Dirio Oficial do Municpio?</fo:block>
	  </fo:table-cell>
	  <fo:table-cell xsl:use-attribute-sets="bordas" padding-left="10pt">
		<fo:block xsl:use-attribute-sets="txtCenter" text-align="center"><xsl:value-of select="$perg6bim1"/></fo:block>
	  </fo:table-cell>
	  <fo:table-cell xsl:use-attribute-sets="bordas" padding-left="10pt">
		<fo:block xsl:use-attribute-sets="txtCenter" text-align="center"><xsl:value-of select="$perg6bim2"/></fo:block>
	  </fo:table-cell>
	  <fo:table-cell xsl:use-attribute-sets="bordas" padding-left="10pt">
		<fo:block xsl:use-attribute-sets="txtCenter" text-align="center"><xsl:value-of select="$perg6bim3"/></fo:block>
	  </fo:table-cell>
	  <fo:table-cell xsl:use-attribute-sets="bordas" padding-left="10pt">
		<fo:block xsl:use-attribute-sets="txtCenter" text-align="center"><xsl:value-of select="$perg6bim4"/></fo:block>
	  </fo:table-cell>
	  <fo:table-cell xsl:use-attribute-sets="bordas" padding-left="10pt">
		<fo:block xsl:use-attribute-sets="txtCenter" text-align="center"><xsl:value-of select="$perg6bim5"/></fo:block>
	  </fo:table-cell>
	  <fo:table-cell xsl:use-attribute-sets="bordas" padding-left="10pt">
		<fo:block xsl:use-attribute-sets="txtCenter" text-align="center"><xsl:value-of select="$perg6bim6"/></fo:block>
	  </fo:table-cell>
	</fo:table-row>

	<fo:table-row>
	  <fo:table-cell xsl:use-attribute-sets="bordas" padding-left="10pt">
		<fo:block xsl:use-attribute-sets="txtLeft" text-align="left">Foi observado o prazo?</fo:block>
	  </fo:table-cell>
	  <fo:table-cell xsl:use-attribute-sets="bordas" padding-left="10pt">
		<fo:block xsl:use-attribute-sets="txtCenter" text-align="center"><xsl:value-of select="$perg7bim1"/></fo:block>
	  </fo:table-cell>
	  <fo:table-cell xsl:use-attribute-sets="bordas" padding-left="10pt">
		<fo:block xsl:use-attribute-sets="txtCenter" text-align="center"><xsl:value-of select="$perg7bim2"/></fo:block>
	  </fo:table-cell>
	  <fo:table-cell xsl:use-attribute-sets="bordas" padding-left="10pt">
		<fo:block xsl:use-attribute-sets="txtCenter" text-align="center"><xsl:value-of select="$perg7bim3"/></fo:block>
	  </fo:table-cell>
	  <fo:table-cell xsl:use-attribute-sets="bordas" padding-left="10pt">
		<fo:block xsl:use-attribute-sets="txtCenter" text-align="center"><xsl:value-of select="$perg7bim4"/></fo:block>
	  </fo:table-cell>
	  <fo:table-cell xsl:use-attribute-sets="bordas" padding-left="10pt">
		<fo:block xsl:use-attribute-sets="txtCenter" text-align="center"><xsl:value-of select="$perg7bim5"/></fo:block>
	  </fo:table-cell>
	  <fo:table-cell xsl:use-attribute-sets="bordas" padding-left="10pt">
		<fo:block xsl:use-attribute-sets="txtCenter" text-align="center"><xsl:value-of select="$perg7bim6"/></fo:block>
	  </fo:table-cell>
	</fo:table-row>

	<fo:table-row>
	  <fo:table-cell xsl:use-attribute-sets="bordas" padding-left="10pt">
		<fo:block xsl:use-attribute-sets="txtLeft" text-align="left">Foram observados os modelos da STN?</fo:block>
	  </fo:table-cell>
	  <fo:table-cell xsl:use-attribute-sets="bordas" padding-left="10pt">
		<fo:block xsl:use-attribute-sets="txtCenter" text-align="center"><xsl:value-of select="$perg8bim1"/></fo:block>
	  </fo:table-cell>
	  <fo:table-cell xsl:use-attribute-sets="bordas" padding-left="10pt">
		<fo:block xsl:use-attribute-sets="txtCenter" text-align="center"><xsl:value-of select="$perg8bim2"/></fo:block>
	  </fo:table-cell>
	  <fo:table-cell xsl:use-attribute-sets="bordas" padding-left="10pt">
		<fo:block xsl:use-attribute-sets="txtCenter" text-align="center"><xsl:value-of select="$perg8bim3"/></fo:block>
	  </fo:table-cell>
	  <fo:table-cell xsl:use-attribute-sets="bordas" padding-left="10pt">
		<fo:block xsl:use-attribute-sets="txtCenter" text-align="center"><xsl:value-of select="$perg8bim4"/></fo:block>
	  </fo:table-cell>
	  <fo:table-cell xsl:use-attribute-sets="bordas" padding-left="10pt">
		<fo:block xsl:use-attribute-sets="txtCenter" text-align="center"><xsl:value-of select="$perg8bim5"/></fo:block>
	  </fo:table-cell>
	  <fo:table-cell xsl:use-attribute-sets="bordas" padding-left="10pt">
		<fo:block xsl:use-attribute-sets="txtCenter" text-align="center"><xsl:value-of select="$perg8bim6"/></fo:block>
	  </fo:table-cell>
	</fo:table-row>

    <fo:table-row>
	  <fo:table-cell xsl:use-attribute-sets="bordas" number-columns-spanned="7">
		<fo:block xsl:use-attribute-sets="txtLeft">Quanto a disponibilizao na Internet:</fo:block>
	  </fo:table-cell>
    </fo:table-row>

	<fo:table-row>
	  <fo:table-cell xsl:use-attribute-sets="bordas" padding-left="10pt">
		<fo:block xsl:use-attribute-sets="txtLeft" text-align="left">o RREO foi disponibilizado na internet?</fo:block>
	  </fo:table-cell>
	  <fo:table-cell xsl:use-attribute-sets="bordas" padding-left="10pt">
		<fo:block xsl:use-attribute-sets="txtCenter" text-align="center"><xsl:value-of select="$perg9bim1"/></fo:block>
	  </fo:table-cell>
	  <fo:table-cell xsl:use-attribute-sets="bordas" padding-left="10pt">
		<fo:block xsl:use-attribute-sets="txtCenter" text-align="center"><xsl:value-of select="$perg9bim2"/></fo:block>
	  </fo:table-cell>
	  <fo:table-cell xsl:use-attribute-sets="bordas" padding-left="10pt">
		<fo:block xsl:use-attribute-sets="txtCenter" text-align="center"><xsl:value-of select="$perg9bim3"/></fo:block>
	  </fo:table-cell>
	  <fo:table-cell xsl:use-attribute-sets="bordas" padding-left="10pt">
		<fo:block xsl:use-attribute-sets="txtCenter" text-align="center"><xsl:value-of select="$perg9bim4"/></fo:block>
	  </fo:table-cell>
	  <fo:table-cell xsl:use-attribute-sets="bordas" padding-left="10pt">
		<fo:block xsl:use-attribute-sets="txtCenter" text-align="center"><xsl:value-of select="$perg9bim5"/></fo:block>
	  </fo:table-cell>
	  <fo:table-cell xsl:use-attribute-sets="bordas" padding-left="10pt">
		<fo:block xsl:use-attribute-sets="txtCenter" text-align="center"><xsl:value-of select="$perg9bim6"/></fo:block>
	  </fo:table-cell>
	</fo:table-row>

	<fo:table-row>
	  <fo:table-cell xsl:use-attribute-sets="bordas" padding-left="10pt">
		<fo:block xsl:use-attribute-sets="txtLeft" text-align="left">Foi observado o prazo?</fo:block>
	  </fo:table-cell>
	  <fo:table-cell xsl:use-attribute-sets="bordas" padding-left="10pt">
		<fo:block xsl:use-attribute-sets="txtCenter" text-align="center"><xsl:value-of select="$perg10bim1"/></fo:block>
	  </fo:table-cell>
	  <fo:table-cell xsl:use-attribute-sets="bordas" padding-left="10pt">
		<fo:block xsl:use-attribute-sets="txtCenter" text-align="center"><xsl:value-of select="$perg10bim2"/></fo:block>
	  </fo:table-cell>
	  <fo:table-cell xsl:use-attribute-sets="bordas" padding-left="10pt">
		<fo:block xsl:use-attribute-sets="txtCenter" text-align="center"><xsl:value-of select="$perg10bim3"/></fo:block>
	  </fo:table-cell>
	  <fo:table-cell xsl:use-attribute-sets="bordas" padding-left="10pt">
		<fo:block xsl:use-attribute-sets="txtCenter" text-align="center"><xsl:value-of select="$perg10bim4"/></fo:block>
	  </fo:table-cell>
	  <fo:table-cell xsl:use-attribute-sets="bordas" padding-left="10pt">
		<fo:block xsl:use-attribute-sets="txtCenter" text-align="center"><xsl:value-of select="$perg10bim5"/></fo:block>
	  </fo:table-cell>
	  <fo:table-cell xsl:use-attribute-sets="bordas" padding-left="10pt">
		<fo:block xsl:use-attribute-sets="txtCenter" text-align="center"><xsl:value-of select="$perg10bim6"/></fo:block>
	  </fo:table-cell>
	</fo:table-row>

	<fo:table-row>
	  <fo:table-cell xsl:use-attribute-sets="bordas" padding-left="10pt">
		<fo:block xsl:use-attribute-sets="txtLeft" text-align="left">Foram observados os modelos da STN?</fo:block>
	  </fo:table-cell>
	  <fo:table-cell xsl:use-attribute-sets="bordas" padding-left="10pt">
		<fo:block xsl:use-attribute-sets="txtCenter" text-align="center"><xsl:value-of select="$perg11bim1"/></fo:block>
	  </fo:table-cell>
	  <fo:table-cell xsl:use-attribute-sets="bordas" padding-left="10pt">
		<fo:block xsl:use-attribute-sets="txtCenter" text-align="center"><xsl:value-of select="$perg11bim2"/></fo:block>
	  </fo:table-cell>
	  <fo:table-cell xsl:use-attribute-sets="bordas" padding-left="10pt">
		<fo:block xsl:use-attribute-sets="txtCenter" text-align="center"><xsl:value-of select="$perg11bim3"/></fo:block>
	  </fo:table-cell>
	  <fo:table-cell xsl:use-attribute-sets="bordas" padding-left="10pt">
		<fo:block xsl:use-attribute-sets="txtCenter" text-align="center"><xsl:value-of select="$perg11bim4"/></fo:block>
	  </fo:table-cell>
	  <fo:table-cell xsl:use-attribute-sets="bordas" padding-left="10pt">
		<fo:block xsl:use-attribute-sets="txtCenter" text-align="center"><xsl:value-of select="$perg11bim5"/></fo:block>
	  </fo:table-cell>
	  <fo:table-cell xsl:use-attribute-sets="bordas" padding-left="10pt">
		<fo:block xsl:use-attribute-sets="txtCenter" text-align="center"><xsl:value-of select="$perg11bim6"/></fo:block>
	  </fo:table-cell>
	</fo:table-row>

  </fo:table-body>  

 </fo:table>
 
 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="556pt"/>


  <fo:table-body >	   
    <fo:table-row>								
     <fo:table-cell>
	  <fo:block xsl:use-attribute-sets="txtJustifyMed" text-align="justify" margin-left="15pt" hyphenate="true" >
      </fo:block>
     </fo:table-cell>
    </fo:table-row>   	
  </fo:table-body>
 </fo:table> 
  
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 
 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="556pt"/>

  <fo:table-body >	   
    <fo:table-row>								
     <fo:table-cell>
	  <fo:block xsl:use-attribute-sets="txtJustifyMed" text-align="justify" margin-left="15pt" hyphenate="true" >
       <xsl:if test="../../Observacoes/ObservacoesRemessas/ObservacoesRemessasRow[CD_OBSERVACOES='UC020']/OBSERVACOES!=''">
        <fo:inline font-weight="bold">Observaes: </fo:inline><xsl:value-of select="../../Observacoes/ObservacoesRemessas/ObservacoesRemessasRow[CD_OBSERVACOES='UC020']/OBSERVACOES"></xsl:value-of>
       </xsl:if>
       <xsl:if test="../../Observacoes/ObservacoesRemessas/ObservacoesRemessasRow[CD_OBSERVACOES='UC020']/OBSERVACOES=''">
        <fo:inline font-style="italic">No foram inseridas observaes para este item.</fo:inline>
       </xsl:if>
      </fo:block>
     </fo:table-cell>
    </fo:table-row>   	
  </fo:table-body>
 </fo:table> 
 <!-- FIM    UC020  --> 
</xsl:template>

<!--
###############################################
##     17 - Publicao do Rel. Gesto Fiscal ##
###############################################
-->
<xsl:template match="UC021">

 <!--Varivel de exibio do Modelo - 21 -->
 <xsl:variable name="poder">
  <xsl:if test="../../Header/Informacoes/InformacoesRow/PODER='C'">
   <xsl:value-of select="' Poder Legislativo'"></xsl:value-of>
  </xsl:if>
  <xsl:if test="../../Header/Informacoes/InformacoesRow/PODER='P'">
   <xsl:value-of select="' Poder Executivo'"></xsl:value-of>
  </xsl:if>
 </xsl:variable>
 
 <!-- INICIO 21 - Publicao do Relatorio de Gesto Fiscal -->
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 
 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" />
  <fo:table-body>
   <fo:table-row>
    <fo:table-cell>
     <fo:block xsl:use-attribute-sets="titFCinza">
      <xsl:text>17 - Publicao do Relatrio de Gesto Fiscal</xsl:text>
     </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-body>
 </fo:table>
 
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 
 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="556pt"/>

  <fo:table-body >	   
    <fo:table-row>								
     <fo:table-cell>
	  <!--Primeiro Pargrafo-->
	  <fo:block xsl:use-attribute-sets="txtJustifyMed" text-align="justify" margin-left="15pt" hyphenate="true" >
          <!--Verifica se o nmero de habitantes  maior que 50.000-->
		  <xsl:if test="../../Header/Informacoes/InformacoesRow/NRO_HABITANTES &gt; 49999">
			<!--Regras Novas - Desenvolvimento-->
			<xsl:if test="((UC021Row[CD_PERGUNTA='UC021_t1p03']/RESPOSTA='S') and (UC021Row[CD_PERGUNTA='UC021_t2p06']/RESPOSTA='S') and (UC021Row[CD_PERGUNTA='UC021_t2p09']/RESPOSTA='S'))">
				<!--Cumpriu, texto que todos esto OK-->
				<xsl:if test="((UC021Row[CD_PERGUNTA='UC021_t1p04']/RESPOSTA='S') and 
				               (UC021Row[CD_PERGUNTA='UC021_t1p05']/RESPOSTA='S') and 
				               (UC021Row[CD_PERGUNTA='UC021_t2p07']/RESPOSTA='S') and 
				               (UC021Row[CD_PERGUNTA='UC021_t2p08']/RESPOSTA='S') and 
				               (UC021Row[CD_PERGUNTA='UC021_t2p10']/RESPOSTA='S') and 
				               (UC021Row[CD_PERGUNTA='UC021_t2p11']/RESPOSTA='S'))">
					As publicaes e divulgaes dos Relatrios de Gesto Fiscal - RGF, relativas ao <xsl:value-of select="../../Header/Informacoes/InformacoesRow/DS_PERIODO"/> de <xsl:value-of select="../../Header/Informacoes/InformacoesRow/ANO_EXERCICIO"/>, foram efetuadas pelo <xsl:value-of select="$poder"/> conforme estabelecido nas Resolues e Instrues Normativas do TCE-RS e na forma do disposto nas Portarias da STN, no prazo fixado no  2 do art. 55 da LRF.
				</xsl:if>				

				<!--Se pelo menos alguma resposta for no-->
				<xsl:if test="((UC021Row[CD_PERGUNTA='UC021_t1p04']/RESPOSTA='N') or 
				               (UC021Row[CD_PERGUNTA='UC021_t1p05']/RESPOSTA='N') or 
				               (UC021Row[CD_PERGUNTA='UC021_t2p07']/RESPOSTA='N') or 
				               (UC021Row[CD_PERGUNTA='UC021_t2p08']/RESPOSTA='N') or 
				               (UC021Row[CD_PERGUNTA='UC021_t2p10']/RESPOSTA='N') or 
				               (UC021Row[CD_PERGUNTA='UC021_t2p11']/RESPOSTA='N'))">
					<!--Texto em que algumas das situaes tem como resposta No-->
					As publicaes e divulgaes dos Relatrios de Gesto Fiscal - RGF, relativas ao <xsl:value-of select="../../Header/Informacoes/InformacoesRow/DS_PERIODO"/> de <xsl:value-of select="../../Header/Informacoes/InformacoesRow/ANO_EXERCICIO"/>, foram efetuadas pelo <xsl:value-of select="$poder"/> conforme estabelecido nas Resolues e Instrues Normativas do TCE-RS, 
					<!--No Observao do prazo-->
					<xsl:if test="((UC021Row[CD_PERGUNTA='UC021_t1p04']/RESPOSTA='N') or (UC021Row[CD_PERGUNTA='UC021_t2p07']/RESPOSTA='N') or (UC021Row[CD_PERGUNTA='UC021_t2p10']/RESPOSTA='N'))">
						entretanto no foi observado o prazo fixado no  2 do art. 55 da LRF em todas as situaes.	
					</xsl:if>
					<!--Observao do prazo-->
					<xsl:if test="((UC021Row[CD_PERGUNTA='UC021_t1p04']/RESPOSTA='S') and (UC021Row[CD_PERGUNTA='UC021_t2p07']/RESPOSTA='S') and (UC021Row[CD_PERGUNTA='UC021_t2p10']/RESPOSTA='S'))">
						sendo observado o prazo fixado no  2 do art. 55 da LRF em todas as situaes.	
					</xsl:if>
					<!--No Observao dos modelos-->
					<xsl:if test="((UC021Row[CD_PERGUNTA='UC021_t1p05']/RESPOSTA='N') or (UC021Row[CD_PERGUNTA='UC021_t2p08']/RESPOSTA='N') or (UC021Row[CD_PERGUNTA='UC021_t2p11']/RESPOSTA='N'))">
						Os modelos da STN no foram observados em todas as publicaes e divulgaes realizadas.
					</xsl:if>
					<!--Observao dos modelos-->
					<xsl:if test="((UC021Row[CD_PERGUNTA='UC021_t1p05']/RESPOSTA='S') and (UC021Row[CD_PERGUNTA='UC021_t2p08']/RESPOSTA='S') and (UC021Row[CD_PERGUNTA='UC021_t2p11']/RESPOSTA='S'))">
						Os modelos da STN foram observados em todas as publicaes e divulgaes realizadas.
					</xsl:if>
		    	</xsl:if>
			</xsl:if>				
			<!--No cumpriu-->
			<xsl:if test="((UC021Row[CD_PERGUNTA='UC021_t1p03']/RESPOSTA='N') or (UC021Row[CD_PERGUNTA='UC021_t2p06']/RESPOSTA='N') or (UC021Row[CD_PERGUNTA='UC021_t2p09']/RESPOSTA='N'))">
				<!--No Cumpriu-->
				As publicaes e divulgaes dos Relatrios de Gesto Fiscal - RGF, relativas ao <xsl:value-of select="../../Header/Informacoes/InformacoesRow/DS_PERIODO"/> de <xsl:value-of select="../../Header/Informacoes/InformacoesRow/ANO_EXERCICIO"/>, no foram efetuadas pelo <xsl:value-of select="$poder"/> conforme estabelecido nas Resolues e Instrues Normativas do TCE-RS e na forma do disposto nas Portarias da STN, no prazo fixado no  2 do art. 55 da LRF.
		    </xsl:if>			
		  </xsl:if>		
          <!--Verifica se o nmero de habitantes  menor que 50.000-->
		  <xsl:if test="../../Header/Informacoes/InformacoesRow/NRO_HABITANTES &lt; 50000">
			<!--Cumpriu-->
			<xsl:if test="(((UC021Row[CD_PERGUNTA='UC021_t1p03']/RESPOSTA='S') and (UC021Row[CD_PERGUNTA='UC021_t2p09']/RESPOSTA='S')) or
						   ((UC021Row[CD_PERGUNTA='UC021_t2p06']/RESPOSTA='S') and (UC021Row[CD_PERGUNTA='UC021_t2p09']/RESPOSTA='S')))">

				<!--Se todas as respostas necessrias forem sim - Cumpriu-->
				<xsl:if test="((UC021Row[CD_PERGUNTA='UC021_t2p10']/RESPOSTA='S') and 
				               (UC021Row[CD_PERGUNTA='UC021_t2p11']/RESPOSTA='S') and 
				               (((UC021Row[CD_PERGUNTA='UC021_t1p04']/RESPOSTA='S') and 
				               (UC021Row[CD_PERGUNTA='UC021_t1p05']/RESPOSTA='S')) or 
				               ((UC021Row[CD_PERGUNTA='UC021_t2p07']/RESPOSTA='S') and 
				               (UC021Row[CD_PERGUNTA='UC021_t2p08']/RESPOSTA='S'))))">
					As publicaes e divulgaes dos Relatrios de Gesto Fiscal - RGF, relativas ao <xsl:value-of select="../../Header/Informacoes/InformacoesRow/DS_PERIODO"/> de <xsl:value-of select="../../Header/Informacoes/InformacoesRow/ANO_EXERCICIO"/>, foram efetuadas pelo <xsl:value-of select="$poder"/> conforme estabelecido nas Resolues e Instrues Normativas do TCE-RS e na forma do disposto nas Portarias da STN, no prazo fixado no  2 do art. 55 da LRF.				
				</xsl:if>
				
				<!--Se pelo menos alguma resposta for no-->
				<xsl:if test="not ((UC021Row[CD_PERGUNTA='UC021_t2p10']/RESPOSTA='S') and 
				                   (UC021Row[CD_PERGUNTA='UC021_t2p11']/RESPOSTA='S') and 
				                   (((UC021Row[CD_PERGUNTA='UC021_t1p04']/RESPOSTA='S') and 
				                     (UC021Row[CD_PERGUNTA='UC021_t1p05']/RESPOSTA='S')) or 
				                    ((UC021Row[CD_PERGUNTA='UC021_t2p07']/RESPOSTA='S') and 
				                     (UC021Row[CD_PERGUNTA='UC021_t2p08']/RESPOSTA='S'))))">
					<!--Cumpriu-->
					As publicaes e divulgaes dos Relatrios de Gesto Fiscal - RGF, relativas ao <xsl:value-of select="../../Header/Informacoes/InformacoesRow/DS_PERIODO"/> de <xsl:value-of select="../../Header/Informacoes/InformacoesRow/ANO_EXERCICIO"/>, foram efetuadas pelo <xsl:value-of select="$poder"/> conforme estabelecido nas Resolues e Instrues Normativas do TCE-RS, 

					<!--No Observao do prazo-->
  			    	<xsl:if test="((((UC021Row[CD_PERGUNTA='UC021_t1p04']/RESPOSTA='N') or (UC021Row[CD_PERGUNTA='UC021_t1p04']/RESPOSTA='X')) and ((UC021Row[CD_PERGUNTA='UC021_t2p07']/RESPOSTA='N') or (UC021Row[CD_PERGUNTA='UC021_t2p07']/RESPOSTA='X'))) or
								   (((UC021Row[CD_PERGUNTA='UC021_t1p04']/RESPOSTA='N') or (UC021Row[CD_PERGUNTA='UC021_t1p04']/RESPOSTA='X')) and ((UC021Row[CD_PERGUNTA='UC021_t2p10']/RESPOSTA='N') or (UC021Row[CD_PERGUNTA='UC021_t2p10']/RESPOSTA='X'))) or
							       (((UC021Row[CD_PERGUNTA='UC021_t2p07']/RESPOSTA='N') or (UC021Row[CD_PERGUNTA='UC021_t2p07']/RESPOSTA='X')) and ((UC021Row[CD_PERGUNTA='UC021_t2p10']/RESPOSTA='N') or (UC021Row[CD_PERGUNTA='UC021_t2p10']/RESPOSTA='X'))))">
						entretanto no foi observado o prazo fixado no  2 do art. 55 da LRF em todas as situaes.	
					</xsl:if>
					<!--Observao do prazo-->
  			    	<xsl:if test="(((UC021Row[CD_PERGUNTA='UC021_t1p04']/RESPOSTA='S') and (UC021Row[CD_PERGUNTA='UC021_t2p10']/RESPOSTA='S')) or
							       ((UC021Row[CD_PERGUNTA='UC021_t2p07']/RESPOSTA='S') and (UC021Row[CD_PERGUNTA='UC021_t2p10']/RESPOSTA='S')))">
						sendo observado o prazo fixado no  2 do art. 55 da LRF em todas as situaes.	
					</xsl:if>
					<!--No Observao do prazo ** CASO ESPECIAL ** -->
  			    	<xsl:if test="((UC021Row[CD_PERGUNTA='UC021_t2p10']/RESPOSTA='N') and 
					               (UC021Row[CD_PERGUNTA='UC021_t2p07']/RESPOSTA='S') and 
								   (UC021Row[CD_PERGUNTA='UC021_t1p04']/RESPOSTA='S'))">
						entretanto no foi observado o prazo fixado no  2 do art. 55 da LRF em todas as situaes.	
					</xsl:if>

					<!--No Observao dos modelos-->
  			    	<xsl:if test="((((UC021Row[CD_PERGUNTA='UC021_t1p05']/RESPOSTA='N') or (UC021Row[CD_PERGUNTA='UC021_t1p05']/RESPOSTA='X')) and ((UC021Row[CD_PERGUNTA='UC021_t2p08']/RESPOSTA='N') or (UC021Row[CD_PERGUNTA='UC021_t2p08']/RESPOSTA='X'))) or
								   (((UC021Row[CD_PERGUNTA='UC021_t1p05']/RESPOSTA='N') or (UC021Row[CD_PERGUNTA='UC021_t1p05']/RESPOSTA='X')) and ((UC021Row[CD_PERGUNTA='UC021_t2p11']/RESPOSTA='N') or (UC021Row[CD_PERGUNTA='UC021_t2p11']/RESPOSTA='X'))) or
							       (((UC021Row[CD_PERGUNTA='UC021_t2p08']/RESPOSTA='N') or (UC021Row[CD_PERGUNTA='UC021_t2p08']/RESPOSTA='X')) and ((UC021Row[CD_PERGUNTA='UC021_t2p11']/RESPOSTA='N') or (UC021Row[CD_PERGUNTA='UC021_t2p11']/RESPOSTA='X'))))">
						Os modelos da STN no foram observados em todas as publicaes e divulgaes realizadas.
					</xsl:if>
					<!--Observao dos modelos-->
  			    	<xsl:if test="(((UC021Row[CD_PERGUNTA='UC021_t1p05']/RESPOSTA='S') and (UC021Row[CD_PERGUNTA='UC021_t2p11']/RESPOSTA='S')) or
							       ((UC021Row[CD_PERGUNTA='UC021_t2p08']/RESPOSTA='S') and (UC021Row[CD_PERGUNTA='UC021_t2p11']/RESPOSTA='S')))">
						Os modelos da STN foram observados em todas as publicaes e divulgaes realizadas.
					</xsl:if>
					<!--No Observao dos modelos ** CASO ESPECIAL ** -->
  			    	<xsl:if test="((UC021Row[CD_PERGUNTA='UC021_t2p11']/RESPOSTA='N') and 
					               (UC021Row[CD_PERGUNTA='UC021_t2p08']/RESPOSTA='S') and 
								   (UC021Row[CD_PERGUNTA='UC021_t1p05']/RESPOSTA='S'))">
						Os modelos da STN no foram observados em todas as publicaes e divulgaes realizadas.
					</xsl:if>
				</xsl:if>
			</xsl:if>
			<!--No cumpriu-->
			<xsl:if test="(((UC021Row[CD_PERGUNTA='UC021_t1p03']/RESPOSTA='N') and (UC021Row[CD_PERGUNTA='UC021_t2p09']/RESPOSTA='N')) or
						   ((UC021Row[CD_PERGUNTA='UC021_t1p03']/RESPOSTA='N') and (UC021Row[CD_PERGUNTA='UC021_t2p06']/RESPOSTA='N')) or
						   ((UC021Row[CD_PERGUNTA='UC021_t2p06']/RESPOSTA='N') and (UC021Row[CD_PERGUNTA='UC021_t2p09']/RESPOSTA='N')) or
						    (UC021Row[CD_PERGUNTA='UC021_t2p09']/RESPOSTA='N'))">
				<!--No Cumpriu-->
				As publicaes e divulgaes dos Relatrios de Gesto Fiscal - RGF, relativas ao <xsl:value-of select="../../Header/Informacoes/InformacoesRow/DS_PERIODO"/> de <xsl:value-of select="../../Header/Informacoes/InformacoesRow/ANO_EXERCICIO"/>, no foram efetuadas pelo <xsl:value-of select="$poder"/> conforme estabelecido nas Resolues e Instrues Normativas do TCE-RS e na forma do disposto nas Portarias da STN, no prazo fixado no  2 do art. 55 da LRF.
		    </xsl:if>			
		  </xsl:if>		
      </fo:block>
	  <!--Trmino do primeiro bloco-->
     </fo:table-cell>
    </fo:table-row>   	
  </fo:table-body>
 </fo:table> 
  
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 
 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="556pt"/>

  <fo:table-body >	   
    <fo:table-row>								
     <fo:table-cell>
	  <fo:block xsl:use-attribute-sets="txtJustifyMed" text-align="justify" margin-left="15pt" hyphenate="true" >
       <xsl:if test="../../Observacoes/ObservacoesRemessas/ObservacoesRemessasRow[CD_OBSERVACOES='UC021']/OBSERVACOES!=''">
        <fo:inline font-weight="bold">Observaes: </fo:inline><xsl:value-of select="../../Observacoes/ObservacoesRemessas/ObservacoesRemessasRow[CD_OBSERVACOES='UC021']/OBSERVACOES"></xsl:value-of>
       </xsl:if>
       <xsl:if test="../../Observacoes/ObservacoesRemessas/ObservacoesRemessasRow[CD_OBSERVACOES='UC021']/OBSERVACOES=''">
        <fo:inline font-style="italic">No foram inseridas observaes para este item.</fo:inline>
       </xsl:if>
      </fo:block>
     </fo:table-cell>
    </fo:table-row>   	
  </fo:table-body>
 </fo:table> 
 <!-- FIM    UC021  --> 
</xsl:template>

<!--
###############################################
# 19 - Inst. Prev. Ef. Arrecadao Tributos  ##
###############################################
-->
<xsl:template match="UC023">

 <xsl:variable name="perg1">
  <xsl:if test="UC023Row[CD_PERGUNTA='UC023_t1p01']/RESPOSTA='S'">
   <xsl:value-of select="'Houve '"></xsl:value-of>
  </xsl:if>
  <xsl:if test="UC023Row[CD_PERGUNTA='UC023_t1p01']/RESPOSTA='N'">
   <xsl:value-of select="'No houve '"></xsl:value-of>
  </xsl:if>
 </xsl:variable>
 <xsl:variable name="perg2">
  <xsl:if test="UC023Row[CD_PERGUNTA='UC023_t1p02']/RESPOSTA='S'">
   <xsl:value-of select="' observaram '"></xsl:value-of>
  </xsl:if>
  <xsl:if test="UC023Row[CD_PERGUNTA='UC023_t1p02']/RESPOSTA='N'">
   <xsl:value-of select="' no observaram '"></xsl:value-of>
  </xsl:if>
 </xsl:variable>
 <xsl:variable name="perg3">
  <xsl:if test="UC023Row[CD_PERGUNTA='UC023_t1p03']/RESPOSTA='S'">
   <xsl:value-of select="' consideraram '"></xsl:value-of>
  </xsl:if>
  <xsl:if test="UC023Row[CD_PERGUNTA='UC023_t1p03']/RESPOSTA='N'">
   <xsl:value-of select="' no consideraram '"></xsl:value-of>
  </xsl:if>
 </xsl:variable>
 <xsl:variable name="perg4">
  <xsl:if test="UC023Row[CD_PERGUNTA='UC023_t1p04']/RESPOSTA='S'">
   <xsl:value-of select="' foram '"></xsl:value-of>
  </xsl:if>
  <xsl:if test="UC023Row[CD_PERGUNTA='UC023_t1p04']/RESPOSTA='N'">
   <xsl:value-of select="' no foram '"></xsl:value-of>
  </xsl:if>
 </xsl:variable>

 <!-- INICIO 19 - Instituio, Previso e Efetiva Arrecadao de Tributos -->
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 
 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" />
  <fo:table-body>
   <fo:table-row>
    <fo:table-cell>
     <fo:block xsl:use-attribute-sets="titFCinza">
      <xsl:text>19 - Instituio, Previso e Efetiva Arrecadao de Tributos</xsl:text>
     </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-body>
 </fo:table>
 
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 
 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="556pt"/>

  <fo:table-body >	   
    <fo:table-row>								
     <fo:table-cell>
	  <fo:block xsl:use-attribute-sets="txtJustifyMed" text-align="justify" margin-left="15pt" hyphenate="true" >
       <!-- Primeira Resposta do Relatrio-->        
	     <xsl:value-of select="$perg1"/> a instituio, previso e efetiva arrecadao de todos os tributos da competncia constitucional do Municpio.   
         <fo:block><fo:leader leader-pattern="space"/></fo:block>
         As previses de receita <xsl:value-of select="$perg2"/> as normas tcnicas e legais, <xsl:value-of select="$perg3"/> os efeitos das alteraes da legislao, da variao do ndice de preos, do crescimento econmico ou de qualquer outro fator relevante e <xsl:value-of select="$perg4"/> acompanhadas de demonstrativo de sua evoluo nos ltimos trs anos, da projeo para os dois seguintes quele a que se referirem, e da metodologia de clculo e premissas utilizadas.
      </fo:block>
     </fo:table-cell>
    </fo:table-row>   	
  </fo:table-body>
 </fo:table> 
  
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 
 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="556pt"/>

  <fo:table-body >	   
    <fo:table-row>								
     <fo:table-cell>
	  <fo:block xsl:use-attribute-sets="txtJustifyMed" text-align="justify" margin-left="15pt" hyphenate="true" >
       <xsl:if test="../../Observacoes/ObservacoesRemessas/ObservacoesRemessasRow[CD_OBSERVACOES='UC023']/OBSERVACOES!=''">
        <fo:inline font-weight="bold">Observaes: </fo:inline><xsl:value-of select="../../Observacoes/ObservacoesRemessas/ObservacoesRemessasRow[CD_OBSERVACOES='UC023']/OBSERVACOES"></xsl:value-of>
       </xsl:if>
       <xsl:if test="../../Observacoes/ObservacoesRemessas/ObservacoesRemessasRow[CD_OBSERVACOES='UC023']/OBSERVACOES=''">
        <fo:inline font-style="italic">No foram inseridas observaes para este item.</fo:inline>
       </xsl:if>
      </fo:block>
     </fo:table-cell>
    </fo:table-row>   	
  </fo:table-body>
 </fo:table> 
 <!-- FIM    UC023  --> 
</xsl:template>

<!--
###############################################
#####   3 - Anexo de Metas Fiscais       ######
###############################################
-->
<xsl:template match="UC008">

 <xsl:variable name="perg1">
  <xsl:if test="UC008Row[CD_PERGUNTA='UC008_t1p01']/RESPOSTA='S'">
   <xsl:value-of select="' integrou '"></xsl:value-of>
  </xsl:if>
  <xsl:if test="UC008Row[CD_PERGUNTA='UC008_t1p01']/RESPOSTA='N'">
   <xsl:value-of select="' no integrou '"></xsl:value-of>
  </xsl:if>
 </xsl:variable>
 <xsl:variable name="perg2">
  <xsl:if test="UC008Row[CD_PERGUNTA='UC008_t2p01']/RESPOSTA='S'">
   <xsl:value-of select="' constaram '"></xsl:value-of>
  </xsl:if>
  <xsl:if test="UC008Row[CD_PERGUNTA='UC008_t2p01']/RESPOSTA='N'">
   <xsl:value-of select="' no constaram '"></xsl:value-of>
  </xsl:if>
 </xsl:variable>
 <xsl:variable name="perg3">
  <xsl:if test="UC008Row[CD_PERGUNTA='UC008_t2p02']/RESPOSTA='S'">
   <xsl:value-of select="'Contemplou '"></xsl:value-of>
  </xsl:if>
  <xsl:if test="UC008Row[CD_PERGUNTA='UC008_t2p02']/RESPOSTA='N'">
   <xsl:value-of select="'No contemplou '"></xsl:value-of>
  </xsl:if>
 </xsl:variable>
 <xsl:variable name="perg4">
  <xsl:if test="UC008Row[CD_PERGUNTA='UC008_t2p03']/RESPOSTA='S'">
   <xsl:value-of select="'Contm '"></xsl:value-of>
  </xsl:if>
  <xsl:if test="UC008Row[CD_PERGUNTA='UC008_t2p03']/RESPOSTA='N'">
   <xsl:value-of select="'No contm '"></xsl:value-of>
  </xsl:if>
 </xsl:variable>
 <xsl:variable name="perg5">
  <xsl:if test="UC008Row[CD_PERGUNTA='UC008_t3p01']/RESPOSTA='S'">
   <xsl:value-of select="' foram '"></xsl:value-of>
  </xsl:if>
  <xsl:if test="UC008Row[CD_PERGUNTA='UC008_t3p01']/RESPOSTA='N'">
   <xsl:value-of select="' no foram '"></xsl:value-of>
  </xsl:if>
 </xsl:variable>
 <xsl:variable name="perg6">
  <xsl:if test="UC008Row[CD_PERGUNTA='UC008_t3p02']/RESPOSTA='S'">
   <xsl:value-of select="' foi '"></xsl:value-of>
  </xsl:if>
  <xsl:if test="UC008Row[CD_PERGUNTA='UC008_t3p02']/RESPOSTA='N'">
   <xsl:value-of select="' no foi '"></xsl:value-of>
  </xsl:if>
 </xsl:variable>
 <xsl:variable name="perg7">
  <xsl:if test="UC008Row[CD_PERGUNTA='UC008_t3p03']/RESPOSTA='S'">
   <xsl:value-of select="'Trata '"></xsl:value-of>
  </xsl:if>
  <xsl:if test="UC008Row[CD_PERGUNTA='UC008_t3p03']/RESPOSTA='N'">
   <xsl:value-of select="'No trata '"></xsl:value-of>
  </xsl:if>
 </xsl:variable>
 <xsl:variable name="perg8">
  <xsl:if test="UC008Row[CD_PERGUNTA='UC008_t3p04']/RESPOSTA='S'">
   <xsl:value-of select="' destacando '"></xsl:value-of>
  </xsl:if>
  <xsl:if test="UC008Row[CD_PERGUNTA='UC008_t3p04']/RESPOSTA='N'">
   <xsl:value-of select="' no destacando '"></xsl:value-of>
  </xsl:if>
 </xsl:variable>
 <xsl:variable name="perg9">
  <xsl:if test="UC008Row[CD_PERGUNTA='UC008_t4p01']/RESPOSTA='S'">
   <xsl:value-of select="'Possui '"></xsl:value-of>
  </xsl:if>
  <xsl:if test="UC008Row[CD_PERGUNTA='UC008_t4p01']/RESPOSTA='N'">
   <xsl:value-of select="'No possui '"></xsl:value-of>
  </xsl:if>
 </xsl:variable>
 <xsl:variable name="perg10">
  <xsl:if test="UC008Row[CD_PERGUNTA='UC008_t4p02']/RESPOSTA='S'">
   <xsl:value-of select="'Possui '"></xsl:value-of>
  </xsl:if>
  <xsl:if test="UC008Row[CD_PERGUNTA='UC008_t4p02']/RESPOSTA='N'">
   <xsl:value-of select="'No possui '"></xsl:value-of>
  </xsl:if>
 </xsl:variable>
 <xsl:variable name="perg11">
  <xsl:if test="UC008Row[CD_PERGUNTA='UC008_t4p03']/RESPOSTA='S'">
   <xsl:value-of select="' Contm '"></xsl:value-of>
  </xsl:if>
  <xsl:if test="UC008Row[CD_PERGUNTA='UC008_t4p03']/RESPOSTA='N'">
   <xsl:value-of select="' No contm '"></xsl:value-of>
  </xsl:if>
 </xsl:variable>
 <xsl:variable name="perg12">
  <xsl:if test="(((UC008Row[CD_PERGUNTA='UC008_t4p01']/RESPOSTA='S') and (UC008Row[CD_PERGUNTA='UC008_t4p02']/RESPOSTA='S')) or ((UC008Row[CD_PERGUNTA='UC008_t4p01']/RESPOSTA='N') and (UC008Row[CD_PERGUNTA='UC008_t4p02']/RESPOSTA='N')))">
   <xsl:value-of select="' e '"></xsl:value-of>
  </xsl:if>
  <xsl:if test="((UC008Row[CD_PERGUNTA='UC008_t4p01']/RESPOSTA='N') and (UC008Row[CD_PERGUNTA='UC008_t4p02']/RESPOSTA='S'))">
   <xsl:value-of select="', entretanto possui o '"></xsl:value-of>
  </xsl:if>
  <xsl:if test="((UC008Row[CD_PERGUNTA='UC008_t4p01']/RESPOSTA='S') and (UC008Row[CD_PERGUNTA='UC008_t4p02']/RESPOSTA='N'))">
   <xsl:value-of select="', entretanto no possui o '"></xsl:value-of>
  </xsl:if>
 </xsl:variable>
 <xsl:variable name="perg13">
  <xsl:if test="(((UC008Row[CD_PERGUNTA='UC008_t4p03']/RESPOSTA='S') and (UC008Row[CD_PERGUNTA='UC008_t4p04']/RESPOSTA='S')) or ((UC008Row[CD_PERGUNTA='UC008_t4p03']/RESPOSTA='N') and (UC008Row[CD_PERGUNTA='UC008_t4p04']/RESPOSTA='N')))">
   <xsl:value-of select="' e '"></xsl:value-of>
  </xsl:if>
  <xsl:if test="((UC008Row[CD_PERGUNTA='UC008_t4p03']/RESPOSTA='N') and (UC008Row[CD_PERGUNTA='UC008_t4p04']/RESPOSTA='S'))">
   <xsl:value-of select="', entretanto contm o '"></xsl:value-of>
  </xsl:if>
  <xsl:if test="((UC008Row[CD_PERGUNTA='UC008_t4p03']/RESPOSTA='S') and (UC008Row[CD_PERGUNTA='UC008_t4p04']/RESPOSTA='N'))">
   <xsl:value-of select="', entretanto no contm o '"></xsl:value-of>
  </xsl:if>
 </xsl:variable>


 <!-- INICIO 19 - Instituio, Previso e Efetiva Arrecadao de Tributos -->
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 
 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" />
  <fo:table-body>
   <fo:table-row>
    <fo:table-cell>
     <fo:block xsl:use-attribute-sets="titFCinza">
      <xsl:text>3 - Anexo de Metas Fiscais</xsl:text>
     </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-body>
 </fo:table>
 
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 
 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="556pt"/>

  <fo:table-body >	   
    <fo:table-row>								
     <fo:table-cell>
	  <fo:block xsl:use-attribute-sets="txtJustifyMed" text-align="justify" margin-left="15pt" hyphenate="true" >
       <!-- Primeira Resposta do Relatrio-->        
	   <xsl:if test="UC008Row[CD_PERGUNTA='UC008_t1p01']/RESPOSTA='N'">
        O Anexo de Metas Fiscais <xsl:value-of select="$perg1"/> o Projeto da LDO.
       </xsl:if>
	   <xsl:if test="UC008Row[CD_PERGUNTA='UC008_t1p01']/RESPOSTA='S'">
         O Anexo de Metas Fiscais <xsl:value-of select="$perg1"/> o Projeto da LDO, sendo que nele <xsl:value-of select="$perg2"/> as metas anuais, em valores correntes e constantes, relativas a receitas, despesas, resultados nominal e primrio e montante da dvida pblica, para o exerccio de <xsl:value-of select="../../Header/Informacoes/InformacoesRow/ANO_EXERCICIO"/> e para os dois seguintes.
	     <fo:block><fo:leader leader-pattern="space"/></fo:block>
	     Verificou-se, ainda, que o Anexo de Metas Fiscais:
	     <fo:block><fo:leader leader-pattern="space"/></fo:block>
         - <xsl:value-of select="$perg3"/> a avaliao do cumprimento das metas relativas ao ano anterior;
	     <fo:block><fo:leader leader-pattern="space"/></fo:block>
         
		 <xsl:if test="UC008Row[CD_PERGUNTA='UC008_t2p03']/RESPOSTA='N'">
         - <xsl:value-of select="$perg4"/> o demonstrativo das metas anuais para o exerccio de <xsl:value-of select="../../Header/Informacoes/InformacoesRow/ANO_EXERCICIO"/>, devidamente instrudo com memria e metodologia de clculo que justificam os resultados pretendidos.
         </xsl:if>
         <xsl:if test="UC008Row[CD_PERGUNTA='UC008_t2p03']/RESPOSTA='S'">
         - <xsl:value-of select="$perg4"/> o demonstrativo das metas anuais para o exerccio de <xsl:value-of select="../../Header/Informacoes/InformacoesRow/ANO_EXERCICIO"/>, devidamente instrudo com memria e metodologia de clculo que justificam os resultados pretendidos. As metas anuais <xsl:value-of select="$perg5"/> comparadas com as fixadas nos trs exerccios anteriores, e <xsl:value-of select="$perg6"/> evidenciada a sua consistncia com as premissas e os objetivos da poltica econmica nacional;
         </xsl:if>

	     <fo:block><fo:leader leader-pattern="space"/></fo:block>
         <xsl:if test="UC008Row[CD_PERGUNTA='UC008_t3p03']/RESPOSTA='N'">
         - <xsl:value-of select="$perg7"/> da evoluo do patrimnio lquido para os trs ltimos exerccios.
         </xsl:if>
         <xsl:if test="UC008Row[CD_PERGUNTA='UC008_t3p03']/RESPOSTA='S'">
         - <xsl:value-of select="$perg7"/> da evoluo do patrimnio lquido para os trs ltimos exerccios, <xsl:value-of select="$perg8"/> a origem e a aplicao dos recursos obtidos com a alienao de ativos;
         </xsl:if>

	     <fo:block><fo:leader leader-pattern="space"/></fo:block>
         <xsl:if test="../../Header/Informacoes/InformacoesRow/POSSUIRPPS='S'">
         - <xsl:value-of select="$perg9"/> a avaliao da situao financeira e atuarial do Regime Prprio de Previdncia dos Servidores - RPPS<xsl:value-of select="$perg12"/> dos demais fundos pblicos e programas estatais de natureza atuarial;
         </xsl:if>
         <xsl:if test="../../Header/Informacoes/InformacoesRow/POSSUIRPPS='N'">
         - <xsl:value-of select="$perg10"/> a avaliao da situao financeira e atuarial dos fundos pblicos e programas estatais de natureza atuarial;
         </xsl:if>

	     <fo:block><fo:leader leader-pattern="space"/></fo:block>
         - <xsl:value-of select="$perg11"/> o demonstrativo da estimativa e compensao da renncia de receita<xsl:value-of select="$perg13"/> da margem de expanso das despesas obrigatrias de carter continuado.

       </xsl:if>

      </fo:block>
     </fo:table-cell>
    </fo:table-row>   	
  </fo:table-body>
 </fo:table> 
  
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 
 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="556pt"/>

  <fo:table-body >	   
    <fo:table-row>								
     <fo:table-cell>
	  <fo:block xsl:use-attribute-sets="txtJustifyMed" text-align="justify" margin-left="15pt" hyphenate="true" >
       <xsl:if test="../../Observacoes/ObservacoesRemessas/ObservacoesRemessasRow[CD_OBSERVACOES='UC008']/OBSERVACOES!=''">
        <fo:inline font-weight="bold">Observaes: </fo:inline><xsl:value-of select="../../Observacoes/ObservacoesRemessas/ObservacoesRemessasRow[CD_OBSERVACOES='UC008']/OBSERVACOES"></xsl:value-of>
       </xsl:if>
       <xsl:if test="../../Observacoes/ObservacoesRemessas/ObservacoesRemessasRow[CD_OBSERVACOES='UC008']/OBSERVACOES=''">
        <fo:inline font-style="italic">No foram inseridas observaes para este item.</fo:inline>
       </xsl:if>
      </fo:block>
     </fo:table-cell>
    </fo:table-row>   	
  </fo:table-body>
 </fo:table> 
 <!-- FIM    UC008  --> 
</xsl:template>

<!--
###############################################
##     20 - Gastos Totais do Legislativo     ##
###############################################
-->
<xsl:template match="UC032">

 <!--Varivel de exibio do Modelo - 20 -->
 <xsl:variable name="perg2_uc032">
  <xsl:if test="UC032Row[CD_PERGUNTA='UC032_t1p02']/RESPOSTA='N'">
   <xsl:value-of select="' no cumprindo '"></xsl:value-of>
  </xsl:if>
  <xsl:if test="UC032Row[CD_PERGUNTA='UC032_t1p02']/RESPOSTA='S'">
   <xsl:value-of select="' cumprindo '"></xsl:value-of>
  </xsl:if>
 </xsl:variable>
 <xsl:variable name="perg4_uc032">
  <xsl:if test="UC032Row[CD_PERGUNTA='UC032_t1p04']/RESPOSTA='N'">
   <xsl:value-of select="' no cumprindo '"></xsl:value-of>
  </xsl:if>
  <xsl:if test="UC032Row[CD_PERGUNTA='UC032_t1p04']/RESPOSTA='S'">
   <xsl:value-of select="' cumprindo '"></xsl:value-of>
  </xsl:if>
 </xsl:variable>
 <xsl:variable name="perg567">
  <xsl:if test="((UC032Row[CD_PERGUNTA='UC032_t1p05']/RESPOSTA='S') and (UC032Row[CD_PERGUNTA='UC032_t1p06']/RESPOSTA='S') and (UC032Row[CD_PERGUNTA='UC032_t1p07']/RESPOSTA='S'))">
   <xsl:value-of select="' da Receita Realizada no Exerccio Anterior Atualizada, dos Gastos Totais e da Folha de Pagamento '"></xsl:value-of>
  </xsl:if>
  <xsl:if test="((UC032Row[CD_PERGUNTA='UC032_t1p05']/RESPOSTA='S') and (UC032Row[CD_PERGUNTA='UC032_t1p06']/RESPOSTA='S') and (UC032Row[CD_PERGUNTA='UC032_t1p07']/RESPOSTA='N'))">
   <xsl:value-of select="' da Receita Realizada no Exerccio Anterior Atualizada e dos Gastos Totais '"></xsl:value-of>
  </xsl:if>
  <xsl:if test="((UC032Row[CD_PERGUNTA='UC032_t1p05']/RESPOSTA='S') and (UC032Row[CD_PERGUNTA='UC032_t1p06']/RESPOSTA='N') and (UC032Row[CD_PERGUNTA='UC032_t1p07']/RESPOSTA='S'))">
   <xsl:value-of select="' da Receita Realizada no Exerccio Anterior Atualizada e da Folha de Pagamento '"></xsl:value-of>
  </xsl:if>
  <xsl:if test="((UC032Row[CD_PERGUNTA='UC032_t1p05']/RESPOSTA='S') and (UC032Row[CD_PERGUNTA='UC032_t1p06']/RESPOSTA='N') and (UC032Row[CD_PERGUNTA='UC032_t1p07']/RESPOSTA='N'))">
   <xsl:value-of select="' da Receita Realizada no Exerccio Anterior Atualizada '"></xsl:value-of>
  </xsl:if>
  <xsl:if test="((UC032Row[CD_PERGUNTA='UC032_t1p05']/RESPOSTA='N') and (UC032Row[CD_PERGUNTA='UC032_t1p06']/RESPOSTA='S') and (UC032Row[CD_PERGUNTA='UC032_t1p07']/RESPOSTA='S'))">
   <xsl:value-of select="' dos Gastos Totais e da Folha de Pagamento '"></xsl:value-of>
  </xsl:if>
  <xsl:if test="((UC032Row[CD_PERGUNTA='UC032_t1p05']/RESPOSTA='N') and (UC032Row[CD_PERGUNTA='UC032_t1p06']/RESPOSTA='S') and (UC032Row[CD_PERGUNTA='UC032_t1p07']/RESPOSTA='N'))">
   <xsl:value-of select="' dos Gastos Totais '"></xsl:value-of>
  </xsl:if>
  <xsl:if test="((UC032Row[CD_PERGUNTA='UC032_t1p05']/RESPOSTA='N') and (UC032Row[CD_PERGUNTA='UC032_t1p06']/RESPOSTA='N') and (UC032Row[CD_PERGUNTA='UC032_t1p07']/RESPOSTA='S'))">
   <xsl:value-of select="' da Folha de Pagamento '"></xsl:value-of>
  </xsl:if>
 </xsl:variable> 
 <xsl:variable name="perg567N">
  <xsl:if test="((UC032Row[CD_PERGUNTA='UC032_t1p05']/RESPOSTA='S') and (UC032Row[CD_PERGUNTA='UC032_t1p06']/RESPOSTA='S') and (UC032Row[CD_PERGUNTA='UC032_t1p07']/RESPOSTA='N'))">
   <xsl:value-of select="' da Folha de Pagamento '"></xsl:value-of>
  </xsl:if>
  <xsl:if test="((UC032Row[CD_PERGUNTA='UC032_t1p05']/RESPOSTA='S') and (UC032Row[CD_PERGUNTA='UC032_t1p06']/RESPOSTA='N') and (UC032Row[CD_PERGUNTA='UC032_t1p07']/RESPOSTA='S'))">
   <xsl:value-of select="' dos Gastos Totais '"></xsl:value-of>
  </xsl:if>
  <xsl:if test="((UC032Row[CD_PERGUNTA='UC032_t1p05']/RESPOSTA='S') and (UC032Row[CD_PERGUNTA='UC032_t1p06']/RESPOSTA='N') and (UC032Row[CD_PERGUNTA='UC032_t1p07']/RESPOSTA='N'))">
   <xsl:value-of select="' dos Gastos Totais e da Folha de Pagamento '"></xsl:value-of>
  </xsl:if>
  <xsl:if test="((UC032Row[CD_PERGUNTA='UC032_t1p05']/RESPOSTA='N') and (UC032Row[CD_PERGUNTA='UC032_t1p06']/RESPOSTA='S') and (UC032Row[CD_PERGUNTA='UC032_t1p07']/RESPOSTA='S'))">
   <xsl:value-of select="' da Receita Realizada no Exerccio Anterior Atualizada '"></xsl:value-of>
  </xsl:if>
  <xsl:if test="((UC032Row[CD_PERGUNTA='UC032_t1p05']/RESPOSTA='N') and (UC032Row[CD_PERGUNTA='UC032_t1p06']/RESPOSTA='S') and (UC032Row[CD_PERGUNTA='UC032_t1p07']/RESPOSTA='N'))">
   <xsl:value-of select="' da Receita Realizada no Exerccio Anterior Atualizada e da Folha de Pagamento '"></xsl:value-of>
  </xsl:if>
  <xsl:if test="((UC032Row[CD_PERGUNTA='UC032_t1p05']/RESPOSTA='N') and (UC032Row[CD_PERGUNTA='UC032_t1p06']/RESPOSTA='N') and (UC032Row[CD_PERGUNTA='UC032_t1p07']/RESPOSTA='S'))">
   <xsl:value-of select="' da Receita Realizada no Exerccio Anterior Atualizada e dos Gastos Totais '"></xsl:value-of>
  </xsl:if>
  <xsl:if test="((UC032Row[CD_PERGUNTA='UC032_t1p05']/RESPOSTA='N') and (UC032Row[CD_PERGUNTA='UC032_t1p06']/RESPOSTA='N') and (UC032Row[CD_PERGUNTA='UC032_t1p07']/RESPOSTA='N'))">
   <xsl:value-of select="' da Receita Realizada no Exerccio Anterior Atualizada, dos Gastos Totais e da Folha de Pagamento '"></xsl:value-of>
  </xsl:if>
 </xsl:variable> 


 <!-- INICIO 20 - Gastos Totais do Legislativo -->
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 
 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" />
  <fo:table-body>
   <fo:table-row>
    <fo:table-cell>
     <fo:block xsl:use-attribute-sets="titFCinza">
      <xsl:text>20 - Gastos Totais do Legislativo</xsl:text>
     </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-body>
 </fo:table>
 
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 
 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="556pt"/>

  <fo:table-body >	   
    <fo:table-row>								
     <fo:table-cell>
	  <fo:block xsl:use-attribute-sets="txtJustifyMed" text-align="justify" margin-left="15pt" hyphenate="true" >
        O Poder Legislativo apresentou <xsl:value-of select="format-number((UC032Row[CD_PERGUNTA='UC032_t1p01']/RESPOSTA_EXT), '##0,00')"/>% de <fo:inline font-weight="bold">Gastos Totais,</fo:inline><xsl:value-of select="$perg2_uc032"/> o limite legal estabelecido no art. 29-A da CF.
      </fo:block>
	  <fo:block xsl:use-attribute-sets="txtJustifyMed" text-align="justify" margin-left="15pt" hyphenate="true" >
        O Poder Legislativo apresentou <xsl:value-of select="format-number((UC032Row[CD_PERGUNTA='UC032_t1p03']/RESPOSTA_EXT), '##0,00')"/>% de <fo:inline font-weight="bold">Folha de Pagamento,</fo:inline><xsl:value-of select="$perg4_uc032"/> o limite legal estabelecido no art. 29-A da CF.
      </fo:block>

	  <fo:block xsl:use-attribute-sets="txtJustifyMed" text-align="justify" margin-left="15pt" hyphenate="true" >
       <xsl:if test="((UC032Row[CD_PERGUNTA='UC032_t1p05']/RESPOSTA='S') or (UC032Row[CD_PERGUNTA='UC032_t1p06']/RESPOSTA='S') or (UC032Row[CD_PERGUNTA='UC032_t1p07']/RESPOSTA='S'))">
        Os valores <xsl:value-of select="$perg567"/> foram apurados conforme estabelecido nas Resolues e Instrues Normativas do TCE/RS.
         <fo:block><fo:leader leader-pattern="space"/></fo:block>
         <xsl:if test="((UC032Row[CD_PERGUNTA='UC032_t1p05']/RESPOSTA='N') or (UC032Row[CD_PERGUNTA='UC032_t1p06']/RESPOSTA='N') or (UC032Row[CD_PERGUNTA='UC032_t1p07']/RESPOSTA='N'))">
          Entretanto, os valores <xsl:value-of select="$perg567N"/> no foram apurados conforme estabelecido nas Resolues e Instrues Normativas do TCE/RS.
         </xsl:if>
       </xsl:if>
      </fo:block>
 	  <fo:block xsl:use-attribute-sets="txtJustifyMed" text-align="justify" margin-left="15pt" hyphenate="true" >
       <xsl:if test="((UC032Row[CD_PERGUNTA='UC032_t1p05']/RESPOSTA='N') and (UC032Row[CD_PERGUNTA='UC032_t1p06']/RESPOSTA='N') and (UC032Row[CD_PERGUNTA='UC032_t1p07']/RESPOSTA='N'))">
        Os valores da Receita Realizada no Exerccio Anterior Atualizada, dos Gastos Totais e da Folha de Pagamento no foram apurados segundo o entendimento do TCE/RS.
	   </xsl:if>
      </fo:block>

     </fo:table-cell>
    </fo:table-row>   	
  </fo:table-body>
 </fo:table> 
  
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 
 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="556pt"/>

  <fo:table-body >	   
    <fo:table-row>								
     <fo:table-cell>
	  <fo:block xsl:use-attribute-sets="txtJustifyMed" text-align="justify" margin-left="15pt" hyphenate="true" >
       <xsl:if test="../../Observacoes/ObservacoesRemessas/ObservacoesRemessasRow[CD_OBSERVACOES='UC032']/OBSERVACOES!=''">
        <fo:inline font-weight="bold">Observaes: </fo:inline><xsl:value-of select="../../Observacoes/ObservacoesRemessas/ObservacoesRemessasRow[CD_OBSERVACOES='UC032']/OBSERVACOES"></xsl:value-of>
       </xsl:if>
       <xsl:if test="../../Observacoes/ObservacoesRemessas/ObservacoesRemessasRow[CD_OBSERVACOES='UC032']/OBSERVACOES=''">
        <fo:inline font-style="italic">No foram inseridas observaes para este item.</fo:inline>
       </xsl:if>
      </fo:block>
     </fo:table-cell>
    </fo:table-row>   	
  </fo:table-body>
 </fo:table> 
 <!-- FIM    UC032  --> 
</xsl:template>

<!--
############################################################
## 23 - Reestimativa de Receita Oramentria - DEPRECATED ##
############################################################
-->
<!-- xsl:template match="UC033">

 <!- -Varivel de exibio do Modelo - 20 - ->
 <xsl:variable name="perg1_uc033">
  <xsl:if test="UC033Row[CD_PERGUNTA='UC033_t1p01']/RESPOSTA='N'">
   <xsl:value-of select="'No houve '"></xsl:value-of>
  </xsl:if>
  <xsl:if test="UC033Row[CD_PERGUNTA='UC033_t1p01']/RESPOSTA='S'">
   <xsl:value-of select="'Houve '"></xsl:value-of>
  </xsl:if>
 </xsl:variable>
 <xsl:variable name="perg2_uc033">
  <xsl:if test="UC033Row[CD_PERGUNTA='UC033_t1p02']/RESPOSTA='N'">
   <xsl:value-of select="' no foi '"></xsl:value-of>
  </xsl:if>
  <xsl:if test="UC033Row[CD_PERGUNTA='UC033_t1p02']/RESPOSTA='S'">
   <xsl:value-of select="' foi '"></xsl:value-of>
  </xsl:if>
 </xsl:variable>
 
 <!- - INICIO 23 - Reestimativa de Receita Oramentria - ->
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 
 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" />
  <fo:table-body>
   <fo:table-row>
    <fo:table-cell>
     <fo:block xsl:use-attribute-sets="titFCinza">
      <xsl:text>23 - Reestimativa de Receita Oramentria por Parte do Poder Legislativo</xsl:text>
     </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-body>
 </fo:table>
 
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 
 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="556pt"/>

  <fo:table-body >	   
    <fo:table-row>								
     <fo:table-cell>
	  <fo:block xsl:use-attribute-sets="txtJustifyMed" text-align="justify" margin-left="15pt" hyphenate="true" >
        <xsl:value-of select="$perg1_uc033"/> reestimativa de receita por parte do Poder Legislativo, sendo que a mesma <xsl:value-of select="$perg2_uc033"/> realizada com base em comprovado erro ou omisso de ordem tcnica ou legal.
      </fo:block>
     </fo:table-cell>
    </fo:table-row>   	
  </fo:table-body>
 </fo:table> 
  
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 
 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="556pt"/>

  <fo:table-body >	   
    <fo:table-row>								
     <fo:table-cell>
	  <fo:block xsl:use-attribute-sets="txtJustifyMed" text-align="justify" margin-left="15pt" hyphenate="true" >
       <xsl:if test="../../Observacoes/ObservacoesRemessas/ObservacoesRemessasRow[CD_OBSERVACOES='UC033']/OBSERVACOES!=''">
        <fo:inline font-weight="bold">Observaes: </fo:inline><xsl:value-of select="../../Observacoes/ObservacoesRemessas/ObservacoesRemessasRow[CD_OBSERVACOES='UC033']/OBSERVACOES"></xsl:value-of>
       </xsl:if>
       <xsl:if test="../../Observacoes/ObservacoesRemessas/ObservacoesRemessasRow[CD_OBSERVACOES='UC033']/OBSERVACOES=''">
        <fo:inline font-style="italic">No foram inseridas observaes para este item.</fo:inline>
       </xsl:if>
      </fo:block>
     </fo:table-cell>
    </fo:table-row>   	
  </fo:table-body>
 </fo:table> 
 <!- - FIM    UC033  - -> 
</xsl:template-->

<!--
###############################################
## 21 - Restos a Pagar - Ult. 8 meses mand.  ##
###############################################
-->
<xsl:template match="UC024">

 <!--Varivel de exibio do Modelo - 21 -->
 <xsl:variable name="poder">
  <xsl:if test="../../Header/Informacoes/InformacoesRow/PODER='C'">
   <xsl:value-of select="' Poder Legislativo'"></xsl:value-of>
  </xsl:if>
  <xsl:if test="../../Header/Informacoes/InformacoesRow/PODER='P'">
   <xsl:value-of select="' Poder Executivo'"></xsl:value-of>
  </xsl:if>
 </xsl:variable>
 <xsl:variable name="perg1_uc024">
  <xsl:if test="UC024Row[CD_PERGUNTA='UC024_t1p01']/RESPOSTA='N'">
   <xsl:value-of select="' no apresentou '"></xsl:value-of>
  </xsl:if>
  <xsl:if test="UC024Row[CD_PERGUNTA='UC024_t1p01']/RESPOSTA='S'">
   <xsl:value-of select="' apresentou '"></xsl:value-of>
  </xsl:if>
 </xsl:variable>
 
 <!-- INICIO 23 - Reestimativa de Receita Oramentria -->
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 
 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" />
  <fo:table-body>
   <fo:table-row>
    <fo:table-cell>
     <fo:block xsl:use-attribute-sets="titFCinza">
      <xsl:text>21 - Restos a Pagar - ltimos 8 meses de mandato</xsl:text>
     </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-body>
 </fo:table>
 
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 
 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="556pt"/>

  <fo:table-body >	   
    <fo:table-row>								
     <fo:table-cell>
      <fo:block xsl:use-attribute-sets="txtJustifyMed" text-align="justify" margin-left="15pt" hyphenate="true" >
        O <xsl:value-of select="$poder"/>, no que concerne a Restos a Pagar por fontes de recurso, <xsl:value-of select="$perg1_uc024"/> insuficincia financeira decorrente de empenhos emitidos no perodo de 01/05 a 31/12/<xsl:value-of select="../../Header/Informacoes/InformacoesRow/ANO_EXERCICIO"/>  (ltimos 2 quadrimestres do mandato).
      </fo:block>
     </fo:table-cell>
    </fo:table-row>   	

    <xsl:if test="UC024Row[CD_PERGUNTA='UC024_t1p01']/RESPOSTA='S'">
      <fo:table-row>
      <fo:table-cell>
      <fo:block xsl:use-attribute-sets="txtJustifyMed" text-align="justify" margin-left="15pt" hyphenate="true" >
      
      <xsl:choose>
        <xsl:when test="UC024Row[CD_PERGUNTA='UC024_t1p02']/RESPOSTA='S'">
          Os empenhos emitidos no perodo de 01/05 a
          31/12/<xsl:value-of select="../../Header/Informacoes/InformacoesRow/ANO_EXERCICIO"/>
          que no foram liquidados at o final do exerccio e que no possuam suficincia financeira foram cancelados.
        </xsl:when>
        <xsl:when test="UC024Row[CD_PERGUNTA='UC024_t1p02']/RESPOSTA='N'">
          Os empenhos emitidos no perodo de 01/05 a
          31/12/<xsl:value-of select="../../Header/Informacoes/InformacoesRow/ANO_EXERCICIO"/>
          que no foram liquidados at o final do exerccio e que no possuam suficincia financeira no foram cancelados.
        </xsl:when>
        <xsl:when test="UC024Row[CD_PERGUNTA='UC024_t1p02']/RESPOSTA='H'">
          No h empenho emitido no perodo de 01/05 a
          31/12/<xsl:value-of select="../../Header/Informacoes/InformacoesRow/ANO_EXERCICIO"/>
          que no tenha sido liquidado at o final do exerccio.
        </xsl:when>
        <xsl:otherwise>
          Nenhuma informao sobre a pergunta "Os empenhos no liquidados que no possuem suficincia financeira foram cancelados?".
        </xsl:otherwise>
      </xsl:choose>

      </fo:block>
      </fo:table-cell>
      </fo:table-row>
    </xsl:if>

  </fo:table-body>
 </fo:table> 
  
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 
 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="556pt"/>

  <fo:table-body >	   
    <fo:table-row>								
     <fo:table-cell>
	  <fo:block xsl:use-attribute-sets="txtJustifyMed" text-align="justify" margin-left="15pt" hyphenate="true" >
       <xsl:if test="../../Observacoes/ObservacoesRemessas/ObservacoesRemessasRow[CD_OBSERVACOES='UC024']/OBSERVACOES!=''">
        <fo:inline font-weight="bold">Observaes: </fo:inline><xsl:value-of select="../../Observacoes/ObservacoesRemessas/ObservacoesRemessasRow[CD_OBSERVACOES='UC024']/OBSERVACOES"></xsl:value-of>
       </xsl:if>
       <xsl:if test="../../Observacoes/ObservacoesRemessas/ObservacoesRemessasRow[CD_OBSERVACOES='UC024']/OBSERVACOES=''">
        <fo:inline font-style="italic">No foram inseridas observaes para este item.</fo:inline>
       </xsl:if>
      </fo:block>
     </fo:table-cell>
    </fo:table-row>   	
  </fo:table-body>
 </fo:table> 
 <!-- FIM    UC024  --> 
</xsl:template>

<!--
###############################################
#######    22 - Equilbrio Financeiro     #####
###############################################
-->
<xsl:template match="UC025">

 <!--Varivel de exibio do Modelo - 22 -->
 <xsl:variable name="poder">
  <xsl:if test="../../Header/Informacoes/InformacoesRow/PODER='C'">
   <xsl:value-of select="' Poder Legislativo'"></xsl:value-of>
  </xsl:if>
  <xsl:if test="../../Header/Informacoes/InformacoesRow/PODER='P'">
   <xsl:value-of select="' Poder Executivo'"></xsl:value-of>
  </xsl:if>
 </xsl:variable>

 <xsl:variable name="perg4_uc025">
  <xsl:if test="UC025Row[CD_PERGUNTA='UC025_t1p04']/RESPOSTA='S'">
   <xsl:value-of select="'foi superior quela apurada no exerccio imediatamente anterior, fato que demonstra a situao de Desequilbrio Financeiro da entidade, restando comprovada a no adoo de medidas suficientes para a busca do equilbrio das contas pblicas, no atendendo o disposto no  1 do art. 1 da LRF.'"></xsl:value-of>
  </xsl:if>
  <xsl:if test="UC025Row[CD_PERGUNTA='UC025_t1p04']/RESPOSTA='I'">
   <xsl:value-of select="'foi inferior quela apurada no exerccio imediatamente anterior, restando comprovada a adoo de medidas que objetivem o alcance do equilbrio das contas pblicas, atendendo o disposto no  1 do art. 1 da LRF.'"></xsl:value-of>
  </xsl:if>
  <xsl:if test="UC025Row[CD_PERGUNTA='UC025_t1p04']/RESPOSTA='N'">
   <xsl:value-of select="'teve incio neste exerccio, pois, no exerccio anterior no havia insuficincia, fato que demonstra a situao de Desequilbrio Financeiro da entidade, restando comprovada a no adoo de medidas suficientes para a busca do equilbrio das contas pblicas, no atendendo o disposto no  1 do art. 1 da LRF.'"></xsl:value-of>
  </xsl:if>
 </xsl:variable>

 
 
 <!-- INICIO 22 - Equilbrio Financeiro -->
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 
 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" />
  <fo:table-body>
   <fo:table-row>
    <fo:table-cell>
     <fo:block xsl:use-attribute-sets="titFCinza">
      <xsl:text>22 - Equilbrio Financeiro</xsl:text>
     </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-body>
 </fo:table>
 
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 
 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="556pt"/>

  <fo:table-body >	   
    <fo:table-row>								
     <fo:table-cell>
	  <fo:block xsl:use-attribute-sets="txtJustifyMed" text-align="justify" margin-left="15pt" hyphenate="true" >
       <xsl:if test="UC025Row[CD_PERGUNTA='UC025_t1p01']/RESPOSTA='S'">
		Na anlise do Saldo de Restos a Pagar por fontes de recurso do <xsl:value-of select="$poder"/>, constatou-se a existncia de recursos financeiros para a cobertura dos mesmos.
       </xsl:if>
       <xsl:if test="UC025Row[CD_PERGUNTA='UC025_t1p01']/RESPOSTA='N'">
        Na anlise do Saldo de Restos a Pagar por fontes de recurso do <xsl:value-of select="$poder"/>, constatou-se a inexistncia de recursos financeiros para a cobertura dos mesmos. 
        <fo:block><fo:leader leader-pattern="space"/></fo:block>
        Analisando-se a evoluo dos restos a pagar por fontes de recurso e das disponibilidades financeiras
        existentes no encerramento do exerccio, constata-se que a insuficincia de R$
        <xsl:value-of select="format-number((UC025Row[CD_PERGUNTA='UC025_t1p02']/RESPOSTA_EXT), '#.###.###.##0,00')"/>
        apurada ao final desse exerccio, correspondente a
        <xsl:value-of select="format-number((UC025Row[CD_PERGUNTA='UC025_t1p03']/RESPOSTA_EXT), '##0,00')"/>%
        do total dos Restos a Pagar, <xsl:value-of select="$perg4_uc025"/>
        <fo:block><fo:leader leader-pattern="space"/></fo:block>
        <fo:block>
          <xsl:choose>
            <xsl:when test="UC025Row[CD_PERGUNTA='UC025_t1p05']/RESPOSTA='S'">
              Os empenhos no liquidados que no possuem suficincia financeira foram cancelados.
            </xsl:when>
            <xsl:when test="UC025Row[CD_PERGUNTA='UC025_t1p05']/RESPOSTA='N'">
              Os empenhos no liquidados que no possuem suficincia financeira no foram cancelados.
            </xsl:when>
            <xsl:when test="UC025Row[CD_PERGUNTA='UC025_t1p05']/RESPOSTA='H'">
              No h empenho no liquidado sem suficincia financeira.
            </xsl:when>
            <xsl:otherwise>
              Nenhuma informao sobre a pergunta "Os empenhos no liquidados que no possuem suficincia financeira foram cancelados?".
            </xsl:otherwise>
          </xsl:choose>
        </fo:block>
       </xsl:if>
      </fo:block>
     </fo:table-cell>
    </fo:table-row>
  </fo:table-body>
 </fo:table> 
  
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 
 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="556pt"/>

  <fo:table-body >	   
    <fo:table-row>								
     <fo:table-cell>
	  <fo:block xsl:use-attribute-sets="txtJustifyMed" text-align="justify" margin-left="15pt" hyphenate="true" >
       <xsl:if test="../../Observacoes/ObservacoesRemessas/ObservacoesRemessasRow[CD_OBSERVACOES='UC025']/OBSERVACOES!=''">
        <fo:inline font-weight="bold">Observaes: </fo:inline><xsl:value-of select="../../Observacoes/ObservacoesRemessas/ObservacoesRemessasRow[CD_OBSERVACOES='UC025']/OBSERVACOES"></xsl:value-of>
       </xsl:if>
       <xsl:if test="../../Observacoes/ObservacoesRemessas/ObservacoesRemessasRow[CD_OBSERVACOES='UC025']/OBSERVACOES=''">
        <fo:inline font-style="italic">No foram inseridas observaes para este item.</fo:inline>
       </xsl:if>
      </fo:block>
     </fo:table-cell>
    </fo:table-row>   	
  </fo:table-body>
 </fo:table> 
 <!-- FIM    UC025  --> 
</xsl:template>

<!--
###############################################
#######    18 - Despesa com Pessoal       #####
###############################################
-->
<xsl:template match="UC022">

 <!--Varivel de exibio do Modelo - 22 -->
 <xsl:variable name="poder">
  <xsl:if test="../../Header/Informacoes/InformacoesRow/PODER='C'">
   <xsl:value-of select="' Poder Legislativo'"></xsl:value-of>
  </xsl:if>
  <xsl:if test="../../Header/Informacoes/InformacoesRow/PODER='P'">
   <xsl:value-of select="' Poder Executivo'"></xsl:value-of>
  </xsl:if>
 </xsl:variable>
 <xsl:variable name="perg1">
  <xsl:if test="UC022Row[CD_PERGUNTA='UC022_t2p01']/RESPOSTA='S'">
   <xsl:value-of select="' foi '"></xsl:value-of>
  </xsl:if>
  <xsl:if test="UC022Row[CD_PERGUNTA='UC022_t2p01']/RESPOSTA='N'">
   <xsl:value-of select="' no foi '"></xsl:value-of>
  </xsl:if>
 </xsl:variable>
 <xsl:variable name="perg2_ex">
  <xsl:if test="UC022Row[CD_PERGUNTA='UC022_t1p01']/RESPOSTA_EXT &gt; 51.30">
   <xsl:value-of select="' excedeu '"></xsl:value-of>
  </xsl:if>
  <xsl:if test="UC022Row[CD_PERGUNTA='UC022_t1p01']/RESPOSTA_EXT &lt; 51.31">
   <xsl:value-of select="' no excedeu '"></xsl:value-of>
  </xsl:if>
 </xsl:variable>
 <xsl:variable name="perg2_leg">
  <xsl:if test="UC022Row[CD_PERGUNTA='UC022_t1p01']/RESPOSTA_EXT &gt; 5.70">
   <xsl:value-of select="' excedeu '"></xsl:value-of>
  </xsl:if>
  <xsl:if test="UC022Row[CD_PERGUNTA='UC022_t1p01']/RESPOSTA_EXT &lt; 5.71">
   <xsl:value-of select="' no excedeu '"></xsl:value-of>
  </xsl:if>
 </xsl:variable>
 <xsl:variable name="periodoD">
  <xsl:if test="UC022Row[CD_PERGUNTA='UC022_t1p05']/RESPOSTA_EXT='1'"> 1 Quadrimestre</xsl:if>
  <xsl:if test="UC022Row[CD_PERGUNTA='UC022_t1p05']/RESPOSTA_EXT='2'"> 2 Quadrimestre</xsl:if>
  <xsl:if test="UC022Row[CD_PERGUNTA='UC022_t1p05']/RESPOSTA_EXT='3'"> 3 Quadrimestre</xsl:if>
  <xsl:if test="UC022Row[CD_PERGUNTA='UC022_t1p05']/RESPOSTA_EXT='4'"> 1 Semestre</xsl:if>
  <xsl:if test="UC022Row[CD_PERGUNTA='UC022_t1p05']/RESPOSTA_EXT='5'"> 2 Semestre</xsl:if>	   		   
 </xsl:variable>
 <xsl:variable name="anoD">
  <xsl:value-of select="UC022Row[CD_PERGUNTA='UC022_t1p06']/RESPOSTA_EXT"></xsl:value-of>
 </xsl:variable>
 <xsl:variable name="periodoE">
  <xsl:if test="UC022Row[CD_PERGUNTA='UC022_t1p09']/RESPOSTA_EXT='1'"> 1 Quadrimestre</xsl:if>
  <xsl:if test="UC022Row[CD_PERGUNTA='UC022_t1p09']/RESPOSTA_EXT='2'"> 2 Quadrimestre</xsl:if>
  <xsl:if test="UC022Row[CD_PERGUNTA='UC022_t1p09']/RESPOSTA_EXT='3'"> 3 Quadrimestre</xsl:if>
  <xsl:if test="UC022Row[CD_PERGUNTA='UC022_t1p09']/RESPOSTA_EXT='4'"> 1 Semestre</xsl:if>
  <xsl:if test="UC022Row[CD_PERGUNTA='UC022_t1p09']/RESPOSTA_EXT='5'"> 2 Semestre</xsl:if>	   		   
 </xsl:variable>
 <xsl:variable name="anoE">
  <xsl:value-of select="UC022Row[CD_PERGUNTA='UC022_t1p10']/RESPOSTA_EXT"></xsl:value-of>
 </xsl:variable>
 <xsl:variable name="perg16">
  <xsl:if test="UC022Row[CD_PERGUNTA='UC022_t4p01']/RESPOSTA='S'">Houve </xsl:if>
  <xsl:if test="UC022Row[CD_PERGUNTA='UC022_t4p01']/RESPOSTA='N'">No houve </xsl:if>
 </xsl:variable>


 <!-- INICIO 18 - Despesa com Pessoal -->
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 
 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" />
  <fo:table-body>
   <fo:table-row>
    <fo:table-cell>
     <fo:block xsl:use-attribute-sets="titFCinza">
      <xsl:text>18 - Despesa com Pessoal</xsl:text>
     </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-body>
 </fo:table>
 
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 
 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="556pt"/>

  <fo:table-body >	   
    <fo:table-row>								
     <fo:table-cell>
	  <fo:block xsl:use-attribute-sets="txtJustifyMed" text-align="justify" margin-left="15pt" hyphenate="true" >
	   <!--PODER LEGISLATIVO   -->          
	   <xsl:if test="../../Header/Informacoes/InformacoesRow/PODER='C'">
        A Despesa com Pessoal do Poder Legislativo <xsl:value-of select="$perg1"/> apurada conforme estabelecido nas Resolues e Instrues Normativas do TCE-RS.        
       <fo:block><fo:leader leader-pattern="space"/></fo:block>
	    A Despesa total com Pessoal <xsl:value-of select="$perg2_leg"/> a 95% (noventa e cinco por cento) do limite no <xsl:value-of select="../../Header/Informacoes/InformacoesRow/DS_PERIODO"/> de <xsl:value-of select="../../Header/Informacoes/InformacoesRow/ANO_EXERCICIO"/>.
         <!--xsl:if test="((UC022Row[CD_PERGUNTA='UC022_t3p01']/RESPOSTA='N') and (UC022Row[CD_PERGUNTA='UC022_t3p02']/RESPOSTA='N') and (UC022Row[CD_PERGUNTA='UC022_t3p03']/RESPOSTA='N') and (UC022Row[CD_PERGUNTA='UC022_t3p04']/RESPOSTA='N') and (UC022Row[CD_PERGUNTA='UC022_t3p05']/RESPOSTA='N')) or (UC022Row[CD_PERGUNTA='UC022_t1p01']/RESPOSTA_EXT &lt; 5.71)">
          .
         </xsl:if-->	   
       <!--xsl:if test="((UC022Row[CD_PERGUNTA='UC022_t3p01']/RESPOSTA='S') or (UC022Row[CD_PERGUNTA='UC022_t3p02']/RESPOSTA='S') or (UC022Row[CD_PERGUNTA='UC022_t3p03']/RESPOSTA='S') or (UC022Row[CD_PERGUNTA='UC022_t3p04']/RESPOSTA='S') or (UC022Row[CD_PERGUNTA='UC022_t3p05']/RESPOSTA='S')) and (UC022Row[CD_PERGUNTA='UC022_t1p01']/RESPOSTA_EXT &gt; 5.70)">
           , e o Poder Legislativo, no perodo imediatamente seguinte:

           <xsl:if test="UC022Row[CD_PERGUNTA='UC022_t3p01']/RESPOSTA='S'">  
             <fo:block><fo:leader leader-pattern="space"/></fo:block>		    
			   - Concedeu vantagem, aumento, reajuste ou adequao de remunerao a qualquer ttulo, no decorrente de sentena judicial ou de determinao legal ou contratual, e da reviso prevista no inciso X do art. 37 da Constituio;
		   </xsl:if>

           <xsl:if test="UC022Row[CD_PERGUNTA='UC022_t3p02']/RESPOSTA='S'">  
             <fo:block><fo:leader leader-pattern="space"/></fo:block>		    
			   - Criou cargo, emprego ou funo;
		   </xsl:if>

           <xsl:if test="UC022Row[CD_PERGUNTA='UC022_t3p03']/RESPOSTA='S'">  
             <fo:block><fo:leader leader-pattern="space"/></fo:block>		    
			   - Alterou a estrutura de carreira, implicando aumento da despesa;
		   </xsl:if>

           <xsl:if test="UC022Row[CD_PERGUNTA='UC022_t3p04']/RESPOSTA='S'">  
             <fo:block><fo:leader leader-pattern="space"/></fo:block>		    
			   - Deu provimento a cargo pblico, admitiu ou contratou pessoal a qualquer ttulo, no relacionada com reposio decorrente de aposentadoria ou falecimento de servidores das reas de educao, sade e segurana;
		   </xsl:if>

           <xsl:if test="UC022Row[CD_PERGUNTA='UC022_t3p05']/RESPOSTA='S'">  
             <fo:block><fo:leader leader-pattern="space"/></fo:block>		    
			   - Contratou hora extra, salvo no caso do disposto no inciso II do  6 do art. 57 da Constituio e as situaes previstas na lei de diretrizes oramentrias.
		   </xsl:if>

         </xsl:if-->	   
           
		   <xsl:if test="((UC022Row[CD_PERGUNTA='UC022_t1p01']/RESPOSTA_EXT &lt; 6.01) and (UC022Row[CD_PERGUNTA='UC022_t1p02']/RESPOSTA='N'))">  
             <fo:block><fo:leader leader-pattern="space"/></fo:block>		    
			   O Poder Legislativo no excedeu o limite de 6% da Despesa com Pessoal no <xsl:value-of select="../../Header/Informacoes/InformacoesRow/DS_PERIODO"/> de <xsl:value-of select="../../Header/Informacoes/InformacoesRow/ANO_EXERCICIO"/>.
		   </xsl:if>

		   <xsl:if test="((UC022Row[CD_PERGUNTA='UC022_t1p01']/RESPOSTA_EXT &lt; 6.01) and (UC022Row[CD_PERGUNTA='UC022_t1p02']/RESPOSTA='S'))">  
             <fo:block><fo:leader leader-pattern="space"/></fo:block>		    
			   O Poder Legislativo excedeu o limite de 6% da Despesa com Pessoal no 
               <xsl:if test="UC022Row[CD_PERGUNTA='UC022_t1p03']/RESPOSTA_EXT='1'"> 1 Quadrimestre </xsl:if>
               <xsl:if test="UC022Row[CD_PERGUNTA='UC022_t1p03']/RESPOSTA_EXT='2'"> 2 Quadrimestre </xsl:if>
               <xsl:if test="UC022Row[CD_PERGUNTA='UC022_t1p03']/RESPOSTA_EXT='3'"> 3 Quadrimestre </xsl:if>
               <xsl:if test="UC022Row[CD_PERGUNTA='UC022_t1p03']/RESPOSTA_EXT='4'"> 1 Semestre </xsl:if>
               <xsl:if test="UC022Row[CD_PERGUNTA='UC022_t1p03']/RESPOSTA_EXT='5'"> 2 Semestre </xsl:if>	   		   
			   de <xsl:value-of select="UC022Row[CD_PERGUNTA='UC022_t1p04']/RESPOSTA_EXT"/>.
		   </xsl:if>

		   <xsl:if test="((UC022Row[CD_PERGUNTA='UC022_t1p01']/RESPOSTA_EXT &gt; 6) and (UC022Row[CD_PERGUNTA='UC022_t1p02']/RESPOSTA='N'))">  
             <fo:block><fo:leader leader-pattern="space"/></fo:block>		    
			   O Poder Legislativo excedeu o limite de 6% da Despesa com Pessoal no <xsl:value-of select="../../Header/Informacoes/InformacoesRow/DS_PERIODO"/> de <xsl:value-of select="../../Header/Informacoes/InformacoesRow/ANO_EXERCICIO"/>.
		   </xsl:if>

		   <xsl:if test="((UC022Row[CD_PERGUNTA='UC022_t1p01']/RESPOSTA_EXT &gt; 6) and (UC022Row[CD_PERGUNTA='UC022_t1p02']/RESPOSTA='S'))">  
             <fo:block><fo:leader leader-pattern="space"/></fo:block>		    
			   O Poder Legislativo excedeu o limite de 6% da Despesa com Pessoal no 
               <xsl:if test="UC022Row[CD_PERGUNTA='UC022_t1p03']/RESPOSTA_EXT='1'"> 1 Quadrimestre </xsl:if>
               <xsl:if test="UC022Row[CD_PERGUNTA='UC022_t1p03']/RESPOSTA_EXT='2'"> 2 Quadrimestre </xsl:if>
               <xsl:if test="UC022Row[CD_PERGUNTA='UC022_t1p03']/RESPOSTA_EXT='3'"> 3 Quadrimestre </xsl:if>
               <xsl:if test="UC022Row[CD_PERGUNTA='UC022_t1p03']/RESPOSTA_EXT='4'"> 1 Semestre </xsl:if>
               <xsl:if test="UC022Row[CD_PERGUNTA='UC022_t1p03']/RESPOSTA_EXT='5'"> 2 Semestre </xsl:if>	   		   
			   de <xsl:value-of select="UC022Row[CD_PERGUNTA='UC022_t1p04']/RESPOSTA_EXT"/>.
		   </xsl:if>
           
		   <xsl:if test="((UC022Row[CD_PERGUNTA='UC022_t1p07']/RESPOSTA='S') and (UC022Row[CD_PERGUNTA='UC022_t1p08']/RESPOSTA='N') and (UC022Row[CD_PERGUNTA='UC022_t1p11']/RESPOSTA='S'))">  
             <fo:block><fo:leader leader-pattern="space"/></fo:block>		    
			 O percentual excedente foi reduzido em, pelo menos, 1/3 no quadrimestre seguinte, <xsl:value-of select="$periodoD"/> de <xsl:value-of select="$anoD"/>, e, foi eliminado o excesso, integralmente, at o segundo perodo seguinte, <xsl:value-of select="$periodoE"/> de <xsl:value-of select="$anoE"/>.
		   </xsl:if>
		   <xsl:if test="((UC022Row[CD_PERGUNTA='UC022_t1p07']/RESPOSTA='S') and (UC022Row[CD_PERGUNTA='UC022_t1p08']/RESPOSTA='S'))">  
             <fo:block><fo:leader leader-pattern="space"/></fo:block>		    
			 O percentual excedente foi eliminado integralmente at o primeiro perodo seguinte, <xsl:value-of select="$periodoD"/> de <xsl:value-of select="$anoD"/>.
		   </xsl:if>
		   <xsl:if test="((UC022Row[CD_PERGUNTA='UC022_t1p07']/RESPOSTA='S') and (UC022Row[CD_PERGUNTA='UC022_t1p08']/RESPOSTA='N') and (UC022Row[CD_PERGUNTA='UC022_t1p11']/RESPOSTA='N'))">  
             <fo:block><fo:leader leader-pattern="space"/></fo:block>		    
			 O percentual excedente foi reduzido em, pelo menos, 1/3 no quadrimestre seguinte, <xsl:value-of select="$periodoD"/> de <xsl:value-of select="$anoD"/>, e, no foi eliminado o excesso, integralmente, at o segundo perodo seguinte, <xsl:value-of select="$periodoE"/> de <xsl:value-of select="$anoE"/>.
		   </xsl:if>
		   <xsl:if test="((UC022Row[CD_PERGUNTA='UC022_t1p07']/RESPOSTA='N') and (UC022Row[CD_PERGUNTA='UC022_t1p08']/RESPOSTA='N') and (UC022Row[CD_PERGUNTA='UC022_t1p11']/RESPOSTA='N'))">  
             <fo:block><fo:leader leader-pattern="space"/></fo:block>		    
			 O percentual excedente no foi reduzido em, pelo menos, 1/3 no quadrimestre seguinte, <xsl:value-of select="$periodoD"/> de <xsl:value-of select="$anoD"/>, e, no foi eliminado o excesso, integralmente, at o segundo perodo seguinte, <xsl:value-of select="$periodoE"/> de <xsl:value-of select="$anoE"/>.
		   </xsl:if>
		   <xsl:if test="((UC022Row[CD_PERGUNTA='UC022_t1p07']/RESPOSTA='N') and (UC022Row[CD_PERGUNTA='UC022_t1p08']/RESPOSTA='N') and (UC022Row[CD_PERGUNTA='UC022_t1p11']/RESPOSTA='S'))">  
             <fo:block><fo:leader leader-pattern="space"/></fo:block>		    
			 O percentual excedente no foi reduzido em, pelo menos, 1/3 no quadrimestre seguinte, <xsl:value-of select="$periodoD"/> de <xsl:value-of select="$anoD"/>, e, foi eliminado o excesso, integralmente, at o segundo perodo seguinte, <xsl:value-of select="$periodoE"/> de <xsl:value-of select="$anoE"/>.
		   </xsl:if>
		   <xsl:if test="((UC022Row[CD_PERGUNTA='UC022_t1p07']/RESPOSTA='S') and (UC022Row[CD_PERGUNTA='UC022_t1p08']/RESPOSTA='N') and (UC022Row[CD_PERGUNTA='UC022_t1p11']/RESPOSTA='X'))">  
             <fo:block><fo:leader leader-pattern="space"/></fo:block>		    
			 O percentual excedente foi reduzido em, pelo menos, 1/3 no quadrimestre seguinte, <xsl:value-of select="$periodoD"/> de <xsl:value-of select="$anoD"/>.
		   </xsl:if>
		   <xsl:if test="((UC022Row[CD_PERGUNTA='UC022_t1p07']/RESPOSTA='N') and (UC022Row[CD_PERGUNTA='UC022_t1p08']/RESPOSTA='N') and (UC022Row[CD_PERGUNTA='UC022_t1p11']/RESPOSTA='X'))">  
             <fo:block><fo:leader leader-pattern="space"/></fo:block>		    
			 O percentual excedente no foi reduzido em, pelo menos, 1/3 no quadrimestre seguinte, <xsl:value-of select="$periodoD"/> de <xsl:value-of select="$anoD"/>.
		   </xsl:if>

           <!--ltima pergunta da tela -->
		   <xsl:if test="(((../../Header/Informacoes/InformacoesRow/DS_PERIODO = '3 Quadrimestre') or (../../Header/Informacoes/InformacoesRow/DS_PERIODO = '2 Semestre')) and (../../Header/Informacoes/InformacoesRow/EHENCMANDATO = 'S'))">  
             <fo:block><fo:leader leader-pattern="space"/></fo:block>		    
			 <xsl:value-of select="$perg16"/> a realizao de ato que resultou aumento de despesa com pessoal expedido nos cento e oitenta dias anteriores ao final de mandato do titular do respectivo Poder ou rgo referido no artigo 20 da Lei de Responsabilidade Fiscal.
		   </xsl:if>

       </xsl:if>	
	   <!--PODER EXECUTIVO   -->   
       <xsl:if test="../../Header/Informacoes/InformacoesRow/PODER='P'">
        A Despesa com Pessoal do Poder Executivo <xsl:value-of select="$perg1"/> apurada conforme estabelecido nas Resolues e Instrues Normativas do TCE-RS.        
       <fo:block><fo:leader leader-pattern="space"/></fo:block>
	    A Despesa total com Pessoal <xsl:value-of select="$perg2_ex"/> a 95% (noventa e cinco por cento) do limite no <xsl:value-of select="../../Header/Informacoes/InformacoesRow/DS_PERIODO"/> de <xsl:value-of select="../../Header/Informacoes/InformacoesRow/ANO_EXERCICIO"/>.
         <!--xsl:if test="((UC022Row[CD_PERGUNTA='UC022_t3p01']/RESPOSTA='N') and (UC022Row[CD_PERGUNTA='UC022_t3p02']/RESPOSTA='N') and (UC022Row[CD_PERGUNTA='UC022_t3p03']/RESPOSTA='N') and (UC022Row[CD_PERGUNTA='UC022_t3p04']/RESPOSTA='N') and (UC022Row[CD_PERGUNTA='UC022_t3p05']/RESPOSTA='N')) or (UC022Row[CD_PERGUNTA='UC022_t1p01']/RESPOSTA_EXT &lt; 51.31)">
         .
         </xsl:if-->	   
       <!--xsl:if test="((UC022Row[CD_PERGUNTA='UC022_t3p01']/RESPOSTA='S') or (UC022Row[CD_PERGUNTA='UC022_t3p02']/RESPOSTA='S') or (UC022Row[CD_PERGUNTA='UC022_t3p03']/RESPOSTA='S') or (UC022Row[CD_PERGUNTA='UC022_t3p04']/RESPOSTA='S') or (UC022Row[CD_PERGUNTA='UC022_t3p05']/RESPOSTA='S')) and (UC022Row[CD_PERGUNTA='UC022_t1p01']/RESPOSTA_EXT &gt; 51.30)">
           , e o Poder Executivo, no perodo imediatamente seguinte:

           <xsl:if test="UC022Row[CD_PERGUNTA='UC022_t3p01']/RESPOSTA='S'">  
             <fo:block><fo:leader leader-pattern="space"/></fo:block>		    
			   - Concedeu vantagem, aumento, reajuste ou adequao de remunerao a qualquer ttulo, no decorrente de sentena judicial ou de determinao legal ou contratual, e da reviso prevista no inciso X do art. 37 da Constituio;
		   </xsl:if>

           <xsl:if test="UC022Row[CD_PERGUNTA='UC022_t3p02']/RESPOSTA='S'">  
             <fo:block><fo:leader leader-pattern="space"/></fo:block>		    
			   - Criou cargo, emprego ou funo;
		   </xsl:if>

           <xsl:if test="UC022Row[CD_PERGUNTA='UC022_t3p03']/RESPOSTA='S'">  
             <fo:block><fo:leader leader-pattern="space"/></fo:block>		    
			   - Alterou a estrutura de carreira, implicando aumento da despesa;
		   </xsl:if>

           <xsl:if test="UC022Row[CD_PERGUNTA='UC022_t3p04']/RESPOSTA='S'">  
             <fo:block><fo:leader leader-pattern="space"/></fo:block>		    
			   - Deu provimento a cargo pblico, admitiu ou contratou pessoal a qualquer ttulo, no relacionada com reposio decorrente de aposentadoria ou falecimento de servidores das reas de educao, sade e segurana;
		   </xsl:if>

           <xsl:if test="UC022Row[CD_PERGUNTA='UC022_t3p05']/RESPOSTA='S'">  
             <fo:block><fo:leader leader-pattern="space"/></fo:block>		    
			   - Contratou hora extra, salvo no caso do disposto no inciso II do  6 do art. 57 da Constituio e as situaes previstas na lei de diretrizes oramentrias.
		   </xsl:if>

         </xsl:if-->	   

		   <xsl:if test="((UC022Row[CD_PERGUNTA='UC022_t1p01']/RESPOSTA_EXT &lt; 54.01) and (UC022Row[CD_PERGUNTA='UC022_t1p02']/RESPOSTA='N'))">  
             <fo:block><fo:leader leader-pattern="space"/></fo:block>		    
			   O Poder Executivo no excedeu o limite de 54% da Despesa com Pessoal no <xsl:value-of select="../../Header/Informacoes/InformacoesRow/DS_PERIODO"/> de <xsl:value-of select="../../Header/Informacoes/InformacoesRow/ANO_EXERCICIO"/>.
		   </xsl:if>

		   <xsl:if test="((UC022Row[CD_PERGUNTA='UC022_t1p01']/RESPOSTA_EXT &lt; 54.01) and (UC022Row[CD_PERGUNTA='UC022_t1p02']/RESPOSTA='S'))">  
             <fo:block><fo:leader leader-pattern="space"/></fo:block>		    
			   O Poder Executivo excedeu o limite de 54% da Despesa com Pessoal no 
               <xsl:if test="UC022Row[CD_PERGUNTA='UC022_t1p03']/RESPOSTA_EXT='1'"> 1 Quadrimestre </xsl:if>
               <xsl:if test="UC022Row[CD_PERGUNTA='UC022_t1p03']/RESPOSTA_EXT='2'"> 2 Quadrimestre </xsl:if>
               <xsl:if test="UC022Row[CD_PERGUNTA='UC022_t1p03']/RESPOSTA_EXT='3'"> 3 Quadrimestre </xsl:if>
               <xsl:if test="UC022Row[CD_PERGUNTA='UC022_t1p03']/RESPOSTA_EXT='4'"> 1 Semestre </xsl:if>
               <xsl:if test="UC022Row[CD_PERGUNTA='UC022_t1p03']/RESPOSTA_EXT='5'"> 2 Semestre </xsl:if>	   		   
			   de <xsl:value-of select="UC022Row[CD_PERGUNTA='UC022_t1p04']/RESPOSTA_EXT"/>.
		   </xsl:if>

		   <xsl:if test="((UC022Row[CD_PERGUNTA='UC022_t1p01']/RESPOSTA_EXT &gt; 54) and (UC022Row[CD_PERGUNTA='UC022_t1p02']/RESPOSTA='N'))">  
             <fo:block><fo:leader leader-pattern="space"/></fo:block>		    
			   O Poder Executivo excedeu o limite de 54% da Despesa com Pessoal no <xsl:value-of select="../../Header/Informacoes/InformacoesRow/DS_PERIODO"/> de <xsl:value-of select="../../Header/Informacoes/InformacoesRow/ANO_EXERCICIO"/>.
		   </xsl:if>

		   <xsl:if test="((UC022Row[CD_PERGUNTA='UC022_t1p01']/RESPOSTA_EXT &gt; 54) and (UC022Row[CD_PERGUNTA='UC022_t1p02']/RESPOSTA='S'))">  
             <fo:block><fo:leader leader-pattern="space"/></fo:block>		    
			   O Poder Executivo excedeu o limite de 54% da Despesa com Pessoal no 
               <xsl:if test="UC022Row[CD_PERGUNTA='UC022_t1p03']/RESPOSTA_EXT='1'"> 1 Quadrimestre </xsl:if>
               <xsl:if test="UC022Row[CD_PERGUNTA='UC022_t1p03']/RESPOSTA_EXT='2'"> 2 Quadrimestre </xsl:if>
               <xsl:if test="UC022Row[CD_PERGUNTA='UC022_t1p03']/RESPOSTA_EXT='3'"> 3 Quadrimestre </xsl:if>
               <xsl:if test="UC022Row[CD_PERGUNTA='UC022_t1p03']/RESPOSTA_EXT='4'"> 1 Semestre </xsl:if>
               <xsl:if test="UC022Row[CD_PERGUNTA='UC022_t1p03']/RESPOSTA_EXT='5'"> 2 Semestre </xsl:if>	   		   
			   de <xsl:value-of select="UC022Row[CD_PERGUNTA='UC022_t1p04']/RESPOSTA_EXT"/>.
		   </xsl:if>

		   <xsl:if test="((UC022Row[CD_PERGUNTA='UC022_t1p07']/RESPOSTA='S') and (UC022Row[CD_PERGUNTA='UC022_t1p08']/RESPOSTA='N') and (UC022Row[CD_PERGUNTA='UC022_t1p11']/RESPOSTA='S'))">  
             <fo:block><fo:leader leader-pattern="space"/></fo:block>		    
			 O percentual excedente foi reduzido em, pelo menos, 1/3 no quadrimestre seguinte, <xsl:value-of select="$periodoD"/> de <xsl:value-of select="$anoD"/>, e, foi eliminado o excesso, integralmente, at o segundo perodo seguinte, <xsl:value-of select="$periodoE"/> de <xsl:value-of select="$anoE"/>.
		   </xsl:if>
		   <xsl:if test="((UC022Row[CD_PERGUNTA='UC022_t1p07']/RESPOSTA='S') and (UC022Row[CD_PERGUNTA='UC022_t1p08']/RESPOSTA='S'))">  
             <fo:block><fo:leader leader-pattern="space"/></fo:block>		    
			 O percentual excedente foi eliminado integralmente at o primeiro perodo seguinte, <xsl:value-of select="$periodoD"/> de <xsl:value-of select="$anoD"/>.
		   </xsl:if>
		   <xsl:if test="((UC022Row[CD_PERGUNTA='UC022_t1p07']/RESPOSTA='S') and (UC022Row[CD_PERGUNTA='UC022_t1p08']/RESPOSTA='N') and (UC022Row[CD_PERGUNTA='UC022_t1p11']/RESPOSTA='N'))">  
             <fo:block><fo:leader leader-pattern="space"/></fo:block>		    
			 O percentual excedente foi reduzido em, pelo menos, 1/3 no quadrimestre seguinte, <xsl:value-of select="$periodoD"/> de <xsl:value-of select="$anoD"/>, e, no foi eliminado o excesso, integralmente, at o segundo perodo seguinte, <xsl:value-of select="$periodoE"/> de <xsl:value-of select="$anoE"/>.
		   </xsl:if>
		   <xsl:if test="((UC022Row[CD_PERGUNTA='UC022_t1p07']/RESPOSTA='N') and (UC022Row[CD_PERGUNTA='UC022_t1p08']/RESPOSTA='N') and (UC022Row[CD_PERGUNTA='UC022_t1p11']/RESPOSTA='N'))">  
             <fo:block><fo:leader leader-pattern="space"/></fo:block>		    
			 O percentual excedente no foi reduzido em, pelo menos, 1/3 no quadrimestre seguinte, <xsl:value-of select="$periodoD"/> de <xsl:value-of select="$anoD"/>, e, no foi eliminado o excesso, integralmente, at o segundo perodo seguinte, <xsl:value-of select="$periodoE"/> de <xsl:value-of select="$anoE"/>.
		   </xsl:if>
		   <xsl:if test="((UC022Row[CD_PERGUNTA='UC022_t1p07']/RESPOSTA='N') and (UC022Row[CD_PERGUNTA='UC022_t1p08']/RESPOSTA='N') and (UC022Row[CD_PERGUNTA='UC022_t1p11']/RESPOSTA='S'))">  
             <fo:block><fo:leader leader-pattern="space"/></fo:block>		    
			 O percentual excedente no foi reduzido em, pelo menos, 1/3 no quadrimestre seguinte, <xsl:value-of select="$periodoD"/> de <xsl:value-of select="$anoD"/>, e, foi eliminado o excesso, integralmente, at o segundo perodo seguinte, <xsl:value-of select="$periodoE"/> de <xsl:value-of select="$anoE"/>.
		   </xsl:if>
		   <xsl:if test="((UC022Row[CD_PERGUNTA='UC022_t1p07']/RESPOSTA='S') and (UC022Row[CD_PERGUNTA='UC022_t1p08']/RESPOSTA='N') and (UC022Row[CD_PERGUNTA='UC022_t1p11']/RESPOSTA='X'))">  
             <fo:block><fo:leader leader-pattern="space"/></fo:block>		    
			 O percentual excedente foi reduzido em, pelo menos, 1/3 no quadrimestre seguinte, <xsl:value-of select="$periodoD"/> de <xsl:value-of select="$anoD"/>.
		   </xsl:if>
		   <xsl:if test="((UC022Row[CD_PERGUNTA='UC022_t1p07']/RESPOSTA='N') and (UC022Row[CD_PERGUNTA='UC022_t1p08']/RESPOSTA='N') and (UC022Row[CD_PERGUNTA='UC022_t1p11']/RESPOSTA='X'))">  
             <fo:block><fo:leader leader-pattern="space"/></fo:block>		    
			 O percentual excedente no foi reduzido em, pelo menos, 1/3 no quadrimestre seguinte, <xsl:value-of select="$periodoD"/> de <xsl:value-of select="$anoD"/>.
		   </xsl:if>
           <!--ltima pergunta da tela -->
		   <xsl:if test="(((../../Header/Informacoes/InformacoesRow/DS_PERIODO = '3 Quadrimestre') or (../../Header/Informacoes/InformacoesRow/DS_PERIODO = '2 Semestre')) and (../../Header/Informacoes/InformacoesRow/EHENCMANDATO = 'S'))">  
             <fo:block><fo:leader leader-pattern="space"/></fo:block>		    
			 <xsl:value-of select="$perg16"/> a realizao de ato que resultou aumento de despesa com pessoal expedido nos cento e oitenta dias anteriores ao final de mandato do titular do respectivo Poder ou rgo referido no artigo 20 da Lei de Responsabilidade Fiscal.
		   </xsl:if>

       </xsl:if>	   
     
      </fo:block>
     </fo:table-cell>
    </fo:table-row>   	
  </fo:table-body>
 </fo:table> 
  
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 
 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="556pt"/>

  <fo:table-body>	   
   <fo:table-row>
    <fo:table-cell>
	  <fo:block xsl:use-attribute-sets="txtJustifyMed" text-align="justify" margin-left="15pt" hyphenate="true" >
       <xsl:if test="../../Observacoes/ObservacoesRemessas/ObservacoesRemessasRow[CD_OBSERVACOES='UC022']/OBSERVACOES!=''">
        <fo:inline font-weight="bold">Observaes: </fo:inline><xsl:value-of select="../../Observacoes/ObservacoesRemessas/ObservacoesRemessasRow[CD_OBSERVACOES='UC022']/OBSERVACOES"></xsl:value-of>
       </xsl:if>
       <xsl:if test="../../Observacoes/ObservacoesRemessas/ObservacoesRemessasRow[CD_OBSERVACOES='UC022']/OBSERVACOES=''">
        <fo:inline font-style="italic">No foram inseridas observaes para este item.</fo:inline>
       </xsl:if>
      </fo:block>
     </fo:table-cell>
    </fo:table-row>   	
  </fo:table-body>
 </fo:table> 
 <!-- FIM    UC022  --> 
</xsl:template>

<!--
#################################################
# 23 - Informaes sobre Inativos e Pensionistas#
#################################################
-->
<xsl:template match="UC040">

 <xsl:variable name="possuiRPPS">
    <xsl:if test="../../Header/Informacoes/InformacoesRow/POSSUIRPPS='S'"> RPPS </xsl:if>
    <xsl:if test="../../Header/Informacoes/InformacoesRow/POSSUIRPPS='N'"> Tesouro Municipal </xsl:if>
 </xsl:variable>

 <!-- INICIO 23 - Informaes sobre Inativos e Pensionistas -->
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 
 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" />
  <fo:table-body>
   <fo:table-row>
    <fo:table-cell>
     <fo:block xsl:use-attribute-sets="titFCinza">
      <xsl:text>23 - Informaes sobre Inativos e Pensionistas</xsl:text>
     </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-body>
 </fo:table>
 
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 
 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="556pt"/>

  <fo:table-body >	   
    <fo:table-row>								
     <fo:table-cell>
	  <fo:block xsl:use-attribute-sets="txtJustifyMed" text-align="justify" margin-left="15pt" hyphenate="true" >
       <!-- Primeira, Segunda e Terceira Resposta do Relatrio-->        
        <xsl:if test="UC040Row[CD_PERGUNTA='UC040_t1p01']/RESPOSTA='N'">
  		 O Municpio no paga complementao de aposentadorias.
        </xsl:if>
        <xsl:if test="UC040Row[CD_PERGUNTA='UC040_t1p01']/RESPOSTA='S'">

            <!--Primeiro Pargrafo-->

			<!--Verifica se a pergunta 2 e 4 so diferentes de zero-->
  			<xsl:if test="((UC040Row[CD_PERGUNTA='UC040_t1p02']/RESPOSTA_EXT!='0') and (UC040Row[CD_PERGUNTA='UC040_t1p04']/RESPOSTA_EXT!='0'))">
			   O Municpio paga complementao de aposentadorias, sendo <xsl:value-of select="UC040Row[CD_PERGUNTA='UC040_t1p02']/RESPOSTA_EXT"/> o nmero total de inativos originrios do Poder Executivo e <xsl:value-of select="UC040Row[CD_PERGUNTA='UC040_t1p04']/RESPOSTA_EXT"/> o nmero total de inativos originrios do Poder Legislativo que recebem tal complementao.
        	</xsl:if>
			<!--Verifica se a pergunta 2  diferente de zero e 4 igual a zero-->
  			<xsl:if test="((UC040Row[CD_PERGUNTA='UC040_t1p02']/RESPOSTA_EXT!='0') and (UC040Row[CD_PERGUNTA='UC040_t1p04']/RESPOSTA_EXT='0'))">
			   O Municpio paga complementao de aposentadorias, sendo <xsl:value-of select="UC040Row[CD_PERGUNTA='UC040_t1p02']/RESPOSTA_EXT"/> o nmero total de inativos originrios do Poder Executivo que recebem tal complementao.
        	</xsl:if>
			<!--Verifica se a pergunta 2  igual de zero e 4  diferente de zero-->
  			<xsl:if test="((UC040Row[CD_PERGUNTA='UC040_t1p02']/RESPOSTA_EXT='0') and (UC040Row[CD_PERGUNTA='UC040_t1p04']/RESPOSTA_EXT!='0'))">
			   O Municpio paga complementao de aposentadorias, sendo <xsl:value-of select="UC040Row[CD_PERGUNTA='UC040_t1p04']/RESPOSTA_EXT"/> o nmero total de inativos originrios do Poder Legislativo que recebem tal complementao.
        	</xsl:if>
            <fo:block><fo:leader leader-pattern="space"/></fo:block>		    

            <!--Segundo Pargrafo-->

			<!--Verifica se a pergunta 3 e 5 so diferentes de zero-->
  			<xsl:if test="((UC040Row[CD_PERGUNTA='UC040_t1p03']/RESPOSTA_EXT!='0') and (UC040Row[CD_PERGUNTA='UC040_t1p05']/RESPOSTA_EXT!='0'))">
			   O nmero total de inativos que passaram a receber complementao de proventos no exerccio  de <xsl:value-of select="UC040Row[CD_PERGUNTA='UC040_t1p03']/RESPOSTA_EXT"/> originrios do Poder Executivo e de <xsl:value-of select="UC040Row[CD_PERGUNTA='UC040_t1p05']/RESPOSTA_EXT"/> originrios do Poder Legislativo.
        	</xsl:if>
			<!--Verifica se a pergunta 3  diferente de zero e 5 igual a zero-->
  			<xsl:if test="((UC040Row[CD_PERGUNTA='UC040_t1p03']/RESPOSTA_EXT!='0') and (UC040Row[CD_PERGUNTA='UC040_t1p05']/RESPOSTA_EXT='0'))">
			   O nmero total de inativos que passaram a receber complementao de proventos no exerccio  de <xsl:value-of select="UC040Row[CD_PERGUNTA='UC040_t1p03']/RESPOSTA_EXT"/> originrios do Poder Executivo.
        	</xsl:if>
			<!--Verifica se a pergunta 3  igual de zero e 5  diferente de zero-->
  			<xsl:if test="((UC040Row[CD_PERGUNTA='UC040_t1p03']/RESPOSTA_EXT='0') and (UC040Row[CD_PERGUNTA='UC040_t1p05']/RESPOSTA_EXT!='0'))">
			   O nmero total de inativos que passaram a receber complementao de proventos no exerccio  de <xsl:value-of select="UC040Row[CD_PERGUNTA='UC040_t1p05']/RESPOSTA_EXT"/> originrios do Poder Legislativo.
        	</xsl:if>
            <fo:block><fo:leader leader-pattern="space"/></fo:block>		    

            <!--Terceiro Pargrafo-->

			<!--Verifica se a pergunta 6  igual a zero-->
  			<xsl:if test="(UC040Row[CD_PERGUNTA='UC040_t1p06']/RESPOSTA_EXT='0')">
			   Atualmente no existem inativos sendo pagos pelo <xsl:value-of select="$possuiRPPS"/>.
        	</xsl:if>
  			<!--Verifica se a pergunta 6  diferente de zero-->
			<xsl:if test="(UC040Row[CD_PERGUNTA='UC040_t1p06']/RESPOSTA_EXT!='0')">
	  			<!--Verifica se a pergunta 7  diferente de zero-->
				<xsl:if test="(UC040Row[CD_PERGUNTA='UC040_t1p07']/RESPOSTA_EXT!='0')">
			       O nmero total de inativos pagos pelo <xsl:value-of select="$possuiRPPS"/>  <xsl:value-of select="UC040Row[CD_PERGUNTA='UC040_t1p06']/RESPOSTA_EXT"/>, sendo que <xsl:value-of select="UC040Row[CD_PERGUNTA='UC040_t1p07']/RESPOSTA_EXT"/> inativaes foram concedidas no perodo.
	        	</xsl:if>
	  			<!--Verifica se a pergunta 7  igual a zero-->
				<xsl:if test="(UC040Row[CD_PERGUNTA='UC040_t1p07']/RESPOSTA_EXT='0')">
			       O nmero total de inativos pagos pelo <xsl:value-of select="$possuiRPPS"/>  <xsl:value-of select="UC040Row[CD_PERGUNTA='UC040_t1p06']/RESPOSTA_EXT"/>.
	        	</xsl:if>		   
        	</xsl:if>
            <fo:block><fo:leader leader-pattern="space"/></fo:block>		    

            <!--Quarto Pargrafo-->

			<!--Verifica se a pergunta 8  igual a zero-->
  			<xsl:if test="(UC040Row[CD_PERGUNTA='UC040_t1p08']/RESPOSTA_EXT='0')">
			   Atualmente no existem penses no-compensveis sendo pagas pelo <xsl:value-of select="$possuiRPPS"/>.
        	</xsl:if>
  			<!--Verifica se a pergunta 8  diferente de zero-->
			<xsl:if test="(UC040Row[CD_PERGUNTA='UC040_t1p08']/RESPOSTA_EXT!='0')">
	  			<!--Verifica se a pergunta 9  diferente de zero-->
				<xsl:if test="(UC040Row[CD_PERGUNTA='UC040_t1p09']/RESPOSTA_EXT!='0')">
			       O total de penses no-compensveis pagas pelo <xsl:value-of select="$possuiRPPS"/>  <xsl:value-of select="UC040Row[CD_PERGUNTA='UC040_t1p08']/RESPOSTA_EXT"/>, sendo que <xsl:value-of select="UC040Row[CD_PERGUNTA='UC040_t1p09']/RESPOSTA_EXT"/> foram concedidas no perodo.
	        	</xsl:if>
	  			<!--Verifica se a pergunta 9  igual a zero-->
				<xsl:if test="(UC040Row[CD_PERGUNTA='UC040_t1p09']/RESPOSTA_EXT='0')">
			       O total de penses no-compensveis pagas pelo <xsl:value-of select="$possuiRPPS"/>  <xsl:value-of select="UC040Row[CD_PERGUNTA='UC040_t1p08']/RESPOSTA_EXT"/>.
	        	</xsl:if>		   
        	</xsl:if>
            <fo:block><fo:leader leader-pattern="space"/></fo:block>		    
        </xsl:if>
      </fo:block>
     </fo:table-cell>
    </fo:table-row>   	
  </fo:table-body>
 </fo:table> 
  
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 
 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="556pt"/>

  <fo:table-body >	   
    <fo:table-row>								
     <fo:table-cell>
	  <fo:block xsl:use-attribute-sets="txtJustifyMed" text-align="justify" margin-left="15pt" hyphenate="true" >
       <xsl:if test="../../Observacoes/ObservacoesRemessas/ObservacoesRemessasRow[CD_OBSERVACOES='UC040']/OBSERVACOES!=''">
        <fo:inline font-weight="bold">Observaes: </fo:inline><xsl:value-of select="../../Observacoes/ObservacoesRemessas/ObservacoesRemessasRow[CD_OBSERVACOES='UC040']/OBSERVACOES"></xsl:value-of>
       </xsl:if>
       <xsl:if test="../../Observacoes/ObservacoesRemessas/ObservacoesRemessasRow[CD_OBSERVACOES='UC040']/OBSERVACOES=''">
        <fo:inline font-style="italic">No foram inseridas observaes para este item.</fo:inline>
       </xsl:if>
      </fo:block>
     </fo:table-cell>
    </fo:table-row>   	
  </fo:table-body>
 </fo:table> 
 <!-- FIM    UC040  --> 
</xsl:template>

<!--
###########################################################################
# 24 ? Contribuio para Custeio de Despesas de Outros Entes da Federao #
###########################################################################
-->
<xsl:template match="UC041">
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
<!--
O municpio (1) <contribuiu / no contribuiu> para o custeio de despesas de competncia de outros Entes da Federao no exerccio de <Ano>. Esse procedimento (2) <foi / no foi>  efetuado de acordo com os incisos I e II do art. 62 da LRF.

(1) se a resposta for ?sim?, usar ?contribuiu?, se for ?no?, usar ?no contribuiu?. 
(2) se a resposta do item (1) for ?no?, no apresentar a segunda frase. Se for ?sim?, apresentar a frase, preenchendo com ?foi? se a resposta do item (2) for ?sim? e com ?no foi? se a resposta do item (2) for ?no?.

Obs: Todas as observaes digitadas na tela sero apresentadas no relatrio, abaixo do respectivo item.

-->
 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" />
  <fo:table-body>
   <fo:table-row>
    <fo:table-cell>
     <fo:block xsl:use-attribute-sets="titFCinza">
      <xsl:text>24 - Contribuio para Custeio de Despesas de Outros Entes da Federao</xsl:text>
     </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-body>
 </fo:table>
 
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 
 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="556pt"/>

  <fo:table-body >	   
    <fo:table-row>								
     <fo:table-cell>
	  <fo:block xsl:use-attribute-sets="txtJustifyMed" text-align="justify" margin-left="15pt" hyphenate="true" >

       <!-- Primeira e Segunda Resposta do Relatrio-->        
       <xsl:choose>
        <xsl:when test="UC041Row[CD_PERGUNTA='UC041_t1p01']/RESPOSTA='S'">
        O municpio contribuiu para o custeio de despesas de competncia de outros Entes da Federao no exerccio de <xsl:value-of select="../../Header/Informacoes/InformacoesRow/ANO_EXERCICIO"/>.
         <xsl:choose>
          <xsl:when test="UC041Row[CD_PERGUNTA='UC041_t1p02']/RESPOSTA='S'">
          Esse procedimento foi efetuado de acordo com os incisos I e II do art. 62 da LRF.
          </xsl:when>
          <xsl:otherwise>
          Esse procedimento no foi efetuado de acordo com os incisos I e II do art. 62 da LRF.
          </xsl:otherwise>
         </xsl:choose>
        </xsl:when>

        <xsl:otherwise>
        O municpio no contribuiu para o custeio de despesas de competncia de outros Entes da Federao no exerccio de <xsl:value-of select="../../Header/Informacoes/InformacoesRow/ANO_EXERCICIO"/>.
        </xsl:otherwise>
       </xsl:choose>

     </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-body>
 </fo:table>

 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 
 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="556pt"/>

  <fo:table-body >	   
    <fo:table-row>								
     <fo:table-cell>
	  <fo:block xsl:use-attribute-sets="txtJustifyMed" text-align="justify" margin-left="15pt" hyphenate="true" >
       <xsl:choose>
         <xsl:when test="../../Observacoes/ObservacoesRemessas/ObservacoesRemessasRow[CD_OBSERVACOES='UC041']/OBSERVACOES!=''">
          <fo:inline font-weight="bold">Observaes: </fo:inline><xsl:value-of select="../../Observacoes/ObservacoesRemessas/ObservacoesRemessasRow[CD_OBSERVACOES='UC041']/OBSERVACOES"></xsl:value-of>
         </xsl:when>
         <xsl:otherwise>
          <fo:inline font-style="italic">No foram inseridas observaes para este item.</fo:inline>
         </xsl:otherwise>
       </xsl:choose>
      </fo:block>
     </fo:table-cell>
    </fo:table-row>   	
  </fo:table-body>
 </fo:table> 
 <!-- FIM UC041 -->
</xsl:template>



<!--
###########################################################################
# 25 - Informaes referentes  LC n 131/2009                            #
###########################################################################
-->
<xsl:template match="UC042">
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
<!--
-->
 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" />
  <fo:table-body>
   <fo:table-row>
    <fo:table-cell>
     <fo:block xsl:use-attribute-sets="titFCinza">
      <xsl:text>25 - Informaes referentes  LC n 131/2009</xsl:text>
     </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-body>
 </fo:table>
 
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 
 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="556pt"/>

  <fo:table-body >	   
    <fo:table-row>								
     <fo:table-cell>
	  <fo:block xsl:use-attribute-sets="txtJustifyMed" text-align="justify" margin-left="15pt" hyphenate="true" >

       <!-- Primeira, Segunda e "Terceira" (Possui Prazo) respostas do Relatrio-->        
       <xsl:choose>
        <xsl:when test="UC042Row[CD_PERGUNTA='UC042_t1p01']/RESPOSTA='S'">
As informaes foram disponibilizadas na Internet, em tempo real, em atendimento ao Art. 48, Pargrafo nico, inciso II e Art. 48-A, ambos da LC n 101/2000, com as alteraes introduzidas pela LC n 131/2009, a partir do dia 
<xsl:value-of select="UC042Row[CD_PERGUNTA='UC042_t1p02']/RESPOSTA_EXT"/>.
        </xsl:when>

        <xsl:otherwise>
		  <xsl:choose>
			<xsl:when test="UC042Row[CD_PERGUNTA='UC042_t1p03']/RESPOSTA='S'"> <!-- Possui Prazo -->
As informaes no foram disponibilizadas na Internet, em tempo real, conforme previsto no Art. 48, Pargrafo nico, inciso II e Art. 48-A, ambos da LC n 101/2000, com as alteraes introduzidas pela LC n 131/2009, pois o Municpio enquadra-se nos prazos previstos no art. 73-B da LC n 101/2000.
            </xsl:when>
            <xsl:otherwise>
As informaes no foram disponibilizadas na Internet, em tempo real, em desatendimento ao Art. 48, Pargrafo nico, inciso II e Art. 48-A, ambos da LC n 101/2000, com as alteraes introduzidas pela LC n 131/2009.
            </xsl:otherwise>
          </xsl:choose>

        </xsl:otherwise>
       </xsl:choose>

     </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-body>
 </fo:table>

 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 
 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="556pt"/>

  <fo:table-body >	   
    <fo:table-row>								
     <fo:table-cell>
	  <fo:block xsl:use-attribute-sets="txtJustifyMed" text-align="justify" margin-left="15pt" hyphenate="true" >
       <xsl:choose>
         <xsl:when test="../../Observacoes/ObservacoesRemessas/ObservacoesRemessasRow[CD_OBSERVACOES='UC042']/OBSERVACOES!=''">
          <fo:inline font-weight="bold">Observaes: </fo:inline><xsl:value-of select="../../Observacoes/ObservacoesRemessas/ObservacoesRemessasRow[CD_OBSERVACOES='UC042']/OBSERVACOES"></xsl:value-of>
         </xsl:when>
         <xsl:otherwise>
          <fo:inline font-style="italic">No foram inseridas observaes para este item.</fo:inline>
         </xsl:otherwise>
       </xsl:choose>
      </fo:block>
     </fo:table-cell>
    </fo:table-row>   	
  </fo:table-body>
 </fo:table> 
</xsl:template>
<!-- FIM UC042 -->


<!--
###########################################################################
# 26 - Sistema de controle de custos                                      #
###########################################################################
-->
<xsl:template match="UC045">

 <xsl:variable name="texto">
   <xsl:choose>
     <xsl:when test="UC045Row[CD_PERGUNTA='UC045_t1p01']/RESPOSTA='S'">
A Administrao Pblica mantm sistema de custos que permite a 
avaliao e o acompanhamento da gesto oramentria, financeira e patrimonial 
conforme previsto no art. 50,  3 da LRF.
     </xsl:when>
     <xsl:otherwise>
A Administrao Pblica no mantm sistema de custos que permite a 
avaliao e o acompanhamento da gesto oramentria, financeira e patrimonial 
conforme previsto no art. 50,  3 da LRF.
     </xsl:otherwise>
   </xsl:choose>
 </xsl:variable>
 
 <xsl:call-template name="UC.itemrelatorio">
   <xsl:with-param name="titulo" select="'26 - Sistema de controle de custos'"/>
   <xsl:with-param name="texto" select="$texto"/>
   <xsl:with-param name="uc.id" select="'UC045'"/>
 </xsl:call-template>

 <!--xsl:call-template name="UC.titulo">
   <xsl:with-param name="titulo" select="'26 - Sistema de controle de custos'"/>
 </xsl:call-template>

 <xsl:call-template name="UC.texto">
   <xsl:with-param name="texto" select="$texto"/>
 </xsl:call-template>

 <xsl:call-template name="UC.observacoes">
   <xsl:with-param name="uc.id" select="'UC045'"/>
 </xsl:call-template-->
 
</xsl:template>
<!-- FIM UC045 -->



<!--
###########################################################################
# 27 - Controle interno                                                   #
###########################################################################
-->
<xsl:template match="UC046">

  <xsl:call-template name="UC.titulo">
    <xsl:with-param name="titulo" select="'27 - Controle Interno'"/>
  </xsl:call-template>

  <!-- t1 -->
  <!-- q1 -->
  <xsl:call-template name="UC.texto">
    <xsl:with-param name="texto">
      <xsl:choose>
        <xsl:when test="UC046Row[CD_PERGUNTA='UC046_p01']/RESPOSTA='S'">
          Os servidores lotados na Unidade Central de Controle Interno exercem suas atividades exclusivamente para o Controle Interno.
        </xsl:when>
        <xsl:when test="UC046Row[CD_PERGUNTA='UC046_p01']/RESPOSTA='N'">
          Os servidores lotados na Unidade Central de Controle Interno no exercem suas atividades exclusivamente para o Controle Interno.
        </xsl:when>
        <xsl:when test="UC046Row[CD_PERGUNTA='UC046_p01']/RESPOSTA='P'">
          Parte dos servidores lotados na Unidade Central de Controle Interno exercem suas atividades exclusivamente para o Controle Interno.
        </xsl:when>
        <xsl:otherwise>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:with-param>
  </xsl:call-template>

  <xsl:call-template name="UC.observacoes">
    <xsl:with-param name="uc.id" select="'UC046_01'"/>
  </xsl:call-template>
  <fo:block margin-left="15pt"><fo:leader leader-pattern="rule" leader-length="30%" rule-style="solid" rule-thickness="1pt"/></fo:block>
  <fo:block><fo:leader leader-pattern="space"/></fo:block>

  <!-- t2 -->
  <!-- q2 -->
  <xsl:call-template name="UC.texto">
    <xsl:with-param name="texto">
      <xsl:choose>
        <xsl:when test="UC046Row[CD_PERGUNTA='UC046_p02']/RESPOSTA='S'">
          A Lei Oramentria Anual estabeleceu a previso de recursos especficos para as atividades pertinentes ao Sistema de Controle Interno.
        </xsl:when>
        <xsl:when test="UC046Row[CD_PERGUNTA='UC046_p02']/RESPOSTA='N'">
          A Lei Oramentria Anual no estabeleceu a previso de recursos especficos para as atividades pertinentes ao Sistema de Controle Interno.
        </xsl:when>
        <xsl:otherwise>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:with-param>
  </xsl:call-template>

  <!-- q2.1 -->
  <xsl:call-template name="UC.texto">
    <xsl:with-param name="texto">
      <xsl:choose>
        <xsl:when test="UC046Row[CD_PERGUNTA='UC046_p03']/RESPOSTA='S'">
          Os recursos destinados  atividade do Sistema de Controle Interno foram efetivamente aplicados na unidade.
        </xsl:when>
        <xsl:when test="UC046Row[CD_PERGUNTA='UC046_p03']/RESPOSTA='N'">
          Os recursos destinados  atividade do Sistema de Controle Interno no foram efetivamente aplicados na unidade.
        </xsl:when>
        <xsl:when test="UC046Row[CD_PERGUNTA='UC046_p03']/RESPOSTA='P'">
          Os recursos destinados  atividade do Sistema de Controle Interno foram parcialmente aplicados na unidade.
        </xsl:when>
        <xsl:otherwise>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:with-param>
  </xsl:call-template>

  <xsl:call-template name="UC.observacoes">
    <xsl:with-param name="uc.id" select="'UC046_02'"/>
  </xsl:call-template>
  <fo:block margin-left="15pt"><fo:leader leader-pattern="rule" leader-length="30%" rule-style="solid" rule-thickness="1pt"/></fo:block>
  <fo:block><fo:leader leader-pattern="space"/></fo:block>


  <!-- t3 -->
  <!-- q3 -->
  <xsl:call-template name="UC.texto">
    <xsl:with-param name="texto">
      <xsl:choose>
        <xsl:when test="UC046Row[CD_PERGUNTA='UC046_p04']/RESPOSTA='S'">
          A Administrao Municipal adotou providncias tendentes  correo das inconformidades apontadas e ao atendimento das recomendaes efetuadas pela Unidade Central de Controle Interno.
        </xsl:when>
        <xsl:when test="UC046Row[CD_PERGUNTA='UC046_p04']/RESPOSTA='N'">
          A Administrao Municipal no adotou providncias tendentes  correo das inconformidades apontadas e ao atendimento das recomendaes efetuadas pela Unidade Central de Controle Interno.
        </xsl:when>
        <xsl:when test="UC046Row[CD_PERGUNTA='UC046_p04']/RESPOSTA='P'">
          A Administrao Municipal adotou parcialmente providncias tendentes  correo das inconformidades apontadas e ao atendimento das recomendaes efetuadas pela Unidade Central de Controle Interno.
        </xsl:when>
        <xsl:when test="UC046Row[CD_PERGUNTA='UC046_p04']/RESPOSTA='H'">
          No foram constatadas inconformidades e/ou recomendaes passveis de serem corrigidas e/ou atendidas pela Administrao Municipal.
        </xsl:when>
        <xsl:otherwise>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:with-param>
  </xsl:call-template>

  <xsl:call-template name="UC.observacoes">
    <xsl:with-param name="uc.id" select="'UC046_03'"/>
  </xsl:call-template>
  <fo:block margin-left="15pt"><fo:leader leader-pattern="rule" leader-length="30%" rule-style="solid" rule-thickness="1pt"/></fo:block>
  <fo:block><fo:leader leader-pattern="space"/></fo:block>

  <!-- t4 -->
  <!-- q4 -->
  <xsl:call-template name="UC.texto">
    <xsl:with-param name="texto">
      <xsl:choose>
        <xsl:when test="UC046Row[CD_PERGUNTA='UC046_p05']/RESPOSTA='S'">
          A Administrao Municipal adotou providncias para regularizao das irregularidades e responsabilizao dos agentes que agiram em infringncia s legislaes vlidas para a Administrao Pblica do municpio.
        </xsl:when>
        <xsl:when test="UC046Row[CD_PERGUNTA='UC046_p05']/RESPOSTA='N'">
          A Administrao Municipal no adotou providncias para regularizao das irregularidades e responsabilizao dos agentes que agiram em infringncia s legislaes vlidas para a Administrao Pblica do municpio.
        </xsl:when>
        <xsl:when test="UC046Row[CD_PERGUNTA='UC046_p05']/RESPOSTA='P'">
          A Administrao Municipal adotou parcialmente providncias para regularizao das irregularidades e responsabilizao dos agentes que agiram em infringncia s legislaes vlidas para a Administrao Pblica do municpio.
        </xsl:when>
        <xsl:when test="UC046Row[CD_PERGUNTA='UC046_p05']/RESPOSTA='H'">
          No houve apontamento de irregularidade com infringncia  legislao municipal passvel de manifestao pela Administrao Municipal.
        </xsl:when>
        <xsl:otherwise>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:with-param>
  </xsl:call-template>

  <xsl:call-template name="UC.observacoes">
    <xsl:with-param name="uc.id" select="'UC046_04'"/>
  </xsl:call-template>
  <fo:block margin-left="15pt"><fo:leader leader-pattern="rule" leader-length="30%" rule-style="solid" rule-thickness="1pt"/></fo:block>
  <fo:block><fo:leader leader-pattern="space"/></fo:block>

  <!-- t5 -->
  <!-- q5 -->
  <xsl:call-template name="UC.texto">
    <xsl:with-param name="texto">
      <xsl:choose>
        <xsl:when test="UC046Row[CD_PERGUNTA='UC046_p06']/RESPOSTA='S'">
          H previso em lei municipal que os rgos e entidades da Administrao Municipal, direta e indireta, alm do Poder Legislativo, submetem-se  fiscalizao da UCCI - inciso I do art. 3 da Resoluo TCE/RS n936/2012.
        </xsl:when>
        <xsl:when test="UC046Row[CD_PERGUNTA='UC046_p06']/RESPOSTA='N'">
          No h previso em lei municipal que os rgos e entidades da Administrao Municipal, direta e indireta, alm do Poder Legislativo, submetem-se  fiscalizao da UCCI - inciso I do art. 3 da Resoluo TCE/RS n 936/2012. 
        </xsl:when>
        <xsl:otherwise>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:with-param>
  </xsl:call-template>

  <xsl:call-template name="UC.leiart">
    <xsl:with-param name="lei" select="UC046Row[CD_PERGUNTA='UC046_p06_lei']/RESPOSTA_EXT"/>
    <xsl:with-param name="artigo" select="UC046Row[CD_PERGUNTA='UC046_p06_art']/RESPOSTA_EXT"/>
  </xsl:call-template>

  <!-- q6 -->
  <xsl:call-template name="UC.texto">
    <xsl:with-param name="texto">
      <xsl:choose>
        <xsl:when test="UC046Row[CD_PERGUNTA='UC046_p07']/RESPOSTA='S'">
          H previso em lei municipal de exame da legalidade e avaliao dos resultados, quanto  eficcia e eficincia, da gesto oramentria, financeira e patrimonial nos rgos e entidades da administrao municipal, bem como da aplicao de recursos pblicos por entidades do direito privado - alnea 'h' do inciso II do art. 4 da Resoluo TCE/RS n 936/2012.
        </xsl:when>
        <xsl:when test="UC046Row[CD_PERGUNTA='UC046_p07']/RESPOSTA='N'">
          No h previso em lei municipal de exame da legalidade e avaliao dos resultados, quanto  eficcia e eficincia, da gesto oramentria, financeira e patrimonial nos rgos e entidades da administrao municipal, bem como da aplicao de recursos pblicos por entidades do direito privado - alnea 'h' do inciso II do art. 4 da Resoluo TCE/RS n 936/2012.
        </xsl:when>
        <xsl:otherwise>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:with-param>
  </xsl:call-template>

  <xsl:call-template name="UC.leiart">
    <xsl:with-param name="lei" select="UC046Row[CD_PERGUNTA='UC046_p07_lei']/RESPOSTA_EXT"/>
    <xsl:with-param name="artigo" select="UC046Row[CD_PERGUNTA='UC046_p07_art']/RESPOSTA_EXT"/>
  </xsl:call-template>

  <xsl:call-template name="UC.observacoes">
    <xsl:with-param name="uc.id" select="'UC046_05'"/>
  </xsl:call-template>
  <fo:block margin-left="15pt"><fo:leader leader-pattern="rule" leader-length="30%" rule-style="solid" rule-thickness="1pt"/></fo:block>
  <fo:block><fo:leader leader-pattern="space"/></fo:block>

  <!-- t6 -->
  <!-- q7 -->
  <xsl:call-template name="UC.texto">
    <xsl:with-param name="texto">
      <xsl:choose>
        <xsl:when test="UC046Row[CD_PERGUNTA='UC046_p08']/RESPOSTA='S'">
          H previso em lei municipal de fixao de prazos a serem cumpridos pelos rgos e entidades auditados internamente para resposta aos questionamentos formulados e aos relatrios elaborados pela UCCI, assim como para a adoo das medidas corretivas demandadas - alnea 'c' do inciso II do art. 3 da Resoluo TCE/RS n 936/2012.
        </xsl:when>
        <xsl:when test="UC046Row[CD_PERGUNTA='UC046_p08']/RESPOSTA='N'">
          No h previso em lei municipal de fixao de prazos a serem cumpridos pelos rgos e entidades auditados internamente para resposta aos questionamentos formulados e aos relatrios elaborados pela UCCI, assim como para a adoo das medidas corretivas demandadas - alnea 'c' do inciso II do art. 3 da Resoluo TCE/RS n 936/2012.
        </xsl:when>
        <xsl:otherwise>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:with-param>
  </xsl:call-template>

  <xsl:call-template name="UC.leiart">
    <xsl:with-param name="lei" select="UC046Row[CD_PERGUNTA='UC046_p08_lei']/RESPOSTA_EXT"/>
    <xsl:with-param name="artigo" select="UC046Row[CD_PERGUNTA='UC046_p08_art']/RESPOSTA_EXT"/>
  </xsl:call-template>

  <!-- q8 -->
  <xsl:call-template name="UC.texto">
    <xsl:with-param name="texto">
      <xsl:choose>
        <xsl:when test="UC046Row[CD_PERGUNTA='UC046_p09']/RESPOSTA='S'">
          H indicao em lei municipal do dever de os responsveis pela UCCI darem cincia aos respectivos administradores e ao Tribunal de Contas das irregularidades ou ilegalidades constatadas no curso da fiscalizao interna, bem como o momento e a forma de adoo dessas providncias, sob pena de sua responsabilizao solidria, nos termos do disposto no artigo 74,  1, da Constituio Federal e alnea 'd' do inciso II do art. 3 da Resoluo TCE/RS n 936/2012.
        </xsl:when>
        <xsl:when test="UC046Row[CD_PERGUNTA='UC046_p09']/RESPOSTA='N'">
          No h indicao em lei municipal do dever de os responsveis pela UCCI darem cincia aos respectivos administradores e ao Tribunal de Contas das irregularidades ou ilegalidades constatadas no curso da fiscalizao interna, bem como o momento e a forma de adoo dessas providncias, sob pena de sua responsabilizao solidria, nos termos do disposto no artigo 74,  1, da Constituio Federal e alnea 'd' do inciso II do art. 3 da Resoluo TCE/RS n 936/2012.
        </xsl:when>
        <xsl:otherwise>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:with-param>
  </xsl:call-template>

  <xsl:call-template name="UC.leiart">
    <xsl:with-param name="lei" select="UC046Row[CD_PERGUNTA='UC046_p09_lei']/RESPOSTA_EXT"/>
    <xsl:with-param name="artigo" select="UC046Row[CD_PERGUNTA='UC046_p09_art']/RESPOSTA_EXT"/>
  </xsl:call-template>

  <xsl:call-template name="UC.observacoes">
    <xsl:with-param name="uc.id" select="'UC046_06'"/>
  </xsl:call-template>
  <fo:block margin-left="15pt"><fo:leader leader-pattern="rule" leader-length="30%" rule-style="solid" rule-thickness="1pt"/></fo:block>
  <fo:block><fo:leader leader-pattern="space"/></fo:block>

  <!-- t7 -->
  <!-- q9 -->
  <xsl:call-template name="UC.texto">
    <xsl:with-param name="texto">
      <xsl:choose>
        <xsl:when test="UC046Row[CD_PERGUNTA='UC046_p10']/RESPOSTA='S'">
          H previso em lei municipal e/ou em normativas prprias, de que a UCCI acompanhar o processamento das tomadas de contas especiais, manifestando-se ao final da respectiva instruo, as quais devero ser encaminhadas ao Tribunal de Contas, a fim de ensejar a possvel responsabilizao dos administradores ou agentes subordinados por atos omissivos ou comissivos que importarem em dano ao errio - inciso II do pargrafo nico do art. 6 da Resoluo TCE/RS n 936/2012.
        </xsl:when>
        <xsl:when test="UC046Row[CD_PERGUNTA='UC046_p10']/RESPOSTA='N'">
          No h previso em lei municipal e/ou em normativas prprias, de que a UCCI acompanhar o processamento das tomadas de contas especiais, manifestando-se ao final da respectiva instruo, as quais devero ser encaminhadas ao Tribunal de Contas, a fim de ensejar a possvel responsabilizao dos administradores ou agentes subordinados por atos omissivos ou comissivos que importarem em dano ao errio - inciso II do pargrafo nico do art. 6 da Resoluo 936/2012.
        </xsl:when>
        <xsl:otherwise>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:with-param>
  </xsl:call-template>

  <xsl:call-template name="UC.leiart">
    <xsl:with-param name="lei" select="UC046Row[CD_PERGUNTA='UC046_p10_lei']/RESPOSTA_EXT"/>
    <xsl:with-param name="artigo" select="UC046Row[CD_PERGUNTA='UC046_p10_art']/RESPOSTA_EXT"/>
  </xsl:call-template>

  <xsl:call-template name="UC.observacoes">
    <xsl:with-param name="uc.id" select="'UC046_07'"/>
  </xsl:call-template>

  <!--
  <xsl:call-template name="UC.itemrelatorio">
    <xsl:with-param name="titulo" select="'26 - Sistema de controle de custos'"/>
    <xsl:with-param name="texto" select="$texto"/>
    <xsl:with-param name="uc.id" select="'UC045'"/>
  </xsl:call-template>
  -->

</xsl:template>
<!-- FIM UC046 -->


<!--
###########################################################################
# TEMPLATES GENERICOS                                                     #
###########################################################################
-->
<!-- template genrico para ttulo dos tens de relatrio -->
<xsl:template name="UC.titulo">
 <xsl:param name="titulo" select="'Sem ttulo'"/>

 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" />
  <fo:table-body>
   <fo:table-row>
    <fo:table-cell>
     <fo:block xsl:use-attribute-sets="titFCinza">
      <xsl:value-of select="$titulo"/>
     </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-body>
 </fo:table>
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
</xsl:template>

<!-- template genrico para o texto dos tens de relatrio -->
<xsl:template name="UC.texto">
 <xsl:param name="texto" select="'Sem texto'"/>

 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="556pt"/>
  <fo:table-body >	   
    <fo:table-row>								
      <fo:table-cell>
	    <fo:block xsl:use-attribute-sets="txtJustifyMed" text-align="justify" margin-left="15pt" hyphenate="true" >
          <xsl:value-of select="$texto"/>
        </fo:block>
      </fo:table-cell>
    </fo:table-row>
  </fo:table-body>
 </fo:table>
</xsl:template>

<!-- template genrico para observaes dos tens de relatrio -->
<xsl:template name="UC.observacoes">
 <xsl:param name="uc.id" select="'UC000'"/>

 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 
 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="556pt"/>
  <fo:table-body >	   
    <fo:table-row>								
     <fo:table-cell>
	  <fo:block xsl:use-attribute-sets="txtJustifyMed" text-align="justify" margin-left="15pt" hyphenate="true" >
       <xsl:choose>
         <xsl:when test="../../Observacoes/ObservacoesRemessas/ObservacoesRemessasRow[CD_OBSERVACOES=$uc.id]/OBSERVACOES!=''">
          <fo:inline font-weight="bold">Observaes: </fo:inline><xsl:value-of select="../../Observacoes/ObservacoesRemessas/ObservacoesRemessasRow[CD_OBSERVACOES=$uc.id]/OBSERVACOES"></xsl:value-of>
         </xsl:when>
         <xsl:otherwise>
          <fo:inline font-style="italic">No foram inseridas observaes para este item.</fo:inline>
         </xsl:otherwise>
       </xsl:choose>
      </fo:block>
     </fo:table-cell>
    </fo:table-row>   	
  </fo:table-body>
 </fo:table>
</xsl:template>

<!-- template genrico para lei/artigo -->
<xsl:template name="UC.leiart">
 <!-- RelMCI/Respostas/UC046/UC046Row -->

 <!--<xsl:param name="uc.id" select="'UC046'"/>
 <xsl:param name="perg.id" select="'pXX'"/>-->
 <xsl:param name="lei" select="''"/>
 <xsl:param name="artigo" select="''"/>
 
 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="556pt"/>
  <fo:table-body>
    <fo:table-row>
     <fo:table-cell>
      <fo:block xsl:use-attribute-sets="txtJustifyMed" text-align="justify" margin-left="15pt" hyphenate="true" >
       <xsl:choose>
         <xsl:when test="$lei!=''">
          <fo:block><fo:leader leader-pattern="space"/></fo:block>
          <fo:inline font-weight="bold">Lei Municipal n: </fo:inline><xsl:value-of select="$lei"/>
          <fo:inline><fo:leader leader-pattern="space" leader-length="3em"/></fo:inline>
          <fo:inline font-weight="bold">artigo: </fo:inline><xsl:value-of select="$artigo"/>
          <fo:block><fo:leader leader-pattern="space"/></fo:block>
         </xsl:when>
         <xsl:otherwise>
         </xsl:otherwise>
       </xsl:choose>
      </fo:block>
     </fo:table-cell>
    </fo:table-row>
  </fo:table-body>
 </fo:table>

</xsl:template>

<!-- template genrico unificando ttulo, texto e observaes -->
<xsl:template name="UC.itemrelatorio">
 <xsl:param name="titulo" select="'Sem ttulo'"/>
 <xsl:param name="texto" select="'Sem texto'"/>
 <xsl:param name="uc.id" select="'UC000'"/>

 <xsl:call-template name="UC.titulo">
   <xsl:with-param name="titulo" select="$titulo"/>
 </xsl:call-template>

 <xsl:call-template name="UC.texto">
   <xsl:with-param name="texto" select="$texto"/>
 </xsl:call-template>

 <xsl:call-template name="UC.observacoes">
   <xsl:with-param name="uc.id" select="$uc.id"/>
 </xsl:call-template>
</xsl:template>
<!--
###########################################################################
# FIM: TEMPLATES GENERICOS                                                #
###########################################################################
-->


<xsl:template match="Informacoes">

 <!-- Observaes do Responsvel pelo Controle Interno da Entidade -->

 <xsl:variable name="texto">
   <xsl:value-of select="../../Observacoes/ObservacoesRemessas/ObservacoesRemessasRow[CD_OBSERVACOES='UC039']/OBSERVACOES"></xsl:value-of>
 </xsl:variable>
 
 <xsl:call-template name="UC.titulo">
   <xsl:with-param name="titulo" select="'Observaes do Responsvel pelo Controle Interno para o TCERS'"/>
 </xsl:call-template>

 <xsl:call-template name="UC.texto">
   <xsl:with-param name="texto" select="$texto"/>
 </xsl:call-template>
 <!--
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 
 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" />
  <fo:table-body>
   <fo:table-row>
    <fo:table-cell>
     <fo:block xsl:use-attribute-sets="titFCinza">
      <xsl:text>Observaes do Responsvel pelo Controle Interno para o TCERS</xsl:text>
     </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-body>
 </fo:table>

 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 
 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="556pt"/>

  <fo:table-body >	   
    <fo:table-row>								
     <fo:table-cell>
	  <fo:block xsl:use-attribute-sets="txtJustifyMed" text-align="justify" margin-left="15pt" hyphenate="true" >
       <xsl:if test="../../Observacoes/ObservacoesRemessas/ObservacoesRemessasRow[CD_OBSERVACOES='UC039']/OBSERVACOES!=''">
        <xsl:value-of select="../../Observacoes/ObservacoesRemessas/ObservacoesRemessasRow[CD_OBSERVACOES='UC039']/OBSERVACOES"></xsl:value-of>
       </xsl:if>       
      </fo:block>
	 </fo:table-cell>
	</fo:table-row>
  </fo:table-body>
 </fo:table>	   
 -->
 
<!-- QUEBRA DE PAGINA -->
<fo:block break-before="page"/>
<!-- QUEBRA DE PAGINA -->
   
<!--#############################-->
<!--####    ASSINATURAS      ####-->
<!--#############################-->

<!--******** VARIAVEIS *********-->
 <xsl:variable name="dataHoraRod" select="document(concat($PATH_REMESSA,'/remessa_info.xml'))//data-geracao"/> 
 <xsl:variable name="dataRod" select="substring($dataHoraRod, 1, 10)"/>
 <xsl:variable name="diaRod" select="substring($dataRod, 9, 2)"/>
 <xsl:variable name="mesRod" select="substring($dataRod, 6, 2)"/>
 <xsl:variable name="anoRod" select="substring($dataRod, 1, 4)"/>


 <xsl:variable name="tipoSetor">
  <xsl:if test="InformacoesRow/PODER='C'">
   <xsl:value-of select="'Presidente da C&#226;mara Municipal'"></xsl:value-of>
  </xsl:if>
  <xsl:if test="InformacoesRow/PODER='P'">
   <xsl:value-of select="'Prefeito Municipal'"></xsl:value-of>
  </xsl:if>
 </xsl:variable>


 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 <fo:block><fo:leader leader-pattern="space"/></fo:block>

 <fo:block xsl:use-attribute-sets="txtCenter">
	<xsl:value-of select="InformacoesRow/NOME"/>, <xsl:value-of select="$diaRod"/>/<xsl:value-of select="$mesRod"/>/<xsl:value-of select="$anoRod"/>
 </fo:block>
 <fo:leader leader-pattern="space" />
 <fo:leader leader-pattern="space" />
 <fo:leader leader-pattern="space" />
 <fo:block xsl:use-attribute-sets="txtCenter">_________________________________________________</fo:block>
 <fo:block xsl:use-attribute-sets="txtCenter"><xsl:value-of select="InformacoesRow/NOME_REPRESENTANTE"/></fo:block>
 <fo:block xsl:use-attribute-sets="txtCenter"><xsl:value-of select="$tipoSetor"/></fo:block>

 <fo:leader leader-pattern="space" />
 <fo:leader leader-pattern="space" />
 <fo:leader leader-pattern="space" />
 <fo:block xsl:use-attribute-sets="txtCenter">_________________________________________________</fo:block>
 <fo:block xsl:use-attribute-sets="txtCenter"><xsl:value-of select="../../ContInternoResp/RespContInternoResp/RespContInternoRespRow/NOME"/></fo:block>
 <fo:block xsl:use-attribute-sets="txtCenter">Responsvel pelo Controle Interno</fo:block>

</xsl:template>
<!-- FIM ASSINATURAS -->


<!--#############################-->
<!--####       HEADER        ####-->
<!--#############################-->
<xsl:template match="Header">
<!--******** VARIAVEIS *********-->

<xsl:variable name="dataHora" select="document(concat($PATH_REMESSA,'/remessa_info.xml'))//data-geracao"/> 
<xsl:variable name="data" select="substring($dataHora, 1, 10)"/>
<xsl:variable name="horario" select="substring($dataHora, 12, 8)"/>
<xsl:variable name="dia" select="substring($data, 9, 2)"/>
<xsl:variable name="mes" select="substring($data, 6, 2)"/>
<xsl:variable name="ano" select="substring($data, 1, 4)"/>
<xsl:variable name="hora" select="substring($horario, 1, 2)"/>
<xsl:variable name="minuto" select="substring($horario, 4, 2)"/>
<xsl:variable name="segundo" select="substring($horario, 7, 2)"/>

<xsl:variable name="poder">
  <xsl:if test="Informacoes/InformacoesRow/PODER='P'">
   <xsl:value-of select="'PODER EXECUTIVO'"></xsl:value-of>
  </xsl:if>
  <xsl:if test="Informacoes/InformacoesRow/PODER='C'">
   <xsl:value-of select="'PODER LEGISLATIVO'"></xsl:value-of>
  </xsl:if>
</xsl:variable>

<!--******** VARIAVEIS *********-->

 <fo:table table-layout="fixed" width="556pt">
   <fo:table-column column-width="40pt"/>
   <fo:table-column column-width="300pt"/>
   <fo:table-column column-width="95pt"/>
   <fo:table-column column-width="38pt"/>
   <fo:table-column column-width="82pt"/>

   <fo:table-body>
     <fo:table-row>
       <fo:table-cell number-columns-spanned="5" border-bottom-style="solid" border-bottom-width="1pt"><fo:block></fo:block></fo:table-cell>
     </fo:table-row>

    <fo:table-row>
	 <fo:table-cell padding-bottom="3pt">
	    <fo:block>
		<fo:external-graphic src="{concat($PATH_IMAGENS,'Brasao.jpg')}"/>
	    </fo:block>
	 </fo:table-cell>
	 <fo:table-cell>
	  <fo:block padding-bottom="5pt">
	      <!-- INICIO CABECALHO  -->
		 <fo:table width="360pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
		  <fo:table-column column-number="1" column-width="5pt"/>
		  <fo:table-column column-number="2" column-width="310pt"/>
		  <fo:table-column column-number="3" column-width="10pt"/>

		  <fo:table-body>
		   <fo:table-row>
		    <fo:table-cell border-width="0.5pt" number-columns-spanned="3" padding-left="5pt">
		     <fo:block xsl:use-attribute-sets="txtLeft">ESTADO DO RIO GRANDE DO SUL </fo:block>
		     <fo:block xsl:use-attribute-sets="txtLeft">TRIBUNAL DE CONTAS DO ESTADO </fo:block>
		    </fo:table-cell>
		   </fo:table-row>
		   <fo:table-row>
		    <fo:table-cell border-width="0.5pt"><fo:block></fo:block></fo:table-cell>	 
		    <fo:table-cell border-width="0.5pt">
		     <fo:block xsl:use-attribute-sets="titNegritoBig">MANIFESTAO CONCLUSIVA DO CONTROLE INTERNO</fo:block>
		    </fo:table-cell>
			<fo:table-cell border-width="0.5pt"><fo:block></fo:block></fo:table-cell>	 
		   </fo:table-row>
		   <fo:table-row>
		    <fo:table-cell border-width="0.5pt"><fo:block></fo:block></fo:table-cell>	 
		    <fo:table-cell border-width="0.5pt">
		     <fo:block xsl:use-attribute-sets="titNegrito"><xsl:value-of select="$poder"/></fo:block>
		    </fo:table-cell>
			<fo:table-cell border-width="0.5pt"><fo:block></fo:block></fo:table-cell>	 
		   </fo:table-row>
		   <fo:table-row>
		    <fo:table-cell border-width="0.5pt"><fo:block></fo:block></fo:table-cell>	 
		    <fo:table-cell border-width="0.5pt">
		     <fo:block xsl:use-attribute-sets="titNegrito">EXERC&#205;CIO DE <xsl:value-of select="Informacoes/InformacoesRow/ANO_EXERCICIO"/></fo:block>
		    </fo:table-cell>
			<fo:table-cell border-width="0.5pt"><fo:block></fo:block></fo:table-cell>	 
		   </fo:table-row>
		   <fo:table-row>
		    <fo:table-cell border-width="0.5pt"><fo:block></fo:block></fo:table-cell>	 
		    <fo:table-cell border-width="0.5pt">
		     <fo:block xsl:use-attribute-sets="titNegrito">Periodo: <xsl:value-of select="Informacoes/InformacoesRow/DS_PERIODO"/></fo:block>
		    </fo:table-cell>
			<fo:table-cell border-width="0.5pt"><fo:block></fo:block></fo:table-cell>	 
		   </fo:table-row>
		   <fo:table-row>
		    <fo:table-cell border-width="0.5pt"><fo:block></fo:block></fo:table-cell>	 
		    <fo:table-cell border-width="0.5pt">
		     <fo:block xsl:use-attribute-sets="titNegrito"><xsl:value-of select="Informacoes/InformacoesRow/NOME"/></fo:block>
		    </fo:table-cell>
			<fo:table-cell border-width="0.5pt"><fo:block></fo:block></fo:table-cell>	 
		   </fo:table-row>
		  </fo:table-body>
		 </fo:table>
	    <!-- FIM CABECALHO  -->  
          </fo:block>
	</fo:table-cell>
	<fo:table-cell padding-bottom="3pt" text-align="center">
	  <!-- BARCODE -->
	      <fo:block><fo:leader leader-pattern="space" /></fo:block>
	      <fo:block><fo:leader leader-pattern="space" /></fo:block>
	      <fo:block><fo:leader leader-pattern="space" /></fo:block>
	      <fo:block><fo:leader leader-pattern="space" /></fo:block>
	      <fo:block>
          <fo:instream-foreign-object>
            <barcode:barcode 
            xmlns:barcode="http://barcode4j.krysalis.org/ns"
            message="{document(concat($PATH_REMESSA,'/remessa_info.xml'))//cod-barras-mCI}">
              <barcode:code128>
                <barcode:height>15mm</barcode:height>
              </barcode:code128>
            </barcode:barcode>
          </fo:instream-foreign-object>
	      </fo:block>
	 <!-- BARCODE -->
  </fo:table-cell>

  <fo:table-cell>
  </fo:table-cell>

  <fo:table-cell padding-bottom="0.5pt" text-align="right">
        <!--
        <fo:table text-align="right" padding-bottom="3pt">
        <fo:table-column column-width="10pt"/>
        <fo:table-column column-width="35pt"/>
        <fo:table-column column-width="35pt"/>
          <fo:table-body>
            <fo:table-row>
              <fo:table-cell/>
              <fo:table-cell number-columns-spanned="2" border-style="solid" border-width="0.25pt" space-before="0pt" space-after="0pt">
                <fo:block xsl:use-attribute-sets="txtLeft" text-align="center">Para uso do</fo:block>
                <fo:block xsl:use-attribute-sets="txtLeft" text-align="center">Tribunal de Contas</fo:block>
              </fo:table-cell>
            </fo:table-row>
            <fo:table-row>
              <fo:table-cell/>
              <fo:table-cell border-style="solid" height="20pt" border-width="0.25pt" space-before="0pt" space-after="0pt">
                <fo:block xsl:use-attribute-sets="txtLeft" text-align="left">Fl.</fo:block>
                <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
              </fo:table-cell>
              <fo:table-cell border-style="solid" height="20pt" border-width="0.25pt" space-before="0pt" space-after="0pt">
                <fo:block xsl:use-attribute-sets="txtLeft" text-align="left">Rubrica</fo:block>
                <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
              </fo:table-cell>
            </fo:table-row>
          </fo:table-body>
        </fo:table>
        -->

        <fo:table text-align="right">
        <fo:table-column column-width="30pt"/>
        <fo:table-column column-width="50pt"/>
          <fo:table-body>
            <fo:table-row>
              <fo:table-cell border-width="0.25pt" space-before="0pt" space-after="0pt">
                <fo:block xsl:use-attribute-sets="txtRight">
                  <fo:external-graphic src="{concat($PATH_IMAGENS,'tce__2025.jpg')}" width="30pt"/>
                </fo:block>
                <fo:block xsl:use-attribute-sets="txtRight" font-weight="bold">
                  <xsl:value-of select="Informacoes/InformacoesRow/VERSAO_MCI"/>
                </fo:block>
              </fo:table-cell>
              <fo:table-cell border-width="0.25pt" space-before="0pt" space-after="0pt">
                <fo:block xsl:use-attribute-sets="txtRight">
                  <xsl:value-of select="$dia"/>/<xsl:value-of select="$mes"/>/<xsl:value-of select="$ano"/>
                </fo:block>		 
                <fo:block xsl:use-attribute-sets="txtRight">
                  <xsl:value-of select="$hora"/>:<xsl:value-of select="$minuto"/>:<xsl:value-of select="$segundo"/>
                </fo:block>
                <fo:block xsl:use-attribute-sets="txtRight">
                  P&#225;g.: <fo:page-number/>/<fo:page-number-citation ref-id="last-page"/>
                </fo:block>
              </fo:table-cell>
            </fo:table-row>
          </fo:table-body>
        </fo:table>

<!--
	  <fo:block xsl:use-attribute-sets="txtRight"> <fo:external-graphic src="{concat($PATH_IMAGENS,'tce.jpg')}" width="30pt"/> </fo:block>
	  <fo:block xsl:use-attribute-sets="txtRight" font-weight="bold">
         <xsl:value-of select="Informacoes/InformacoesRow/VERSAO_MCI"/>
      </fo:block> 	  
	  <fo:block xsl:use-attribute-sets="txtRight">
         <xsl:value-of select="$dia"/>/<xsl:value-of select="$mes"/>/<xsl:value-of select="$ano"/>
	  </fo:block>		 
	  <fo:block xsl:use-attribute-sets="txtRight">
         <xsl:value-of select="$hora"/>:<xsl:value-of select="$minuto"/>:<xsl:value-of select="$segundo"/>
	  </fo:block>
	  <fo:block xsl:use-attribute-sets="txtRight">
         P&#225;g.: <fo:page-number/>/<fo:page-number-citation ref-id="last-page"/>
	  </fo:block>
-->

  </fo:table-cell>   

</fo:table-row>
<fo:table-row>
  <fo:table-cell number-columns-spanned="5" border-bottom-style="solid" border-bottom-width="1pt"><fo:block></fo:block></fo:table-cell>
</fo:table-row>


</fo:table-body>
</fo:table>
</xsl:template>

</xsl:stylesheet><!-- Stylus Studio meta-information - (c) 2004-2008. Progress Software Corporation. All rights reserved.

<metaInformation>
	<scenarios>
		<scenario default="yes" name="Scenario1" userelativepaths="yes" externalpreview="no" url="relmci.xml" htmlbaseurl="" outputurl="relmci.pdf" processortype="jaxp" useresolver="yes" profilemode="0" profiledepth="" profilelength="" urlprofilexml=""
		          commandline="" additionalpath="" additionalclasspath="" postprocessortype="fop" postprocesscommandline="" postprocessadditionalpath="" postprocessgeneratedext="" validateoutput="no" validator="internal" customvalidator="">
			<advancedProp name="sInitialMode" value=""/>
			<advancedProp name="bXsltOneIsOkay" value="true"/>
			<advancedProp name="bSchemaAware" value="true"/>
			<advancedProp name="bXml11" value="false"/>
			<advancedProp name="iValidation" value="0"/>
			<advancedProp name="bExtensions" value="true"/>
			<advancedProp name="iWhitespace" value="0"/>
			<advancedProp name="sInitialTemplate" value=""/>
			<advancedProp name="bTinyTree" value="true"/>
			<advancedProp name="bWarnings" value="true"/>
			<advancedProp name="bUseDTD" value="false"/>
			<advancedProp name="iErrorHandling" value="fatal"/>
		</scenario>
	</scenarios>
	<MapperMetaTag>
		<MapperInfo srcSchemaPathIsRelative="yes" srcSchemaInterpretAsXML="no" destSchemaPath="" destSchemaRoot="" destSchemaPathIsRelative="yes" destSchemaInterpretAsXML="no">
			<SourceSchema srcSchemaPath="relmci.xml" srcSchemaRoot="RelMCI" AssociatedInstance="" loaderFunction="document" loaderFunctionUsesURI="no"/>
			<SourceSchema srcSchemaPath="remessa_info.xml" srcSchemaRoot="remessa-info" AssociatedInstance="file:///s:/Internet/MCI/Temp/xmls/remessa/remessa_info.xml" loaderFunction="document" loaderFunctionUsesURI="no"/>
			<SourceSchema srcSchemaPath="remessa\remessa_info.xml" srcSchemaRoot="remessa-info" AssociatedInstance="file:///s:/Internet/MCI/Temp/xmls/remessa/remessa_info.xml" loaderFunction="document" loaderFunctionUsesURI="no"/>
		</MapperInfo>
		<MapperBlockPosition>
			<template match="/">
				<block path="fo:root/fo:page-sequence/fo:static-content/xsl:apply-templates" x="288" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/fo:table/fo:table-body/fo:table-row[2]/fo:table-cell/xsl:if/=[0]" x="242" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/fo:table/fo:table-body/fo:table-row[2]/fo:table-cell/xsl:if" x="288" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/fo:table/fo:table-body/fo:table-row[2]/fo:table-cell/xsl:if/fo:block/xsl:value-of" x="288" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/fo:table/fo:table-body/fo:table-row[2]/fo:table-cell/xsl:if[1]/=[0]" x="242" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/fo:table/fo:table-body/fo:table-row[2]/fo:table-cell/xsl:if[1]" x="288" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/fo:table/fo:table-body/fo:table-row[2]/fo:table-cell/xsl:if[1]/fo:block/xsl:value-of" x="288" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/fo:table/fo:table-body/fo:table-row[3]/fo:table-cell/xsl:if/!=[0]" x="242" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/fo:table/fo:table-body/fo:table-row[3]/fo:table-cell/xsl:if" x="288" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/fo:table/fo:table-body/fo:table-row[3]/fo:table-cell/xsl:if/fo:block/xsl:value-of" x="288" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/fo:table/fo:table-body/fo:table-row[4]/fo:table-cell/xsl:if/!=[0]" x="242" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/fo:table/fo:table-body/fo:table-row[4]/fo:table-cell/xsl:if" x="288" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/fo:table/fo:table-body/fo:table-row[4]/fo:table-cell/xsl:if/fo:block/xsl:value-of" x="288" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/fo:table/fo:table-body/fo:table-row[5]/fo:table-cell/xsl:if/!=[0]" x="242" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/fo:table/fo:table-body/fo:table-row[5]/fo:table-cell/xsl:if" x="288" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/fo:table/fo:table-body/fo:table-row[5]/fo:table-cell/xsl:if/fo:block/xsl:value-of" x="288" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:apply-templates" x="288" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if/!=[0]" x="212" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if" x="258" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if/xsl:apply-templates" x="288" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[1]/!=[0]" x="212" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[1]" x="258" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[1]/xsl:apply-templates" x="288" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/=[0]" x="182" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]" x="228" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if/!=[0]" x="212" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if" x="258" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if/xsl:apply-templates" x="288" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if[1]/or[0]" x="182" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if[1]/or[0]/=[0]" x="136" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if[1]/or[0]/=[1]" x="136" y="22"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if[1]" x="228" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if[1]/xsl:if/!=[0]" x="212" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if[1]/xsl:if" x="258" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if[1]/xsl:if/xsl:apply-templates" x="288" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if[1]/xsl:if[1]/!=[0]" x="212" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if[1]/xsl:if[1]" x="258" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if[1]/xsl:if[1]/xsl:apply-templates" x="288" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if[1]/xsl:if[2]/!=[0]" x="212" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if[1]/xsl:if[2]" x="258" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if[1]/xsl:if[2]/xsl:apply-templates" x="288" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if[1]/xsl:if[3]/!=[0]" x="212" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if[1]/xsl:if[3]" x="258" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if[1]/xsl:if[3]/xsl:apply-templates" x="288" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if[1]/xsl:if[4]/!=[0]" x="212" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if[1]/xsl:if[4]" x="258" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if[1]/xsl:if[4]/xsl:apply-templates" x="288" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if[1]/xsl:if[5]/!=[0]" x="212" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if[1]/xsl:if[5]" x="258" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if[1]/xsl:if[5]/xsl:apply-templates" x="288" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if[1]/xsl:if[6]/!=[0]" x="212" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if[1]/xsl:if[6]" x="258" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if[1]/xsl:if[6]/xsl:apply-templates" x="288" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if[1]/xsl:if[7]/!=[0]" x="212" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if[1]/xsl:if[7]" x="258" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if[1]/xsl:if[7]/xsl:apply-templates" x="288" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if[1]/xsl:if[8]/!=[0]" x="212" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if[1]/xsl:if[8]" x="258" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if[1]/xsl:if[8]/xsl:apply-templates" x="288" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if[1]/xsl:if[9]/!=[0]" x="212" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if[1]/xsl:if[9]" x="258" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if[1]/xsl:if[9]/xsl:apply-templates" x="288" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if[1]/xsl:if[10]/or[0]" x="182" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if[1]/xsl:if[10]/or[0]/=[0]" x="136" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if[1]/xsl:if[10]/or[0]/=[1]" x="136" y="22"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if[1]/xsl:if[10]" x="228" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if[1]/xsl:if[10]/xsl:if/!=[0]" x="212" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if[1]/xsl:if[10]/xsl:if" x="258" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if[1]/xsl:if[10]/xsl:if/xsl:apply-templates" x="288" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if[1]/xsl:if[11]/!=[0]" x="212" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if[1]/xsl:if[11]" x="258" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if[1]/xsl:if[11]/xsl:apply-templates" x="288" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if[1]/xsl:if[12]/!=[0]" x="212" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if[1]/xsl:if[12]" x="258" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if[1]/xsl:if[12]/xsl:apply-templates" x="288" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if[1]/xsl:if[13]/!=[0]" x="212" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if[1]/xsl:if[13]" x="258" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if[1]/xsl:if[13]/xsl:apply-templates" x="288" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if[1]/xsl:if[14]/!=[0]" x="212" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if[1]/xsl:if[14]" x="258" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if[1]/xsl:if[14]/xsl:apply-templates" x="288" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if[1]/xsl:if[15]/!=[0]" x="212" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if[1]/xsl:if[15]" x="258" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if[1]/xsl:if[15]/xsl:apply-templates" x="288" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if[1]/xsl:if[16]/!=[0]" x="212" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if[1]/xsl:if[16]" x="258" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if[1]/xsl:if[16]/xsl:apply-templates" x="288" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if[1]/xsl:if[17]/or[0]" x="182" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if[1]/xsl:if[17]/or[0]/=[0]" x="136" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if[1]/xsl:if[17]/or[0]/=[1]" x="136" y="22"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if[1]/xsl:if[17]" x="228" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if[1]/xsl:if[17]/xsl:if/!=[0]" x="212" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if[1]/xsl:if[17]/xsl:if" x="258" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if[1]/xsl:if[17]/xsl:if/xsl:apply-templates" x="288" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if[1]/xsl:if[17]/xsl:if[1]/=[0]" x="182" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if[1]/xsl:if[17]/xsl:if[1]" x="228" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if[1]/xsl:if[17]/xsl:if[1]/xsl:if/!=[0]" x="212" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if[1]/xsl:if[17]/xsl:if[1]/xsl:if" x="258" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if[1]/xsl:if[17]/xsl:if[1]/xsl:if/xsl:apply-templates" x="288" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if[1]/xsl:if[17]/xsl:if[2]/!=[0]" x="212" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if[1]/xsl:if[17]/xsl:if[2]" x="258" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if[1]/xsl:if[17]/xsl:if[2]/xsl:apply-templates" x="288" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if[2]/or[0]" x="182" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if[2]/or[0]/or[0]" x="136" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if[2]/or[0]/or[0]/=[0]" x="90" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if[2]/or[0]/or[0]/=[1]" x="90" y="22"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if[2]/or[0]/=[1]" x="136" y="22"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if[2]" x="228" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if[2]/xsl:if/!=[0]" x="212" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if[2]/xsl:if" x="258" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if[2]/xsl:if/xsl:apply-templates" x="288" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if[2]/xsl:if[1]/!=[0]" x="212" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if[2]/xsl:if[1]" x="258" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if[2]/xsl:if[1]/xsl:apply-templates" x="288" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if[2]/xsl:if[2]/!=[0]" x="212" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if[2]/xsl:if[2]" x="258" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if[2]/xsl:if[2]/xsl:apply-templates" x="288" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if[2]/xsl:if[3]/!=[0]" x="212" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if[2]/xsl:if[3]" x="258" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if[2]/xsl:if[3]/xsl:apply-templates" x="288" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if[2]/xsl:if[4]/or[0]" x="182" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if[2]/xsl:if[4]/or[0]/=[0]" x="136" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if[2]/xsl:if[4]/or[0]/=[1]" x="136" y="22"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if[2]/xsl:if[4]" x="228" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if[2]/xsl:if[4]/xsl:if/!=[0]" x="212" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if[2]/xsl:if[4]/xsl:if" x="258" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if[2]/xsl:if[4]/xsl:if/xsl:apply-templates" x="288" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if[2]/xsl:if[5]/or[0]" x="182" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if[2]/xsl:if[5]/or[0]/or[0]" x="136" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if[2]/xsl:if[5]/or[0]/or[0]/=[0]" x="90" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if[2]/xsl:if[5]/or[0]/or[0]/=[1]" x="90" y="22"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if[2]/xsl:if[5]/or[0]/=[1]" x="136" y="22"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if[2]/xsl:if[5]" x="228" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if[2]/xsl:if[5]/xsl:if/!=[0]" x="212" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if[2]/xsl:if[5]/xsl:if" x="258" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if[2]/xsl:if[5]/xsl:if/xsl:apply-templates" x="288" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if[2]/xsl:if[5]/xsl:if[1]/!=[0]" x="212" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if[2]/xsl:if[5]/xsl:if[1]" x="258" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if[2]/xsl:if[5]/xsl:if[1]/xsl:apply-templates" x="288" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if[2]/xsl:if[5]/xsl:if[2]/!=[0]" x="212" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if[2]/xsl:if[5]/xsl:if[2]" x="258" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if[2]/xsl:if[5]/xsl:if[2]/xsl:apply-templates" x="288" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if[2]/xsl:if[5]/xsl:if[3]/!=[0]" x="212" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if[2]/xsl:if[5]/xsl:if[3]" x="258" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if[2]/xsl:if[5]/xsl:if[3]/xsl:apply-templates" x="288" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if[2]/xsl:if[5]/xsl:if[4]/!=[0]" x="212" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if[2]/xsl:if[5]/xsl:if[4]" x="258" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if[2]/xsl:if[5]/xsl:if[4]/xsl:apply-templates" x="288" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if[2]/xsl:if[5]/xsl:if[5]/!=[0]" x="212" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if[2]/xsl:if[5]/xsl:if[5]" x="258" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if[2]/xsl:if[5]/xsl:if[5]/xsl:apply-templates" x="288" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if[2]/xsl:if[5]/xsl:if[6]/or[0]" x="182" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if[2]/xsl:if[5]/xsl:if[6]/or[0]/=[0]" x="136" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if[2]/xsl:if[5]/xsl:if[6]/or[0]/=[1]" x="136" y="22"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if[2]/xsl:if[5]/xsl:if[6]" x="228" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if[2]/xsl:if[5]/xsl:if[6]/xsl:if/!=[0]" x="212" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if[2]/xsl:if[5]/xsl:if[6]/xsl:if" x="258" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if[2]/xsl:if[5]/xsl:if[6]/xsl:if/xsl:apply-templates" x="288" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if[2]/xsl:if[5]/xsl:if[6]/xsl:if[1]/=[0]" x="182" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if[2]/xsl:if[5]/xsl:if[6]/xsl:if[1]" x="228" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if[2]/xsl:if[5]/xsl:if[6]/xsl:if[1]/xsl:if/!=[0]" x="212" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if[2]/xsl:if[5]/xsl:if[6]/xsl:if[1]/xsl:if" x="258" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if[2]/xsl:if[5]/xsl:if[6]/xsl:if[1]/xsl:if/xsl:apply-templates" x="288" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if[2]/xsl:if[5]/xsl:if[7]/!=[0]" x="212" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if[2]/xsl:if[5]/xsl:if[7]" x="258" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[2]/xsl:if[2]/xsl:if[5]/xsl:if[7]/xsl:apply-templates" x="288" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[3]/=[0]" x="182" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[3]" x="228" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[3]/xsl:if/!=[0]" x="212" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[3]/xsl:if" x="258" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[3]/xsl:if/xsl:apply-templates" x="288" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[3]/xsl:if[1]/!=[0]" x="212" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[3]/xsl:if[1]" x="258" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[3]/xsl:if[1]/xsl:apply-templates" x="288" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[3]/xsl:if[2]/!=[0]" x="212" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[3]/xsl:if[2]" x="258" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[3]/xsl:if[2]/xsl:apply-templates" x="288" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[3]/xsl:if[3]/or[0]" x="182" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[3]/xsl:if[3]/or[0]/=[0]" x="136" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[3]/xsl:if[3]/or[0]/=[1]" x="136" y="22"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[3]/xsl:if[3]" x="228" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[3]/xsl:if[3]/xsl:if/!=[0]" x="212" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[3]/xsl:if[3]/xsl:if" x="258" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[3]/xsl:if[3]/xsl:if/xsl:apply-templates" x="288" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[3]/xsl:if[3]/xsl:if[1]/=[0]" x="182" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[3]/xsl:if[3]/xsl:if[1]" x="228" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[3]/xsl:if[3]/xsl:if[1]/xsl:if/!=[0]" x="212" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[3]/xsl:if[3]/xsl:if[1]/xsl:if" x="258" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[3]/xsl:if[3]/xsl:if[1]/xsl:if/xsl:apply-templates" x="288" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[3]/xsl:if[3]/xsl:if[2]/!=[0]" x="212" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[3]/xsl:if[3]/xsl:if[2]" x="258" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[3]/xsl:if[3]/xsl:if[2]/xsl:apply-templates" x="288" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[4]/!=[0]" x="212" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[4]" x="258" y="0"/>
				<block path="fo:root/fo:page-sequence/fo:flow/fo:block/xsl:if[4]/xsl:apply-templates" x="288" y="0"/>
			</template>
			<template match="UC012">
				<block path="fo:table[1]/fo:table-body/fo:table-row/fo:table-cell/fo:block/xsl:if/=[0]" x="212" y="0"/>
				<block path="fo:table[1]/fo:table-body/fo:table-row/fo:table-cell/fo:block/xsl:if" x="258" y="0"/>
				<block path="" x="288" y="0"/>
				<block path="fo:table[1]/fo:table-body/fo:table-row/fo:table-cell/fo:block/xsl:if[1]/!=[0]" x="182" y="0"/>
				<block path="fo:table[1]/fo:table-body/fo:table-row/fo:table-cell/fo:block/xsl:if[1]" x="228" y="0"/>
				<block path="fo:table[1]/fo:table-body/fo:table-row/fo:table-cell/fo:block/xsl:if[1]/xsl:if/=[0]" x="212" y="0"/>
				<block path="fo:table[1]/fo:table-body/fo:table-row/fo:table-cell/fo:block/xsl:if[1]/xsl:if" x="258" y="0"/>
				<block path="fo:table[1]/fo:table-body/fo:table-row/fo:table-cell/fo:block/xsl:if[1]/xsl:if/xsl:value-of" x="288" y="0"/>
				<block path="fo:table[1]/fo:table-body/fo:table-row/fo:table-cell/fo:block/xsl:if[1]/xsl:if/xsl:value-of[1]" x="288" y="0"/>
				<block path="fo:table[1]/fo:table-body/fo:table-row/fo:table-cell/fo:block/xsl:if[1]/xsl:if[1]/=[0]" x="212" y="0"/>
				<block path="fo:table[1]/fo:table-body/fo:table-row/fo:table-cell/fo:block/xsl:if[1]/xsl:if[1]" x="258" y="0"/>
				<block path="fo:table[1]/fo:table-body/fo:table-row/fo:table-cell/fo:block/xsl:if[1]/xsl:if[1]/xsl:value-of" x="288" y="0"/>
				<block path="fo:table[1]/fo:table-body/fo:table-row/fo:table-cell/fo:block/xsl:if[1]/xsl:if[1]/xsl:value-of[1]" x="288" y="0"/>
				<block path="fo:table[1]/fo:table-body/fo:table-row/fo:table-cell/fo:block/xsl:if[1]/xsl:if[1]/xsl:value-of[2]" x="288" y="0"/>
				<block path="fo:table[1]/fo:table-body/fo:table-row/fo:table-cell/fo:block/xsl:if[1]/xsl:if[1]/xsl:value-of[3]" x="288" y="0"/>
				<block path="fo:table[1]/fo:table-body/fo:table-row/fo:table-cell/fo:block/xsl:if[1]/xsl:if[1]/xsl:value-of[4]" x="288" y="0"/>
				<block path="fo:table[1]/fo:table-body/fo:table-row/fo:table-cell/fo:block/xsl:if[1]/xsl:if[2]/!=[0]" x="182" y="0"/>
				<block path="fo:table[1]/fo:table-body/fo:table-row/fo:table-cell/fo:block/xsl:if[1]/xsl:if[2]" x="228" y="0"/>
				<block path="fo:table[1]/fo:table-body/fo:table-row/fo:table-cell/fo:block/xsl:if[1]/xsl:if[2]/xsl:if/=[0]" x="212" y="0"/>
				<block path="fo:table[1]/fo:table-body/fo:table-row/fo:table-cell/fo:block/xsl:if[1]/xsl:if[2]/xsl:if" x="258" y="0"/>
				<block path="fo:table[1]/fo:table-body/fo:table-row/fo:table-cell/fo:block/xsl:if[1]/xsl:if[2]/xsl:if/xsl:value-of" x="288" y="0"/>
				<block path="fo:table[1]/fo:table-body/fo:table-row/fo:table-cell/fo:block/xsl:if[1]/xsl:if[2]/xsl:if[1]/=[0]" x="182" y="0"/>
				<block path="fo:table[1]/fo:table-body/fo:table-row/fo:table-cell/fo:block/xsl:if[1]/xsl:if[2]/xsl:if[1]" x="228" y="0"/>
				<block path="fo:table[1]/fo:table-body/fo:table-row/fo:table-cell/fo:block/xsl:if[1]/xsl:if[2]/xsl:if[1]/xsl:if/=[0]" x="212" y="0"/>
				<block path="fo:table[1]/fo:table-body/fo:table-row/fo:table-cell/fo:block/xsl:if[1]/xsl:if[2]/xsl:if[1]/xsl:if" x="258" y="0"/>
				<block path="fo:table[1]/fo:table-body/fo:table-row/fo:table-cell/fo:block/xsl:if[1]/xsl:if[2]/xsl:if[1]/xsl:if/xsl:value-of" x="288" y="0"/>
				<block path="fo:table[1]/fo:table-body/fo:table-row/fo:table-cell/fo:block/xsl:if[1]/xsl:if[2]/xsl:if[1]/xsl:if/xsl:value-of[1]" x="288" y="0"/>
				<block path="fo:table[1]/fo:table-body/fo:table-row/fo:table-cell/fo:block/xsl:if[1]/xsl:if[2]/xsl:if[1]/xsl:if[1]/=[0]" x="212" y="0"/>
				<block path="fo:table[1]/fo:table-body/fo:table-row/fo:table-cell/fo:block/xsl:if[1]/xsl:if[2]/xsl:if[1]/xsl:if[1]" x="258" y="0"/>
				<block path="fo:table[1]/fo:table-body/fo:table-row/fo:table-cell/fo:block/xsl:if[1]/xsl:if[2]/xsl:if[1]/xsl:if[1]/xsl:value-of" x="288" y="0"/>
				<block path="fo:table[1]/fo:table-body/fo:table-row/fo:table-cell/fo:block/xsl:if[1]/xsl:if[2]/xsl:if[1]/xsl:if[1]/xsl:value-of[1]" x="288" y="0"/>
				<block path="fo:table[1]/fo:table-body/fo:table-row/fo:table-cell/fo:block/xsl:if[1]/xsl:if[3]/=[0]" x="182" y="0"/>
				<block path="fo:table[1]/fo:table-body/fo:table-row/fo:table-cell/fo:block/xsl:if[1]/xsl:if[3]" x="228" y="0"/>
				<block path="fo:table[1]/fo:table-body/fo:table-row/fo:table-cell/fo:block/xsl:if[1]/xsl:if[3]/xsl:if/=[0]" x="212" y="0"/>
				<block path="fo:table[1]/fo:table-body/fo:table-row/fo:table-cell/fo:block/xsl:if[1]/xsl:if[3]/xsl:if" x="258" y="0"/>
				<block path="fo:table[1]/fo:table-body/fo:table-row/fo:table-cell/fo:block/xsl:if[1]/xsl:if[3]/xsl:if[1]/=[0]" x="182" y="0"/>
				<block path="fo:table[1]/fo:table-body/fo:table-row/fo:table-cell/fo:block/xsl:if[1]/xsl:if[3]/xsl:if[1]" x="228" y="0"/>
				<block path="fo:table[1]/fo:table-body/fo:table-row/fo:table-cell/fo:block/xsl:if[1]/xsl:if[3]/xsl:if[1]/xsl:if/=[0]" x="212" y="0"/>
				<block path="fo:table[1]/fo:table-body/fo:table-row/fo:table-cell/fo:block/xsl:if[1]/xsl:if[3]/xsl:if[1]/xsl:if" x="258" y="0"/>
				<block path="fo:table[1]/fo:table-body/fo:table-row/fo:table-cell/fo:block/xsl:if[1]/xsl:if[3]/xsl:if[1]/xsl:if/xsl:value-of" x="288" y="0"/>
				<block path="fo:table[1]/fo:table-body/fo:table-row/fo:table-cell/fo:block/xsl:if[1]/xsl:if[3]/xsl:if[1]/xsl:if[1]/=[0]" x="212" y="0"/>
				<block path="fo:table[1]/fo:table-body/fo:table-row/fo:table-cell/fo:block/xsl:if[1]/xsl:if[3]/xsl:if[1]/xsl:if[1]" x="258" y="0"/>
				<block path="fo:table[1]/fo:table-body/fo:table-row/fo:table-cell/fo:block/xsl:if[1]/xsl:if[3]/xsl:if[1]/xsl:if[1]/xsl:value-of" x="288" y="0"/>
				<block path="fo:table[1]/fo:table-body/fo:table-row/fo:table-cell/fo:block/xsl:if[1]/xsl:if[3]/xsl:if[1]/xsl:if[1]/xsl:value-of[1]" x="288" y="0"/>
				<block path="fo:table[2]/fo:table-body/fo:table-row/fo:table-cell/fo:block/xsl:if/!=[0]" x="242" y="0"/>
				<block path="fo:table[2]/fo:table-body/fo:table-row/fo:table-cell/fo:block/xsl:if" x="288" y="0"/>
				<block path="fo:table[2]/fo:table-body/fo:table-row/fo:table-cell/fo:block/xsl:if[1]/=[0]" x="242" y="0"/>
				<block path="fo:table[2]/fo:table-body/fo:table-row/fo:table-cell/fo:block/xsl:if[1]" x="288" y="0"/>
			</template>
			<template match="Header">
				<block path="fo:table/fo:table-body/fo:table-row/fo:table-cell[1]/fo:block/fo:table/fo:table-body/fo:table-row[2]/fo:table-cell[1]/fo:block/xsl:value-of" x="100" y="27"/>
				<block path="fo:table/fo:table-body/fo:table-row/fo:table-cell[4]/fo:block[1]/xsl:value-of" x="100" y="27"/>
				<block path="fo:table/fo:table-body/fo:table-row/fo:table-cell[4]/fo:block[1]/xsl:value-of[1]" x="140" y="27"/>
				<block path="fo:table/fo:table-body/fo:table-row/fo:table-cell[4]/fo:block[1]/xsl:value-of[2]" x="60" y="27"/>
				<block path="fo:table/fo:table-body/fo:table-row/fo:table-cell[4]/fo:block[2]/xsl:value-of" x="20" y="27"/>
				<block path="fo:table/fo:table-body/fo:table-row/fo:table-cell[4]/fo:block[2]/xsl:value-of[1]" x="100" y="27"/>
				<block path="fo:table/fo:table-body/fo:table-row/fo:table-cell[4]/fo:block[2]/xsl:value-of[2]" x="100" y="27"/>
			</template>
			<template match="UC022">
				<block path="fo:table[1]/fo:table-body/fo:table-row/fo:table-cell/fo:block/xsl:if/=[0]" x="212" y="0"/>
				<block path="fo:table[1]/fo:table-body/fo:table-row/fo:table-cell/fo:block/xsl:if" x="258" y="0"/>
				<block path="" x="288" y="0"/>
				<block path="fo:table[1]/fo:table-body/fo:table-row/fo:table-cell/fo:block/xsl:if/xsl:value-of" x="288" y="0"/>
				<block path="fo:table[1]/fo:table-body/fo:table-row/fo:table-cell/fo:block/xsl:if/xsl:value-of[1]" x="288" y="0"/>
				<block path="fo:table[1]/fo:table-body/fo:table-row/fo:table-cell/fo:block/xsl:if/xsl:if/or[0]" x="212" y="0"/>
				<block path="fo:table[1]/fo:table-body/fo:table-row/fo:table-cell/fo:block/xsl:if/xsl:if/or[0]/and[0]" x="166" y="0"/>
				<block path="fo:table[1]/fo:table-body/fo:table-row/fo:table-cell/fo:block/xsl:if/xsl:if/or[0]/and[0]/and[0]" x="120" y="0"/>
				<block path="fo:table[1]/fo:table-body/fo:table-row/fo:table-cell/fo:block/xsl:if/xsl:if/or[0]/and[0]/and[0]/and[0]" x="74" y="0"/>
				<block path="fo:table[1]/fo:table-body/fo:table-row/fo:table-cell/fo:block/xsl:if/xsl:if/or[0]/and[0]/and[0]/and[0]/and[0]" x="28" y="0"/>
				<block path="fo:table[1]/fo:table-body/fo:table-row/fo:table-cell/fo:block/xsl:if/xsl:if/or[0]/and[0]/and[0]/and[0]/and[0]/=[1]" x="0" y="22"/>
				<block path="fo:table[1]/fo:table-body/fo:table-row/fo:table-cell/fo:block/xsl:if/xsl:if/or[0]/and[0]/and[0]/and[0]/=[1]" x="28" y="22"/>
				<block path="fo:table[1]/fo:table-body/fo:table-row/fo:table-cell/fo:block/xsl:if/xsl:if/or[0]/and[0]/and[0]/=[1]" x="74" y="22"/>
				<block path="fo:table[1]/fo:table-body/fo:table-row/fo:table-cell/fo:block/xsl:if/xsl:if/or[0]/and[0]/=[1]" x="120" y="22"/>
			</template>
		</MapperBlockPosition>
		<TemplateContext></TemplateContext>
		<MapperFilter side="source"></MapperFilter>
	</MapperMetaTag>
</metaInformation>
-->