/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.webutil.ws.tagext;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.Tag;
import javax.servlet.jsp.tagext.TagSupport;
import oracle.ds.v2.impl.system.typemap.XmlJavaTypeMap;
import oracle.j2ee.ws.client.WebServiceMethod;
import oracle.j2ee.ws.client.WebServiceProxy;
import oracle.j2ee.ws.client.WebServiceProxyException;
import oracle.j2ee.ws.client.wsdl.Message;
import oracle.j2ee.ws.client.wsdl.Operation;
import oracle.j2ee.ws.client.wsdl.Part;
import oracle.j2ee.ws.client.wsdl.PortType;
import oracle.jsp.webutil.tagutil.TagUtil;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLNode;
import org.apache.soap.util.xml.QName;
import org.apache.soap.util.xml.XMLJavaMappingRegistry;
import org.w3c.dom.Node;

public class InvokeTag
extends TagSupport {
    private WebServiceProxy _proxy;
    private String _webservice;
    private XMLJavaMappingRegistry _xjmr;
    private String _wsdlUrl;
    private Operation _operation;
    private String _operationName;
    private String _inputMsgName;
    private String _outputMsgName;
    private int _scope = 1;
    private ArrayList _alPartNames = new ArrayList();
    private ArrayList _alPartValues = new ArrayList();
    private boolean _xmlToWriter;
    private String _toXMLObjName;
    private static final String MSG_FILE = "oracle.jsp.webutil.ws.tagext.LocalStrings";
    private static ResourceBundle msgs = ResourceBundle.getBundle("oracle.jsp.webutil.ws.tagext.LocalStrings");

    public InvokeTag() {
        this.resetAttr();
    }

    public void setWebservice(String webservice) {
        this._webservice = webservice;
    }

    public void setOperation(String operation) {
        this._operationName = operation;
    }

    public void setXmlToWriter(boolean b) {
        this._xmlToWriter = b;
    }

    public boolean getXmlToWriter() {
        return this._xmlToWriter;
    }

    public void setToXMLObjName(String xmlObjName) {
        this._toXMLObjName = xmlObjName;
    }

    public String getToXMLObjName() {
        return this._toXMLObjName;
    }

    public void setInputMsgName(String inmsg) {
        this._inputMsgName = inmsg;
    }

    public void setOutputMsgName(String outmsg) {
        this._outputMsgName = outmsg;
    }

    public int doStartTag() throws JspTagException {
        String tagId = this.getId();
        if (tagId == null || tagId.trim().length() == 0) {
            throw new JspTagException(msgs.getString("no_id"));
        }
        if (this._operationName == null || this._operationName.trim().length() == 0) {
            throw new JspTagException(msgs.getString("no_operation"));
        }
        return 1;
    }

    public int doEndTag() throws JspTagException {
        Object wstag = null;
        ArrayList _alMaps = null;
        if (this._webservice != null && this._webservice.trim().length() != 0) {
            this._scope = this.pageContext.getAttributesScope(this._webservice);
            _alMaps = (ArrayList)this.pageContext.findAttribute(this._webservice + ".mapping");
            this._proxy = (WebServiceProxy)this.pageContext.findAttribute(this._webservice);
        }
        if (this._proxy == null) {
            throw new JspTagException(msgs.getString("no_webservice"));
        }
        try {
            this._xjmr = this._proxy.getXMLMappingRegistry();
            Iterator it = _alMaps.iterator();
            while (it.hasNext()) {
                XmlJavaTypeMap map = (XmlJavaTypeMap)it.next();
                this._xjmr.mapTypes(map.getEncodingStyleUri(), map.getQName(), map.getJavaClass(), map.getSerializer(), map.getDeserializer());
            }
        }
        catch (Exception e) {
            throw new JspTagException(e.toString() + ": " + e.getMessage());
        }
        try {
            PortType pt = this._proxy.getPortType();
            this._operation = pt.getOperation(this._operationName, this._inputMsgName, this._outputMsgName);
            WebServiceMethod m = null;
            m = this._inputMsgName == null && this._outputMsgName == null ? this._proxy.getMethod(this._operationName) : this._proxy.getMethod(this._operationName, this._inputMsgName, this._outputMsgName);
            if (this._operation == null || m == null) {
                throw new JspTagException(msgs.getString("no_ws_operation") + this._operationName);
            }
            String szInEncStyle = m.getInputEncodingStyle();
            Message msgIn = this._operation.getInput().getMessage();
            Map mapParts = msgIn.getParts();
            Collection colParts = mapParts.values();
            Iterator itParts = colParts.iterator();
            while (itParts.hasNext()) {
                Part part = (Part)itParts.next();
                String szPartName = part.getName();
                QName partQname = part.getTypeName();
                if (partQname == null) continue;
                String szJavaType = this._xjmr.queryJavaType(partQname, szInEncStyle).getName();
                int idx = this._alPartNames.indexOf(szPartName);
                String value = (String)this._alPartValues.get(idx);
                if (szJavaType.equals("java.lang.String")) continue;
                if (szJavaType.equals("int")) {
                    Integer i = new Integer(value);
                    this._alPartValues.remove(idx);
                    this._alPartValues.add(idx, i);
                    continue;
                }
                if (szJavaType.equals("float")) {
                    Float f = new Float(value);
                    this._alPartValues.remove(idx);
                    this._alPartValues.add(idx, f);
                    continue;
                }
                if (szJavaType.equals("double")) {
                    Double d = new Double(value);
                    this._alPartValues.remove(idx);
                    this._alPartValues.add(idx, d);
                    continue;
                }
                if (szJavaType.equals("long")) {
                    Long l = new Long(value);
                    this._alPartValues.remove(idx);
                    this._alPartValues.add(idx, l);
                    continue;
                }
                if (szJavaType.equals("short")) {
                    Short s = new Short(value);
                    this._alPartValues.remove(idx);
                    this._alPartValues.add(idx, s);
                    continue;
                }
                if (szJavaType.equals("byte")) {
                    Byte b = new Byte(value);
                    this._alPartValues.remove(idx);
                    this._alPartValues.add(idx, b);
                    continue;
                }
                Object obj = null;
                try {
                    Class<?> cls = Class.forName(szJavaType);
                    Class<?> strClass = Class.forName("java.lang.String");
                    Class[] argCl = new Class[]{strClass};
                    Constructor<?> constr = cls.getConstructor(argCl);
                    Object[] objArr = new Object[]{value};
                    obj = constr.newInstance(objArr);
                }
                catch (Exception exp) {
                    throw new JspTagException(exp.toString() + ": " + exp.getMessage());
                }
                this._alPartValues.remove(idx);
                this._alPartValues.add(idx, obj);
            }
            Object objResult = m.invoke(this.arrayList2StringArray(this._alPartNames), this.arrayList2ObjectArray(this._alPartValues));
            this.pageContext.setAttribute(this.getId(), objResult, this._scope);
            if (objResult.getClass().getName().equals("oracle.xml.parser.v2.XMLElement") || objResult.getClass().getName().equals("oracle.xml.parser.v2.XMLDocument") || objResult.getClass().getName().equals("oracle.xml.parser.v2.XMLNode")) {
                XMLDocument doc = new XMLDocument();
                XMLNode adoptedNode = (XMLNode)doc.adoptNode((Node)((XMLNode)objResult));
                doc.appendChild((Node)adoptedNode);
                TagUtil.setToXMLObj((Tag)this, doc);
                if (this._toXMLObjName != null) {
                    this.pageContext.setAttribute(this._toXMLObjName, (Object)doc);
                }
                if (this._xmlToWriter) {
                    JspWriter out = this.pageContext.getOut();
                    XMLNode node = (XMLNode)objResult;
                    node.print(new PrintWriter((Writer)out));
                }
            }
        }
        catch (WebServiceProxyException e) {
            throw new JspTagException(e.toString() + ": " + e.getMessage());
        }
        catch (IOException exp) {
            throw new JspTagException(exp.toString() + ": " + exp.getMessage());
        }
        finally {
            this._alPartNames.clear();
            this._alPartValues.clear();
        }
        return 6;
    }

    public void addPart(String name, Object value) {
        this._alPartNames.add(this._alPartNames.size(), name);
        this._alPartValues.add(this._alPartValues.size(), value);
    }

    private void resetAttr() {
        this._proxy = null;
        this._webservice = null;
        this._inputMsgName = null;
        this._outputMsgName = null;
        this._toXMLObjName = null;
        this._alPartNames.clear();
        this._alPartValues.clear();
    }

    public void release() {
        this._proxy = null;
        this._webservice = null;
        this._inputMsgName = null;
        this._outputMsgName = null;
        this._xmlToWriter = false;
        this._alPartNames.clear();
        this._alPartValues.clear();
        super.release();
    }

    private String[] arrayList2StringArray(ArrayList al) {
        String[] sa = new String[al.size()];
        int i = 0;
        Iterator it = al.iterator();
        while (it.hasNext()) {
            sa[i++] = (String)it.next();
        }
        return sa;
    }

    private Object[] arrayList2ObjectArray(ArrayList al) {
        Object[] oa = new Object[al.size()];
        int i = 0;
        Iterator it = al.iterator();
        while (it.hasNext()) {
            oa[i++] = it.next();
        }
        return oa;
    }
}

