/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.webutil.tagutil;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.servlet.ServletException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import oracle.jsp.webutil.tagutil.TagUtil;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLDocumentFragment;
import oracle.xml.parser.v2.XSLException;
import oracle.xml.parser.v2.XSLProcessor;
import oracle.xml.parser.v2.XSLStylesheet;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class JmlTransform {
    private static final String MSG_FILE = "oracle.jsp.webutil.tagutil.LocalStrings";
    private static ResourceBundle msgs = ResourceBundle.getBundle("oracle.jsp.webutil.tagutil.LocalStrings");

    public static XMLDocument transform(PageContext pc, Reader source, JspWriter sink, String href, XMLDocument fromXMLObj, boolean needDomObj, boolean toWriter) throws MalformedURLException, XSLException, SAXException, IOException, ServletException {
        XSLStylesheet xsl = null;
        XMLDocument xmld = null;
        URL url = null;
        if (href != null) {
            url = TagUtil.getURLFromResource(pc, href, ".xsl");
        }
        try {
            InputStream is = url.openStream();
            xsl = new XSLStylesheet(is, url);
        }
        catch (Exception e) {
            throw new IOException(MessageFormat.format(msgs.getString("err_opening_url"), url.toString()));
        }
        XSLProcessor xslProcessor = new XSLProcessor();
        if (fromXMLObj == null && source != null) {
            DOMParser d = new DOMParser();
            d.parse(source);
            xmld = d.getDocument();
        } else {
            xmld = fromXMLObj;
        }
        XMLDocument toXMLObj = null;
        if (xmld != null) {
            if (needDomObj) {
                XMLDocumentFragment result = xslProcessor.processXSL(xsl, xmld);
                toXMLObj = new XMLDocument();
                try {
                    toXMLObj.appendChild((Node)result);
                }
                catch (Exception e) {
                    Node node;
                    toXMLObj = new XMLDocument();
                    for (node = result.getFirstChild(); node != null && node.getNodeType() != 1; node = node.getNextSibling()) {
                    }
                    toXMLObj.appendChild(node);
                }
            }
            if (toWriter) {
                PrintWriter out = new PrintWriter((Writer)sink);
                xslProcessor.processXSL(xsl, xmld, out);
            }
        }
        return toXMLObj;
    }

    public static void transform(PageContext pc, Reader source, JspWriter sink, String href) throws MalformedURLException, XSLException, SAXException, IOException, ServletException {
        JmlTransform.transform(pc, source, sink, href, null, false, true);
    }
}

