/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.webutil.personalization.tagext;

import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.servlet.jsp.JspTagException;
import oracle.dmt.op.re.base.DataItem;
import oracle.dmt.op.re.reapi.rt.IdentificationData;
import oracle.dmt.op.re.reapi.rt.REProxyRT;
import oracle.dmt.op.re.reexception.BadDBConnectionException;
import oracle.dmt.op.re.reexception.ConnectionPoolIsFullException;
import oracle.dmt.op.re.reexception.ErrorExecutingRE;
import oracle.dmt.op.re.reexception.InvalidIDException;
import oracle.dmt.op.re.reexception.NullParameterException;
import oracle.dmt.op.re.reexception.REProxyInitException;
import oracle.jsp.webutil.personalization.OPUtil;
import oracle.jsp.webutil.personalization.tagext.ItemTagSupport;

public class RemoveDemographicRecordTag
extends ItemTagSupport {
    private static final String MSG_FILE = "oracle.jsp.webutil.personalization.tagext.LocalStrings";
    private static ResourceBundle msgs = ResourceBundle.getBundle("oracle.jsp.webutil.personalization.tagext.LocalStrings");
    private DataItem theItem = null;

    public RemoveDemographicRecordTag() {
        this.tagName = "removeDemographicRecord";
        this.dataSrc = "DEMOGRAPHIC";
    }

    public int doStartTag() throws JspTagException {
        if (OPUtil.getDisableRecording(this.pageContext)) {
            this.release();
            return 0;
        }
        if (OPUtil.isEmpty(this.type)) {
            throw new JspTagException(msgs.getString("type_missing"));
        }
        if (OPUtil.isEmpty(this.value)) {
            throw new JspTagException(msgs.getString("value_missing"));
        }
        REProxyRT proxy = OPUtil.getProxy(this.pageContext);
        IdentificationData idData = OPUtil.getIdData(this.pageContext);
        if (proxy == null) {
            throw new JspTagException(msgs.getString("no_proxy"));
        }
        if (idData == null) {
            throw new JspTagException(msgs.getString("no_id_data"));
        }
        this.ID = 0L;
        this.theItem = this.getDataItem(this.createOPItem(), this.dataSrc, this.value);
        if (this.theItem == null) {
            this.release();
            return 0;
        }
        try {
            proxy.removeItem(idData, this.theItem);
        }
        catch (BadDBConnectionException e) {
            throw new JspTagException(MessageFormat.format(msgs.getString("cannot_rm_item"), this.tagName, ((Object)((Object)e)).getClass() + e.getMessage()));
        }
        catch (InvalidIDException e) {
            throw new JspTagException(MessageFormat.format(msgs.getString("cannot_rm_item"), this.tagName, ((Object)((Object)e)).getClass() + e.getMessage()));
        }
        catch (ErrorExecutingRE e) {
            throw new JspTagException(MessageFormat.format(msgs.getString("cannot_rm_item"), this.tagName, ((Object)((Object)e)).getClass() + e.getMessage()));
        }
        catch (REProxyInitException e) {
            throw new JspTagException(MessageFormat.format(msgs.getString("cannot_rm_item"), this.tagName, ((Object)((Object)e)).getClass() + e.getMessage()));
        }
        catch (ConnectionPoolIsFullException e) {
            throw new JspTagException(MessageFormat.format(msgs.getString("cannot_rm_item"), this.tagName, ((Object)((Object)e)).getClass() + e.getMessage()));
        }
        catch (NullParameterException e) {
            throw new JspTagException(MessageFormat.format(msgs.getString("cannot_rm_item"), this.tagName, ((Object)((Object)e)).getClass() + e.getMessage()));
        }
        this.release();
        return 0;
    }

    public int doEndTag() {
        this.release();
        return 6;
    }

    public void setType(String s) throws JspTagException {
        if (OPUtil.isEmpty(s)) {
            return;
        }
        if (!(s.equalsIgnoreCase("GENDER") || s.equalsIgnoreCase("AGE") || s.equalsIgnoreCase("MARITAL_STATUS") || s.equalsIgnoreCase("PERSONAL_INCOME") || s.equalsIgnoreCase("HOUSEHOLD_INCOME") || s.equalsIgnoreCase("IS_HEAD_OF_HOUSEHOLD") || s.equalsIgnoreCase("HOUSEHOLD_SIZE") || s.equalsIgnoreCase("RENT_OWN_INDICATOR") || s.toUpperCase().startsWith("ATTRIBUTE"))) {
            throw new JspTagException(msgs.getString("invalid_type"));
        }
        this.type = s;
    }

    public void setValue(String s) {
        this.value = s;
    }

    public void release() {
        super.release();
        this.value = null;
    }
}

