/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.webutil.personalization.tagext;

import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.servlet.jsp.JspTagException;
import oracle.dmt.op.re.base.FilteringSettings;
import oracle.dmt.op.re.base.TuningSettings;
import oracle.dmt.op.re.reapi.rt.IdentificationData;
import oracle.dmt.op.re.reapi.rt.REProxyRT;
import oracle.dmt.op.re.reapi.rt.RecommendationContent;
import oracle.dmt.op.re.reapi.rt.RecommendationList;
import oracle.dmt.op.re.reexception.ArrayTooLargeException;
import oracle.dmt.op.re.reexception.BadDBConnectionException;
import oracle.dmt.op.re.reexception.ConnectionPoolIsFullException;
import oracle.dmt.op.re.reexception.ErrorExecutingRE;
import oracle.dmt.op.re.reexception.InvalidIDException;
import oracle.dmt.op.re.reexception.NullParameterException;
import oracle.dmt.op.re.reexception.REProxyInitException;
import oracle.jsp.webutil.personalization.ConfigFileException;
import oracle.jsp.webutil.personalization.OPUtil;
import oracle.jsp.webutil.personalization.tagext.RecommendationGetter;

public class GetRecommendationsTag
extends RecommendationGetter {
    private static final String MSG_FILE = "oracle.jsp.webutil.personalization.tagext.LocalStrings";
    private static ResourceBundle msgs = ResourceBundle.getBundle("oracle.jsp.webutil.personalization.tagext.LocalStrings");
    String from = null;
    long[] fromHotPicksGroups = null;

    public GetRecommendationsTag() {
        this.tagName = "getRecommendations";
        this.isXSell = false;
        this.outItemList_position = 0;
    }

    public int doStartTag() throws JspTagException {
        try {
            this.checkMaxQuantity();
        }
        catch (ConfigFileException e) {
            throw new JspTagException(MessageFormat.format(msgs.getString("err_read_attr"), "getRecommendations", "maxQuantity", e.getMessage()));
        }
        if (this.from == null && this.fromHotPicksGroups == null) {
            this.from = "TOP";
        }
        if (!OPUtil.isEmpty(this.from) && this.fromHotPicksGroups != null) {
            throw new JspTagException(msgs.getString("exclusive_attr"));
        }
        REProxyRT proxy = OPUtil.getProxy(this.pageContext);
        IdentificationData idData = OPUtil.getIdData(this.pageContext);
        if (proxy == null) {
            throw new JspTagException(msgs.getString("no_proxy"));
        }
        if (idData == null) {
            throw new JspTagException(msgs.getString("no_id_data"));
        }
        TuningSettings tunings = null;
        FilteringSettings filters = null;
        try {
            tunings = this.createTuningSettings();
        }
        catch (ConfigFileException e) {
            throw new JspTagException(MessageFormat.format(msgs.getString("err_config_tuning"), e.getMessage()));
        }
        RecommendationContent recContent = this.createRecommendationContent();
        try {
            filters = this.createFilteringSettings();
        }
        catch (ConfigFileException e) {
            throw new JspTagException(MessageFormat.format(msgs.getString("err_config_filtering"), e.getMessage()));
        }
        RecommendationList recList = null;
        try {
            recList = this.fromHotPicksGroups != null ? proxy.recommendFromHotPicks(idData, this.maxQuantity, this.fromHotPicksGroups, tunings, filters, recContent) : (this.from.equals("TOP") ? proxy.recommendTopItems(idData, this.maxQuantity, tunings, filters, recContent) : proxy.recommendBottomItems(idData, this.maxQuantity, tunings, filters, recContent));
        }
        catch (ArrayTooLargeException e) {
            throw new JspTagException(MessageFormat.format(msgs.getString("err_recomm"), e.getMessage()));
        }
        catch (NullParameterException e) {
            throw new JspTagException(MessageFormat.format(msgs.getString("err_recomm"), e.getMessage()));
        }
        catch (BadDBConnectionException e) {
            throw new JspTagException(MessageFormat.format(msgs.getString("err_recomm"), e.getMessage()));
        }
        catch (InvalidIDException e) {
            throw new JspTagException(MessageFormat.format(msgs.getString("err_recomm"), e.getMessage()));
        }
        catch (ErrorExecutingRE e) {
            throw new JspTagException(MessageFormat.format(msgs.getString("err_recomm"), e.getMessage()));
        }
        catch (REProxyInitException e) {
            throw new JspTagException(MessageFormat.format(msgs.getString("err_recomm"), e.getMessage()));
        }
        catch (ConnectionPoolIsFullException e) {
            throw new JspTagException(MessageFormat.format(msgs.getString("err_recomm"), e.getMessage()));
        }
        this.processRecommendationResults(recList);
        return 1;
    }

    public int doEndTag() throws JspTagException {
        this.release();
        return 6;
    }

    public void setFrom(String s) throws JspTagException {
        if (OPUtil.isEmpty(s)) {
            return;
        }
        if (!s.equalsIgnoreCase("TOP") && !s.equalsIgnoreCase("BOTTOM")) {
            throw new JspTagException(msgs.getString("invalid_from"));
        }
        this.from = s.toUpperCase();
    }

    public void setFromHotPicksGroups(String s) throws JspTagException {
        this.fromHotPicksGroups = this.getLongArray(s, "fromHotPicksGroups");
    }

    public void release() {
        this.from = null;
        this.fromHotPicksGroups = null;
        super.release();
    }
}

