/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.webutil.personalization;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.Random;
import java.util.ResourceBundle;
import javax.servlet.ServletContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.PageContext;
import oracle.dmt.op.re.base.Enum;
import oracle.dmt.op.re.base.FilteringSettings;
import oracle.dmt.op.re.base.TuningSettings;
import oracle.dmt.op.re.reapi.rt.IdentificationData;
import oracle.dmt.op.re.reapi.rt.REProxyManager;
import oracle.dmt.op.re.reapi.rt.REProxyRT;
import oracle.dmt.op.re.reexception.NullParameterException;
import oracle.dmt.op.re.reexception.REProxyInitException;
import oracle.jsp.webutil.personalization.ConfigFile;
import oracle.jsp.webutil.personalization.ConfigFileException;

public class OPUtil {
    private static final String MSG_FILE = "oracle.jsp.webutil.personalization.LocalStrings";
    private static ResourceBundle msgs = ResourceBundle.getBundle("oracle.jsp.webutil.personalization.LocalStrings");
    public static final String ATTR_OPUTIL = "oracle.jsp.webutil.personalization.OPUtil";
    public static final String ATTR_CONFIG = "oracle.jsp.webutil.personalization.ConfigFile";
    public static final String ATTR_PROXY = "oracle.jsp.webutil.personalization.REProxy";
    public static final String ATTR_IDDATA = "oracle.jsp.webutil.personalization.IdData";
    public static final String ATTR_USERID = "oracle.jsp.webutil.personalization.UserID";
    public static final String ATTR_DISABLE_REC = "oracle.jsp.webutil.personalization.DisableRec";
    public static final String ATTR_USE_SESS = "oracle.jsp.webutil.personalization.UseSession";
    public static final String ATTR_SESS_LSNR = "oracle.jsp.webutil.personalization.SessLsnr";
    public static final String COOKIE_USERID = "OPTL_UserID";
    public static final String COOKIE_USERCUST = "OPTL_UserCustomer";
    public static final String COOKIE_RENAME = "OPTL_REName";
    public static final String COOKIE_USE_SESS = "OPTL_USE_SESS";
    public static final String COOKIE_DISABLE_REC = "OPTL_DisRec";
    public static final String APP_CONFIG_LOCATION = "/WEB-INF/personalization.xml";
    public static Random random = null;
    private ConfigFile configFile = null;

    public static boolean isEmpty(String s) {
        return s == null || s.length() == 0 || s.equals("");
    }

    public static boolean isSessionFul(PageContext pageContext) {
        HttpServletRequest req = (HttpServletRequest)pageContext.getRequest();
        HttpSession httpSess = req.getSession(false);
        REProxyRT proxy = null;
        IdentificationData idData = null;
        if (httpSess != null) {
            proxy = (REProxyRT)httpSess.getAttribute(ATTR_PROXY);
            idData = (IdentificationData)httpSess.getAttribute(ATTR_IDDATA);
            return proxy != null && idData != null;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConfigFile getConfig(PageContext pageContext) throws ConfigFileException {
        ServletContext application = pageContext.getServletContext();
        ConfigFile configFile = (ConfigFile)application.getAttribute(ATTR_CONFIG);
        if (configFile != null) {
            return configFile;
        }
        ServletContext servletContext = application;
        synchronized (servletContext) {
            configFile = (ConfigFile)application.getAttribute(ATTR_CONFIG);
            if (configFile != null) {
                return configFile;
            }
            configFile = new ConfigFile(application.getResourceAsStream(APP_CONFIG_LOCATION));
            application.setAttribute(ATTR_CONFIG, (Object)configFile);
        }
        return configFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Random getRandom(HttpServletRequest request) {
        if (random != null) {
            return random;
        }
        String IP = null;
        try {
            IP = InetAddress.getByName(request.getServerName()).getHostAddress();
            int first = IP.indexOf(".");
            int second = IP.indexOf(".", first + 1);
            int third = IP.lastIndexOf(".");
            IP = IP.substring(0, first) + IP.substring(first + 1, second) + IP.substring(second + 1, third) + IP.substring(third + 1);
        }
        catch (UnknownHostException e) {
            IP = "";
        }
        String port = String.valueOf(request.getServerPort());
        Class clazz = OPUtil.class;
        synchronized (clazz) {
            if (random != null) {
                return random;
            }
            try {
                random = new Random(Long.parseLong(IP + port));
            }
            catch (NumberFormatException e) {
                random = new Random(request.getServerPort());
            }
        }
        return random;
    }

    public static boolean setupRequestForOP(PageContext pageContext) throws JspTagException {
        HttpServletRequest request = (HttpServletRequest)pageContext.getRequest();
        String REName = null;
        String userID = null;
        String userCust = null;
        String disableRec = null;
        Cookie[] cooks = request.getCookies();
        if (cooks == null) {
            return false;
        }
        for (int i = 0; i < cooks.length; ++i) {
            if (cooks[i].getName().equals(COOKIE_RENAME)) {
                REName = cooks[i].getValue();
                continue;
            }
            if (cooks[i].getName().equals(COOKIE_USERID)) {
                userID = cooks[i].getValue();
                continue;
            }
            if (cooks[i].getName().equals(COOKIE_USERCUST)) {
                userCust = cooks[i].getValue();
                continue;
            }
            if (!cooks[i].getName().equals(COOKIE_DISABLE_REC)) continue;
            disableRec = cooks[i].getValue();
        }
        if (OPUtil.isEmpty(REName) || OPUtil.isEmpty(userID) || OPUtil.isEmpty(userCust)) {
            return false;
        }
        try {
            REProxyRT proxy = REProxyManager.getProxy((String)REName);
            if (proxy == null) {
                REInfo re = new REInfo();
                re.name = REName;
                proxy = OPUtil.createREProxy(re, pageContext);
            }
            request.setAttribute(ATTR_PROXY, (Object)proxy);
        }
        catch (REProxyInitException e) {
            throw new JspTagException(MessageFormat.format(msgs.getString("fail_engine"), REName));
        }
        boolean isUserCustomer = false;
        if (userCust.equalsIgnoreCase("true")) {
            isUserCustomer = true;
        }
        Enum.UserType enumUser = isUserCustomer ? Enum.User.CUSTOMER : Enum.User.VISITOR;
        try {
            IdentificationData idData = IdentificationData.createSessionless((String)userID, (Enum.UserType)enumUser);
            request.setAttribute(ATTR_IDDATA, (Object)idData);
            request.setAttribute(ATTR_USERID, (Object)userID);
        }
        catch (NullParameterException e) {
            throw new JspTagException("Internal error: userID or userType not available.\n");
        }
        if (disableRec == null) {
            request.setAttribute(ATTR_DISABLE_REC, (Object)"false");
        } else if (disableRec.equalsIgnoreCase("true")) {
            request.setAttribute(ATTR_DISABLE_REC, (Object)"true");
        } else {
            request.setAttribute(ATTR_DISABLE_REC, (Object)"false");
        }
        return true;
    }

    public static REProxyRT createREProxy(REInfo reinfo, PageContext pageContext) throws JspTagException {
        try {
            if (OPUtil.isEmpty(reinfo.URL) || OPUtil.isEmpty(reinfo.schema) || OPUtil.isEmpty(reinfo.passwd)) {
                reinfo = (REInfo)OPUtil.getConfig(pageContext).readElement("RE", reinfo.name);
            }
        }
        catch (ConfigFileException e) {
            throw new JspTagException(e.getMessage());
        }
        if (OPUtil.isEmpty(reinfo.URL) || OPUtil.isEmpty(reinfo.schema) || OPUtil.isEmpty(reinfo.passwd)) {
            throw new JspTagException(msgs.getString("lack_info"));
        }
        REProxyRT proxy = null;
        String errMessage = null;
        try {
            proxy = REProxyManager.createProxy((String)reinfo.name, (String)reinfo.URL, (String)reinfo.schema, (String)reinfo.passwd, (int)reinfo.cSize, (int)reinfo.flushInt);
        }
        catch (Exception e) {
            errMessage = e.getMessage();
            proxy = null;
        }
        if (proxy == null) {
            throw new JspTagException(MessageFormat.format(msgs.getString("fail_engine_2"), reinfo.name, errMessage));
        }
        return proxy;
    }

    public static IdentificationData getIdData(PageContext pageContext) throws JspTagException {
        boolean isUserCustomer = false;
        String userID = null;
        IdentificationData idData = null;
        String userCust = null;
        HttpServletRequest request = (HttpServletRequest)pageContext.getRequest();
        HttpSession httpSess = request.getSession(false);
        if (OPUtil.isSessionFul(pageContext) && (idData = (IdentificationData)httpSess.getAttribute(ATTR_IDDATA)) != null) {
            return idData;
        }
        idData = (IdentificationData)request.getAttribute(ATTR_IDDATA);
        if (idData != null) {
            return idData;
        }
        Cookie[] cooks = request.getCookies();
        if (cooks == null) {
            return null;
        }
        for (int i = 0; i < cooks.length; ++i) {
            if (cooks[i].getName().equals(COOKIE_USERID)) {
                userID = cooks[i].getValue();
                continue;
            }
            if (!cooks[i].getName().equals(COOKIE_USERCUST)) continue;
            userCust = cooks[i].getValue();
        }
        if (OPUtil.isEmpty(userID) || OPUtil.isEmpty(userCust)) {
            return null;
        }
        if (userCust.equalsIgnoreCase("true")) {
            isUserCustomer = true;
        }
        Enum.UserType enumUser = isUserCustomer ? Enum.User.CUSTOMER : Enum.User.VISITOR;
        try {
            idData = IdentificationData.createSessionless((String)userID, (Enum.UserType)enumUser);
            if (idData != null) {
                request.setAttribute(ATTR_IDDATA, (Object)idData);
            }
            return idData;
        }
        catch (Exception e) {
            throw new JspTagException(msgs.getString("cannot_create_id"));
        }
    }

    public static REProxyRT getProxy(PageContext pageContext) throws JspTagException {
        String REName = null;
        HttpServletRequest request = (HttpServletRequest)pageContext.getRequest();
        HttpSession httpSess = request.getSession(false);
        REProxyRT proxy = null;
        if (OPUtil.isSessionFul(pageContext) && (proxy = (REProxyRT)httpSess.getAttribute(ATTR_PROXY)) != null) {
            return proxy;
        }
        proxy = (REProxyRT)request.getAttribute(ATTR_PROXY);
        if (proxy != null) {
            return proxy;
        }
        Cookie[] cooks = request.getCookies();
        if (cooks == null) {
            return null;
        }
        for (int i = 0; i < cooks.length; ++i) {
            if (!cooks[i].getName().equals(COOKIE_RENAME)) continue;
            REName = cooks[i].getValue();
        }
        if (OPUtil.isEmpty(REName)) {
            return null;
        }
        try {
            proxy = REProxyManager.getProxy(REName);
            if (proxy != null) {
                request.setAttribute(ATTR_PROXY, (Object)proxy);
            }
            return proxy;
        }
        catch (Exception e) {
            throw new JspTagException(msgs.getString("no_proxy"));
        }
    }

    public static TuningSettings getTuningSettings(PageContext pageContext, String name) throws JspTagException, ConfigFileException {
        TuningSettings ts = null;
        if (!OPUtil.isEmpty(name)) {
            ts = (TuningSettings)OPUtil.getConfig(pageContext).readElement("Tuning", name);
            return ts;
        }
        ts = (TuningSettings)OPUtil.getConfig(pageContext).readElement("DefaultTuning", null);
        if (ts != null) {
            return ts;
        }
        try {
            return new TuningSettings(Enum.DataSourceType.getType((String)"ALL"), Enum.InterestDimensionType.getType((String)"NAVIGATION"), Enum.PersonalizationIndexType.getType((String)"MEDIUM"), Enum.ProfileDataBalanceType.getType((String)"BALANCED"), Enum.ProfileUsageType.getType((String)"INCLUDE"));
        }
        catch (NullParameterException e) {
            throw new JspTagException("Internal error: unable to create default TuningSettings object.\n");
        }
    }

    public static FilteringSettings getFilteringSettings(PageContext pageContext, String name) throws JspTagException, ConfigFileException {
        FilteringSettings fs = null;
        if (!OPUtil.isEmpty(name)) {
            fs = (FilteringSettings)OPUtil.getConfig(pageContext).readElement("Filtering", name);
            return fs;
        }
        fs = (FilteringSettings)OPUtil.getConfig(pageContext).readElement("DefaultFiltering", null);
        return fs;
    }

    public static int getMaxQuantity(PageContext pageContext) throws ConfigFileException {
        int mq = Integer.MIN_VALUE;
        mq = OPUtil.getConfig(pageContext).getIntValue("RecommendationSettings", "maxQuantity");
        return mq;
    }

    public static boolean getDisableRecording(PageContext pageContext) throws JspTagException {
        String disable = null;
        HttpServletRequest request = (HttpServletRequest)pageContext.getRequest();
        HttpSession httpSess = request.getSession(false);
        if (OPUtil.isSessionFul(pageContext)) {
            disable = (String)httpSess.getAttribute(ATTR_DISABLE_REC);
            if (disable == null) {
                return false;
            }
            return disable.equalsIgnoreCase("true");
        }
        disable = (String)request.getAttribute(ATTR_DISABLE_REC);
        if (disable != null) {
            return disable.equalsIgnoreCase("true");
        }
        Cookie[] cooks = request.getCookies();
        if (cooks == null) {
            return false;
        }
        for (int i = 0; i < cooks.length; ++i) {
            if (!cooks[i].getName().equals(COOKIE_DISABLE_REC)) continue;
            disable = cooks[i].getValue();
        }
        if (OPUtil.isEmpty(disable)) {
            request.setAttribute(ATTR_DISABLE_REC, (Object)"false");
            return false;
        }
        request.setAttribute(ATTR_DISABLE_REC, (Object)disable);
        return disable.equalsIgnoreCase("true");
    }

    public static class REInfo {
        public String name = null;
        public String URL = null;
        public String schema = null;
        public String passwd = null;
        public int cSize = 3234;
        public int flushInt = 60000;
    }
}

