/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.webutil.personalization;

import com.evermind.security.SecuritySensitive;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.ResourceBundle;
import oracle.dmt.op.re.base.Enum;
import oracle.dmt.op.re.base.FilteringSettings;
import oracle.dmt.op.re.base.TuningSettings;
import oracle.dmt.op.re.reexception.ArrayTooLargeException;
import oracle.dmt.op.re.reexception.NullParameterException;
import oracle.jsp.webutil.personalization.ConfigFileException;
import oracle.jsp.webutil.personalization.OPUtil;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.DTD;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLParseException;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class ConfigFile {
    private static DTD dtd = null;
    private static Document serverConfig = null;
    private Document appConfig = null;
    private ConfigLookup configLookup = null;
    private static final String MSG_FILE = "oracle.jsp.webutil.personalization.LocalStrings";
    private static ResourceBundle msgs = ResourceBundle.getBundle("oracle.jsp.webutil.personalization.LocalStrings");

    private static Document getServerConfig() throws ConfigFileException, XMLParseException, SAXException, IOException {
        Object config = null;
        String j2ee_home_config = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("oracle.j2ee.home");
            }
        });
        if (j2ee_home_config == null) {
            throw new ConfigFileException(msgs.getString("null_j2ee_home"));
        }
        j2ee_home_config = j2ee_home_config + File.separator + "config";
        InputStream docStream = ConfigFile.class.getResourceAsStream(j2ee_home_config + "personalization.xml");
        return ConfigFile.parseConfigStream(docStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigFile(InputStream appConfigStream) throws ConfigFileException {
        if (dtd == null) {
            Class clazz = ConfigFile.class;
            synchronized (clazz) {
                try {
                    dtd = ConfigFile.parseDTD();
                }
                catch (Exception e) {
                    throw new ConfigFileException(msgs.getString("error_parsing_config") + "personalization.dtd:\n" + e.getMessage());
                }
                try {
                    serverConfig = ConfigFile.getServerConfig();
                }
                catch (Exception e) {
                    throw new ConfigFileException(msgs.getString("error_parsing_server_config") + "personalization.xml:\n" + e.getMessage());
                }
            }
        }
        try {
            this.appConfig = ConfigFile.parseConfigStream(appConfigStream);
        }
        catch (Exception e) {
            throw new ConfigFileException(msgs.getString("error_parsing_app_config") + "personalization.xml:\n" + e.getMessage());
        }
        this.configLookup = new ConfigLookup(this.appConfig, serverConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DTD parseDTD() throws IOException, XMLParseException, SAXException {
        DOMParser parser = new DOMParser();
        InputStream dtdStream = null;
        try {
            dtdStream = ConfigFile.class.getResourceAsStream("personalization.dtd");
            parser.parseDTD(dtdStream, "personalization-config");
            DTD dTD = parser.getDoctype();
            return dTD;
        }
        finally {
            if (dtdStream != null) {
                dtdStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Document parseConfigStream(InputStream docStream) throws IOException, XMLParseException, SAXException {
        if (docStream == null || dtd == null) {
            return null;
        }
        DOMParser parser = new DOMParser();
        parser.setDoctype(dtd);
        parser.setErrorStream((OutputStream)System.err);
        parser.setValidationMode(true);
        parser.showWarnings(true);
        try {
            parser.parse(docStream);
            XMLDocument xMLDocument = parser.getDocument();
            return xMLDocument;
        }
        finally {
            if (docStream != null) {
                docStream.close();
            }
        }
    }

    private String getConfigType(boolean ow) {
        return ow ? msgs.getString("app") : msgs.getString("server");
    }

    public Object readElement(String elemType, String name) {
        if (elemType.equals("RE")) {
            return this.configLookup.getRE(name);
        }
        if (elemType.equals("Tuning") || elemType.equals("DefaultTuning")) {
            return this.configLookup.getTuning(name);
        }
        if (elemType.equals("Filtering") || elemType.equals("DefaultFiltering")) {
            return this.configLookup.getFiltering(name);
        }
        return null;
    }

    public int getIntValue(String elemType, String attrName) {
        if (elemType.equals("RecommendationSettings") && attrName.equals("maxQuantity")) {
            return this.configLookup.getMaxQuantity();
        }
        return Integer.MIN_VALUE;
    }

    private class ConfigLookup {
        private Hashtable namedREs = new Hashtable();
        private Hashtable namedTunings = new Hashtable();
        private TuningSettings dfltTuning = null;
        private Hashtable namedFilterings = new Hashtable();
        private FilteringSettings dfltFiltering = null;
        private int mq = Integer.MIN_VALUE;

        private ConfigLookup() {
        }

        ConfigLookup(Document appConfig, Document serverConfig) throws ConfigFileException {
            this();
            if (appConfig != null) {
                this.setConfigLookup(appConfig, true);
            }
            if (serverConfig != null) {
                this.setConfigLookup(serverConfig, false);
            }
        }

        private synchronized void setConfigLookup(Document config, boolean overwrite) throws ConfigFileException {
            Element root = config.getDocumentElement();
            NodeList nodes = root.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                if (!(nodes.item(i) instanceof Element)) continue;
                Element elem = (Element)nodes.item(i);
                String elName = elem.getTagName();
                if (elName.equals("RE")) {
                    this.setRE(elem, overwrite);
                    continue;
                }
                if (elName.equals("Tuning")) {
                    this.setTuning(elem, overwrite);
                    continue;
                }
                if (elName.equals("DefaultTuning")) {
                    this.setTuning(elem, overwrite);
                    continue;
                }
                if (elName.equals("Filtering")) {
                    this.setFiltering(elem, overwrite);
                    continue;
                }
                if (elName.equals("DefaultFiltering")) {
                    this.setFiltering(elem, overwrite);
                    continue;
                }
                if (!elName.equals("RecommendationSettings")) continue;
                this.setRecSettings(elem, overwrite);
            }
        }

        private synchronized void setRE(Element elem, boolean overwrite) throws ConfigFileException {
            if (!overwrite && this.namedREs.get(elem.getAttribute("Name")) != null) {
                return;
            }
            OPUtil.REInfo re = new OPUtil.REInfo();
            re.name = elem.getAttribute("Name");
            re.URL = elem.getAttribute("URL");
            re.schema = elem.getAttribute("Schema");
            try {
                re.passwd = SecuritySensitive.global().decode(elem.getAttribute("Password"));
            }
            catch (NoClassDefFoundError e) {
                re.passwd = elem.getAttribute("Password");
            }
            try {
                re.cSize = Integer.parseInt(elem.getAttribute("CacheSize"));
            }
            catch (NumberFormatException e) {
                throw new ConfigFileException(MessageFormat.format(msgs.getString("err_parsing_int"), ConfigFile.this.getConfigType(overwrite), "RE", "CacheSize"));
            }
            try {
                re.flushInt = Integer.parseInt(elem.getAttribute("FlushInterval"));
            }
            catch (NumberFormatException e) {
                throw new ConfigFileException(MessageFormat.format(msgs.getString("err_parsing_int"), ConfigFile.this.getConfigType(overwrite), "RE", "FlushInterval"));
            }
            this.namedREs.put(re.name, re);
        }

        private synchronized void setTuning(Element elem, boolean overwrite) throws ConfigFileException {
            String name = elem.getAttribute("Name");
            if (!overwrite && name != null && this.namedTunings.get(name) != null) {
                return;
            }
            if (!overwrite && elem.getTagName().equals("DefaultTuning") && this.dfltTuning != null) {
                return;
            }
            String ds = elem.getAttribute("DataSource");
            String id = elem.getAttribute("InterestDimension");
            String pi = elem.getAttribute("PersonalizationIndex");
            String pdb = elem.getAttribute("ProfileDataBalance");
            String pu = elem.getAttribute("ProfileUsage");
            try {
                TuningSettings ts = new TuningSettings(Enum.DataSourceType.getType((String)ds), Enum.InterestDimensionType.getType((String)id), Enum.PersonalizationIndexType.getType((String)pi), Enum.ProfileDataBalanceType.getType((String)pdb), Enum.ProfileUsageType.getType((String)pu));
                if (elem.getNodeName().equals("DefaultTuning")) {
                    this.dfltTuning = ts;
                } else {
                    this.namedTunings.put(name, ts);
                }
            }
            catch (NullParameterException e) {
                throw new ConfigFileException(MessageFormat.format(msgs.getString("err_attr_tuning"), ConfigFile.this.getConfigType(overwrite), elem.getTagName().equals("DefaultTuning") ? "DefaultTuning" : "Tuning,", name));
            }
        }

        private synchronized void setFiltering(Element elem, boolean overwrite) throws ConfigFileException {
            String name = elem.getAttribute("Name");
            if (!overwrite && name != null && this.namedFilterings.get(name) != null) {
                return;
            }
            if (!overwrite && elem.getTagName().equals("DefaultFiltering") && this.dfltFiltering != null) {
                return;
            }
            int taxID = 0;
            try {
                taxID = Integer.parseInt(elem.getAttribute("TaxonomyID"));
            }
            catch (NumberFormatException e) {
                throw new ConfigFileException(MessageFormat.format(msgs.getString("err_parsing_int"), ConfigFile.this.getConfigType(overwrite), elem.getTagName(), "TaxonomyID"));
            }
            Element filter = (Element)elem.getFirstChild();
            NodeList cats = filter.getChildNodes();
            long[] catIDs = new long[cats.getLength()];
            for (int i = 0; i < cats.getLength(); ++i) {
                Text catPCData = (Text)cats.item(i).getFirstChild();
                try {
                    catIDs[i] = Long.parseLong(catPCData.getData());
                    continue;
                }
                catch (DOMException e) {
                    --i;
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new ConfigFileException(MessageFormat.format(msgs.getString("err_parsing_int"), ConfigFile.this.getConfigType(overwrite), elem.getTagName(), "category ID"));
                }
            }
            FilteringSettings fs = new FilteringSettings();
            String filterName = filter.getTagName();
            if (filterName.equals("AllItems")) {
                fs.setItemFiltering(taxID);
            } else if (filterName.equals("AllCategories")) {
                fs.setCategoryFiltering(taxID);
            } else {
                try {
                    if (filterName.equals("ExcludeItems")) {
                        fs.setItemExclusion(taxID, catIDs);
                    } else if (filterName.equals("IncludeItems")) {
                        fs.setItemFiltering(taxID, catIDs);
                    } else if (filterName.equals("ExcludeCategories")) {
                        fs.setCategoryExclusion(taxID, catIDs);
                    } else if (filterName.equals("IncludeCategories")) {
                        fs.setCategoryFiltering(taxID, catIDs);
                    } else if (filterName.equals("CategoryLevel")) {
                        fs.setCategoryLevelFiltering(taxID, catIDs);
                    } else if (filterName.equals("SubTreeItems")) {
                        fs.setItemSubTreeFiltering(taxID, catIDs);
                    } else if (filterName.equals("SubTreeCategories")) {
                        fs.setCategorySubTreeFiltering(taxID, catIDs);
                    }
                }
                catch (ArrayTooLargeException e) {
                    throw new ConfigFileException(MessageFormat.format(msgs.getString("err_parsing_config"), ConfigFile.this.getConfigType(overwrite), elem.getTagName()));
                }
            }
            if (elem.getTagName().equals("DefaultFiltering")) {
                this.dfltFiltering = fs;
            } else {
                this.namedFilterings.put(name, fs);
            }
        }

        private synchronized void setRecSettings(Element elem, boolean overwrite) throws ConfigFileException {
            if (!overwrite && this.mq != Integer.MIN_VALUE) {
                return;
            }
            try {
                this.mq = Integer.parseInt(elem.getAttribute("maxQuantity"));
            }
            catch (NumberFormatException e) {
                throw new ConfigFileException(MessageFormat.format(msgs.getString("err_parsing_int"), ConfigFile.this.getConfigType(overwrite), "RecommendationSettings", "maxQuantity"));
            }
        }

        public OPUtil.REInfo getRE(String name) {
            return (OPUtil.REInfo)this.namedREs.get(name);
        }

        public TuningSettings getTuning(String name) {
            if (name == null) {
                return this.dfltTuning;
            }
            return (TuningSettings)this.namedTunings.get(name);
        }

        public FilteringSettings getFiltering(String name) {
            if (name == null) {
                return this.dfltFiltering;
            }
            return (FilteringSettings)this.namedFilterings.get(name);
        }

        public int getMaxQuantity() {
            return this.mq;
        }
    }
}

