/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.webutil.jesi.tagext;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.BodyContent;
import oracle.jsp.webutil.jesi.tagext.JESIBodyTag;
import oracle.jsp.webutil.jesi.tagext.JESITag;
import oracle.jsp.webutil.jesi.tagext.TemplateTag;

public class FragmentTag
extends JESIBodyTag {
    private static final String FRAGMENT_INUSE = "oracle.jsp.webutil.jesi.tagext.fragment.inuse";
    private int tagCount = 0;
    private int requestFragment = -1;
    private TemplateTag parentTemplate = null;

    public int doStartTag() throws JspTagException {
        if (this.pageContext.getAttribute(FRAGMENT_INUSE, 2) != null) {
            this.release();
            throw new JspTagException(msgs.getString("nested_fragment"));
        }
        this.pageContext.setAttribute(FRAGMENT_INUSE, (Object)this, 2);
        this.setTagCountInfo();
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        if (!JESITag.requestFromESI_10(request)) {
            return 1;
        }
        try {
            if (this.requestFragment == this.getCurrentTagCount()) {
                ((HttpServletResponse)this.pageContext.getResponse()).setHeader("Surrogate-Control", this.makeSurrogateControl());
                return 2;
            }
            if (this.requestFragment == -1) {
                this.pageContext.getOut().write("<esi:include src=\"" + this.getURL() + "\"/>");
            }
            return 0;
        }
        catch (IOException e) {
            this.release();
            throw new JspTagException(e.toString());
        }
    }

    public int doAfterBody() throws JspTagException {
        return 6;
    }

    int getCurrentTagCount() {
        return this.tagCount;
    }

    void setTagCountInfo() throws JspTagException {
        this.parentTemplate = (TemplateTag)((Object)this.pageContext.getAttribute("oracle.jsp.webutil.jesi.tagext.template.inuse", 2));
        if (this.parentTemplate == null) {
            throw new JspTagException(msgs.getString("out_template"));
        }
        this.parentTemplate.incrementFragmentTagCount();
        this.tagCount = this.parentTemplate.getFragmentTagCount();
        this.requestFragment = this.parentTemplate.getRequestFragment();
    }

    private String getURL() {
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        HttpServletResponse response = (HttpServletResponse)this.pageContext.getResponse();
        String url = request.getRequestURI() + "?" + "__esi_fragment" + "=" + this.getCurrentTagCount();
        return FragmentTag.copyParams(request, response, url, true, null);
    }

    public int doEndTag() throws JspTagException {
        BodyContent c;
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        if (JESITag.requestFromESI_10(request) && this.requestFragment == this.getCurrentTagCount() && (c = this.getBodyContent()) != null) {
            this.parentTemplate.setRequestFragmentBody(c.getString());
        }
        this.pageContext.removeAttribute(FRAGMENT_INUSE, 2);
        this.release();
        return 6;
    }

    public void release() {
        this.tagCount = 0;
        this.requestFragment = -1;
        this.parentTemplate = null;
        super.release();
    }
}

