/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.webutil.jesi;

import com.evermind.security.SecuritySensitive;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.ResourceBundle;
import oracle.jsp.webutil.jesi.PropertyData;
import org.xml.sax.AttributeList;
import org.xml.sax.HandlerBase;
import org.xml.sax.SAXException;

public abstract class XMLData
extends HandlerBase {
    private static final String MSG_FILE = "oracle.jsp.webutil.jesi.LocalStrings";
    private static ResourceBundle msgs = ResourceBundle.getBundle("oracle.jsp.webutil.jesi.LocalStrings");
    boolean done = false;
    protected XMLData childCurrent = null;
    protected String dataTagCurrent = null;
    protected String dataTagValue = null;
    protected StringBuffer content = new StringBuffer();
    protected String name = null;
    protected Hashtable properties = new Hashtable();

    public XMLData(String name) {
        this.name = name;
    }

    protected String getName() {
        return this.name;
    }

    public final void startElement(String name, AttributeList atts) throws SAXException {
        if (this.childCurrent != null) {
            this.childCurrent.startElement(name, atts);
        } else {
            this.childCurrent = this.getTagObject(name, atts);
        }
    }

    public void setProperty(String name, String value) {
        if (value != null && name != null) {
            if ("password".equals(name)) {
                try {
                    value = SecuritySensitive.global().decode(value);
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                    // empty catch block
                }
            }
            this.properties.put(name, value);
        }
    }

    public String getProperty(String name) {
        return (String)this.properties.get(name);
    }

    protected XMLData getTagObject(String name, AttributeList atts) throws SAXException {
        throw new SAXException(MessageFormat.format(msgs.getString("unknown_tag_name"), name, this.name));
    }

    public final void endElement(String name) throws SAXException {
        if (this.childCurrent != null) {
            this.childCurrent.endElement(name);
            if (this.childCurrent.done) {
                if (this.childCurrent instanceof PropertyData) {
                    PropertyData data = (PropertyData)this.childCurrent;
                    this.setProperty(data.getName(), data.getValue());
                }
                this.childCurrent = null;
            }
        } else if (name.equals(this.name)) {
            this.done = true;
        } else {
            throw new SAXException(MessageFormat.format(msgs.getString("tag_mismatch"), name, this.name));
        }
    }

    public final void characters(char[] ch, int start, int length) throws SAXException {
        if (this.childCurrent != null) {
            this.childCurrent.characters(ch, start, length);
        } else {
            this.content.append(ch, start, length);
        }
    }

    public String getValue() {
        return this.content.toString();
    }
}

