/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.webutil.fileaccess.tagext;

import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.Tag;
import javax.servlet.jsp.tagext.TagSupport;
import oracle.jsp.dbutil.ConnBean;
import oracle.jsp.dbutil.tagext.dbOpenTag;
import oracle.jsp.webutil.fileaccess.FileAccessException;
import oracle.jsp.webutil.fileaccess.HttpUploadBean;

public class HttpUploadTag
extends TagSupport {
    private String destinationType;
    private String fileType;
    private String overwrite;
    private String table;
    private String prefixCol;
    private String fileNameCol;
    private String dataCol;
    private String scope;
    private String destination;
    private String connectionId;
    private HttpUploadBean upBean;
    private ConnBean cb;
    private String docCharacterset = "ISO-8859-1";
    private static final String MSG_FILE = "oracle.jsp.webutil.fileaccess.tagext.LocalStrings";
    private static final ResourceBundle msgs = ResourceBundle.getBundle("oracle.jsp.webutil.fileaccess.tagext.LocalStrings");

    public HttpUploadTag() {
        this.resetAttr();
    }

    public void release() {
        this.resetAttr();
    }

    private void resetAttr() {
        this.destinationType = "filesystem";
        this.fileType = "binary";
        this.overwrite = "true";
        this.table = "fileaccess";
        this.prefixCol = "fileprefix";
        this.fileNameCol = "filename";
        this.dataCol = "data";
        this.scope = "page";
        this.docCharacterset = "ISO-8859-1";
        this.destination = null;
        this.connectionId = null;
        this.upBean = null;
        this.cb = null;
    }

    public int doStartTag() throws JspTagException {
        try {
            this.upBean = new HttpUploadBean();
            this.upBean.setDestinationType(this.destinationType);
            this.upBean.setFileType(this.fileType);
            this.upBean.setOverwrite(this.overwrite);
            if (this.destinationType == null || this.destinationType.equals("")) {
                throw new JspTagException(msgs.getString("NO_DESTINATIONTYPE"));
            }
            if (this.destinationType.equalsIgnoreCase("filesystem")) {
                this.upBean.setBaseDir(this.pageContext.getServletContext(), (HttpServletRequest)this.pageContext.getRequest());
                this.upBean.setDestination(this.destination);
            }
            if (this.destinationType.equalsIgnoreCase("database")) {
                this.establishConnection();
                this.upBean.setTable(this.table);
                this.upBean.setPrefixColumn(this.prefixCol);
                this.upBean.setFileNameColumn(this.fileNameCol);
                this.upBean.setDataColumn(this.dataCol);
                this.upBean.setDestination(this.destination);
                this.upBean.setDocCharacterset(this.docCharacterset);
            }
            this.upBean.upload((HttpServletRequest)this.pageContext.getRequest());
        }
        catch (FileAccessException a) {
            throw new JspTagException(a.toString());
        }
        catch (JspException e) {
            throw new JspTagException(e.toString());
        }
        return 0;
    }

    public int doEndTag() throws JspException {
        this.resetAttr();
        return 6;
    }

    private void establishConnection() throws JspTagException {
        String cid = this.getConnId();
        if (cid != null) {
            if (this.scope == null || this.scope.equals("page")) {
                this.cb = (ConnBean)this.pageContext.getAttribute(cid);
            } else if (this.scope.equals("request")) {
                this.cb = (ConnBean)this.pageContext.getAttribute(cid, 2);
            } else if (this.scope.equals("session")) {
                this.cb = (ConnBean)this.pageContext.getAttribute(cid, 3);
            } else if (this.scope.equals("application")) {
                this.cb = (ConnBean)this.pageContext.getAttribute(cid, 4);
            }
            if (this.cb == null) {
                throw new JspTagException(MessageFormat.format(msgs.getString("CONNID_NOT_FOUND"), cid, this.scope));
            }
        } else {
            dbOpenTag tag = (dbOpenTag)HttpUploadTag.findAncestorWithClass((Tag)this, (Class)dbOpenTag.class);
            if (tag == null) {
                throw new JspTagException(msgs.getString("NO_ENCLOSING_CONNECTION"));
            }
            this.cb = tag.getConnBean();
        }
        if (this.cb == null) {
            throw new JspTagException(msgs.getString("NO_CONNECTION"));
        }
        try {
            this.cb.connect();
            this.upBean.setConnection(this.cb);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setDestination(String s) {
        this.destination = s;
    }

    public void setDestinationType(String s) {
        this.destinationType = s;
    }

    public void setConnId(String s) {
        this.connectionId = s;
    }

    public String getConnId() {
        return this.connectionId;
    }

    public void setScope(String s) throws JspTagException {
        if (s == null || s.equals("")) {
            throw new JspTagException(msgs.getString("NO_SCOPE"));
        }
        String temp = s.toLowerCase();
        if (!(temp.equals("page") || temp.equals("request") || temp.equals("session") || temp.equals("application"))) {
            throw new JspTagException(MessageFormat.format(msgs.getString("INVALID_SCOPE"), s));
        }
        this.scope = temp;
    }

    public void setOverwrite(String s) {
        this.overwrite = s;
    }

    public void setFileType(String s) {
        this.fileType = s;
    }

    public void setTable(String s) {
        this.table = s;
    }

    public void setPrefixColumn(String s) {
        this.prefixCol = s;
    }

    public void setFileNameColumn(String s) {
        this.fileNameCol = s;
    }

    public void setDataColumn(String s) {
        this.dataCol = s;
    }

    public void setDocCharacterset(String s) {
        this.docCharacterset = s;
    }

    public String getDocCharacterset() {
        return this.docCharacterset;
    }
}

