/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.webutil.fileaccess;

import java.sql.Connection;
import java.util.Enumeration;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import oracle.jsp.dbutil.ConnBean;
import oracle.jsp.webutil.fileaccess.FileAccessException;
import oracle.jsp.webutil.fileaccess.FileAccessUtil;
import oracle.jsp.webutil.fileaccess.FormBasedUpload;
import oracle.jsp.webutil.fileaccess.HttpFileAccessBean;

public class HttpUploadBean
extends HttpFileAccessBean {
    FormBasedUpload fbu = new FormBasedUpload();

    public void upload(HttpServletRequest req) throws FileAccessException {
        try {
            if (req != null) {
                this.fbu.setFileDetails(this.fd);
                if (this.fd.locationType == 1) {
                    this.fbu.setDbDetails(this.dd);
                }
                this.fbu.upload((ServletRequest)req);
                this.fileNames = this.fbu.getFileNames();
            }
        }
        catch (FileAccessException ae) {
            throw new FileAccessException(ae.getMessage());
        }
        catch (Exception e) {
            throw new FileAccessException(e.getMessage());
        }
    }

    public void setOverwrite(String s) throws FileAccessException {
        if (s == null || s.equals("") || s.equalsIgnoreCase("true")) {
            this.fd.setOverwrite(true);
        } else if (s.equalsIgnoreCase("false")) {
            this.fd.setOverwrite(false);
        } else {
            throw new FileAccessException(FileAccessUtil.formatErrorMessage("INVALID_OVERWRITE", s));
        }
    }

    public void setOverwrite(boolean overwrite) {
        this.fd.setOverwrite(overwrite);
    }

    public void setDestinationType(String destType) throws FileAccessException {
        this.setLocationType(destType, ACCESSUPLOAD);
    }

    public void setDestinationType(int destType) throws FileAccessException {
        this.setLocationType(destType, ACCESSUPLOAD);
    }

    public void setDestination(String s) throws FileAccessException {
        this.setLocation(s, ACCESSUPLOAD);
    }

    public void setFileType(String s) throws FileAccessException {
        super.setFileType(s);
    }

    public void setFileType(int i) throws FileAccessException {
        super.setFileType(i);
    }

    public void setTable(String s) throws FileAccessException {
        super.setTable(s);
    }

    public void setPrefixColumn(String s) throws FileAccessException {
        super.setPrefixColumn(s);
    }

    public void setFileNameColumn(String s) throws FileAccessException {
        super.setFileNameColumn(s);
    }

    public void setDataColumn(String s) throws FileAccessException {
        super.setDataColumn(s);
    }

    public void setConnection(ConnBean cb) {
        super.setConnBean(cb);
    }

    public void setConnection(Connection conn) {
        super.setConnection(conn);
    }

    public void setBaseDir(ServletContext servletContext, HttpServletRequest request) throws FileAccessException {
        super.setBaseDir(servletContext, request);
    }

    public void setTempUpload(String s) throws FileAccessException {
        if (s == null || s.equals("") || s.equalsIgnoreCase("false")) {
            this.fd.setTempFile(false);
        } else if (s.equalsIgnoreCase("true")) {
            this.fd.setTempFile(true);
            this.setOverwrite(false);
        } else {
            throw new FileAccessException(FileAccessUtil.formatErrorMessage("INVALID_OVERWRITE", s));
        }
    }

    public void setTempUpload(boolean overwrite) throws FileAccessException {
        this.fd.setTempFile(overwrite);
        this.setOverwrite(false);
    }

    public void setDocCharacterset(String charset) {
        super.setDocCharacterset(charset);
    }

    public String getOverwrite() {
        return this.fd.overwrite ? "true" : "false";
    }

    public String getDestinationType() {
        return this.getLocationType();
    }

    public String getDestination() {
        return this.getLocation();
    }

    public String getFileType() {
        return super.getFileType();
    }

    public String getTable() {
        return super.getTable();
    }

    public String getPrefixColumn() {
        return super.getPrefixColumn();
    }

    public String getFileNameColumn() {
        return super.getFileNameColumn();
    }

    public String getDataColumn() {
        return super.getDataColumn();
    }

    public String getDocCharacterset() {
        return super.getDocCharacterset();
    }

    public Enumeration getFileNames() {
        return super.getFileNames();
    }

    public String getParameter(String name) {
        return this.fbu.getParameter(name);
    }
}

