/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.webutil.fileaccess;

import java.io.File;
import java.util.Enumeration;
import java.util.Vector;
import oracle.jsp.webutil.fileaccess.FileAccessException;
import oracle.jsp.webutil.fileaccess.FileAccessUtil;
import oracle.jsp.webutil.fileaccess.PersistentEntity;

public abstract class FileSystemEntity
extends PersistentEntity {
    private Vector fileVector = new Vector();

    public boolean checkLocation() throws FileAccessException {
        File dir = new File(this.fd.getFSPath());
        if (!dir.isDirectory()) {
            throw new FileAccessException(FileAccessUtil.formatErrorMessage("NOT_A_DIRECTORY", new Object[]{this.fd.location}));
        }
        if (!dir.canWrite()) {
            throw new FileAccessException(FileAccessUtil.formatErrorMessage("DIR_NOT_WRITABLE", this.fd.location));
        }
        if (this.fd.location.equals("*")) {
            return true;
        }
        if (this.fd.location.length() != 0) {
            this.fd.location = this.fd.location + (this.fd.location.endsWith(System.getProperty("file.separator")) ? "" : System.getProperty("file.separator"));
        }
        return true;
    }

    public void deleteEmpty() throws FileAccessException {
        try {
            File f = new File(this.fd.basedir + this.fd.location + "__zero_len_file");
            if (f.exists()) {
                f.delete();
            }
        }
        catch (SecurityException i) {
            throw new FileAccessException(FileAccessUtil.formatErrorMessage("ERROR_DELETING_EMPTY_FILES", i));
        }
    }

    public Enumeration getFileNames() throws FileAccessException {
        this.checkLocation();
        this.listFiles(new File(this.fd.getFSPath()));
        if (this.fd.fileList != null) {
            this.fd.fileList.removeAllElements();
        } else {
            this.fd.fileList = new Vector();
        }
        this.fd.fileList = (Vector)this.fileVector.clone();
        return this.fd.fileList.elements();
    }

    public void listFiles(File f) {
        this.addFileName(f);
        if (f.isDirectory()) {
            String[] files = f.list();
            for (int i = 0; i < files.length; ++i) {
                if (this.fd.recurse) {
                    this.listFiles(new File(f, files[i]));
                    continue;
                }
                this.addFileName(new File(f, files[i]));
            }
        }
    }

    protected void setBaseDir(String basedir) {
        this.fd.basedir = basedir;
    }

    private void addFileName(File f) {
        if (!f.isDirectory()) {
            String s = new String(f.toString());
            this.fileVector.addElement(s.substring(this.fd.basedir.length(), s.length()));
        }
    }
}

