/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.webutil.fileaccess;

import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import oracle.jsp.webutil.fileaccess.FileAccessException;

public class FileAccessUtil {
    protected static final String PROP_FILE = "/WEB-INF/fileaccess.properties";
    protected static final String BASE_DIR = "fileaccess.basedir";
    protected static final String UNIQUE_FILENAME = "fileaccess.tempUpload";
    public static final String BINARY_FILE = "binary";
    public static final String CHARACTER_FILE = "character";
    public static final String FILESYSTEM = "filesystem";
    public static final String DATABASE = "database";
    public static final int LOCATION_TYPE_FILESYSTEM = 0;
    public static final int LOCATION_TYPE_DATABASE = 1;
    public static final int FILE_TYPE_BINARY = 0;
    public static final int FILE_TYPE_CHARACTER = 1;
    public static final String SRCTYPE_PARAM = "srcType";
    public static final String TABLE_PARAM = "table";
    public static final String DATA_COL_PARAM = "dataCol";
    public static final String PREFIX_COL_PARAM = "prefixCol";
    public static final String FNAME_COL_PARAM = "fileNameCol";
    public static final String FILETYPE_PARAM = "fileType";
    public static final String DOC_CHARACTERSET_PARAM = "docCharacterset";
    public static final int LOCATION_TYPE_DEFAULT = 0;
    public static final int FILE_TYPE_DEFAULT = 0;
    public static final boolean OVERWRITE_DEFAULT = true;
    public static final boolean UNIQUE_FILENAME_DEFAULT = false;
    public static final String OVERWRITE_STR_DEFAULT = "true";
    public static final boolean RECURSE_DEFAULT = true;
    public static final String RECURSE_STR_DEFAULT = "true";
    public static final String TABLE_NAME_DEFAULT = "fileaccess";
    public static final String PREFIX_COL_DEFAULT = "fileprefix";
    public static final String FILE_NAME_COL_DEFAULT = "filename";
    public static final String DATA_COL_DEFAULT = "data";
    public static final String DEFAULT_CHARSET = "ISO-8859-1";
    protected static final String ZERO_LEN_FILE = "__zero_len_file";
    protected static final String CONNKEY = "9843UF8HF9YT9NVRJG";
    private static final String MSG_FILE = "oracle.jsp.webutil.fileaccess.LocalStrings";
    private static final ResourceBundle msgs = ResourceBundle.getBundle("oracle.jsp.webutil.fileaccess.LocalStrings");

    public static InputStream getResourceAsStream(ServletContext sc, HttpServletRequest req, String path) {
        try {
            return sc.getResourceAsStream(path);
        }
        catch (NoSuchMethodError nsme) {
            return null;
        }
    }

    protected String getBaseDir(ServletContext sc, HttpServletRequest req) throws FileAccessException {
        Properties prop = new Properties();
        try {
            prop.load(FileAccessUtil.getResourceAsStream(sc, req, PROP_FILE));
            String temp = prop.getProperty(BASE_DIR).trim().endsWith(System.getProperty("file.separator")) ? prop.getProperty(BASE_DIR).trim() : prop.getProperty(BASE_DIR).trim() + System.getProperty("file.separator");
            return temp.replace('\"', System.getProperty("file.separator").toCharArray()[0]);
        }
        catch (Exception io) {
            throw new FileAccessException(FileAccessUtil.formatErrorMessage("ERROR_OPENING_PROP_FILE"));
        }
    }

    protected String getTempUpload(ServletContext sc, HttpServletRequest req) throws FileAccessException {
        Properties prop = new Properties();
        try {
            prop.load(FileAccessUtil.getResourceAsStream(sc, req, PROP_FILE));
            return prop.getProperty(UNIQUE_FILENAME).trim();
        }
        catch (Exception io) {
            throw new FileAccessException(FileAccessUtil.formatErrorMessage("ERROR_OPENING_PROP_FILE"));
        }
    }

    protected static String formatErrorMessage(String mesg, Object[] o) {
        return MessageFormat.format(msgs.getString(mesg), o);
    }

    protected static String formatErrorMessage(String mesg, Object o) {
        return MessageFormat.format(msgs.getString(mesg), o);
    }

    protected static String formatErrorMessage(String mesg) {
        return MessageFormat.format(msgs.getString(mesg), null);
    }
}

