/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.webutil.fileaccess;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Vector;
import oracle.jdbc.OracleResultSet;
import oracle.jsp.dbutil.CursorBean;
import oracle.jsp.webutil.fileaccess.DbDetails;
import oracle.jsp.webutil.fileaccess.FileAccessException;
import oracle.jsp.webutil.fileaccess.FileAccessUtil;
import oracle.jsp.webutil.fileaccess.FileBLOB;
import oracle.jsp.webutil.fileaccess.PersistentEntity;
import oracle.sql.BLOB;
import oracle.sql.CLOB;

public abstract class DatabaseEntity
extends PersistentEntity {
    protected DbDetails dd;
    protected BLOB blob;
    protected CLOB clob;
    private Vector fileVector = new Vector();

    public void establishConnection() throws FileAccessException {
        try {
            if (!this.dd.isPlainConnection) {
                if (this.dd.connBean.isConnectionClosed()) {
                    this.dd.connBean.connect();
                }
                this.dd.conn = this.dd.connBean.getConnection();
            } else {
                this.dd.conn = this.dd.connBean.getConnection();
                if (this.dd.conn.isClosed()) {
                    throw new FileAccessException(FileAccessUtil.formatErrorMessage("CONNECTION_CLOSED"));
                }
            }
        }
        catch (Exception e) {
            throw new FileAccessException(FileAccessUtil.formatErrorMessage("CONNECTION_CLOSED") + ":" + e);
        }
    }

    public void releaseConnection() throws FileAccessException {
        try {
            if (!this.dd.isPlainConnection && !this.dd.connBean.isConnectionClosed()) {
                this.dd.connBean.close();
            }
        }
        catch (Exception e) {
            throw new FileAccessException(FileAccessUtil.formatErrorMessage("CANNOT_CLOSE_CONNECTION"));
        }
    }

    public boolean checkLocation() throws FileAccessException {
        String sel_cmd = "select object_type from user_objects where object_name = '" + this.dd.tableName.toUpperCase() + "'";
        try {
            CursorBean curBean = this.dd.connBean.getCursorBean(1, sel_cmd);
            ResultSet rs = curBean.executeQuery();
            rs.next();
            String objType = rs.getString(1);
            return objType != null && objType.equals("TABLE");
        }
        catch (SQLException se) {
            throw new FileAccessException(FileAccessUtil.formatErrorMessage("TABLE_NOT_FOUND", this.dd.tableName), se);
        }
    }

    public void deleteEmpty() throws FileAccessException {
        String del_cmd = "delete from " + this.dd.tableName.toUpperCase() + " where " + this.dd.destColName + " = '" + this.fd.location + "' and " + this.dd.fileColName + " = '" + "__zero_len_file" + "'";
        try {
            CursorBean curBean = this.dd.connBean.getCursorBean(0, del_cmd);
            curBean.execute();
            curBean.execute("commit");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    protected void setDbDetails(DbDetails dd) {
        this.dd = dd;
    }

    public Enumeration getFileNames() throws FileAccessException {
        try {
            this.dd.conn.setAutoCommit(false);
            PreparedStatement stmt = null;
            ResultSet rs = null;
            stmt = this.dd.conn.prepareStatement(this.constructSelCmd());
            if (!this.fd.location.equals("*")) {
                if (this.fd.recurse) {
                    stmt.setString(1, this.fd.location.endsWith("%") ? this.fd.location : this.fd.location + "%");
                } else {
                    stmt.setString(1, this.fd.location);
                }
            }
            rs = stmt.executeQuery();
            while (rs.next()) {
                String fn = rs.getString(1) + System.getProperty("file.separator") + rs.getString(2);
                this.fileVector.addElement(fn);
            }
            if (this.fd.fileList != null) {
                this.fd.fileList.removeAllElements();
            } else {
                this.fd.fileList = new Vector();
            }
            this.fd.fileList = (Vector)this.fileVector.clone();
        }
        catch (SQLException se) {
            try {
                if (this.dd.connBean != null && !this.dd.conn.isClosed()) {
                    this.dd.conn.close();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            throw new FileAccessException(FileAccessUtil.formatErrorMessage("ERROR_GETTING_FILENAMES") + ":" + se);
        }
        return this.fd.fileList.elements();
    }

    protected void getLobLocator() throws SQLException {
        String ins_cmd = "INSERT into " + this.dd.tableName + "(" + this.dd.destColName + "," + this.dd.fileColName + "," + this.dd.dataColName + ")" + " values (?, ?, empty_" + (this instanceof FileBLOB ? "blob" : "clob") + "())";
        String sel_cmd = "select " + this.dd.dataColName + " from " + this.dd.tableName + " where " + this.dd.destColName + " = ? and " + this.dd.fileColName + " = ? for update";
        this.dd.conn.setAutoCommit(false);
        PreparedStatement pstmt = null;
        PreparedStatement stmt = null;
        try {
            pstmt = this.dd.conn.prepareStatement(ins_cmd);
            pstmt.setString(1, this.fd.location);
            pstmt.setString(2, this.fd.filename);
            pstmt.execute();
            pstmt.close();
            this.dd.conn.commit();
        }
        catch (SQLException se) {
            if (se.getSQLState().equals("23000")) {
                if (!this.fd.overwrite) {
                    throw new SQLException(FileAccessUtil.formatErrorMessage("FILE_EXISTS"));
                }
            }
            throw new SQLException(FileAccessUtil.formatErrorMessage("sql_err", se.getMessage()));
        }
        ResultSet rs = null;
        stmt = this.dd.conn.prepareStatement(sel_cmd);
        stmt.setString(1, this.fd.location);
        stmt.setString(2, this.fd.filename);
        rs = stmt.executeQuery();
        if (rs != null) {
            while (rs.next()) {
                if (this instanceof FileBLOB) {
                    this.blob = ((OracleResultSet)rs).getBLOB(1);
                    continue;
                }
                this.clob = ((OracleResultSet)rs).getCLOB(1);
            }
        }
    }

    private String constructSelCmd() {
        String sel_cmd = null;
        sel_cmd = this.fd.location.equals("*") ? "select " + this.dd.destColName + ", " + this.dd.fileColName + " from " + this.dd.tableName.toUpperCase() : (this.fd.recurse ? "select " + this.dd.destColName + ", " + this.dd.fileColName + " from " + this.dd.tableName.toUpperCase() + " where " + this.dd.destColName + " like ?" : "select " + this.dd.destColName + ", " + this.dd.fileColName + " from " + this.dd.tableName.toUpperCase() + " where " + this.dd.destColName + " = ?");
        return sel_cmd;
    }
}

