/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.webutil.email.tagext;

import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.BodyTagSupport;
import oracle.jsp.webutil.email.SendMailBean;
import oracle.jsp.webutil.fileaccess.FileAccessException;
import oracle.jsp.webutil.fileaccess.HttpUploadBean;

public class SendMailTag
extends BodyTagSupport {
    private SendMailBean mailBean = null;
    private HttpUploadBean uploadBean = null;
    private static final String MSG_FILE = "oracle.jsp.webutil.email.tagext.LocalStrings";
    private static ResourceBundle msgs = ResourceBundle.getBundle("oracle.jsp.webutil.email.tagext.LocalStrings");

    public SendMailTag() {
        this.resetAttr();
    }

    public void release() {
        this.resetAttr();
    }

    private void resetAttr() {
        this.mailBean = new SendMailBean();
        this.uploadBean = new HttpUploadBean();
    }

    public void setHost(String s) {
        this.mailBean.setHost(s);
    }

    public String getHost() {
        return this.mailBean.getHost();
    }

    public void setSession(String s) {
        this.mailBean.setSession(s);
    }

    public String getSession() {
        return this.mailBean.getSession();
    }

    public void setSender(String s) throws Exception {
        this.mailBean.setSender(s);
    }

    public String getSender() {
        return this.mailBean.getSender();
    }

    public void setRecipient(String s) throws Exception {
        this.mailBean.setRecipient(s);
    }

    public String getRecipient() {
        return this.mailBean.getRecipient();
    }

    public void setCc(String s) {
        this.mailBean.setCc(s);
    }

    public String getCc() {
        return this.mailBean.getCc();
    }

    public void setBcc(String s) {
        this.mailBean.setBcc(s);
    }

    public String getBcc() {
        return this.mailBean.getBcc();
    }

    public void setSubject(String s) {
        this.mailBean.setSubject(s);
    }

    public String getSubject() {
        return this.mailBean.getSubject();
    }

    public String getClientAttachment() throws Exception {
        return this.mailBean.getClientAttachment();
    }

    public void setClientAttachment(String displayName) throws Exception {
        this.mailBean.setClientAttachment(displayName);
    }

    public void addClientAttachment(String displayName) throws Exception {
        this.mailBean.addClientAttachment(displayName);
    }

    public String getServerAttachment() throws Exception {
        return this.mailBean.getServerAttachment();
    }

    public void setServerAttachment(String s) throws Exception {
        this.mailBean.setServerAttachment(s);
    }

    public void addServerAttachment(String s) throws Exception {
        this.mailBean.addServerAttachment(s);
    }

    public void setContentType(String s) {
        this.mailBean.setContentType(s);
    }

    public String getContentType() {
        return this.mailBean.getContentType();
    }

    public void setContentEncoding(String s) {
        this.mailBean.setContentEncoding(s);
    }

    public String getContentEncoding() {
        return this.mailBean.getContentEncoding();
    }

    public int doStartTag() throws JspTagException {
        try {
            this.mailBean.setAttachmentPermission(this.pageContext.getServletContext(), (HttpServletRequest)this.pageContext.getRequest());
            if (this.mailBean.detectClientAttachment()) {
                this.uploadBean.setTempUpload(true);
            }
        }
        catch (FileAccessException e) {
            e.printStackTrace();
            throw new JspTagException(msgs.getString("email_fail") + e.toString());
        }
        return 2;
    }

    public int doAfterBody() throws JspTagException {
        try {
            this.mailBean.setContent(this.bodyContent.getString());
            this.mailBean.sendMessage(this.pageContext);
        }
        catch (Exception e) {
            throw new JspTagException(msgs.getString("email_fail") + e.toString());
        }
        return 0;
    }

    public int doEndTag() {
        this.resetAttr();
        this.mailBean.close();
        return 6;
    }
}

