/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.net.www;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class Base64Decoder {
    private static final char[] KEY;
    private static final byte[] REVERSE_MAPPING;

    public byte[] decode(String input) throws IOException {
        if (input == null) {
            return null;
        }
        return this.decode(input.getBytes());
    }

    public byte[] decode(byte[] input) throws IOException {
        if (input == null) {
            return null;
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(input);
        return this.decode(bais);
    }

    public byte[] decode(InputStream is) throws IOException {
        if (is == null) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.decode(is, baos);
        return baos.toByteArray();
    }

    public void decode(InputStream is, OutputStream os) throws IOException {
        byte[] buf = new byte[4];
        int byte_count = 0;
        if (is == null || os == null) {
            return;
        }
        while ((buf[byte_count] = (byte)is.read()) != -1 && buf[byte_count] != 61) {
            buf[byte_count] = REVERSE_MAPPING[buf[byte_count]];
            if (buf[byte_count] == -1 || ++byte_count != 4) continue;
            this.writeFirstByte(os, buf);
            this.writeSecondByte(os, buf);
            this.writeThirdByte(os, buf);
            byte_count = 0;
            os.flush();
        }
        if (byte_count == 1) {
            throw new IOException("Input does not contain a valid Base 64 encoded data");
        }
        if (byte_count == 2) {
            this.writeFirstByte(os, buf);
        } else if (byte_count == 3) {
            this.writeFirstByte(os, buf);
            this.writeSecondByte(os, buf);
        }
        os.flush();
    }

    private void writeFirstByte(OutputStream os, byte[] buf) throws IOException {
        os.write((byte)(buf[0] << 2 & 0xFC | buf[1] >>> 4 & 3));
    }

    private void writeSecondByte(OutputStream os, byte[] buf) throws IOException {
        os.write((byte)(buf[1] << 4 & 0xF0 | buf[2] >>> 2 & 0xF));
    }

    private void writeThirdByte(OutputStream os, byte[] buf) throws IOException {
        os.write((byte)(buf[2] << 6 & 0xC0 | buf[3] & 0x3F));
    }

    static {
        int i;
        KEY = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
        REVERSE_MAPPING = new byte[256];
        for (i = 0; i < 256; ++i) {
            Base64Decoder.REVERSE_MAPPING[i] = -1;
        }
        for (i = 0; i < KEY.length; ++i) {
            Base64Decoder.REVERSE_MAPPING[Base64Decoder.KEY[i]] = (byte)i;
        }
    }
}

