/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.net.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import java.util.ResourceBundle;
import oracle.jsp.net.http.HttpResponse;
import oracle.jsp.net.www.Base64Encoder;

public class HttpRequest {
    private static final String MSG_FILE = "oracle.jsp.net.http.LocalStrings";
    private static ResourceBundle msgs = ResourceBundle.getBundle("oracle.jsp.net.http.LocalStrings");
    private static final String CRLF = "\r\n";
    private URL m_URL;
    private boolean m_connected;
    private boolean m_sent;
    private Socket m_socket;
    private InputStream m_inputStream;
    private OutputStream m_outputStream;
    private int m_timeout;
    private Properties m_headers;
    private String m_request;
    private String m_content;
    private String m_contentType;
    private String m_method;
    private HttpResponse m_resp;
    private Base64Encoder m_encoder;

    public HttpRequest(String url) throws MalformedURLException {
        this.m_URL = new URL(url);
        this.m_headers = new Properties();
        this.m_method = "POST";
        this.m_encoder = new Base64Encoder();
    }

    public synchronized void connect() throws IOException {
        if (!this.m_connected) {
            this.m_socket = new Socket(this.m_URL.getHost(), this.m_URL.getPort());
            this.m_connected = true;
        }
    }

    public synchronized void disconnect() {
        if (this.m_inputStream != null) {
            try {
                this.m_inputStream.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            this.m_inputStream = null;
        }
        if (this.m_outputStream != null) {
            try {
                this.m_outputStream.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            this.m_outputStream = null;
        }
        if (this.m_socket != null) {
            try {
                this.m_socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.m_socket = null;
        }
        this.m_connected = false;
    }

    public HttpResponse send() throws IOException {
        if (this.m_sent) {
            throw new IOException(msgs.getString("invalid_op"));
        }
        this.connect();
        StringBuffer sb = new StringBuffer();
        sb.append(this.getMethod()).append(" ");
        sb.append(this.m_URL.getFile());
        sb.append(" HTTP/1.0").append(CRLF);
        sb.append("Host: " + this.m_URL.getHost()).append(CRLF);
        Enumeration<?> enumerator = this.m_headers.propertyNames();
        while (enumerator.hasMoreElements()) {
            String key = (String)enumerator.nextElement();
            sb.append(key).append(": ").append(this.getHeader(key)).append(CRLF);
        }
        if (this.m_content != null && this.m_content.length() != 0) {
            sb.append("Content-Length: " + this.m_content.length()).append(CRLF);
            sb.append("Content-Type: " + this.m_contentType).append(CRLF);
        }
        this.m_request = sb.toString();
        PrintWriter out = new PrintWriter(this.getOutputStream());
        out.print(this.m_request);
        out.print(CRLF);
        if (this.m_content != null) {
            out.print(this.m_content);
            out.print(CRLF);
            out.print(CRLF);
        }
        out.flush();
        this.m_sent = true;
        return new HttpResponse(this);
    }

    public void setMethod(String method) {
        this.m_method = method;
    }

    public String getMethod() {
        return this.m_method;
    }

    public void setHeader(String key, String value) {
        this.m_headers.put(key, value);
    }

    protected String getHeader(String key) {
        return this.m_headers.getProperty(key);
    }

    public void authenticate(String username, String password) {
        this.setHeader("Authorization", "Basic " + this.m_encoder.encode((username + ":" + password).getBytes()));
    }

    public void setContent(String content, String type) {
        this.m_content = content;
        this.m_contentType = type;
    }

    protected synchronized InputStream getInputStream() throws IOException {
        if (this.m_inputStream == null) {
            this.m_inputStream = this.m_socket.getInputStream();
        }
        return this.m_inputStream;
    }

    protected synchronized OutputStream getOutputStream() throws IOException {
        if (this.m_outputStream == null) {
            this.m_outputStream = this.m_socket.getOutputStream();
        }
        return this.m_outputStream;
    }

    public String toString() {
        return this.m_request + this.m_content;
    }

    public void finalize() throws Throwable {
        this.disconnect();
    }
}

