/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.jwcache.tagext;

import java.io.IOException;
import java.io.Writer;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.BodyContent;
import javax.servlet.jsp.tagext.BodyTag;
import oracle.jsp.jwcache.CachePolicyLoadingException;
import oracle.jsp.jwcache.tagext.CachePolicyActionTagBase;

public class CacheTag
extends CachePolicyActionTagBase
implements BodyTag {
    private static final String MSG_FILE = "oracle.jsp.jwcache.tagext.LocalStrings";
    private static ResourceBundle msgs = ResourceBundle.getBundle("oracle.jsp.jwcache.tagext.LocalStrings");
    private BodyContent body = null;

    public int doStartTag() throws JspTagException {
        this.req = (HttpServletRequest)this.pc.getRequest();
        try {
            this.setupPolicy();
        }
        catch (ParseException pe) {
            throw new JspTagException(pe.toString());
        }
        catch (CachePolicyLoadingException cple) {
            throw new JspTagException(cple.toString());
        }
        if (this.invalidateCache) {
            this.policyObj.invalidateCache(this.req, this.specifiedName, this.getParentSectionCounter());
        }
        this.block = this.policyObj.getCache(this.req, this.specifiedName, this.getParentSectionCounter());
        this.printInfo(true);
        this.policyObj.markupBegin(this.pc.getServletContext(), this.req, (Writer)this.pc.getOut(), this.specifiedName, this.getParentSectionCounter());
        if (!this.policyObj.isRecent(this.block)) {
            this.executeBody = true;
            return 2;
        }
        this.executeBody = false;
        try {
            this.pc.getOut().print(this.block.getData());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return 0;
    }

    public void setBodyContent(BodyContent b) {
        this.body = b;
    }

    public void doInitBody() throws JspTagException {
    }

    public int doAfterBody() throws JspTagException {
        return 0;
    }

    public int doEndTag() throws JspTagException {
        if (this.executeBody) {
            if (this.block == null) {
                this.policyObj.putCache(this.body, this.req, this.specifiedName, this.getParentSectionCounter());
            }
            try {
                this.body.getEnclosingWriter().print(this.body.getString());
            }
            catch (IOException ioe) {
                throw new JspTagException(MessageFormat.format(msgs.getString("cannot_write"), ioe));
            }
        }
        this.policyObj.markupEnd(this.pc.getServletContext(), this.req, (Writer)this.pc.getOut(), this.specifiedName, this.getParentSectionCounter());
        this.printInfo(false);
        this.getParentSectionCounter().inc();
        return 6;
    }

    public void release() {
        super.release();
        this.body = null;
    }
}

