/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.jwcache.tagext;

import java.io.IOException;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import oracle.jsp.jwcache.CacheBlock;
import oracle.jsp.jwcache.tagext.CachePolicyTagBase;

public class CachePolicyActionTagBase
extends CachePolicyTagBase {
    protected boolean invalidateCache = false;
    protected String specifiedName = null;
    protected boolean printCacheBlockInfo = false;
    protected boolean printCachePolicy = false;
    protected CacheBlock block = null;
    protected HttpServletRequest req = null;
    protected boolean executeBody = false;
    public static final String COMMENT_OPEN = "<!-- oracle_jwcache";
    public static final String COMMENT_CLOSE = "oracle_jwcache -->";

    protected void printInfo(boolean start) {
        if (!this.printCachePolicy && !this.printCacheBlockInfo) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(COMMENT_OPEN);
        sb.append(' ');
        if (start) {
            sb.append("cache_start:");
            sb.append('\n');
        } else {
            sb.append("cache_end:");
            sb.append('\n');
        }
        sb.append(this.policyObj.getDebugCacheName(this.req, this.specifiedName, this.getParentSectionCounter()));
        if (start) {
            if (this.printCacheBlockInfo && this.block != null) {
                Date creationDate = new Date(this.block.getCreationTime());
                Date expirationDate = new Date(this.block.getExpirationTime());
                sb.append("<cache_block_info>\n");
                sb.append("  <creation_time>");
                sb.append(creationDate);
                sb.append("</creation_time>\n");
                sb.append("  <expiration_time>");
                sb.append(expirationDate);
                sb.append("</expiration_time>\n");
                sb.append("</cache_block_info>\n");
            }
            if (this.printCachePolicy) {
                sb.append(this.toString());
                sb.append('\n');
            }
        }
        sb.append(COMMENT_CLOSE);
        try {
            this.pc.getOut().print((Object)sb);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setInvalidateCache(boolean invalidateCache) {
        this.invalidateCache = invalidateCache;
    }

    public void setName(String specifiedName) {
        this.specifiedName = specifiedName;
    }

    public void setPrintCacheBlockInfo(boolean printCacheBlockInfo) {
        this.printCacheBlockInfo = printCacheBlockInfo;
    }

    public void setPrintCachePolicy(boolean printCachePolicy) {
        this.printCachePolicy = printCachePolicy;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("<cacheTagInfo>\n");
        sb.append("  <invalidateCache>");
        sb.append(this.invalidateCache);
        sb.append("</invalidateCache>");
        sb.append("\n");
        sb.append("  <name>");
        sb.append(this.specifiedName);
        sb.append("</name>");
        sb.append("\n");
        sb.append("</cacheTagInfo>\n");
        sb.append(this.policyObj);
        return new String(sb);
    }

    public void release() {
        super.release();
        this.invalidateCache = false;
        this.specifiedName = null;
        this.printCacheBlockInfo = false;
        this.printCachePolicy = false;
        this.block = null;
        this.req = null;
        this.executeBody = false;
    }
}

