/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.jwcache.repository.impl;

import java.io.Serializable;
import java.util.Date;
import oracle.ias.cache.Attributes;
import oracle.ias.cache.CacheAccess;
import oracle.ias.cache.CacheException;
import oracle.ias.cache.InvalidArgumentException;
import oracle.ias.cache.ObjectExistsException;
import oracle.ias.cache.ObjectNotFoundException;
import oracle.jsp.jwcache.CacheBlock;
import oracle.jsp.jwcache.CacheConfig;
import oracle.jsp.jwcache.ExpirationPolicy;
import oracle.jsp.jwcache.impl.CacheOCSUtil;
import oracle.jsp.jwcache.repository.CacheRepository;
import oracle.jsp.jwcache.repository.CacheRepositoryException;
import oracle.jsp.jwcache.repository.impl.RepoImplUtil;

public class OCSRepoImpl
implements CacheRepository {
    public static final String REGION_NAME = "oracle.jsp.jwcache";
    public static final String ROOT_GROUP = "oracle.jsp.jwcache.root";
    private Attributes groupAttr = null;
    private boolean distributed = true;

    public void init(CacheConfig cacheConfig) throws CacheRepositoryException {
        CacheAccess cAccess;
        try {
            CacheOCSUtil.initOCS(cacheConfig.getServletConfig());
            this.groupAttr = this.genAttributes();
        }
        catch (Exception e) {
            throw new CacheRepositoryException(e);
        }
        String distributedFlag = cacheConfig.getInitParameter("distributed");
        if (distributedFlag != null) {
            this.distributed = distributedFlag.equals("true");
        }
        try {
            CacheAccess.defineRegion((String)REGION_NAME, (Attributes)this.groupAttr);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            cAccess = this.getCacheAccess();
        }
        catch (CacheException ce) {
            throw new CacheRepositoryException(ce);
        }
        try {
            if (!cAccess.isPresent((Object)ROOT_GROUP)) {
                cAccess.defineGroup(ROOT_GROUP, this.groupAttr);
            }
        }
        catch (CacheException ce) {
            throw new CacheRepositoryException(ce);
        }
    }

    private CacheAccess getCacheAccess() throws CacheException {
        CacheAccess cAccess = CacheAccess.getAccess((String)REGION_NAME);
        return cAccess;
    }

    public void destroy() {
    }

    private void defineObject(CacheAccess cAccess, String cacheName, String parentGroup, Attributes attr) {
        try {
            cAccess.defineObject((Object)cacheName, parentGroup, attr);
        }
        catch (CacheException ce) {
            // empty catch block
        }
    }

    private Attributes genAttributes(long ttl_second) throws InvalidArgumentException {
        Attributes attr = new Attributes();
        attr.setTimeToLive(ttl_second);
        if (this.distributed) {
            attr.setFlags(9L);
        } else {
            attr.setFlags(8L);
        }
        return attr;
    }

    private Attributes genAttributes() throws InvalidArgumentException {
        Attributes attr = new Attributes();
        if (this.distributed) {
            attr.setFlags(9L);
        } else {
            attr.setFlags(8L);
        }
        return attr;
    }

    private void resetAttributes(CacheAccess cAccess, String cacheName, Attributes newAttr) throws CacheException {
        if (cAccess.getAttributes((Object)cacheName).getTimeToLive() != newAttr.getTimeToLive()) {
            cAccess.resetAttributes((Object)cacheName, newAttr);
        }
    }

    public void putCache(String[] name, Serializable cacheTarget, ExpirationPolicy expirationPolicy) throws CacheRepositoryException {
        try {
            CacheAccess cAccess = this.getCacheAccess();
            String cacheName = RepoImplUtil.concatName(name);
            long creationTime = this.getCurrentTime().getTime();
            long expirationTime = expirationPolicy.getExpirationTime(creationTime);
            Attributes attr = this.genAttributes((expirationTime - creationTime) / 1000L);
            String parentGroup = this.createGroups(cAccess, name);
            cacheTarget = (Serializable)RepoImplUtil.cloneObjIfNeeded(cacheTarget);
            CacheBlock cBlock = new CacheBlock(creationTime, expirationTime, cacheTarget);
            this.defineObject(cAccess, cacheName, parentGroup, attr);
            cAccess.replace((Object)cacheName, parentGroup, (Object)cBlock);
            this.resetAttributes(cAccess, cacheName, attr);
            if (expirationPolicy.getWriteThrough()) {
                cAccess.save((Object)cacheName);
            }
        }
        catch (InvalidArgumentException iae) {
            throw new CacheRepositoryException(iae);
        }
        catch (CacheException ce) {
            throw new CacheRepositoryException(ce);
        }
    }

    public CacheBlock getCache(String[] name) throws CacheRepositoryException {
        try {
            CacheAccess cAccess = this.getCacheAccess();
            String cacheName = RepoImplUtil.concatName(name);
            String parentGroup = this.createGroups(cAccess, name);
            try {
                this.defineObject(cAccess, cacheName, parentGroup, this.genAttributes());
                CacheBlock cb = (CacheBlock)cAccess.get((Object)cacheName, parentGroup, null);
                cb = RepoImplUtil.cloneCacheBlockIfNeeded(cb);
                long ttl_second = (cb.getExpirationTime() - cb.getCreationTime()) / 1000L;
                this.resetAttributes(cAccess, cacheName, this.genAttributes(ttl_second));
                if (cb.getExpirationTime() < this.getCurrentTime().getTime()) {
                    return null;
                }
                return cb;
            }
            catch (ObjectNotFoundException onfe) {
                return null;
            }
        }
        catch (CacheException ce) {
            throw new CacheRepositoryException(ce);
        }
    }

    public void invalidateCache(String[] name) throws CacheRepositoryException {
        try {
            CacheAccess cAccess = this.getCacheAccess();
            String cacheName = RepoImplUtil.concatName(name);
            cAccess.invalidate((Object)cacheName);
        }
        catch (CacheException ce) {
            throw new CacheRepositoryException(ce);
        }
    }

    public void invalidateCacheLike(String[] name) throws CacheRepositoryException {
        String[] matchedNamePart = RepoImplUtil.handleWildcard(name);
        String groupName = this.genGroupName(matchedNamePart);
        try {
            CacheAccess cAccess = this.getCacheAccess();
            cAccess.invalidate((Object)groupName);
        }
        catch (CacheException ce) {
            throw new CacheRepositoryException(ce);
        }
    }

    public void cleanExpiredCache() throws CacheRepositoryException {
    }

    public Date getCurrentTime() {
        return new Date();
    }

    private String genGroupName(String[] name) {
        StringBuffer sb = new StringBuffer();
        String lastGroup = ROOT_GROUP;
        String curGroup = null;
        for (int i = 0; i < name.length; ++i) {
            sb.append(name[i]);
            lastGroup = curGroup = new String(sb);
            sb.append(' ');
        }
        return lastGroup;
    }

    private String createGroups(CacheAccess cAccess, String[] name) throws CacheRepositoryException {
        StringBuffer sb = new StringBuffer();
        String lastGroup = ROOT_GROUP;
        String curGroup = null;
        for (int i = 0; i < name.length - 1; ++i) {
            sb.append(name[i]);
            curGroup = new String(sb);
            try {
                if (!cAccess.isPresent((Object)curGroup)) {
                    cAccess.defineGroup(curGroup, lastGroup, this.groupAttr);
                }
            }
            catch (ObjectExistsException oee) {
            }
            catch (CacheException ce) {
                throw new CacheRepositoryException(ce);
            }
            lastGroup = curGroup;
            sb.append(' ');
        }
        return lastGroup;
    }
}

