/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.jwcache.repository.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ResourceBundle;
import oracle.jsp.jwcache.CloneableCacheObj;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLParseException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class DOMCacheWrapper
implements Serializable,
CloneableCacheObj {
    private static final String MSG_FILE = "oracle.jsp.jwcache.repository.impl.LocalStrings";
    private static ResourceBundle msgs = ResourceBundle.getBundle("oracle.jsp.jwcache.repository.impl.LocalStrings");
    private transient Document domObj;

    protected DOMCacheWrapper() {
    }

    public DOMCacheWrapper(Document domObj) {
        this.domObj = domObj;
    }

    public Document getDocument() {
        return this.domObj;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (this.domObj != null) {
            if (!(this.domObj instanceof XMLDocument)) {
                throw new IllegalStateException(msgs.getString("cannot_serialize"));
            }
        } else {
            throw new IllegalStateException(msgs.getString("DOM_not_initialized"));
        }
        XMLDocument oxDoc = (XMLDocument)this.domObj;
        oxDoc.print((OutputStream)out);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        DOMParser parser = new DOMParser();
        try {
            parser.parse((InputStream)in);
            this.domObj = parser.getDocument();
        }
        catch (XMLParseException xpe) {
            throw new IOException(xpe.toString());
        }
        catch (SAXException saxe) {
            throw new IOException(saxe.toString());
        }
    }

    public DOMCacheWrapper completeCopy() {
        Document doc2 = (Document)this.domObj.cloneNode(true);
        return new DOMCacheWrapper(doc2);
    }

    public Object cloneCacheObj() {
        return this.completeCopy();
    }
}

