/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.jwcache.impl;

import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import oracle.ias.cache.Attributes;
import oracle.ias.cache.Cache;
import oracle.ias.cache.CacheAccess;
import oracle.ias.cache.CacheAttributes;
import oracle.ias.cache.CacheException;
import oracle.ias.cache.InvalidArgumentException;
import oracle.ias.cache.ObjectNotFoundException;
import oracle.jsp.jwcache.CachePolicy;
import oracle.jsp.jwcache.CachePolicyLoadingException;
import oracle.jsp.jwcache.impl.CacheCommonUtil;
import oracle.jsp.jwcache.impl.CacheConfigFileUtil;

public class CacheOCSUtil {
    private static final String MSG_FILE = "oracle.jsp.jwcache.impl.LocalStrings";
    private static ResourceBundle msgs = ResourceBundle.getBundle("oracle.jsp.jwcache.impl.LocalStrings");
    private static boolean INITED_OCS = false;
    private static final String OCS_POLICIES_REGION = "oracle.jsp.jwcache.CachePolicy.REGION";

    public static void initOCS(ServletConfig config) throws CacheException {
        if (!INITED_OCS) {
            String ocs4j_file = CacheCommonUtil.getAppConfigInitParameter(config, "ocs4j_file");
            config.getServletContext().log("ocs4j_file:" + ocs4j_file);
            if (ocs4j_file == null) {
                CacheAttributes cattr = new CacheAttributes();
                cattr.distribute = true;
                Cache.init((CacheAttributes)cattr);
            } else {
                Cache.open((String)ocs4j_file);
            }
            Cache.setLogSeverity((int)-1);
            INITED_OCS = true;
        }
    }

    protected static boolean isPolicyInOCS(ServletConfig config) {
        String ocsFlag = CacheCommonUtil.getAppConfigInitParameter(config, "cache_policy_in_ocs");
        if (ocsFlag == null) {
            return System.getProperty("oracle.jserver.version") == null;
        }
        return Boolean.valueOf(ocsFlag);
    }

    private static Attributes genAttributes(long ttl_second) throws InvalidArgumentException {
        Attributes attr = new Attributes();
        attr.setTimeToLive(ttl_second);
        attr.setFlags(9L);
        return attr;
    }

    private static CacheAccess getPolicyOCSAccess(ServletConfig config) throws CachePolicyLoadingException {
        try {
            CacheOCSUtil.initOCS(config);
        }
        catch (Exception e) {
            throw new CachePolicyLoadingException(e);
        }
        try {
            CacheAccess.defineRegion((String)OCS_POLICIES_REGION);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            CacheAccess cAccess = CacheAccess.getAccess((String)OCS_POLICIES_REGION);
            if (!cAccess.isPresent((Object)"oracle.jsp.jwcache.cachepolicies")) {
                Attributes groupAttr = CacheOCSUtil.genAttributes(3600L);
                cAccess.defineGroup("oracle.jsp.jwcache.cachepolicies", groupAttr);
            }
            return cAccess;
        }
        catch (CacheException ce) {
            throw new CachePolicyLoadingException(ce);
        }
    }

    private static String genPolicyNameForOCS(HttpServletRequest req, String name) {
        return "oracle.jsp.jwcache.cachepolicies:" + req.getServerName() + ":" + req.getServerPort() + "/" + CacheCommonUtil.getContextPath(req) + name;
    }

    protected static CachePolicy lookupPolicyOCS(ServletConfig config, HttpServletRequest req, String name) throws CachePolicyLoadingException {
        CacheAccess cAccess = CacheOCSUtil.getPolicyOCSAccess(config);
        String policyName = CacheOCSUtil.genPolicyNameForOCS(req, name);
        Attributes attr = null;
        try {
            attr = CacheOCSUtil.genAttributes(3600L);
        }
        catch (InvalidArgumentException iae) {
            config.getServletContext().log("lookupPolicyOCS:InvalidArgumentException" + (Object)((Object)iae));
        }
        CachePolicy policy = null;
        try {
            try {
                policy = (CachePolicy)cAccess.get((Object)policyName, "oracle.jsp.jwcache.cachepolicies", (Object)attr);
                return new CachePolicy(config, policy);
            }
            catch (ObjectNotFoundException onfe) {
                try {
                    policy = CacheConfigFileUtil.loadCachePolicy(config, name);
                }
                catch (Exception e) {
                    e.printStackTrace(System.out);
                    throw new CachePolicyLoadingException(MessageFormat.format(msgs.getString("cannot_load_policy"), name), e);
                }
                try {
                    cAccess.defineObject((Object)policyName, "oracle.jsp.jwcache.cachepolicies", attr);
                }
                catch (CacheException ce) {
                    // empty catch block
                }
                cAccess.replace((Object)policyName, "oracle.jsp.jwcache.cachepolicies", (Object)policy);
                return new CachePolicy(policy);
            }
        }
        catch (CacheException ce) {
            throw new CachePolicyLoadingException(ce);
        }
    }

    protected static CachePolicy refreshPolicyOCS(ServletConfig config, HttpServletRequest req, String name) throws CachePolicyLoadingException {
        CacheAccess cAccess = CacheOCSUtil.getPolicyOCSAccess(config);
        String policyName = CacheOCSUtil.genPolicyNameForOCS(req, name);
        CachePolicy policy = null;
        try {
            try {
                policy = CacheConfigFileUtil.loadCachePolicy(config, name);
            }
            catch (Exception e) {
                throw new CachePolicyLoadingException(MessageFormat.format(msgs.getString("cannot_load_policy"), name), e);
            }
            cAccess.replace((Object)policyName, "oracle.jsp.jwcache.cachepolicies", (Object)policy);
            return new CachePolicy(policy);
        }
        catch (CacheException ce) {
            throw new CachePolicyLoadingException(ce);
        }
    }
}

