/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.jwcache;

import java.io.Serializable;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.ResourceBundle;
import oracle.jsp.jwcache.CachePolicy;
import oracle.jsp.jwcache.impl.CacheCommonUtil;

public class ExpirationPolicy
implements Serializable {
    private int type;
    private long ttl;
    private long timeInaDay;
    private int dayInaWeek;
    private int dayInaMonth;
    private boolean writeThrough;
    protected CachePolicy cachePolicyObj;
    public static final int TYPE_TTL = 0;
    public static final int TYPE_DAILY = 1;
    public static final int TYPE_WEEKLY = 2;
    public static final int TYPE_MONTHLY = 3;
    public static final String[] TYPE_STRS = new String[]{"TTL", "daily", "weekly", "monthly"};
    public static final int WEEKLY_SUNDAY = 0;
    public static final int WEEKLY_MONDAY = 1;
    public static final int WEEKLY_TUESDAY = 2;
    public static final int WEEKLY_WEDNESDAY = 3;
    public static final int WEEKLY_THURSDAY = 4;
    public static final int WEEKLY_FRIDAY = 5;
    public static final int WEEKLY_SATURDAY = 6;
    public static final String[] WEEKLY_STRS = new String[]{"Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"};
    private static final String MSG_FILE = "oracle.jsp.jwcache.LocalStrings";
    private static ResourceBundle msgs = ResourceBundle.getBundle("oracle.jsp.jwcache.LocalStrings");
    private SimpleDateFormat time_format = new SimpleDateFormat("hh:mm:ss");
    private long MAX_TIME_IN_A_DAY = 86400L;

    public ExpirationPolicy() {
        this(0, 300L, 300L, 3, 10, true);
    }

    public ExpirationPolicy(ExpirationPolicy expPolicy) {
        this.type = expPolicy.type;
        this.ttl = expPolicy.ttl;
        this.timeInaDay = expPolicy.timeInaDay;
        this.dayInaWeek = expPolicy.dayInaWeek;
        this.dayInaMonth = expPolicy.dayInaMonth;
        this.writeThrough = expPolicy.writeThrough;
        this.cachePolicyObj = expPolicy.cachePolicyObj;
    }

    public ExpirationPolicy(int type, long ttl, long timeInaDay, int dayInaWeek, int dayInaMonth, boolean writeThrough) {
        this.setExpirationType(type);
        this.setTTL(ttl);
        this.setTimeInaDay(timeInaDay);
        this.setDayInaWeek(dayInaWeek);
        this.setDayInaMonth(dayInaMonth);
        this.setWriteThrough(writeThrough);
    }

    private void setAttrChanged() {
        if (this.cachePolicyObj != null) {
            this.cachePolicyObj.setAttrChanged();
        }
    }

    public int getExpirationType() {
        return this.type;
    }

    public void setExpirationType(int type) {
        if (type < 0 || type > 3) {
            throw new IllegalArgumentException(MessageFormat.format(msgs.getString("undefined_expire_type"), new Integer(type)));
        }
        this.type = type;
        this.setAttrChanged();
    }

    public void setExpirationType(String s) {
        for (int i = 0; i < TYPE_STRS.length; ++i) {
            if (!TYPE_STRS[i].equalsIgnoreCase(s)) continue;
            this.setExpirationType(i);
            return;
        }
        throw new IllegalArgumentException(MessageFormat.format(msgs.getString("illegal_expiration_policy"), s));
    }

    public long getTTL() {
        return this.ttl;
    }

    public void setTTL(long ttl) {
        if (ttl < 0L) {
            throw new IllegalArgumentException(msgs.getString("negative_ttl"));
        }
        this.ttl = ttl;
        this.setAttrChanged();
    }

    public long getTimeInaDay() {
        return this.timeInaDay;
    }

    public void setTimeInaDay(long timeInaDay) {
        if (timeInaDay < 0L || timeInaDay > this.MAX_TIME_IN_A_DAY) {
            throw new IllegalArgumentException(MessageFormat.format(msgs.getString("invalid_range"), "timeInaDay", Long.toString(timeInaDay)));
        }
        this.timeInaDay = timeInaDay;
        this.setAttrChanged();
    }

    public void setTimeInaDay(String s) throws ParseException {
        Date d = null;
        Date midnite_d = null;
        midnite_d = this.time_format.parse("00:00:00");
        d = this.time_format.parse(s);
        long elapse = (d.getTime() - midnite_d.getTime()) / 1000L;
        this.setTimeInaDay(elapse);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("  <expirationPolicy\n");
        sb.append("    expirationType=\"");
        sb.append(TYPE_STRS[this.type]);
        sb.append("\"\n");
        sb.append("    TTL=\"");
        sb.append(this.ttl);
        sb.append("\"\n");
        sb.append("    timeInaDay=\"");
        sb.append(this.timeInaDay);
        sb.append("\"\n");
        sb.append("    dayInaWeek=\"");
        sb.append(this.dayInaWeek);
        sb.append("\"\n");
        sb.append("    dayInaMonth=\"");
        sb.append(this.dayInaMonth);
        sb.append("\"\n");
        sb.append("    writeThrough=\"");
        sb.append(this.writeThrough);
        sb.append("\"\n");
        sb.append("  >");
        return new String(sb);
    }

    public int getDayInaWeek() {
        return this.dayInaWeek;
    }

    public void setDayInaWeek(int dayInaWeek) {
        if (dayInaWeek < 0 || dayInaWeek > 6) {
            throw new IllegalArgumentException(MessageFormat.format(msgs.getString("invalid_range"), "dayInaWeek", new Integer(dayInaWeek)));
        }
        this.dayInaWeek = dayInaWeek;
        this.setAttrChanged();
    }

    public void setDayInaWeek(String s) {
        for (int i = 0; i < WEEKLY_STRS.length; ++i) {
            if (!WEEKLY_STRS[i].equalsIgnoreCase(s)) continue;
            this.setDayInaWeek(i);
            return;
        }
        throw new IllegalArgumentException(MessageFormat.format(msgs.getString("illegal_weekday"), s));
    }

    public int getDayInaMonth() {
        return this.dayInaMonth;
    }

    public void setDayInaMonth(int dayInaMonth) {
        if (dayInaMonth < 0 || dayInaMonth > 31) {
            throw new IllegalArgumentException(MessageFormat.format(msgs.getString("invalid_range"), "dayInaMonth", Long.toString(dayInaMonth)));
        }
        this.dayInaMonth = dayInaMonth;
        this.setAttrChanged();
    }

    public boolean getWriteThrough() {
        return this.writeThrough;
    }

    public void setWriteThrough(boolean writeThrough) {
        this.writeThrough = writeThrough;
        this.setAttrChanged();
    }

    public void setWriteThrough(String v) {
        this.setWriteThrough(CacheCommonUtil.strToBoolean(v));
    }

    public long getExpirationTime(long cur) {
        switch (this.type) {
            case 0: {
                return cur + this.ttl * 1000L;
            }
            case 1: {
                GregorianCalendar gregCal = new GregorianCalendar();
                gregCal.setTime(new Date(cur));
                ExpirationPolicy.setCalTimeInaDay(this.timeInaDay, gregCal);
                if (gregCal.getTime().getTime() <= cur) {
                    gregCal.add(5, 1);
                }
                return gregCal.getTime().getTime();
            }
            case 2: {
                GregorianCalendar gregCal = new GregorianCalendar();
                gregCal.setTime(new Date(cur));
                switch (this.dayInaWeek) {
                    case 0: {
                        gregCal.set(7, 1);
                        break;
                    }
                    case 1: {
                        gregCal.set(7, 2);
                        break;
                    }
                    case 2: {
                        gregCal.set(7, 3);
                        break;
                    }
                    case 3: {
                        gregCal.set(7, 4);
                        break;
                    }
                    case 4: {
                        gregCal.set(7, 5);
                        break;
                    }
                    case 5: {
                        gregCal.set(7, 6);
                        break;
                    }
                    case 6: {
                        gregCal.set(7, 7);
                    }
                }
                ExpirationPolicy.setCalTimeInaDay(this.timeInaDay, gregCal);
                if (gregCal.getTime().getTime() <= cur) {
                    gregCal.add(5, 7);
                }
                return gregCal.getTime().getTime();
            }
            case 3: {
                GregorianCalendar gregCal = new GregorianCalendar();
                gregCal.setTime(new Date(cur));
                ExpirationPolicy.setCalTimeInaDay(this.timeInaDay, gregCal);
                gregCal.set(5, this.dayInaMonth);
                if (this.dayInaMonth != gregCal.get(5)) {
                    gregCal.set(5, 1);
                    gregCal.add(5, -1);
                }
                if (gregCal.getTime().getTime() <= cur) {
                    gregCal.add(2, 1);
                    if (this.dayInaMonth != gregCal.get(5)) {
                        gregCal.set(5, this.dayInaMonth);
                        if (this.dayInaMonth != gregCal.get(5)) {
                            gregCal.set(5, 1);
                            gregCal.add(5, -1);
                        }
                    }
                }
                return gregCal.getTime().getTime();
            }
        }
        throw new IllegalStateException(MessageFormat.format(msgs.getString("undefined_expire_type"), new Integer(this.type)));
    }

    private static void setCalTimeInaDay(long timeInaDay, Calendar cal) {
        long second = timeInaDay % 60L;
        long minute = timeInaDay / 60L;
        long hour_of_day = minute / 60L;
        cal.set(11, (int)hour_of_day);
        cal.set(12, (int)(minute %= 60L));
        cal.set(13, (int)second);
    }
}

