/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.dbutil.tagext;

import java.util.ResourceBundle;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.TagSupport;
import oracle.jsp.webutil.tagutil.TagUtil;

public class dbSetCookieTag
extends TagSupport {
    private String name;
    private String value;
    private String domain;
    private String version;
    private String comment;
    private String maxAge;
    private String path;
    private String secure;
    private static final String MSG_FILE = "oracle.jsp.dbutil.tagext.LocalStrings";
    private static ResourceBundle msgs = ResourceBundle.getBundle("oracle.jsp.dbutil.tagext.LocalStrings");

    public dbSetCookieTag() {
        this.resetAttr();
    }

    public int doStartTag() throws JspTagException {
        if (this.name == null || "".equals(this.name.trim())) {
            throw new JspTagException(msgs.getString("cookie_null"));
        }
        Cookie c = new Cookie(this.name, this.value);
        if (this.maxAge != null) {
            try {
                c.setMaxAge(Integer.parseInt(this.maxAge.trim()));
            }
            catch (Exception e) {
                throw new JspTagException(msgs.getString("age_wrong") + " " + this.maxAge);
            }
        }
        if (this.version != null) {
            try {
                c.setVersion(Integer.parseInt(this.version.trim()));
            }
            catch (Exception e) {
                throw new JspTagException(msgs.getString("version_wrong") + " " + this.version);
            }
        }
        if (this.secure != null) {
            this.secure = this.secure.trim();
            if ("true".equalsIgnoreCase(this.secure)) {
                c.setSecure(true);
            } else if ("false".equalsIgnoreCase(this.secure)) {
                c.setSecure(false);
            } else {
                throw new JspTagException(msgs.getString("flag_wrong") + " " + this.secure);
            }
        }
        if (this.comment != null) {
            c.setComment(this.comment);
        }
        if (this.path != null) {
            c.setPath(this.path);
        }
        if (this.domain != null) {
            c.setDomain(this.domain);
        }
        ((HttpServletResponse)this.pageContext.getResponse()).addCookie(c);
        return 1;
    }

    public int doEndTag() throws JspException {
        this.resetAttr();
        return 6;
    }

    public void release() {
        this.resetAttr();
    }

    public void setDomain(String s) throws JspTagException {
        TagUtil.validateString(s, "domain");
        this.domain = s;
    }

    public void setName(String s) throws JspTagException {
        TagUtil.validateString(s, "name");
        this.name = s;
    }

    public void setValue(String s) throws JspTagException {
        TagUtil.validateString(s, "value");
        this.value = s;
    }

    public void setVersion(String s) throws JspTagException {
        TagUtil.validateString(s, "version");
        this.version = s;
    }

    public void setComment(String s) throws JspTagException {
        TagUtil.validateString(s, "comment");
        this.comment = s;
    }

    public void setMaxAge(String s) throws JspTagException {
        TagUtil.validateString(s, "maxAge");
        this.maxAge = s;
    }

    public void setPath(String s) throws JspTagException {
        TagUtil.validateString(s, "path");
        this.path = s;
    }

    public void setSecure(String s) throws JspTagException {
        TagUtil.validateString(s, "secure");
        this.secure = s;
    }

    private void resetAttr() {
        this.name = null;
        this.value = null;
        this.domain = null;
        this.version = null;
        this.comment = null;
        this.maxAge = null;
        this.path = null;
        this.secure = null;
    }
}

