/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.dbutil.tagext;

import java.sql.ResultSet;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.BodyContent;
import javax.servlet.jsp.tagext.BodyTagSupport;
import javax.servlet.jsp.tagext.Tag;
import oracle.jsp.dbutil.ConnBean;
import oracle.jsp.dbutil.CursorBean;
import oracle.jsp.dbutil.tagext.dbOpenTag;
import oracle.jsp.webutil.tagutil.TagUtil;
import oracle.xml.parser.v2.XMLDocument;

public class dbQueryTag
extends BodyTagSupport {
    CursorBean cursor;
    ResultSet result;
    static final String S_PREFIX = "Oracle.JSP.Query.MaxRows";
    private String qid;
    private ConnBean cb;
    private String cid;
    private String scope;
    private BodyContent bodyContent;
    private String bindParams;
    private String toXMLObjName;
    private boolean got_bodyContent;
    private String outputType;
    private static final String MSG_FILE = "oracle.jsp.dbutil.tagext.LocalStrings";
    private static ResourceBundle msgs = ResourceBundle.getBundle("oracle.jsp.dbutil.tagext.LocalStrings");

    public dbQueryTag() {
        this.resetAttr();
    }

    public int doStartTag() throws JspTagException {
        this.newCursorBean();
        if (this.cid != null) {
            if (this.scope == null || this.scope.equals("page")) {
                this.cb = (ConnBean)this.pageContext.getAttribute(this.cid);
            } else if (this.scope.equals("request")) {
                this.cb = (ConnBean)this.pageContext.getAttribute(this.cid, 2);
            } else if (this.scope.equals("session")) {
                this.cb = (ConnBean)this.pageContext.getAttribute(this.cid, 3);
            } else if (this.scope.equals("application")) {
                this.cb = (ConnBean)this.pageContext.getAttribute(this.cid, 4);
            }
            if (this.cb == null) {
                throw new JspTagException(MessageFormat.format(msgs.getString("connid_not_found"), this.cid, this.scope));
            }
        } else {
            dbOpenTag tag = (dbOpenTag)dbQueryTag.findAncestorWithClass((Tag)this, (Class)dbOpenTag.class);
            if (tag == null) {
                throw new JspTagException(msgs.getString("not_nested"));
            }
            this.cb = tag.getConnBean();
        }
        if (this.cb == null) {
            throw new JspTagException(msgs.getString("conn_not_found"));
        }
        try {
            this.cb.connect();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 2;
    }

    public int doAfterBody() throws JspTagException {
        if (!this.got_bodyContent) {
            this.processBodyContent();
        }
        return 6;
    }

    public void processBodyContent() throws JspTagException {
        BodyContent body = this.getBodyContent();
        String query = body.getString().trim();
        int i = query.indexOf(":dbNext");
        if (i != -1) {
            query = query.substring(0, i);
            i = query.lastIndexOf("<");
            query = query.substring(0, i - 1);
        }
        body.clearBody();
        try {
            query = dbQueryTag.resolveQueryParams(query, this.pageContext);
            Vector varValues = dbQueryTag.resolveVariables(this.bindParams, this.pageContext);
            if (varValues == null || varValues.size() == 0) {
                this.cursor.create(this.cb);
            } else {
                this.cursor.create(this.cb, 1, query);
                for (i = 0; i < varValues.size(); ++i) {
                    String value = (String)varValues.elementAt(i);
                    if (value == null) {
                        this.cursor.setNull(i + 1, 12);
                        continue;
                    }
                    this.cursor.setString(i + 1, value);
                }
            }
            JspWriter out = body.getEnclosingWriter();
            if (this.outputType.equalsIgnoreCase("HTML")) {
                out.println(this.cursor.getResultAsHTMLTable(query));
            } else if (this.outputType.equalsIgnoreCase("XML")) {
                XMLDocument doc = (XMLDocument)this.cursor.getResultAsXMLDocument(query);
                TagUtil.setToXMLObj((Tag)this, doc);
                if (this.toXMLObjName != null) {
                    this.pageContext.setAttribute(this.toXMLObjName, (Object)doc);
                }
                out.println(this.cursor.getResultAsXMLString(query));
            } else {
                this.result = this.cursor.executeQuery(query);
            }
        }
        catch (Exception ex) {
            throw new JspTagException(ex.toString());
        }
        this.got_bodyContent = true;
    }

    public int doEndTag() {
        if (this.outputType.equalsIgnoreCase("JDBC") && this.getQueryId() != null) {
            this.pageContext.setAttribute(this.getQueryId(), (Object)this.result);
            this.pageContext.setAttribute(S_PREFIX + this.getQueryId(), (Object)new Integer(this.cursor.getMaxRows()));
        } else {
            this.release();
        }
        return 6;
    }

    public void release() {
        try {
            if (this.getQueryId() == null) {
                this.cursor.close();
            }
            this.resetAttr();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setConnId(String s) throws JspException {
        TagUtil.validateString(s, "connId");
        this.cid = s;
    }

    public void setScope(String s) throws JspTagException {
        TagUtil.validateString(s, "scope");
        String temp = s.toLowerCase();
        if (!(temp.equals("page") || temp.equals("request") || temp.equals("session") || temp.equals("application"))) {
            throw new JspTagException(MessageFormat.format(msgs.getString("invalid_scope"), s));
        }
        this.scope = temp;
    }

    public void setMaxRows(String s) throws JspTagException {
        TagUtil.validateString(s, "maxRows");
        this.newCursorBean();
        try {
            this.cursor.setMaxRows(Integer.parseInt(s));
        }
        catch (Exception e) {
            throw new JspTagException(MessageFormat.format(msgs.getString("invalid_Rows"), "maxRows"));
        }
    }

    public void setSkipRows(String s) throws JspTagException {
        TagUtil.validateString(s, "skipRows");
        this.newCursorBean();
        try {
            this.cursor.setSkipRows(Integer.parseInt(s));
        }
        catch (Exception e) {
            throw new JspTagException(MessageFormat.format(msgs.getString("invalid_Rows"), "skipRows"));
        }
    }

    public void setBindParams(String s) throws JspTagException {
        TagUtil.validateString(s, "bindParams");
        this.bindParams = s;
    }

    public void setToXMLObjName(String s) throws JspTagException {
        TagUtil.validateString(s, "toXMLObject");
        this.toXMLObjName = s;
    }

    public void setOutput(String s) throws JspTagException {
        TagUtil.validateString(s, "output");
        this.outputType = s;
    }

    public void setQueryId(String s) throws JspTagException {
        TagUtil.validateString(s, "queryId");
        this.qid = s;
    }

    public String getConnId() {
        return this.cid;
    }

    public String getScope() {
        return this.scope;
    }

    public String getBindParams() {
        return this.bindParams;
    }

    public String getToXMLObjName() {
        return this.toXMLObjName;
    }

    public String getOutput() {
        return this.outputType;
    }

    public String getQueryId() {
        return this.qid;
    }

    static String resolveQueryParams(String query, PageContext pageContext) {
        int posStart = 0;
        int posEnd = 0;
        StringBuffer sb = new StringBuffer();
        if (query == null) {
            return null;
        }
        while (true) {
            if ((posStart = query.indexOf("{@")) < 0) {
                sb.append(query);
                break;
            }
            posEnd = query.indexOf("}", posStart);
            if (posEnd < 0) {
                sb.append(query);
                break;
            }
            String varName = query.substring(posStart + 2, posEnd);
            String varValue = dbQueryTag.resolveParam(varName.trim(), pageContext);
            sb.append(query.substring(0, posStart));
            if (varValue != null) {
                sb.append(varValue);
            }
            if (posEnd == query.length() - 1) break;
            query = query.substring(posEnd + 1);
        }
        return sb.toString();
    }

    static int getBindVariableCount(String bindParams) {
        int bvcount = 0;
        if (bindParams != null && !bindParams.equals("")) {
            StringTokenizer st = new StringTokenizer(bindParams);
            while (st.hasMoreTokens()) {
                st.nextToken();
                ++bvcount;
            }
        }
        return bvcount;
    }

    static Vector resolveVariables(String bindParams, PageContext pageContext) {
        Vector<String> values = new Vector<String>();
        if (bindParams != null && !bindParams.equals("")) {
            StringTokenizer st = new StringTokenizer(bindParams);
            while (st.hasMoreTokens()) {
                String varName = st.nextToken();
                values.addElement(dbQueryTag.resolveParam(varName, pageContext));
            }
        }
        return values;
    }

    static String resolveParam(String varName, PageContext pageContext) {
        String value = null;
        try {
            value = pageContext.getRequest().getParameter(varName);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (value != null) {
            return value;
        }
        try {
            HttpServletRequest request = (HttpServletRequest)pageContext.getRequest();
            Cookie[] cookies = request.getCookies();
            for (int i = 0; cookies != null && i < cookies.length; ++i) {
                if (!varName.equals(cookies[i].getName())) continue;
                return cookies[i].getValue();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            value = (String)pageContext.getAttribute(varName, 3);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (value != null) {
            return value;
        }
        try {
            value = (String)pageContext.getAttribute(varName, 1);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (value != null) {
            return value;
        }
        try {
            value = (String)pageContext.getAttribute(varName, 2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value;
    }

    private void newCursorBean() {
        if (this.cursor == null) {
            this.cursor = new CursorBean();
        }
    }

    private void resetAttr() {
        this.cursor = null;
        this.cb = null;
        this.cid = null;
        this.scope = "page";
        this.bodyContent = null;
        this.bindParams = null;
        this.toXMLObjName = null;
        this.result = null;
        this.got_bodyContent = false;
        this.outputType = "HTML";
    }
}

