/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.dbutil.tagext;

import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.TagSupport;
import oracle.jsp.dbutil.ConnBean;
import oracle.jsp.webutil.tagutil.TagUtil;

public class dbOpenTag
extends TagSupport {
    private ConnBean cb;
    private String commitOnClose;
    private String scope;
    private String cid;
    private static final String MSG_FILE = "oracle.jsp.dbutil.tagext.LocalStrings";
    private static ResourceBundle msgs = ResourceBundle.getBundle("oracle.jsp.dbutil.tagext.LocalStrings");

    public dbOpenTag() {
        this.resetAttr();
    }

    public int doStartTag() throws JspTagException {
        this.newConnBean();
        if (this.cb.getDataSource() == null && this.cb.getURL() == null) {
            throw new JspTagException(msgs.getString("datasrc_or_url"));
        }
        if (this.cb.getDataSource() == null) {
            if (this.cb.getUser() == null) {
                throw new JspTagException(msgs.getString("no_uid"));
            }
            if (this.cb.getPassword() == null) {
                throw new JspTagException(msgs.getString("no_pwd"));
            }
        }
        this.setCommitOnCloseValue();
        try {
            this.cb.connect();
        }
        catch (Exception e) {
            throw new JspTagException(msgs.getString("conn_failed"));
        }
        if (this.cid != null) {
            if (this.scope == null || this.scope.equals("page")) {
                this.pageContext.setAttribute(this.cid, (Object)this.cb);
            } else if (this.scope.equals("request")) {
                this.pageContext.setAttribute(this.cid, (Object)this.cb, 2);
            } else if (this.scope.equals("session")) {
                this.pageContext.setAttribute(this.cid, (Object)this.cb, 3);
            } else if (this.scope.equals("application")) {
                this.pageContext.setAttribute(this.cid, (Object)this.cb, 4);
            }
        }
        return 1;
    }

    public int doEndTag() throws JspTagException {
        if (this.cid != null) {
            if (this.cb.getConnection() == null) {
                try {
                    this.cb.connect();
                }
                catch (Exception e) {
                    throw new JspTagException(msgs.getString("conn_failed"));
                }
            }
        } else {
            this.release();
        }
        return 6;
    }

    public void release() {
        try {
            if (this.getConnId() == null) {
                this.cb.close();
            }
            this.resetAttr();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setConnId(String s) throws JspTagException {
        TagUtil.validateString(s, "connId");
        this.cid = s;
    }

    public void setCommitOnClose(String s) throws JspTagException {
        TagUtil.validateString(s, "commitOnClose");
        if (!s.equalsIgnoreCase("true") && !s.equalsIgnoreCase("false")) {
            throw new JspTagException(MessageFormat.format(msgs.getString("invalid_commitOnClose"), s));
        }
        this.commitOnClose = s.toLowerCase();
    }

    public void setUser(String s) throws JspTagException {
        TagUtil.validateString(s, "user");
        this.newConnBean();
        this.cb.setUser(s);
    }

    public void setPassword(String s) throws JspTagException {
        TagUtil.validateString(s, "password");
        this.newConnBean();
        this.cb.setPassword(s);
    }

    public void setURL(String s) throws JspTagException {
        TagUtil.validateString(s, "URL");
        this.newConnBean();
        this.cb.setURL(s);
    }

    public void setDataSource(String s) throws JspTagException {
        TagUtil.validateString(s, "dataSource");
        this.newConnBean();
        this.cb.setDataSource(s);
    }

    public void setScope(String s) throws JspTagException {
        TagUtil.validateString(s, "scope");
        if (s != null && !s.equals("")) {
            String temp = s.toLowerCase();
            if (temp.equals("page") || temp.equals("request") || temp.equals("session") || temp.equals("application")) {
                this.scope = s;
            } else {
                throw new JspTagException(MessageFormat.format(msgs.getString("invalid_scope"), s));
            }
        }
    }

    public String getConnId() {
        return this.cid;
    }

    public String getScope() {
        return this.scope;
    }

    public String getCommitOnClose() {
        return this.commitOnClose;
    }

    public ConnBean getConnBean() {
        return this.cb;
    }

    private void newConnBean() {
        if (this.cb == null) {
            this.cb = new ConnBean();
        }
    }

    private void setCommitOnCloseValue() throws JspTagException {
        if (this.commitOnClose == null) {
            this.commitOnClose = this.pageContext.getServletContext().getInitParameter("commit-on-close");
        }
        if (this.commitOnClose != null) {
            try {
                this.cb.setCommitOnClose(this.commitOnClose);
            }
            catch (IllegalArgumentException e) {
                throw new JspTagException(e.getMessage());
            }
        }
    }

    private void resetAttr() {
        this.cb = null;
        this.commitOnClose = null;
        this.scope = "page";
        this.cid = null;
    }
}

