/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.dbutil.tagext;

import java.io.IOException;
import java.io.Writer;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ResourceBundle;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.BodyContent;
import javax.servlet.jsp.tagext.BodyTagSupport;
import javax.servlet.jsp.tagext.Tag;
import oracle.jsp.dbutil.tagext.dbQueryTag;
import oracle.jsp.webutil.tagutil.TagUtil;

public class dbNextTag
extends BodyTagSupport {
    private String qid;
    private ResultSet result;
    private int maxRows;
    private int count;
    private static final String MSG_FILE = "oracle.jsp.dbutil.tagext.LocalStrings";
    private static ResourceBundle msgs = ResourceBundle.getBundle("oracle.jsp.dbutil.tagext.LocalStrings");

    public dbNextTag() {
        this.resetAttr();
    }

    public int doStartTag() throws JspTagException {
        if (this.qid != null) {
            this.result = (ResultSet)this.pageContext.getAttribute(this.qid);
            Integer nMaxRows = (Integer)this.pageContext.getAttribute("Oracle.JSP.Query.MaxRows" + this.qid);
            if (nMaxRows != null) {
                this.maxRows = nMaxRows;
            }
        } else {
            dbQueryTag tag = (dbQueryTag)dbNextTag.findAncestorWithClass((Tag)this, (Class)dbQueryTag.class);
            if (tag == null) {
                throw new JspTagException(msgs.getString("not_nested"));
            }
            this.result = tag.result;
            this.maxRows = tag.cursor.getMaxRows();
        }
        if (this.result != null) {
            try {
                if (this.result.next() && this.maxRows - this.count != 0) {
                    return 2;
                }
                return 0;
            }
            catch (SQLException ex) {
                throw new JspTagException(ex.toString());
            }
        }
        dbQueryTag query = (dbQueryTag)this.getParent();
        query.processBodyContent();
        this.result = query.result;
        this.maxRows = query.cursor.getMaxRows();
        return 2;
    }

    public int doAfterBody() throws JspTagException {
        BodyContent body = this.getBodyContent();
        try {
            body.writeOut((Writer)this.getPreviousOut());
        }
        catch (IOException ex) {
            throw new JspTagException("IO_error");
        }
        body.clearBody();
        ++this.count;
        try {
            if (this.result.next() && this.maxRows - this.count != 0) {
                return 2;
            }
            return 0;
        }
        catch (SQLException ex) {
            throw new JspTagException(msgs.getString("SQL_error"));
        }
    }

    public int doEndTag() {
        this.resetAttr();
        return 6;
    }

    public void release() {
        super.release();
        this.resetAttr();
    }

    public void setQueryId(String s) throws JspException {
        TagUtil.validateString(s, "queryId");
        this.qid = s;
    }

    private void resetAttr() {
        this.qid = null;
        this.result = null;
        this.maxRows = -1;
        this.count = 0;
    }
}

