/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.dbutil.tagext;

import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.BodyContent;
import javax.servlet.jsp.tagext.BodyTagSupport;
import javax.servlet.jsp.tagext.Tag;
import oracle.jsp.dbutil.ConnBean;
import oracle.jsp.dbutil.CursorBean;
import oracle.jsp.dbutil.tagext.dbOpenTag;
import oracle.jsp.dbutil.tagext.dbQueryTag;
import oracle.jsp.webutil.tagutil.TagUtil;

public class dbExecuteTag
extends BodyTagSupport {
    CursorBean cursor;
    private ConnBean cb;
    private String connectionId;
    private String scope;
    private String m_bindParams;
    private String outputType;
    private static final String MSG_FILE = "oracle.jsp.dbutil.tagext.LocalStrings";
    private static ResourceBundle msgs = ResourceBundle.getBundle("oracle.jsp.dbutil.tagext.LocalStrings");

    public dbExecuteTag() {
        this.resetAttr();
    }

    public int doStartTag() throws JspTagException {
        this.newCursorBean();
        String cid = this.getConnId();
        if (cid != null) {
            if (this.scope == null || this.scope.equals("page")) {
                this.cb = (ConnBean)this.pageContext.getAttribute(cid);
            } else if (this.scope.equals("request")) {
                this.cb = (ConnBean)this.pageContext.getAttribute(cid, 2);
            } else if (this.scope.equals("session")) {
                this.cb = (ConnBean)this.pageContext.getAttribute(cid, 3);
            } else if (this.scope.equals("application")) {
                this.cb = (ConnBean)this.pageContext.getAttribute(cid, 4);
            }
            if (this.cb == null) {
                throw new JspTagException(MessageFormat.format(msgs.getString("connid_not_found"), cid, this.scope));
            }
        } else {
            dbOpenTag tag = (dbOpenTag)dbExecuteTag.findAncestorWithClass((Tag)this, (Class)dbOpenTag.class);
            if (tag == null) {
                throw new JspTagException(msgs.getString("not_nested"));
            }
            this.cb = tag.getConnBean();
        }
        if (this.cb == null) {
            throw new JspTagException(msgs.getString("conn_not_found"));
        }
        try {
            this.cb.connect();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 2;
    }

    public int doAfterBody() throws JspTagException {
        this.processBodyContent();
        return 6;
    }

    public void processBodyContent() throws JspTagException {
        BodyContent body = this.getBodyContent();
        String sql = body.getString().trim();
        body.clearBody();
        JspWriter out = body.getEnclosingWriter();
        try {
            sql = dbQueryTag.resolveQueryParams(sql, this.pageContext);
            Vector varValues = dbQueryTag.resolveVariables(this.m_bindParams, this.pageContext);
            if (varValues == null || varValues.size() == 0) {
                this.cursor.create(this.cb);
            } else {
                this.cursor.create(this.cb, 1, sql);
                for (int i = 0; i < varValues.size(); ++i) {
                    String value = (String)varValues.elementAt(i);
                    if (value == null) {
                        this.cursor.setNull(i + 1, 12);
                        continue;
                    }
                    this.cursor.setString(i + 1, value);
                }
            }
            this.cursor.execute(sql);
            if (this.outputType.equalsIgnoreCase("yes")) {
                int cnt = this.cursor.getUpdateCount();
                if (cnt != -1) {
                    out.println("<b> " + cnt + msgs.getString("rows_affected") + "<b>");
                } else {
                    out.println("<b> " + msgs.getString("stmt_success") + " </b>");
                }
            }
        }
        catch (Exception ex) {
            try {
                if (this.outputType.equalsIgnoreCase("yes")) {
                    out.println("<b>" + msgs.getString("stmt_fail") + "</b>");
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            throw new JspTagException(ex.toString());
        }
    }

    public int doEndTag() {
        this.release();
        return 6;
    }

    public void release() {
        try {
            this.cursor.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.resetAttr();
    }

    public void setConnId(String s) throws JspTagException {
        TagUtil.validateString(s, "connId");
        this.connectionId = s;
    }

    public void setScope(String s) throws JspTagException {
        TagUtil.validateString(s, "scope");
        String temp = s.toLowerCase();
        if (!(temp.equals("page") || temp.equals("request") || temp.equals("session") || temp.equals("application"))) {
            throw new JspTagException(MessageFormat.format(msgs.getString("invalid_scope"), s));
        }
        this.scope = s.toLowerCase();
    }

    public void setBindParams(String s) throws JspTagException {
        TagUtil.validateString(s, "bindParams");
        this.m_bindParams = s;
    }

    public void setOutput(String s) throws JspException {
        TagUtil.validateString(s, "output");
        this.outputType = s;
    }

    public String getConnId() {
        return this.connectionId;
    }

    public String getOutput() {
        return this.outputType;
    }

    private void newCursorBean() {
        if (this.cursor == null) {
            this.cursor = new CursorBean();
        }
    }

    private void resetAttr() {
        this.cursor = null;
        this.cb = null;
        this.connectionId = null;
        this.scope = "page";
        this.m_bindParams = null;
        this.outputType = "NO";
    }
}

