/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.dbutil;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ResourceBundle;
import oracle.jdbc.OracleDriver;
import oracle.jsp.dbutil.BeanUtil;
import oracle.jsp.webutil.tagutil.event.JspScopeEvent;
import oracle.jsp.webutil.tagutil.event.JspScopeListener;

public class DBBean
implements JspScopeListener,
Serializable {
    private transient Connection m_conn = null;
    private String m_user = null;
    private String m_password = null;
    private String m_url = null;
    private static final String MSG_FILE = "oracle.jsp.dbutil.LocalStrings";
    private static ResourceBundle msgs = ResourceBundle.getBundle("oracle.jsp.dbutil.LocalStrings");

    public DBBean() {
        try {
            DriverManager.registerDriver((Driver)new OracleDriver());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void setUser(String user) {
        this.m_user = user;
    }

    public synchronized String getUser() {
        return this.m_user;
    }

    public synchronized void setPassword(String password) {
        this.m_password = password;
    }

    public synchronized String getPassword() {
        return this.m_password;
    }

    public synchronized void setURL(String url) {
        this.m_url = url;
    }

    public synchronized String getURL() {
        return this.m_url;
    }

    public synchronized void connect() throws SQLException {
        if (this.m_conn == null) {
            this.m_conn = DriverManager.getConnection(this.m_url, this.m_user, this.m_password);
        }
    }

    public synchronized void close() throws SQLException {
        if (this.m_conn != null) {
            this.m_conn.close();
            this.m_conn = null;
        }
    }

    public String getResultAsXMLString(String sql) throws SQLException {
        if (this.m_conn == null) {
            throw new SQLException(msgs.getString("conn_null"));
        }
        Statement stmt = this.m_conn.createStatement();
        if (stmt == null) {
            throw new SQLException(msgs.getString("cursor_null"));
        }
        ResultSet rset = stmt.executeQuery(sql);
        String xmlString = BeanUtil.translateToXML(this.m_conn, sql, rset);
        rset.close();
        stmt.close();
        return xmlString;
    }

    public String getResultAsHTMLTable(String sql) throws SQLException {
        if (this.m_conn == null) {
            throw new SQLException(msgs.getString("conn_null"));
        }
        Statement stmt = this.m_conn.createStatement();
        if (stmt == null) {
            throw new SQLException(msgs.getString("cursor_null"));
        }
        ResultSet rset = stmt.executeQuery(sql);
        String htmlTable = BeanUtil.translateToHTMLTable(rset);
        rset.close();
        stmt.close();
        return htmlTable;
    }

    public void outOfScope(JspScopeEvent ae) {
        try {
            this.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

