/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.dbutil;

import java.io.InputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ResourceBundle;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OraclePreparedStatement;
import oracle.jdbc.OracleStatement;
import oracle.jsp.dbutil.BeanUtil;
import oracle.jsp.dbutil.ConnBean;
import oracle.jsp.webutil.tagutil.event.JspScopeEvent;
import oracle.jsp.webutil.tagutil.event.JspScopeListener;
import oracle.sql.ARRAY;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.CustomDatum;
import oracle.sql.CustomDatumFactory;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.NUMBER;
import oracle.sql.RAW;
import oracle.sql.REF;
import oracle.sql.ROWID;
import oracle.sql.STRUCT;
import org.w3c.dom.Document;

public class CursorBean
implements JspScopeListener,
Serializable {
    protected Statement m_stmt = null;
    protected transient Connection m_conn = null;
    protected String m_sql = null;
    protected int m_maxRows = -1;
    protected int m_skipRows = 0;
    public static final int PLAIN_STMT = 0;
    public static final int PREP_STMT = 1;
    public static final int CALL_STMT = 2;
    public static final int TYPE_FORWARD_ONLY = 1003;
    public static final int TYPE_SCROLL_INSENSITIVE = 1004;
    public static final int TYPE_SCROLL_SENSITIVE = 1005;
    public static final int CONCUR_READ_ONLY = 1007;
    public static final int CONCUR_UPDATABLE = 1008;
    protected int m_stmtType = 0;
    protected int m_rsetType = 1003;
    protected int m_rsetCon = 1007;
    protected int m_preFetch = 10;
    protected int m_batchSize = 1;
    protected int m_queryTimeout = 0;
    private static final String MSG_FILE = "oracle.jsp.dbutil.LocalStrings";
    private static ResourceBundle msgs = ResourceBundle.getBundle("oracle.jsp.dbutil.LocalStrings");

    public synchronized void setConnBean(ConnBean cb) {
        this.m_conn = cb.m_conn;
    }

    public void create(ConnBean cb, int type, String sql) throws SQLException {
        this.m_conn = cb.m_conn;
        this.create(type, sql);
    }

    public void create(ConnBean cb) throws SQLException {
        this.m_conn = cb.m_conn;
        if (this.m_conn == null) {
            throw new SQLException(msgs.getString("conn_null"));
        }
        this.create(0, null);
    }

    public void create() throws SQLException {
        this.create(0, null);
    }

    public synchronized Connection getJDBCConnection() {
        return this.m_conn;
    }

    public synchronized void create(int type, String sql) throws SQLException {
        if (this.m_conn == null) {
            throw new SQLException(msgs.getString("conn_null"));
        }
        this.m_sql = sql;
        this.m_stmtType = type;
        if (this.m_stmt != null) {
            this.m_stmt.close();
            this.m_stmt = null;
        }
        this.m_stmt = this.m_stmtType == 2 ? this.m_conn.prepareCall(sql, this.m_rsetType, this.m_rsetCon) : (this.m_stmtType == 1 ? this.m_conn.prepareStatement(sql, this.m_rsetType, this.m_rsetCon) : this.m_conn.createStatement(this.m_rsetType, this.m_rsetCon));
        if (this.m_stmt == null) {
            throw new SQLException(msgs.getString("stmt_err"));
        }
        if (this.m_conn instanceof OracleConnection) {
            if (this.m_preFetch != 10) {
                ((OracleStatement)this.m_stmt).setRowPrefetch(this.m_preFetch);
            }
            if (this.m_stmtType != 0) {
                ((OraclePreparedStatement)this.m_stmt).setExecuteBatch(this.m_batchSize);
            }
        } else if (this.m_preFetch != 10) {
            this.m_stmt.setFetchSize(this.m_preFetch);
        }
        if (this.m_queryTimeout != 0) {
            this.m_stmt.setQueryTimeout(this.m_queryTimeout);
        }
    }

    public synchronized ResultSet executeQuery(String sql) throws SQLException {
        this.m_sql = sql;
        return this.executeQuery();
    }

    public synchronized ResultSet executeQuery() throws SQLException {
        if (this.m_stmt == null) {
            throw new SQLException(msgs.getString("stmt_null"));
        }
        if (this.m_stmtType == 0) {
            ResultSet rs = this.m_stmt.executeQuery(this.m_sql);
            this.skipRows(rs);
            return rs;
        }
        ResultSet rs = ((PreparedStatement)this.m_stmt).executeQuery();
        this.skipRows(rs);
        return rs;
    }

    private void skipRows(ResultSet rs) throws SQLException {
        for (int i = 0; i < this.m_skipRows; ++i) {
            if (rs.next()) continue;
            return;
        }
    }

    public synchronized int executeUpdate(String sql) throws SQLException {
        this.m_sql = sql;
        return this.executeUpdate();
    }

    public synchronized int executeUpdate() throws SQLException {
        if (this.m_stmt == null) {
            throw new SQLException(msgs.getString("stmt_null"));
        }
        if (this.m_stmtType == 0) {
            return this.m_stmt.executeUpdate(this.m_sql);
        }
        return ((PreparedStatement)this.m_stmt).executeUpdate();
    }

    public synchronized int getUpdateCount() throws SQLException {
        return this.m_stmt.getUpdateCount();
    }

    public synchronized boolean execute(String sql) throws SQLException {
        this.m_sql = sql;
        return this.execute();
    }

    public synchronized boolean execute() throws SQLException {
        if (this.m_stmt == null) {
            throw new SQLException(msgs.getString("stmt_null"));
        }
        if (this.m_stmtType == 0) {
            return this.m_stmt.execute(this.m_sql);
        }
        return ((PreparedStatement)this.m_stmt).execute();
    }

    public synchronized void close() throws SQLException {
        if (this.m_stmt != null) {
            this.m_stmt.close();
            this.m_stmt = null;
        }
    }

    public synchronized void setResultSetType(int rtype) {
        this.m_rsetType = rtype;
    }

    public synchronized int getResultSetType() {
        return this.m_rsetType;
    }

    public synchronized void setResultSetConcurrency(int rscon) {
        this.m_rsetCon = rscon;
    }

    public synchronized int getResultSetConcurrency() {
        return this.m_rsetCon;
    }

    public synchronized void setPreFetch(int prefSize) {
        this.m_preFetch = prefSize;
    }

    public synchronized int getPreFetch() {
        return this.m_preFetch;
    }

    public void setMaxRows(int maxRows) {
        this.m_maxRows = maxRows;
    }

    public int getMaxRows() {
        return this.m_maxRows;
    }

    public void setSkipRows(int skipRows) {
        this.m_skipRows = skipRows;
    }

    public int getSkipRows() {
        return this.m_skipRows;
    }

    public synchronized void setExecuteBatch(int bsize) {
        this.m_batchSize = bsize;
    }

    public synchronized int getExecuteBatch() {
        return this.m_batchSize;
    }

    public synchronized void setQueryTimeout(int tout) {
        this.m_queryTimeout = tout;
    }

    public synchronized int getQueryTimeout() {
        return this.m_queryTimeout;
    }

    public synchronized void setNull(int paramIndex, int sqlType, String sqlName) throws SQLException {
        if (this.m_stmtType == 0) {
            throw new SQLException(msgs.getString("prep_or_call_stmt"));
        }
        if (this.m_stmt == null) {
            throw new SQLException(msgs.getString("stmt_null"));
        }
        ((PreparedStatement)this.m_stmt).setNull(paramIndex, sqlType, sqlName);
    }

    public synchronized void setNull(int paramIndex, int sqlType) throws SQLException {
        if (this.m_stmtType == 0) {
            throw new SQLException(msgs.getString("prep_or_call_stmt"));
        }
        if (this.m_stmt == null) {
            throw new SQLException(msgs.getString("stmt_null"));
        }
        ((PreparedStatement)this.m_stmt).setNull(paramIndex, sqlType);
    }

    public synchronized void setBoolean(int paramIndex, boolean x) throws SQLException {
        if (this.m_stmtType == 0) {
            throw new SQLException(msgs.getString("prep_or_call_stmt"));
        }
        if (this.m_stmt == null) {
            throw new SQLException(msgs.getString("stmt_null"));
        }
        ((PreparedStatement)this.m_stmt).setBoolean(paramIndex, x);
    }

    public synchronized void setByte(int paramIndex, byte x) throws SQLException {
        if (this.m_stmtType == 0) {
            throw new SQLException(msgs.getString("prep_or_call_stmt"));
        }
        if (this.m_stmt == null) {
            throw new SQLException(msgs.getString("stmt_null"));
        }
        ((PreparedStatement)this.m_stmt).setByte(paramIndex, x);
    }

    public synchronized void setShort(int paramIndex, short x) throws SQLException {
        if (this.m_stmtType == 0) {
            throw new SQLException(msgs.getString("prep_or_call_stmt"));
        }
        if (this.m_stmt == null) {
            throw new SQLException(msgs.getString("stmt_null"));
        }
        ((PreparedStatement)this.m_stmt).setShort(paramIndex, x);
    }

    public synchronized void setInt(int paramIndex, int x) throws SQLException {
        if (this.m_stmtType == 0) {
            throw new SQLException(msgs.getString("prep_or_call_stmt"));
        }
        if (this.m_stmt == null) {
            throw new SQLException(msgs.getString("stmt_null"));
        }
        ((PreparedStatement)this.m_stmt).setInt(paramIndex, x);
    }

    public synchronized void setLong(int paramIndex, long x) throws SQLException {
        if (this.m_stmtType == 0) {
            throw new SQLException(msgs.getString("prep_or_call_stmt"));
        }
        if (this.m_stmt == null) {
            throw new SQLException(msgs.getString("stmt_null"));
        }
        ((PreparedStatement)this.m_stmt).setLong(paramIndex, x);
    }

    public synchronized void setFloat(int paramIndex, float x) throws SQLException {
        if (this.m_stmtType == 0) {
            throw new SQLException(msgs.getString("prep_or_call_stmt"));
        }
        if (this.m_stmt == null) {
            throw new SQLException(msgs.getString("stmt_null"));
        }
        ((PreparedStatement)this.m_stmt).setFloat(paramIndex, x);
    }

    public synchronized void setDouble(int paramIndex, double x) throws SQLException {
        if (this.m_stmt != null && this.m_stmtType != 0) {
            ((PreparedStatement)this.m_stmt).setDouble(paramIndex, x);
        }
    }

    public synchronized void setBigDecimal(int paramIndex, BigDecimal x) throws SQLException {
        if (this.m_stmtType == 0) {
            throw new SQLException(msgs.getString("prep_or_call_stmt"));
        }
        if (this.m_stmt == null) {
            throw new SQLException(msgs.getString("stmt_null"));
        }
        ((PreparedStatement)this.m_stmt).setBigDecimal(paramIndex, x);
    }

    public synchronized void setString(int paramIndex, String x) throws SQLException {
        if (this.m_stmtType == 0) {
            throw new SQLException(msgs.getString("prep_or_call_stmt"));
        }
        if (this.m_stmt == null) {
            throw new SQLException(msgs.getString("stmt_null"));
        }
        ((PreparedStatement)this.m_stmt).setString(paramIndex, x);
    }

    public synchronized void setFixedCHAR(int paramIndex, String x) throws SQLException {
        if (this.m_conn instanceof OracleConnection) {
            if (this.m_stmtType == 0) {
                throw new SQLException(msgs.getString("prep_or_call_stmt"));
            }
            if (this.m_stmt == null) {
                throw new SQLException(msgs.getString("stmt_null"));
            }
            ((OraclePreparedStatement)this.m_stmt).setFixedCHAR(paramIndex, x);
        }
    }

    public synchronized void setCursor(int paramIndex, ResultSet rs) throws SQLException {
        if (this.m_conn instanceof OracleConnection) {
            if (this.m_stmtType == 0) {
                throw new SQLException(msgs.getString("prep_or_call_stmt"));
            }
            if (this.m_stmt == null) {
                throw new SQLException(msgs.getString("stmt_null"));
            }
            ((OraclePreparedStatement)this.m_stmt).setCursor(paramIndex, rs);
        }
    }

    public synchronized void setROWID(int paramIndex, ROWID x) throws SQLException {
        if (this.m_conn instanceof OracleConnection) {
            if (this.m_stmtType == 0) {
                throw new SQLException(msgs.getString("prep_or_call_stmt"));
            }
            if (this.m_stmt == null) {
                throw new SQLException(msgs.getString("stmt_null"));
            }
            ((OraclePreparedStatement)this.m_stmt).setROWID(paramIndex, x);
        }
    }

    public synchronized void setArray(int paramIndex, Array arr) throws SQLException {
        if (this.m_stmtType == 0) {
            throw new SQLException(msgs.getString("prep_or_call_stmt"));
        }
        if (this.m_stmt == null) {
            throw new SQLException(msgs.getString("stmt_null"));
        }
        ((PreparedStatement)this.m_stmt).setArray(paramIndex, arr);
    }

    public synchronized void setARRAY(int paramIndex, ARRAY arr) throws SQLException {
        if (this.m_conn instanceof OracleConnection) {
            if (this.m_stmtType == 0) {
                throw new SQLException(msgs.getString("prep_or_call_stmt"));
            }
            if (this.m_stmt == null) {
                throw new SQLException(msgs.getString("stmt_null"));
            }
            ((OraclePreparedStatement)this.m_stmt).setARRAY(paramIndex, arr);
        }
    }

    public synchronized void setSTRUCT(int paramIndex, STRUCT struct) throws SQLException {
        if (this.m_conn instanceof OracleConnection) {
            if (this.m_stmtType == 0) {
                throw new SQLException(msgs.getString("prep_or_call_stmt"));
            }
            if (this.m_stmt == null) {
                throw new SQLException(msgs.getString("stmt_null"));
            }
            ((OraclePreparedStatement)this.m_stmt).setSTRUCT(paramIndex, struct);
        }
    }

    public synchronized void setRAW(int paramIndex, RAW raw) throws SQLException {
        if (this.m_conn instanceof OracleConnection) {
            if (this.m_stmtType == 0) {
                throw new SQLException(msgs.getString("prep_or_call_stmt"));
            }
            if (this.m_stmt == null) {
                throw new SQLException(msgs.getString("stmt_null"));
            }
            ((OraclePreparedStatement)this.m_stmt).setRAW(paramIndex, raw);
        }
    }

    public synchronized void setCHAR(int paramIndex, CHAR ch) throws SQLException {
        if (this.m_conn instanceof OracleConnection) {
            if (this.m_stmtType == 0) {
                throw new SQLException(msgs.getString("prep_or_call_stmt"));
            }
            if (this.m_stmt == null) {
                throw new SQLException(msgs.getString("stmt_null"));
            }
            ((OraclePreparedStatement)this.m_stmt).setCHAR(paramIndex, ch);
        }
    }

    public synchronized void setDate(int paramIndex, Date date) throws SQLException {
        if (this.m_stmtType == 0) {
            throw new SQLException(msgs.getString("prep_or_call_stmt"));
        }
        if (this.m_stmt == null) {
            throw new SQLException(msgs.getString("stmt_null"));
        }
        ((PreparedStatement)this.m_stmt).setDate(paramIndex, date);
    }

    public synchronized void setDATE(int paramIndex, DATE date) throws SQLException {
        if (this.m_stmtType == 0) {
            throw new SQLException(msgs.getString("prep_or_call_stmt"));
        }
        if (this.m_stmt == null) {
            throw new SQLException(msgs.getString("stmt_null"));
        }
        ((OraclePreparedStatement)this.m_stmt).setDATE(paramIndex, date);
    }

    public synchronized void setNUMBER(int paramIndex, NUMBER num) throws SQLException {
        if (this.m_conn instanceof OracleConnection) {
            if (this.m_stmtType == 0) {
                throw new SQLException(msgs.getString("prep_or_call_stmt"));
            }
            if (this.m_stmt == null) {
                throw new SQLException(msgs.getString("stmt_null"));
            }
            ((OraclePreparedStatement)this.m_stmt).setNUMBER(paramIndex, num);
        }
    }

    public synchronized void setBlob(int paramIndex, Blob lob) throws SQLException {
        if (this.m_stmtType == 0) {
            throw new SQLException(msgs.getString("prep_or_call_stmt"));
        }
        if (this.m_stmt == null) {
            throw new SQLException(msgs.getString("stmt_null"));
        }
        ((PreparedStatement)this.m_stmt).setBlob(paramIndex, lob);
    }

    public synchronized void setBLOB(int paramIndex, BLOB lob) throws SQLException {
        if (this.m_conn instanceof OracleConnection) {
            if (this.m_stmtType == 0) {
                throw new SQLException(msgs.getString("prep_or_call_stmt"));
            }
            if (this.m_stmt == null) {
                throw new SQLException(msgs.getString("stmt_null"));
            }
            ((OraclePreparedStatement)this.m_stmt).setBLOB(paramIndex, lob);
        }
    }

    public synchronized void setClob(int paramIndex, Clob lob) throws SQLException {
        if (this.m_stmtType == 0) {
            throw new SQLException(msgs.getString("prep_or_call_stmt"));
        }
        if (this.m_stmt == null) {
            throw new SQLException(msgs.getString("stmt_null"));
        }
        ((PreparedStatement)this.m_stmt).setClob(paramIndex, lob);
    }

    public synchronized void setCLOB(int paramIndex, CLOB lob) throws SQLException {
        if (this.m_conn instanceof OracleConnection) {
            if (this.m_stmtType == 0) {
                throw new SQLException(msgs.getString("prep_or_call_stmt"));
            }
            if (this.m_stmt == null) {
                throw new SQLException(msgs.getString("stmt_null"));
            }
            ((OraclePreparedStatement)this.m_stmt).setCLOB(paramIndex, lob);
        }
    }

    public synchronized void setBFILE(int paramIndex, BFILE file) throws SQLException {
        if (this.m_conn instanceof OracleConnection) {
            if (this.m_stmtType == 0) {
                throw new SQLException(msgs.getString("prep_or_call_stmt"));
            }
            if (this.m_stmt == null) {
                throw new SQLException(msgs.getString("stmt_null"));
            }
            ((OraclePreparedStatement)this.m_stmt).setBFILE(paramIndex, file);
        }
    }

    public synchronized void setBfile(int paramIndex, BFILE file) throws SQLException {
        if (this.m_conn instanceof OracleConnection) {
            if (this.m_stmtType == 0) {
                throw new SQLException(msgs.getString("prep_or_call_stmt"));
            }
            if (this.m_stmt == null) {
                throw new SQLException(msgs.getString("stmt_null"));
            }
            ((OraclePreparedStatement)this.m_stmt).setBfile(paramIndex, file);
        }
    }

    public synchronized void setBytes(int paramIndex, byte[] x) throws SQLException {
        if (this.m_stmtType == 0) {
            throw new SQLException(msgs.getString("prep_or_call_stmt"));
        }
        if (this.m_stmt == null) {
            throw new SQLException(msgs.getString("stmt_null"));
        }
        ((PreparedStatement)this.m_stmt).setBytes(paramIndex, x);
    }

    public synchronized void setTime(int paramIndex, Time x) throws SQLException {
        if (this.m_stmtType == 0) {
            throw new SQLException(msgs.getString("prep_or_call_stmt"));
        }
        if (this.m_stmt == null) {
            throw new SQLException(msgs.getString("stmt_null"));
        }
        ((PreparedStatement)this.m_stmt).setTime(paramIndex, x);
    }

    public synchronized void setTimestamp(int paramIndex, Timestamp x) throws SQLException {
        if (this.m_stmtType == 0) {
            throw new SQLException(msgs.getString("prep_or_call_stmt"));
        }
        if (this.m_stmt == null) {
            throw new SQLException(msgs.getString("stmt_null"));
        }
        ((PreparedStatement)this.m_stmt).setTimestamp(paramIndex, x);
    }

    public synchronized void setUnicodeStream(int paramIndex, InputStream istream, int length) throws SQLException {
        if (this.m_stmtType == 0) {
            throw new SQLException(msgs.getString("prep_or_call_stmt"));
        }
        if (this.m_stmt == null) {
            throw new SQLException(msgs.getString("stmt_null"));
        }
        ((PreparedStatement)this.m_stmt).setUnicodeStream(paramIndex, istream, length);
    }

    public synchronized void setAsciiStream(int paramIndex, InputStream istream, int length) throws SQLException {
        if (this.m_stmtType == 0) {
            throw new SQLException(msgs.getString("prep_or_call_stmt"));
        }
        if (this.m_stmt == null) {
            throw new SQLException(msgs.getString("stmt_null"));
        }
        ((PreparedStatement)this.m_stmt).setAsciiStream(paramIndex, istream, length);
    }

    public synchronized void setBinaryStream(int paramIndex, InputStream istream, int length) throws SQLException {
        if (this.m_stmtType == 0) {
            throw new SQLException(msgs.getString("prep_or_call_stmt"));
        }
        if (this.m_stmt == null) {
            throw new SQLException(msgs.getString("stmt_null"));
        }
        ((PreparedStatement)this.m_stmt).setBinaryStream(paramIndex, istream, length);
    }

    public synchronized void setCustomDatum(int paramIndex, CustomDatum x) throws SQLException {
        if (this.m_conn instanceof OracleConnection) {
            if (this.m_stmtType == 0) {
                throw new SQLException(msgs.getString("prep_or_call_stmt"));
            }
            if (this.m_stmt == null) {
                throw new SQLException(msgs.getString("stmt_null"));
            }
            ((OraclePreparedStatement)this.m_stmt).setCustomDatum(paramIndex, x);
        }
    }

    public synchronized void setObject(int paramIndex, Object x, int targetSqlType, int scale) throws SQLException {
        if (this.m_stmtType == 0) {
            throw new SQLException(msgs.getString("prep_or_call_stmt"));
        }
        if (this.m_stmt == null) {
            throw new SQLException(msgs.getString("stmt_null"));
        }
        ((PreparedStatement)this.m_stmt).setObject(paramIndex, x, targetSqlType, scale);
    }

    public void setObject(int paramIndex, Object x, int targetSqlType) throws SQLException {
        if (this.m_stmtType == 0) {
            throw new SQLException(msgs.getString("prep_or_call_stmt"));
        }
        if (this.m_stmt == null) {
            throw new SQLException(msgs.getString("stmt_null"));
        }
        ((PreparedStatement)this.m_stmt).setObject(paramIndex, x, targetSqlType);
    }

    public void setRefType(int paramIndex, REF ref) throws SQLException {
        if (this.m_conn instanceof OracleConnection) {
            if (this.m_stmtType == 0) {
                throw new SQLException(msgs.getString("prep_or_call_stmt"));
            }
            if (this.m_stmt == null) {
                throw new SQLException(msgs.getString("stmt_null"));
            }
            ((OraclePreparedStatement)this.m_stmt).setRefType(paramIndex, ref);
        }
    }

    public synchronized void setRef(int paramIndex, Ref ref) throws SQLException {
        if (this.m_stmtType == 0) {
            throw new SQLException(msgs.getString("prep_or_call_stmt"));
        }
        if (this.m_stmt == null) {
            throw new SQLException(msgs.getString("stmt_null"));
        }
        ((PreparedStatement)this.m_stmt).setRef(paramIndex, ref);
    }

    public synchronized void setREF(int paramIndex, REF ref) throws SQLException {
        if (this.m_conn instanceof OracleConnection) {
            if (this.m_stmtType == 0) {
                throw new SQLException(msgs.getString("prep_or_call_stmt"));
            }
            if (this.m_stmt == null) {
                throw new SQLException(msgs.getString("stmt_null"));
            }
            ((OraclePreparedStatement)this.m_stmt).setREF(paramIndex, ref);
        }
    }

    public synchronized void setObject(int paramIndex, Object x) throws SQLException {
        if (this.m_stmtType == 0) {
            throw new SQLException(msgs.getString("prep_or_call_stmt"));
        }
        if (this.m_stmt == null) {
            throw new SQLException(msgs.getString("stmt_null"));
        }
        ((PreparedStatement)this.m_stmt).setObject(paramIndex, x);
    }

    public synchronized void setOracleObject(int paramIndex, Datum x) throws SQLException {
        if (this.m_conn instanceof OracleConnection) {
            if (this.m_stmtType == 0) {
                throw new SQLException(msgs.getString("prep_or_call_stmt"));
            }
            if (this.m_stmt == null) {
                throw new SQLException(msgs.getString("stmt_null"));
            }
            ((OraclePreparedStatement)this.m_stmt).setOracleObject(paramIndex, x);
        }
    }

    public synchronized void registerOutParameter(int paramIndex, int sqlType, String sqlName) throws SQLException {
        if (this.m_stmtType != 2) {
            throw new SQLException(msgs.getString("only_call_stmt"));
        }
        if (this.m_stmt == null) {
            throw new SQLException(msgs.getString("stmt_null"));
        }
        ((CallableStatement)this.m_stmt).registerOutParameter(paramIndex, sqlType, sqlName);
    }

    public synchronized void registerOutParameter(int paramIndex, int sqlType, int scale) throws SQLException {
        if (this.m_stmtType != 2) {
            throw new SQLException(msgs.getString("only_call_stmt"));
        }
        if (this.m_stmt == null) {
            throw new SQLException(msgs.getString("stmt_null"));
        }
        ((CallableStatement)this.m_stmt).registerOutParameter(paramIndex, sqlType, scale);
    }

    public synchronized void registerOutParameter(int paramIndex, int sqlType, int scale, int maxLength) throws SQLException {
        if (this.m_conn instanceof OracleConnection) {
            if (this.m_stmtType != 2) {
                throw new SQLException(msgs.getString("only_call_stmt"));
            }
            if (this.m_stmt == null) {
                throw new SQLException(msgs.getString("stmt_null"));
            }
            ((OracleCallableStatement)this.m_stmt).registerOutParameter(paramIndex, sqlType, scale, maxLength);
        }
    }

    public synchronized void registerOutParameter(int paramIndex, int sqlType) throws SQLException {
        if (this.m_stmtType != 2) {
            throw new SQLException(msgs.getString("only_call_stmt"));
        }
        if (this.m_stmt == null) {
            throw new SQLException(msgs.getString("stmt_null"));
        }
        ((CallableStatement)this.m_stmt).registerOutParameter(paramIndex, sqlType);
    }

    public String getString(int parameterIndex) throws SQLException {
        if (this.m_stmtType != 2) {
            throw new SQLException(msgs.getString("only_call_stmt"));
        }
        if (this.m_stmt == null) {
            throw new SQLException(msgs.getString("stmt_null"));
        }
        return ((CallableStatement)this.m_stmt).getString(parameterIndex);
    }

    public Datum getOracleObject(int parameterIndex) throws SQLException {
        if (this.m_conn instanceof OracleConnection) {
            if (this.m_stmtType != 2) {
                throw new SQLException(msgs.getString("only_call_stmt"));
            }
            if (this.m_stmt == null) {
                throw new SQLException(msgs.getString("stmt_null"));
            }
            return ((OracleCallableStatement)this.m_stmt).getOracleObject(parameterIndex);
        }
        return null;
    }

    public ROWID getROWID(int parameterIndex) throws SQLException {
        if (this.m_conn instanceof OracleConnection) {
            if (this.m_stmtType != 2) {
                throw new SQLException(msgs.getString("only_call_stmt"));
            }
            if (this.m_stmt == null) {
                throw new SQLException(msgs.getString("stmt_null"));
            }
            return ((OracleCallableStatement)this.m_stmt).getROWID(parameterIndex);
        }
        return null;
    }

    public NUMBER getNUMBER(int parameterIndex) throws SQLException {
        if (this.m_conn instanceof OracleConnection) {
            if (this.m_stmtType != 2) {
                throw new SQLException(msgs.getString("only_call_stmt"));
            }
            if (this.m_stmt == null) {
                throw new SQLException(msgs.getString("stmt_null"));
            }
            return ((OracleCallableStatement)this.m_stmt).getNUMBER(parameterIndex);
        }
        return null;
    }

    public Date getDate(int parameterIndex) throws SQLException {
        if (this.m_stmtType != 2) {
            throw new SQLException(msgs.getString("only_call_stmt"));
        }
        if (this.m_stmt == null) {
            throw new SQLException(msgs.getString("stmt_null"));
        }
        return ((CallableStatement)this.m_stmt).getDate(parameterIndex);
    }

    public DATE getDATE(int parameterIndex) throws SQLException {
        if (this.m_conn instanceof OracleConnection) {
            if (this.m_stmtType != 2) {
                throw new SQLException(msgs.getString("only_call_stmt"));
            }
            if (this.m_stmt == null) {
                throw new SQLException(msgs.getString("stmt_null"));
            }
            return ((OracleCallableStatement)this.m_stmt).getDATE(parameterIndex);
        }
        return null;
    }

    public Ref getRef(int parameterIndex) throws SQLException {
        if (this.m_stmtType != 2) {
            throw new SQLException(msgs.getString("only_call_stmt"));
        }
        if (this.m_stmt == null) {
            throw new SQLException(msgs.getString("stmt_null"));
        }
        return ((CallableStatement)this.m_stmt).getRef(parameterIndex);
    }

    public REF getREF(int parameterIndex) throws SQLException {
        if (this.m_conn instanceof OracleConnection) {
            if (this.m_stmtType != 2) {
                throw new SQLException(msgs.getString("only_call_stmt"));
            }
            if (this.m_stmt == null) {
                throw new SQLException(msgs.getString("stmt_null"));
            }
            return ((OracleCallableStatement)this.m_stmt).getREF(parameterIndex);
        }
        return null;
    }

    public Array getArray(int parameterIndex) throws SQLException {
        if (this.m_stmtType != 2) {
            throw new SQLException(msgs.getString("only_call_stmt"));
        }
        if (this.m_stmt == null) {
            throw new SQLException(msgs.getString("stmt_null"));
        }
        return ((CallableStatement)this.m_stmt).getArray(parameterIndex);
    }

    public ARRAY getARRAY(int parameterIndex) throws SQLException {
        if (this.m_conn instanceof OracleConnection) {
            if (this.m_stmtType != 2) {
                throw new SQLException(msgs.getString("only_call_stmt"));
            }
            if (this.m_stmt == null) {
                throw new SQLException(msgs.getString("stmt_null"));
            }
            return ((OracleCallableStatement)this.m_stmt).getARRAY(parameterIndex);
        }
        return null;
    }

    public STRUCT getSTRUCT(int parameterIndex) throws SQLException {
        if (this.m_conn instanceof OracleConnection) {
            if (this.m_stmtType != 2) {
                throw new SQLException(msgs.getString("only_call_stmt"));
            }
            if (this.m_stmt == null) {
                throw new SQLException(msgs.getString("stmt_null"));
            }
            return ((OracleCallableStatement)this.m_stmt).getSTRUCT(parameterIndex);
        }
        return null;
    }

    public CHAR getCHAR(int parameterIndex) throws SQLException {
        if (this.m_conn instanceof OracleConnection) {
            if (this.m_stmtType != 2) {
                throw new SQLException(msgs.getString("only_call_stmt"));
            }
            if (this.m_stmt == null) {
                throw new SQLException(msgs.getString("stmt_null"));
            }
            return ((OracleCallableStatement)this.m_stmt).getCHAR(parameterIndex);
        }
        return null;
    }

    public RAW getRAW(int parameterIndex) throws SQLException {
        if (this.m_conn instanceof OracleConnection) {
            if (this.m_stmtType != 2) {
                throw new SQLException(msgs.getString("only_call_stmt"));
            }
            if (this.m_stmt == null) {
                throw new SQLException(msgs.getString("stmt_null"));
            }
            return ((OracleCallableStatement)this.m_stmt).getRAW(parameterIndex);
        }
        return null;
    }

    public Blob getBlob(int parameterIndex) throws SQLException {
        if (this.m_stmtType != 2) {
            throw new SQLException(msgs.getString("only_call_stmt"));
        }
        if (this.m_stmt == null) {
            throw new SQLException(msgs.getString("stmt_null"));
        }
        return ((CallableStatement)this.m_stmt).getBlob(parameterIndex);
    }

    public BLOB getBLOB(int parameterIndex) throws SQLException {
        if (this.m_conn instanceof OracleConnection) {
            if (this.m_stmtType != 2) {
                throw new SQLException(msgs.getString("only_call_stmt"));
            }
            if (this.m_stmt == null) {
                throw new SQLException(msgs.getString("stmt_null"));
            }
            return ((OracleCallableStatement)this.m_stmt).getBLOB(parameterIndex);
        }
        return null;
    }

    public Clob getClob(int parameterIndex) throws SQLException {
        if (this.m_stmtType != 2) {
            throw new SQLException(msgs.getString("only_call_stmt"));
        }
        if (this.m_stmt == null) {
            throw new SQLException(msgs.getString("stmt_null"));
        }
        return ((CallableStatement)this.m_stmt).getClob(parameterIndex);
    }

    public CLOB getCLOB(int parameterIndex) throws SQLException {
        if (this.m_conn instanceof OracleConnection) {
            if (this.m_stmtType != 2) {
                throw new SQLException(msgs.getString("only_call_stmt"));
            }
            if (this.m_stmt == null) {
                throw new SQLException(msgs.getString("stmt_null"));
            }
            return ((OracleCallableStatement)this.m_stmt).getCLOB(parameterIndex);
        }
        return null;
    }

    public BFILE getBFILE(int parameterIndex) throws SQLException {
        if (this.m_conn instanceof OracleConnection) {
            if (this.m_stmtType != 2) {
                throw new SQLException(msgs.getString("only_call_stmt"));
            }
            if (this.m_stmt == null) {
                throw new SQLException(msgs.getString("stmt_null"));
            }
            return ((OracleCallableStatement)this.m_stmt).getBFILE(parameterIndex);
        }
        return null;
    }

    public boolean getBoolean(int parameterIndex) throws SQLException {
        if (this.m_stmtType != 2) {
            throw new SQLException(msgs.getString("only_call_stmt"));
        }
        if (this.m_stmt == null) {
            throw new SQLException(msgs.getString("stmt_null"));
        }
        return ((CallableStatement)this.m_stmt).getBoolean(parameterIndex);
    }

    public byte getByte(int parameterIndex) throws SQLException {
        if (this.m_stmtType != 2) {
            throw new SQLException(msgs.getString("only_call_stmt"));
        }
        if (this.m_stmt == null) {
            throw new SQLException(msgs.getString("stmt_null"));
        }
        return ((CallableStatement)this.m_stmt).getByte(parameterIndex);
    }

    public short getShort(int parameterIndex) throws SQLException {
        if (this.m_stmtType != 2) {
            throw new SQLException(msgs.getString("only_call_stmt"));
        }
        if (this.m_stmt == null) {
            throw new SQLException(msgs.getString("stmt_null"));
        }
        return ((CallableStatement)this.m_stmt).getShort(parameterIndex);
    }

    public int getInt(int parameterIndex) throws SQLException {
        if (this.m_stmtType != 2) {
            throw new SQLException(msgs.getString("only_call_stmt"));
        }
        if (this.m_stmt == null) {
            throw new SQLException(msgs.getString("stmt_null"));
        }
        return ((CallableStatement)this.m_stmt).getInt(parameterIndex);
    }

    public long getLong(int parameterIndex) throws SQLException {
        if (this.m_stmtType != 2) {
            throw new SQLException(msgs.getString("only_call_stmt"));
        }
        if (this.m_stmt == null) {
            throw new SQLException(msgs.getString("stmt_null"));
        }
        return ((CallableStatement)this.m_stmt).getLong(parameterIndex);
    }

    public float getFloat(int parameterIndex) throws SQLException {
        if (this.m_stmtType != 2) {
            throw new SQLException(msgs.getString("only_call_stmt"));
        }
        if (this.m_stmt == null) {
            throw new SQLException(msgs.getString("stmt_null"));
        }
        return ((CallableStatement)this.m_stmt).getFloat(parameterIndex);
    }

    public double getDouble(int parameterIndex) throws SQLException {
        if (this.m_stmtType != 2) {
            throw new SQLException(msgs.getString("only_call_stmt"));
        }
        if (this.m_stmt == null) {
            throw new SQLException(msgs.getString("stmt_null"));
        }
        return ((CallableStatement)this.m_stmt).getDouble(parameterIndex);
    }

    public BigDecimal getBigDecimal(int parameterIndex, int scale) throws SQLException {
        if (this.m_stmtType != 2) {
            throw new SQLException(msgs.getString("only_call_stmt"));
        }
        if (this.m_stmt == null) {
            throw new SQLException(msgs.getString("stmt_null"));
        }
        return ((CallableStatement)this.m_stmt).getBigDecimal(parameterIndex);
    }

    public byte[] getBytes(int parameterIndex) throws SQLException {
        if (this.m_stmtType != 2) {
            throw new SQLException(msgs.getString("only_call_stmt"));
        }
        if (this.m_stmt == null) {
            throw new SQLException(msgs.getString("stmt_null"));
        }
        return ((CallableStatement)this.m_stmt).getBytes(parameterIndex);
    }

    public Time getTime(int parameterIndex) throws SQLException {
        if (this.m_stmtType != 2) {
            throw new SQLException(msgs.getString("only_call_stmt"));
        }
        if (this.m_stmt == null) {
            throw new SQLException(msgs.getString("stmt_null"));
        }
        return ((CallableStatement)this.m_stmt).getTime(parameterIndex);
    }

    public Timestamp getTimestamp(int parameterIndex) throws SQLException {
        if (this.m_stmtType != 2) {
            throw new SQLException(msgs.getString("only_call_stmt"));
        }
        if (this.m_stmt == null) {
            throw new SQLException(msgs.getString("stmt_null"));
        }
        return ((CallableStatement)this.m_stmt).getTimestamp(parameterIndex);
    }

    public InputStream getAsciiStream(int parameterIndex) throws SQLException {
        if (this.m_conn instanceof OracleConnection) {
            if (this.m_stmtType != 2) {
                throw new SQLException(msgs.getString("only_call_stmt"));
            }
            if (this.m_stmt == null) {
                throw new SQLException(msgs.getString("stmt_null"));
            }
            return ((OracleCallableStatement)this.m_stmt).getAsciiStream(parameterIndex);
        }
        return null;
    }

    public InputStream getUnicodeStream(int parameterIndex) throws SQLException {
        if (this.m_conn instanceof OracleConnection) {
            if (this.m_stmtType != 2) {
                throw new SQLException(msgs.getString("only_call_stmt"));
            }
            if (this.m_stmt == null) {
                throw new SQLException(msgs.getString("stmt_null"));
            }
            return ((OracleCallableStatement)this.m_stmt).getUnicodeStream(parameterIndex);
        }
        return null;
    }

    public InputStream getBinaryStream(int parameterIndex) throws SQLException {
        if (this.m_conn instanceof OracleConnection) {
            if (this.m_stmt != null && this.m_stmtType == 2) {
                return ((OracleCallableStatement)this.m_stmt).getBinaryStream(parameterIndex);
            }
            return null;
        }
        return null;
    }

    public Object getObject(int parameterIndex) throws SQLException {
        if (this.m_stmt != null && this.m_stmtType == 2) {
            return ((CallableStatement)this.m_stmt).getObject(parameterIndex);
        }
        return null;
    }

    public Object getCustomDatum(int parameterIndex, CustomDatumFactory factory) throws SQLException {
        if (this.m_conn instanceof OracleConnection) {
            if (this.m_stmtType != 2) {
                throw new SQLException(msgs.getString("only_call_stmt"));
            }
            if (this.m_stmt == null) {
                throw new SQLException(msgs.getString("stmt_null"));
            }
            return ((OracleCallableStatement)this.m_stmt).getCustomDatum(parameterIndex, factory);
        }
        return null;
    }

    public ResultSet getCursor(int parameterIndex) throws SQLException {
        if (this.m_conn instanceof OracleConnection) {
            if (this.m_stmtType != 2) {
                throw new SQLException(msgs.getString("only_call_stmt"));
            }
            if (this.m_stmt == null) {
                throw new SQLException(msgs.getString("stmt_null"));
            }
            return ((OracleCallableStatement)this.m_stmt).getCursor(parameterIndex);
        }
        return null;
    }

    public String getResultAsXMLString() throws SQLException {
        ResultSet rset = this.executeQuery();
        String op = BeanUtil.translateToXML(this.m_conn, this.m_sql, rset, this.m_maxRows);
        rset.close();
        return op;
    }

    public String getResultAsXMLString(String sql) throws SQLException {
        ResultSet rset = this.executeQuery(sql);
        String op = BeanUtil.translateToXML(this.m_conn, sql, rset, this.m_maxRows);
        if (rset != null) {
            rset.close();
        }
        return op;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document getResultAsXMLDocument(String sql) throws SQLException {
        ResultSet rset = this.executeQuery(sql);
        try {
            Document document = BeanUtil.translateToXMLDocument(this.m_conn, sql, rset, this.m_maxRows);
            return document;
        }
        finally {
            if (rset != null) {
                rset.close();
            }
        }
    }

    public String getResultAsHTMLTable(String sql) throws SQLException {
        ResultSet rset = this.executeQuery(sql);
        String op = BeanUtil.translateToHTMLTable(rset, this.m_maxRows);
        if (rset != null) {
            rset.close();
        }
        return op;
    }

    public String getResultAsHTMLTable() throws SQLException {
        ResultSet rset = this.executeQuery();
        String op = BeanUtil.translateToHTMLTable(rset, this.m_maxRows);
        rset.close();
        return op;
    }

    public void outOfScope(JspScopeEvent ae) {
        try {
            this.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

