/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.dbutil;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.sql.DataSource;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OracleDriver;
import oracle.jsp.dbutil.CursorBean;
import oracle.jsp.webutil.tagutil.event.JspScopeEvent;
import oracle.jsp.webutil.tagutil.event.JspScopeListener;

public class ConnBean
implements JspScopeListener,
HttpSessionBindingListener,
Serializable {
    protected transient Connection m_conn = null;
    protected String m_user = null;
    protected String m_password = null;
    protected String m_url = null;
    protected int m_scSize = 0;
    protected String m_location = null;
    protected DataSource m_datasource = null;
    protected transient InitialContext m_context = null;
    protected boolean m_commitOnClose = false;
    protected boolean m_resetAutoCommit = false;
    protected boolean m_registered = false;
    protected static int DEFAULT_PREFETCH_SIZE = 10;
    protected static int DEFAULT_BATCH_SIZE = 1;
    protected int m_preFetch = DEFAULT_PREFETCH_SIZE;
    protected int m_batchSize = DEFAULT_BATCH_SIZE;
    private static final String MSG_FILE = "oracle.jsp.dbutil.LocalStrings";
    private static ResourceBundle msgs = ResourceBundle.getBundle("oracle.jsp.dbutil.LocalStrings");

    public synchronized void setDataSource(String location) {
        this.m_location = location;
    }

    public synchronized String getDataSource() {
        return this.m_location;
    }

    public synchronized void setUser(String user) {
        this.m_user = user;
    }

    public synchronized String getUser() {
        return this.m_user;
    }

    public synchronized void setPassword(String password) {
        this.m_password = password;
    }

    public synchronized String getPassword() {
        return this.m_password;
    }

    public synchronized void setURL(String url) {
        this.m_url = url;
    }

    public synchronized String getURL() {
        return this.m_url;
    }

    public synchronized void connect() throws SQLException {
        if (this.m_conn != null) {
            return;
        }
        if (this.m_location != null && this.m_location.length() != 0) {
            try {
                this.m_context = new InitialContext();
                this.m_datasource = (DataSource)this.m_context.lookup(this.m_location);
                if (this.m_user != null && this.m_password != null) {
                    this.m_conn = this.m_datasource.getConnection(this.m_user, this.m_password);
                }
                this.m_conn = this.m_datasource.getConnection();
            }
            catch (NamingException n) {
                throw new SQLException(msgs.getString("datasrc_err") + n.toString());
            }
        } else {
            if (!this.m_registered) {
                try {
                    DriverManager.registerDriver((Driver)new OracleDriver());
                    this.m_registered = true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.m_conn == null) {
                this.m_conn = DriverManager.getConnection(this.m_url, this.m_user, this.m_password);
                if (this.m_conn == null) {
                    throw new SQLException(msgs.getString("conn_fail"));
                }
                if (this.m_scSize > 0) {
                    ((OracleConnection)this.m_conn).setStmtCacheSize(this.m_scSize);
                }
                if (this.m_preFetch != DEFAULT_PREFETCH_SIZE) {
                    ((OracleConnection)this.m_conn).setDefaultRowPrefetch(this.m_preFetch);
                }
                if (this.m_batchSize != DEFAULT_BATCH_SIZE) {
                    ((OracleConnection)this.m_conn).setDefaultExecuteBatch(this.m_batchSize);
                }
            }
        }
        if (this.m_conn != null && !this.m_commitOnClose && this.m_conn.getAutoCommit()) {
            this.m_conn.setAutoCommit(false);
            this.m_resetAutoCommit = true;
        }
    }

    public synchronized void close() throws SQLException {
        if (this.m_conn != null && !this.isConnectionClosed()) {
            try {
                if (this.m_commitOnClose) {
                    this.m_conn.commit();
                } else {
                    this.m_conn.rollback();
                }
                if (this.m_resetAutoCommit) {
                    this.m_conn.setAutoCommit(true);
                    this.m_resetAutoCommit = false;
                }
                this.m_conn.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.m_conn = null;
        }
    }

    public synchronized Connection getConnection() {
        return this.m_conn;
    }

    public synchronized CursorBean getCursorBean(int stype, String sql) throws SQLException {
        if (this.m_conn == null) {
            this.connect();
        }
        CursorBean cb = new CursorBean();
        cb.create(this, stype, sql);
        if (this.m_preFetch != DEFAULT_PREFETCH_SIZE) {
            cb.setPreFetch(this.m_preFetch);
        }
        if (this.m_batchSize != DEFAULT_BATCH_SIZE && stype != 0) {
            cb.setExecuteBatch(this.m_batchSize);
        }
        return cb;
    }

    public synchronized void setPreFetch(int prefSize) {
        this.m_preFetch = prefSize;
    }

    public synchronized int getPreFetch() {
        return this.m_preFetch;
    }

    public synchronized void setExecuteBatch(int bsize) {
        this.m_batchSize = bsize;
    }

    public synchronized int getExecuteBatch() {
        return this.m_batchSize;
    }

    public synchronized void setStmtCacheSize(int scsize) throws SQLException {
        this.m_scSize = scsize;
        if (this.m_conn != null) {
            ((OracleConnection)this.m_conn).setStmtCacheSize(this.m_scSize);
        }
    }

    public synchronized int getStmtCacheSize() {
        return this.m_scSize;
    }

    public void setCommitOnClose(String commitOnClose) throws IllegalArgumentException {
        if (commitOnClose != null && commitOnClose.equalsIgnoreCase("true")) {
            this.m_commitOnClose = true;
        } else if (commitOnClose != null && commitOnClose.equalsIgnoreCase("false")) {
            this.m_commitOnClose = false;
        } else {
            throw new IllegalArgumentException(MessageFormat.format(msgs.getString("invalid_commitOnClose"), commitOnClose));
        }
    }

    public String getCommitOnClose() {
        return this.m_commitOnClose ? "true" : "false";
    }

    public boolean isConnectionClosed() {
        try {
            return this.m_conn.isClosed();
        }
        catch (Exception e) {
            return true;
        }
    }

    public void outOfScope(JspScopeEvent ae) {
        this.closeScope();
    }

    private void closeScope() {
        try {
            this.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setConnection(Connection conn) {
        this.m_conn = conn;
    }

    public void valueBound(HttpSessionBindingEvent event) {
    }

    public void valueUnbound(HttpSessionBindingEvent event) {
        this.closeScope();
    }
}

