/*
 * Decompiled with CFR 0.152.
 */
package oracle.calypso.invalidation;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import oracle.calypso.invalidation.Invalidator2;
import oracle.calypso.invalidation.SOAPElement;
import oracle.calypso.invalidation.SOAPEnvelope;
import oracle.jsp.net.http.HttpRequest;
import oracle.jsp.net.http.HttpResponse;

public class Invalidator
extends SOAPElement {
    private static final String CACHE_SIGNATURE = "/x-oracle-cache-invalidate";
    private static final String NEWLINE = System.getProperty("line.separator", "\n");
    protected static boolean s_useSOAP;
    private HttpRequest m_httpReq;
    private HttpResponse m_httpResp;

    public Invalidator(String url, String username, String password, boolean useSOAP) throws MalformedURLException {
        super("INVALIDATION");
        String urlFile = new URL(url).getFile();
        this.m_httpReq = new HttpRequest(url + CACHE_SIGNATURE);
        this.m_httpReq.authenticate(username, password);
        this.m_httpReq.setHeader("User-agent", Invalidator.class.getName() + "/1.0" + " HTTP/1.0");
        this.m_httpReq.setMethod("POST");
        s_useSOAP = useSOAP;
    }

    public Invalidator(String url, String username, String password) throws MalformedURLException {
        this(url, username, password, false);
    }

    public Invalidator(String url) throws MalformedURLException {
        this(url, "invalidator", "invalidator", false);
    }

    public boolean invalidate() throws IOException {
        this.m_httpReq.setContent(this.toXml(), "text/xml");
        this.m_httpResp = this.m_httpReq.send();
        return this.m_httpResp.recv();
    }

    public String getInvalidationResponse() throws IOException {
        return this.m_httpResp.getContent();
    }

    public HttpRequest getHttpRequest() {
        return this.m_httpReq;
    }

    public HttpResponse getHttpResponse() {
        return this.m_httpResp;
    }

    public String toXml() {
        StringBuffer sb = new StringBuffer();
        if (s_useSOAP) {
            SOAPEnvelope soapEnvelope = new SOAPEnvelope("invalidate");
            soapEnvelope.getMethod().setChild(this);
            sb.append(soapEnvelope.toString());
        } else {
            sb.append(this.getDocHdr());
            sb.append(super.toString());
        }
        return sb.toString();
    }

    private String getDocHdr() {
        if (this instanceof Invalidator2) {
            return "<?xml version=\"1.0\" ?> " + NEWLINE + "<!DOCTYPE INVALIDATION SYSTEM \"internal:///WCSinvalidation.dtd\">" + NEWLINE;
        }
        return "<?xml version=\"1.0\" ?> " + NEWLINE + "<!DOCTYPE INVALIDATION SYSTEM \"internal:///invalidation.dtd\">" + NEWLINE;
    }
}

