/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.inspector.beans;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import oracle.bali.inspector.beans.AbstractPropertyEditorFactory;

class FieldPropertyEditorFactory
extends AbstractPropertyEditorFactory {
    private Field _field;

    public FieldPropertyEditorFactory(Object object, Field field) {
        super(object);
        if (field == null) {
            throw new IllegalArgumentException();
        }
        this._field = field;
    }

    public Field getField() {
        return this._field;
    }

    public String getDisplayName() {
        return this.getName();
    }

    public String getName() {
        return this.getField().getName();
    }

    public boolean setValue(Object object) throws IllegalAccessException, IllegalArgumentException {
        boolean bl = this.getCachedValue() != object;
        this.getField().set(this.getTarget(), object);
        this.setCachedValue(object);
        this.setCachedDisplayValue(AbstractPropertyEditorFactory.INVALID_PROPERTY);
        return bl;
    }

    public Object getValue(Object object) throws IllegalAccessException, IllegalArgumentException {
        Object object2 = this.getCachedValue();
        if (object2 == AbstractPropertyEditorFactory.INVALID_PROPERTY) {
            object2 = this.getField().get(object);
            this.setCachedValue(object2);
        }
        return object2;
    }

    public boolean isReadable() {
        int n = this.getField().getModifiers();
        boolean bl = Modifier.isPublic(n);
        return bl;
    }

    public boolean isWritable() {
        int n = this.getField().getModifiers();
        boolean bl = Modifier.isPublic(n) && !Modifier.isFinal(n);
        return bl;
    }

    public Class getType() {
        return this.getField().getType();
    }

    protected Object createPropertyID() {
        return new Object();
    }
}

