/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.inspector;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.EventObject;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import oracle.bali.inspector.DisplayValueRenderer;
import oracle.bali.inspector.PropertyEditorRenderer;
import oracle.bali.inspector.swing.AbstractTableCellEditor;

class NullEditor
extends AbstractTableCellEditor {
    private JPanel _panel = new JPanel();
    private Component _child;
    private Object _value;
    private JLabel _label;
    private ImageGenerator _listener;
    private static final TableCellEditor _sInstance = new NullEditor();

    public static TableCellEditor getTableCellEditor() {
        return _sInstance;
    }

    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        this._value = object;
        this._clearImage();
        return this._panel;
    }

    public Object getCellEditorValue() {
        return this._value;
    }

    public boolean isCellEditable(EventObject eventObject) {
        return false;
    }

    public void dispose() {
        this._clearImage();
        if (this._label != null) {
            this._panel.removeComponentListener(this._listener);
            this._panel.remove(this._label);
        }
        this._label = null;
        this._child = null;
        this._value = null;
        this._listener = null;
    }

    protected NullEditor(Component component) {
        this();
        this._child = component;
        if (component != null) {
            this._label = new JLabel();
            this._panel.setLayout(new BorderLayout());
            this._panel.add("West", this._label);
            this._listener = new ImageGenerator();
            this._panel.addComponentListener(this._listener);
        }
    }

    private NullEditor() {
    }

    private void _clearImage() {
        if (this._label != null) {
            ImageIcon imageIcon = (ImageIcon)this._label.getIcon();
            this._label.setIcon(null);
            if (imageIcon != null) {
                imageIcon.getImage().flush();
            }
            this._listener.init();
        }
    }

    private class ImageGenerator
    extends ComponentAdapter {
        private int _width = -1;
        private int _height = -1;

        private ImageGenerator() {
        }

        public void componentResized(ComponentEvent componentEvent) {
            if (NullEditor.this._child == null) {
                return;
            }
            Component component = componentEvent.getComponent();
            this._createImage(component);
        }

        private void _createImage(Component component) {
            Rectangle rectangle = component.getBounds();
            int n = rectangle.width;
            int n2 = rectangle.height;
            if (n != this._width || n2 != this._height) {
                Object object;
                boolean bl;
                this._width = n;
                this._height = n2;
                Image image = component.createImage(n, n2);
                Graphics graphics = image.getGraphics();
                graphics.setClip(rectangle.x, rectangle.y, n, n2);
                graphics.setColor(component.getBackground());
                graphics.fillRect(rectangle.x, rectangle.y, n, n2);
                graphics.setColor(component.getForeground());
                graphics.setFont(component.getFont());
                NullEditor.this._child.setBounds(rectangle.x, rectangle.y, this._width, this._height);
                NullEditor.this._child.validate();
                JComponent jComponent = NullEditor.this._child instanceof JComponent ? (JComponent)NullEditor.this._child : null;
                boolean bl2 = bl = jComponent == null ? false : jComponent.isDoubleBuffered();
                if (jComponent != null) {
                    jComponent.setDoubleBuffered(false);
                }
                if (NullEditor.this._child instanceof PropertyEditorRenderer) {
                    ((PropertyEditorRenderer)NullEditor.this._child).__getEditor().setValue(NullEditor.this._value);
                } else if (NullEditor.this._child instanceof DisplayValueRenderer) {
                    object = NullEditor.this._value == null ? "" : NullEditor.this._value.toString();
                    ((DisplayValueRenderer)NullEditor.this._child).setText((String)object);
                }
                NullEditor.this._child.paint(graphics);
                if (jComponent != null) {
                    jComponent.setDoubleBuffered(bl);
                }
                object = (ImageIcon)NullEditor.this._label.getIcon();
                NullEditor.this._label.setIcon(new ImageIcon(image));
                if (object != null) {
                    ((ImageIcon)object).getImage().flush();
                }
            }
        }

        public void init() {
            this._width = -1;
            this._height = -1;
        }
    }
}

