/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.inspector;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import oracle.bali.inspector.PropertyModel;

public class DisplayValueRenderer
extends DefaultTableCellRenderer {
    private static TableCellRenderer _sInstance = new DisplayValueRenderer();
    private Border _noFocusBorder = new EmptyBorder(1, 2, 1, 2);

    private DisplayValueRenderer() {
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        PropertyModel propertyModel = (PropertyModel)jTable.getModel();
        object = propertyModel.getPropertyDisplayValue(n);
        Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        if (!bl2 && component instanceof JComponent) {
            JComponent jComponent = (JComponent)component;
            Border border = UIManager.getBorder("Table.focusCellHighlightBorder");
            Insets insets = border.getBorderInsets(jComponent);
            if (!this._noFocusBorder.getBorderInsets(jComponent).equals(insets)) {
                this._noFocusBorder = new EmptyBorder(insets.top, insets.left, insets.bottom, insets.right);
            }
            jComponent.setBorder(this._noFocusBorder);
        }
        this.setOpaque(true);
        return component;
    }

    public static TableCellRenderer getTableCellRenderer() {
        return _sInstance;
    }

    public void paintComponent(Graphics graphics) {
        Rectangle rectangle = this.getBounds();
        Color color = graphics.getColor();
        graphics.setColor(this.getBackground());
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics.setColor(color);
        super.paintComponent(graphics);
    }
}

