/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.rules;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.jbo.rules.JboAbstractValidator;
import oracle.jbo.rules.JboValidatorContext;
import oracle.jbo.rules.JboValidatorInterface;

public class JboRegExpValidator
extends JboAbstractValidator
implements JboValidatorInterface {
    public static final String REGEX_CASE_INSENSITIVE_TEXT = "CaseInsensitive";
    public static final String REGEX_MULTILINE_TEXT = "Multiline";
    public static final String REGEX_DOTALL_TEXT = "DotAll";
    public static final String REGEX_UNICODE_CASE_TEXT = "UnicodeCase";
    public static final String REGEX_CANON_EQ_TEXT = "CanonEq";
    protected String mPattern;
    protected String mFlagValue;

    protected void initialize(JboValidatorContext jboValidatorContext) {
        super.initialize(jboValidatorContext);
    }

    public JboRegExpValidator() {
        this.mbInverse = false;
        this.setDefaultDescription("01299");
    }

    public JboRegExpValidator(boolean bl, String string, String string2) {
        this.mbInverse = bl;
        this.setPattern(string);
        this.setFlagValue(string2);
        this.setDefaultDescription("01302");
    }

    public boolean validateValue(Object object) {
        if (object == null) {
            return true;
        }
        int n = JboRegExpValidator.getRegExpFlagInt(this.getFlagValue());
        Pattern pattern = n != 0 ? Pattern.compile(this.getPattern(), n) : Pattern.compile(this.getPattern());
        Matcher matcher = pattern.matcher(object.toString());
        return matcher.matches();
    }

    public void setPattern(String string) {
        this.mPattern = string;
    }

    public String getPattern() {
        return this.mPattern;
    }

    public void setFlagValue(String string) {
        this.mFlagValue = string;
    }

    public String getFlagValue() {
        return this.mFlagValue;
    }

    public String toString() {
        return new String(" RegExp Compare( " + this.getPattern() + ")");
    }

    public static int getRegExpFlagInt(String string) {
        int n = 0;
        if (string != null && string.trim().length() > 0) {
            int n2 = 0;
            n2 |= JboRegExpValidator.getKeyValue(string, REGEX_CASE_INSENSITIVE_TEXT, 2);
            n2 |= JboRegExpValidator.getKeyValue(string, REGEX_MULTILINE_TEXT, 8);
            n2 |= JboRegExpValidator.getKeyValue(string, REGEX_DOTALL_TEXT, 32);
            n2 |= JboRegExpValidator.getKeyValue(string, REGEX_UNICODE_CASE_TEXT, 64);
            n = n2 |= JboRegExpValidator.getKeyValue(string, REGEX_CANON_EQ_TEXT, 128);
        }
        return n;
    }

    protected static int getKeyValue(String string, String string2, int n) {
        return string.indexOf(string2) >= 0 ? n : 0;
    }
}

